/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tinytree;

import net.sf.saxon.om.AxisIteratorImpl;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.tinytree.TinyTree;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;

final class AttributeEnumeration
extends AxisIteratorImpl {
    private TinyTree tree;
    private int element;
    private NodeTest nodeTest;
    private int index;
    private int currentNodeNr;

    AttributeEnumeration(TinyTree tinyTree, int n, NodeTest nodeTest) {
        this.nodeTest = nodeTest;
        this.tree = tinyTree;
        this.element = n;
        this.index = tinyTree.alpha[n];
        this.currentNodeNr = -1;
    }

    public boolean moveNext() {
        while (true) {
            if (this.index >= this.tree.numberOfAttributes || this.tree.attParent[this.index] != this.element) {
                this.index = Integer.MAX_VALUE;
                this.current = null;
                this.position = -1;
                this.currentNodeNr = -1;
                return false;
            }
            int n = this.tree.getAttributeAnnotation(this.index);
            if ((n & 0x40000000) != 0) {
                n = 631;
            }
            if (this.nodeTest.matches(2, this.tree.attCode[this.index], n)) {
                ++this.position;
                this.currentNodeNr = this.index++;
                if (this.nodeTest instanceof NameTest) {
                    this.index = Integer.MAX_VALUE;
                }
                return true;
            }
            ++this.index;
        }
    }

    public Item next() {
        this.current = this.moveNext() ? this.tree.getAttributeNode(this.currentNodeNr) : null;
        return this.current;
    }

    public Item current() {
        if (this.current == null) {
            if (this.currentNodeNr == -1) {
                return null;
            }
            this.current = this.tree.getAttributeNode(this.currentNodeNr);
        }
        return this.current;
    }

    public Value atomize() throws XPathException {
        if (this.currentNodeNr == -1) {
            throw new NullPointerException();
        }
        int n = this.tree.getAttributeAnnotation(this.currentNodeNr);
        if ((n & 0x40000000) != 0) {
            n = 631;
        }
        if (n == 631) {
            return new UntypedAtomicValue(this.tree.attValue[this.currentNodeNr]);
        }
        if (n == 513) {
            return new StringValue(this.tree.attValue[this.currentNodeNr]);
        }
        return ((NodeInfo)this.current()).atomize();
    }

    public CharSequence getStringValue() {
        if (this.currentNodeNr == -1) {
            throw new NullPointerException();
        }
        return this.tree.attValue[this.currentNodeNr];
    }

    public SequenceIterator getAnother() {
        return new AttributeEnumeration(this.tree, this.element, this.nodeTest);
    }
}

