/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.xpath;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;
import javax.xml.transform.Source;
import javax.xml.transform.SourceLocator;
import javax.xml.xpath.XPathFunctionResolver;
import javax.xml.xpath.XPathVariableResolver;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.VariableDeclaration;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.sxpath.AbstractStaticContext;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.xpath.JAXPVariable;
import net.sf.saxon.xpath.XPathFunctionLibrary;

public class JAXPXPathStaticContext
extends AbstractStaticContext
implements StaticContext,
NamespaceResolver,
Container {
    private SlotManager stackFrameMap;
    private XPathFunctionLibrary xpathFunctionLibrary;
    private NamespaceContext namespaceContext = new MinimalNamespaceContext();
    private XPathVariableResolver variableResolver;

    public JAXPXPathStaticContext(Configuration configuration) {
        this.setConfiguration(configuration);
        this.stackFrameMap = configuration.makeSlotManager();
        this.setDefaultFunctionLibrary();
        this.xpathFunctionLibrary = new XPathFunctionLibrary();
        this.addFunctionLibrary(this.xpathFunctionLibrary);
    }

    public void setNamespaceContext(NamespaceContext namespaceContext) {
        this.namespaceContext = namespaceContext;
    }

    public NamespaceContext getNamespaceContext() {
        return this.namespaceContext;
    }

    public SlotManager getStackFrameMap() {
        return this.stackFrameMap;
    }

    public void setXPathVariableResolver(XPathVariableResolver xPathVariableResolver) {
        this.variableResolver = xPathVariableResolver;
    }

    public XPathVariableResolver getXPathVariableResolver() {
        return this.variableResolver;
    }

    public void setXPathFunctionResolver(XPathFunctionResolver xPathFunctionResolver) {
        if (this.xpathFunctionLibrary != null) {
            this.xpathFunctionLibrary.setXPathFunctionResolver(xPathFunctionResolver);
        }
    }

    public XPathFunctionResolver getXPathFunctionResolver() {
        if (this.xpathFunctionLibrary != null) {
            return this.xpathFunctionLibrary.getXPathFunctionResolver();
        }
        return null;
    }

    public void issueWarning(String string, SourceLocator sourceLocator) {
        System.err.println(string);
    }

    public String getURIForPrefix(String string) throws XPathException {
        String string2 = this.getURIForPrefix(string, false);
        if (string2 == null) {
            throw new StaticError("Prefix " + string + " has not been declared");
        }
        return string2;
    }

    public NamespaceResolver getNamespaceResolver() {
        return this;
    }

    public String getURIForPrefix(String string, boolean bl) {
        if (string.equals("")) {
            if (bl) {
                return this.getDefaultElementNamespace();
            }
            return "";
        }
        return this.namespaceContext.getNamespaceURI(string);
    }

    public Iterator iteratePrefixes() {
        if (this.namespaceContext instanceof NamespaceResolver) {
            return ((NamespaceResolver)this.namespaceContext).iteratePrefixes();
        }
        throw new UnsupportedOperationException();
    }

    public final VariableReference bindVariable(int n) throws StaticError {
        if (this.variableResolver != null) {
            QNameValue qNameValue = new QNameValue(this.getNamePool(), n);
            return new VariableReference((VariableDeclaration)new JAXPVariable(qNameValue, this.variableResolver));
        }
        throw new StaticError("Variable is used in XPath expression, but no JAXP VariableResolver is available");
    }

    public void importSchema(Source source) throws SchemaException {
        this.getConfiguration().addSchemaSource(source, this.getConfiguration().getErrorListener());
    }

    public boolean isImportedSchema(String string) {
        return this.getConfiguration().isSchemaAvailable(string);
    }

    public Set getImportedSchemaNamespaces() {
        return this.getConfiguration().getImportedNamespaces();
    }

    private static class MinimalNamespaceContext
    implements NamespaceContext,
    NamespaceResolver {
        private MinimalNamespaceContext() {
        }

        public String getNamespaceURI(String string) {
            if (string == null) {
                throw new IllegalArgumentException("prefix");
            }
            if (string.equals("")) {
                return "";
            }
            if (string.equals("xml")) {
                return "http://www.w3.org/XML/1998/namespace";
            }
            if (string.equals("xs")) {
                return "http://www.w3.org/2001/XMLSchema";
            }
            if (string.equals("xsi")) {
                return "http://www.w3.org/2001/XMLSchema-instance";
            }
            if (string.equals("saxon")) {
                return "http://saxon.sf.net/";
            }
            return null;
        }

        public String getPrefix(String string) {
            throw new UnsupportedOperationException();
        }

        public Iterator getPrefixes(String string) {
            throw new UnsupportedOperationException();
        }

        public Iterator iteratePrefixes() {
            String[] stringArray = new String[]{"", "xml", "xs", "xsi", "saxon"};
            return Arrays.asList(stringArray).iterator();
        }

        public String getURIForPrefix(String string, boolean bl) {
            return this.getNamespaceURI(string);
        }
    }
}

