<?xml version="1.0"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/officity/directory/HomePanel.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
    <xsl:import href="app.include.xsl"/>
    <xsl:output encoding="UTF-8" method="xml" indent="no"/>
    <xsl:strip-space elements="*"/>

	<xsl:template match="/RESPONSE">
    	<xsl:call-template name="panel-navigation" />
    </xsl:template>
	
	<xsl:template name="panel-body-navigation">  
        <xsl:call-template name="staticitemheader">
            <xsl:with-param name="title">Directory</xsl:with-param>
            <xsl:with-param name="icon">../system/images/icons/directory/32.png</xsl:with-param>
            <xsl:with-param name="info">
            	<xsl:text>Manage your adress book.</xsl:text>
            </xsl:with-param>
        </xsl:call-template>
        
        <!--xsl:call-template name="navigationitem">
            <xsl:with-param name="title">Check contacts</xsl:with-param>
            <xsl:with-param name="panelURI">contacts/CheckNew</xsl:with-param>
            <xsl:with-param name="params"></xsl:with-param>
            <xsl:with-param name="icon">../system/images/icons/contacts/contacts-18.png</xsl:with-param>
        </xsl:call-template-->
        
	    <xsl:call-template name="nav-new">
	    	<xsl:with-param name="title" select="'New contact'" />
	    	<xsl:with-param name="module" select="'contact'" />
	    	<xsl:with-param name="panelURI" select="'contacts/New'"/>
	   	</xsl:call-template>

        <xsl:call-template name="navigationitem">
            <xsl:with-param name="title">Myself</xsl:with-param>
            <xsl:with-param name="panelURI">contacts/Details</xsl:with-param>
            <xsl:with-param name="params">ID:<xsl:value-of select="$userID" /></xsl:with-param>
            <xsl:with-param name="icon">
                <xsl:text>../system/images/icons/contacts/contact-black-18.png</xsl:text>
            </xsl:with-param>
            <xsl:with-param name="info">
                <xsl:value-of select="$userID" />
            </xsl:with-param>
        </xsl:call-template> 
        
        <xsl:call-template name="navigationitem">
            <xsl:with-param name="title">Browse</xsl:with-param>
            <xsl:with-param name="panelURI">contacts/Directory</xsl:with-param>
            <xsl:with-param name="icon">
                <xsl:text>../system/images/icons/contacts/address-book.png</xsl:text>
            </xsl:with-param>
        </xsl:call-template>

        <xsl:call-template name="navigationitem">
            <xsl:with-param name="title">Quick search</xsl:with-param>
            <xsl:with-param name="panelURI">contacts/DirectorySearch</xsl:with-param>
            <xsl:with-param name="icon">
                <xsl:text>../system/images/icons/contacts/address-book.png</xsl:text>
            </xsl:with-param>
        </xsl:call-template>

        <xsl:call-template name="nav-search">
            <xsl:with-param name="title">Search</xsl:with-param>
            <xsl:with-param name="module" select="'contact'"/>
        </xsl:call-template>

        <xsl:call-template name="nav-savedfilters">
            <xsl:with-param name="title">Saved filters</xsl:with-param>
            <xsl:with-param name="module" select="'contact'"/>
        </xsl:call-template>
	</xsl:template>
</xsl:stylesheet>