<?xml version="1.0"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/officity/directory/contacts/CheckNew.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
    <xsl:import href="include.xsl"/>
    <xsl:output encoding="UTF-8" method="xml" indent="no"/>
    <xsl:strip-space elements="*"/>
    
    <!-- parameters -->
    <xsl:param name="checkFormID">
        <xsl:text>form-check-</xsl:text><xsl:value-of select="$panelID"/>
    </xsl:param>
    
	<xsl:template match="/RESPONSE">
    	<xsl:call-template name="panel-navigation" />
    </xsl:template>
    
   	<xsl:template name="panel-header-navigation">
		<form class="header-form" id="{$checkFormID}" name="{$checkFormID}">
            <input type="hidden" id="panelID" name="panelID" value="{$panelID}" />
			<table>
				<tr>
					<td>Check contacts: </td>
					<td>
						<input type="text" class="input-text-small" default-value="Last name" default-color="#bbbbbb">
							<xsl:attribute name="name">
								<xsl:call-template name="gen-info-input-name">
									<xsl:with-param name="moduleName" select="'contact'" />
									<xsl:with-param name="fieldName" select="'lastname'"/>
								</xsl:call-template>
							</xsl:attribute>
						</input>
						<input type="text" class="input-text-small" default-value="First name" default-color="#bbbbbb">
							<xsl:attribute name="name">
								<xsl:call-template name="gen-info-input-name">
									<xsl:with-param name="moduleName" select="'contact'" />
									<xsl:with-param name="fieldName" select="'firstname'"/>
								</xsl:call-template>
							</xsl:attribute>
						</input>
					</td>
					<td>
						<input style="margin-left:15px;" type="submit" id="submit-check" name="submit-check" value="Check" class="input-submit-save" />
					</td>
				</tr>
			</table>
		</form>
	</xsl:template>

	<xsl:template name="panel-js-navigation">
		$('#<xsl:value-of select="$checkFormID" />').submit(delegate(this, function() {
		    dataChecker<xsl:value-of select="$panelID" />.proceed();
			return false;
		}));
		
		dataChecker<xsl:value-of select="$panelID" /> = new DataChecker(
		    <xsl:value-of select="$panelID" />,
		    AppController,
		    '<xsl:apply-templates select="/RESPONSE/RESULTS[@name='item']/CONTACT" mode="element-script-check4create"/>',
		    '<xsl:value-of select="$checkFormID" />'
		);
	</xsl:template>
</xsl:stylesheet>
