<?xml version="1.0"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/officity/directory/contacts/Details.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
    <xsl:import href="include.xsl"/>    
    <xsl:output encoding="UTF-8" method="xml" indent="no"/>
    <xsl:strip-space elements="*"/>
    
    <!-- parameters -->
    <xsl:param name="fields" select="/RESPONSE/RESULTS[@name='fields']/FIELD"/>
    <xsl:param name="depentities" select="/RESPONSE/RESULTS[@name='dependencies']/DEPENDENCYENTITY"/>
  	<!--xsl:param name="descriptions" select="/RESPONSE/RESULTS[@name='descriptions']/DESCRIPTIONCONFIG"/-->
  	
    <xsl:param name="item" select="/RESPONSE/RESULTS[@name='item']/*[1]"/>
    <xsl:param name="itemInfo" select="$item/INFO"/>
    <xsl:param name="itemDeps" select="$item/DEPENDENCIES"/>
    <xsl:param name="itemDescs" select="$item/DESCRIPTIONS"/>
    <xsl:param name="module" select="/RESPONSE/URL/module"/>
    
    <xsl:param name="contactKeyrings" select="/RESPONSE/RESULTS[@name='contactKeyrings']/KEYRING"/>
    
    <!-- optional -->
    <xsl:param name="dependency" select="/RESPONSE/URL/dependency"/>
    <xsl:param name="targetModule" select="/RESPONSE/URL/targetModule"/>
    <xsl:param name="targetID" select="/RESPONSE/URL/targetID"/>
    
    <!-- IDs -->
    <xsl:param name="tinyClass">
		<xsl:text>mceEditor-</xsl:text>
		<xsl:value-of select="$panelID" />
    </xsl:param>
    
   	<xsl:template match="/RESPONSE">
    	<xsl:call-template name="panel-elementdetails">
    		<xsl:with-param name="element" select= "$item" />
    		<xsl:with-param name="tabsList">
				<xsl:text>details,Details;address,Address;desc,Description (</xsl:text>
				<xsl:value-of select="/RESPONSE/NECTIL/language" />
				<xsl:text>);</xsl:text>
    		</xsl:with-param>
    		 <xsl:with-param name="displayOverviewTab" select="true()" />
    		 <xsl:with-param name="displayAdminTab" select="true()" />
    	</xsl:call-template>
    </xsl:template>
    
    <!-- custom : tabs content -->
	<xsl:template name="panel-body-element-tabs-content">
		<xsl:param name="element" />
		<xsl:param name="newElement" />
		
		<!-- tab : details -->
  		<xsl:call-template name="element-tabform-create">
			<xsl:with-param name="denom" select="'details'" />
			<xsl:with-param name="element" select="$element" />
			<xsl:with-param name="content">
				<xsl:call-template name="element-tab-details">
					<xsl:with-param name="element" select="$element" />
				</xsl:call-template>
			</xsl:with-param>
		</xsl:call-template>
		
		<!-- tab : address -->
  		<xsl:call-template name="element-tabform-create">
			<xsl:with-param name="denom" select="'address'" />
			<xsl:with-param name="element" select="$element" />
			<xsl:with-param name="content">
				<xsl:call-template name="element-tab-address">
					<xsl:with-param name="element" select="$element" />
				</xsl:call-template>
			</xsl:with-param>
		</xsl:call-template>
		
		<!-- tab : shared description -->
		<xsl:call-template name="element-tabform-create">
			<xsl:with-param name="denom" select="'desc'" />
			<xsl:with-param name="element" select="$element" />
			<xsl:with-param name="content">
				<xsl:call-template name="element-tab-desc">
					<xsl:with-param name="element" select="$element" />
					<xsl:with-param name="languageID" select="/RESPONSE/NECTIL/language" />
				</xsl:call-template>
			</xsl:with-param>
		</xsl:call-template>
	</xsl:template>
	
	<!-- custom : overview -->
    <xsl:template name="element-tab-overview">
    	<xsl:param name="element" />  
    	<xsl:param name="legend" />

		<xsl:call-template name="element-overview-note">
			<xsl:with-param name="element" select="$element"/>
		</xsl:call-template>

        <xsl:call-template name="overview-fieldset">
	        <xsl:with-param name="legend" select="'Contact overview'" />
	        <xsl:with-param name="content">
	        	<xsl:apply-templates select="$element/INFO/CONTACTTYPE" mode="overview-line" />
            	<xsl:call-template name="overview-line">
            		<xsl:with-param name="label" select="'Name:'" />
            		<xsl:with-param name="value">
            			<xsl:apply-templates select="$element" mode="element-label"/>
            		</xsl:with-param>
            	</xsl:call-template>          
            	<xsl:apply-templates select="$element/INFO/EMAIL1" mode="overview-line" />
            	<xsl:apply-templates select="$element[INFO/CONTACTTYPE='PM']/INFO/WEBSITE" mode="overview-line" />
		       	<xsl:apply-templates select="$element/INFO/MOBILEPHONE" mode="overview-line" />
		       	<xsl:apply-templates select="$element/INFO/PHONE1" mode="overview-line" /> 	            	
            	
            	<xsl:call-template name="overview-line">
            		<xsl:with-param name="label" select="'Address:'" />
            		<xsl:with-param name="value">
            			<xsl:value-of select="$element/INFO/ADDRESS" /><br />
            			<xsl:value-of select="$element/INFO/POSTALCODE" />
            			<xsl:text>&#160;</xsl:text>
            			<xsl:value-of select="$element/INFO/CITY" /><br />
			            <xsl:call-template name="field-value">
			            	<xsl:with-param name ="field" select="$fields[INFO/DENOMINATION='COUNTRYID']"/>
			            	<xsl:with-param name ="node" select="$element/INFO/COUNTRYID"/>
			           	</xsl:call-template>
            		</xsl:with-param>
            		<xsl:with-param name="topLabel" select="true()" />
            	</xsl:call-template>            	
            	
            	<xsl:apply-templates select="$element/INFO/LANGUAGEID" mode="overview-line" />
            	
            	<xsl:call-template name="form-empty-line" /> 
				
            	<xsl:call-template name="overview-line">
            		<xsl:with-param name="label" select="'Work contacts:'" />
            		<xsl:with-param name="value">
            			<xsl:for-each select="$element/DEPENDENCIES/DEPENDENCY[@type='contactWork']/CONTACT">
            				<a href="mailto:{INFO/EMAIL1}" title="Send an e-mail to {INFO/EMAIL1}">
	            				<xsl:apply-templates select="." mode="element-label" />
            				</a>
            				<br />
						</xsl:for-each>
					</xsl:with-param>
					<xsl:with-param name="topLabel" select="true()" />
            	</xsl:call-template>
			</xsl:with-param>
		</xsl:call-template>
        
        <xsl:call-template name="overview-fieldset">
	        <xsl:with-param name="legend" select="'Access'" />
	        <xsl:with-param name="content">
				<xsl:call-template name="overview-line">
				    <xsl:with-param name="label" select="'Keyring:'"/>
			    	<xsl:with-param name="value">
			    		<xsl:for-each select="$contactKeyrings">
			    			<xsl:sort select="INFO/DENOMINATION" />
			    			<xsl:value-of select="INFO/DENOMINATION" /><br />
			    		</xsl:for-each>
			    	</xsl:with-param>
		    	</xsl:call-template>
	    	</xsl:with-param>
    	</xsl:call-template>
    </xsl:template>
	    
    <!-- custom : details tab -->
    <xsl:template name="element-tab-details">
        <xsl:param name="element" />    
           
       	<xsl:apply-templates select="$element[INFO/CONTACTTYPE='PP']/INFO/LASTNAME" mode="form-info-line">
       		<xsl:with-param name="required" select="$element/INFO/CONTACTTYPE='PP'"  />
       	</xsl:apply-templates>
       	<xsl:apply-templates select="$element[INFO/CONTACTTYPE='PP']/INFO/FIRSTNAME" mode="form-info-line">
       	</xsl:apply-templates>
       	<xsl:apply-templates select="$element[INFO/CONTACTTYPE='PP']/INFO/TITLE" mode="form-info-line" />

       	<xsl:apply-templates select="$element/INFO/DENOMINATION" mode="form-info-line">
       		<xsl:with-param name="required" select="$element/INFO/CONTACTTYPE='PM'"  />
       	</xsl:apply-templates>
       	
       	<xsl:apply-templates select="$element/INFO/EMAIL1" mode="form-info-line">
       		<xsl:with-param name="required" select="true()"  />
       	</xsl:apply-templates>
       	<xsl:apply-templates select="$element[INFO/CONTACTTYPE='PM']/INFO/WEBSITE" mode="form-info-line" />
       	
       	<xsl:apply-templates select="$element/INFO/DIGITALINFO1" mode="form-info-line">
       	</xsl:apply-templates>
       	
       	<xsl:apply-templates select="$element/INFO/MOBILEPHONE" mode="form-info-line" />
       	<xsl:apply-templates select="$element/INFO/PHONE1" mode="form-info-line" />
       	<xsl:apply-templates select="$element/INFO/LANGUAGEID" mode="form-info-line" />       	   
       	<xsl:apply-templates select="$element[INFO/CONTACTTYPE='PP']/INFO/BIRTHDAY" mode="form-info-line" />
       	<xsl:apply-templates select="$element/INFO/PRIVACY1" mode="form-info-line" />               
       	<xsl:apply-templates select="$element/INFO/PREVIEW" mode="form-info-line">	
       		<xsl:with-param name="topLabel" select="true()" />
       	</xsl:apply-templates>  
       	 
       	<xsl:apply-templates select="$element" mode="form-info-line-submit" />
    </xsl:template>
    
    <!-- custom : address tab -->
    <xsl:template name="element-tab-address">
        <xsl:param name="element" />   
        
       	<xsl:apply-templates select="$element/INFO/ADDRESS" mode="form-info-line">
	       	<xsl:with-param name="type" select="'textarea'" /> 
       	</xsl:apply-templates>
       	<xsl:apply-templates select="$element/INFO/POSTALCODE" mode="form-info-line" />
       	<xsl:apply-templates select="$element/INFO/CITY" mode="form-info-line" />
       	<xsl:apply-templates select="$element/INFO/COUNTRYID" mode="form-info-line" />
       	<xsl:apply-templates select="$element" mode="form-info-line-submit" />
	</xsl:template>		
	
	<!-- custom : description tab -->
   <xsl:template name="element-tab-desc">
   		<xsl:param name="element" /> 
		<xsl:param name="languageID" />		   			
		<xsl:variable name="currentDesc" select="$element/DESCRIPTIONS/DESCRIPTION[@languageID=$languageID]"/> 
		
		<xsl:choose>
			<xsl:when test="$currentDesc">
				<xsl:apply-templates select="$currentDesc/TITLE" mode="form-desc-line">			
					<xsl:with-param name="type" select="'text'" />
				</xsl:apply-templates>						
				
				<xsl:apply-templates select="$currentDesc/BODY" mode="form-desc-line">
					<xsl:with-param name="label" select="'Body (styled):'"/>
					<xsl:with-param name="type" select="'styled'" />
					<xsl:with-param name="cssclass" select="$tinyClass" />
				</xsl:apply-templates>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="form-desc-line">			
					<xsl:with-param name="moduleName" select="name($element)" />
					<xsl:with-param name="fieldName" select="'TITLE'" />
					<xsl:with-param name="languageID" select="$languageID" />
					<xsl:with-param name="type" select="'text'" />
				</xsl:call-template>	
									
				<xsl:call-template name="form-desc-line">			
					<xsl:with-param name="moduleName" select="name($element)" />
					<xsl:with-param name="fieldName" select="'BODY'" />
					<xsl:with-param name="languageID" select="$languageID" />
					<xsl:with-param name="label" select="'Body (styled):'" />
					<xsl:with-param name="type" select="'styled'" />
					<xsl:with-param name="cssclass" select="$tinyClass" />
				</xsl:call-template>					
			</xsl:otherwise>
		</xsl:choose>
		
		<xsl:apply-templates select="$element" mode="form-desc-line-submit" />
  	</xsl:template>
      
    <xsl:template name="panel-block-details-nav-element">
    	<xsl:param name="element" />
    	
        <xsl:call-template name="new-followup">
            <xsl:with-param name="title">Follow-up</xsl:with-param>
            <xsl:with-param name="element" select="$element" />
            <xsl:with-param name="cssclass">first</xsl:with-param>
        </xsl:call-template>
        <xsl:for-each select="$depentities/DEPENDENCYTYPE[@from=$module and not(TYPE=preceding-sibling::DEPENDENCYTYPE/TYPE)]">
            <xsl:sort select="DENOMINATION/LABEL" />
			<xsl:call-template name="nav-links">
                <xsl:with-param name="title">
                    <xsl:apply-templates select="." mode="element-label"/>
                </xsl:with-param>
				<xsl:with-param name="module" select="@from" />
				<xsl:with-param name="originID" select="$element/@ID" />
				<xsl:with-param name="targetModule" select="@to" />
				<xsl:with-param name="dependency" select="TYPE"/>
				<xsl:with-param name="panelURI" select="'../../system/tools/element/Link'"/>
			</xsl:call-template>
        </xsl:for-each>

		<xsl:call-template name="navigationdetailsitem">
			<xsl:with-param name="title" select="'Twitter'"/>
			<xsl:with-param name="panelURI" select="'../../system/tools/followup/List'"/>
			<xsl:with-param name="params">
				<xsl:text>ID:</xsl:text>
				<xsl:value-of select="$element/@ID"/>
				<xsl:text>,module:'</xsl:text>
				<xsl:value-of select="name($element)"/>
				<xsl:text>'</xsl:text>
			</xsl:with-param>
			<xsl:with-param name="icon">
				<xsl:text>../system/images/icons/followups/twitter.png</xsl:text>
			</xsl:with-param> 
		</xsl:call-template>

		<xsl:call-template name="history-list">
			<xsl:with-param name="title">History</xsl:with-param>
			<xsl:with-param name="element" select="$element" />
			<xsl:with-param name="cssclass">last</xsl:with-param>
		</xsl:call-template>		
    </xsl:template>
    
	<xsl:template match="DEPENDENCYTYPE" mode="element-label">
		<xsl:value-of select="DENOMINATION/LABEL" />
        <xsl:text> (</xsl:text>
		<xsl:value-of select="count($itemDeps/DEPENDENCY[@type=current()/TYPE]/*)" />
		<xsl:text>)</xsl:text>
	</xsl:template>
	
    <!-- custom : element details js -->
	<xsl:template name="panel-js-element">
		<xsl:param name="element" />
		$('#<xsl:value-of select="$panelID"/>.panel').addClass('<xsl:apply-templates select="$element" mode="element-panel-details-class"/>');
		
		<xsl:call-template name="js-init-tinyMCE">	
			<xsl:with-param name="textareaClass" select="$tinyClass" />
		</xsl:call-template>

		<xsl:call-template name="js-init-autoresize">
			<xsl:with-param name="excludeClass" select="$tinyClass" />
		</xsl:call-template>
				
		<xsl:call-template name="js-init-tabs" />

		<xsl:call-template name="js-init-datepicker">
			<xsl:with-param name="selector" select="'.input-date'"/>
		</xsl:call-template>
	</xsl:template>
    
    <xsl:template name="panel-add-js">

    </xsl:template>
</xsl:stylesheet>