<?xml version="1.0"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/officity/directory/contacts/DirectorySearch.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
    <xsl:import href="include.xsl"/>
    <xsl:output encoding="UTF-8" method="xml" indent="no"/>
    <xsl:strip-space elements="*"/>
    
    <!-- parameters -->
    <xsl:param name="index" select="'ABC,DEF,GHI,JKL,MNO,PQR,STU,VWXYZ,0123456789'"/>
    <xsl:param name="list" select="/RESPONSE/RESULTS[@name='list']"/>

	<xsl:template match="/RESPONSE">
		<xsl:call-template name="panel-quicksearch">
			<xsl:with-param name="list" select="/RESPONSE/RESULTS[@name='list']"/>
	        <xsl:with-param name="addNew" select="true()"/>
	        <xsl:with-param name="pagingStyle" select="'pager'"/>
		</xsl:call-template>
    </xsl:template>
    
	<xsl:template name="panel-list-quicksearch">
        <xsl:param name="list" />
                
        <xsl:choose>
	        <xsl:when test="$list">
		        <xsl:choose>
		            <xsl:when test="$list/@hits > 0">
		                <xsl:for-each select="$list/*">
		                	<xsl:sort select="translate(concat(INFO[CONTACTTYPE='PP']/LASTNAME,INFO[CONTACTTYPE='PP']/FIRSTNAME,INFO[CONTACTTYPE='PM']/DENOMINATION), $xsltsl-str-upper, $xsltsl-str-lower)" order="ascending"/>
		                    <xsl:apply-templates select="." mode="element-navitem-quicksearch" />
		                </xsl:for-each>
		            </xsl:when>
		            <xsl:otherwise>
		                <div class="no-result">No hits</div>
		            </xsl:otherwise>
		        </xsl:choose>
	        </xsl:when>
			<xsl:otherwise>
                <xsl:call-template name="nav-search">
                    <xsl:with-param name="module" select="'contact'" />
                </xsl:call-template>

                <xsl:call-template name="nav-savedfilters">
                    <xsl:with-param name="module" select="'contact'" />
                </xsl:call-template>

				<xsl:call-template name="build-directory-index">
                    <xsl:with-param name="index-list" select="$index"/>
                </xsl:call-template>
                
	    		<script type="text/javascript">
				    <xsl:call-template name="create-index-counters">
				        <xsl:with-param name="index-list" select="$index"/>
				    </xsl:call-template>
			    </script>
			</xsl:otherwise>
        </xsl:choose>
    </xsl:template>

	<xsl:template name="build-directory-index">
		<xsl:param name="index-list" />
		<xsl:choose>
			<xsl:when test="substring-before($index-list,',')">
				<xsl:call-template name="directory-item">
					<xsl:with-param name="index" select="substring-before($index-list,',')"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="directory-item">
					<xsl:with-param name="index" select="$index-list"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:if test="substring-after($index-list,',')">
			<xsl:call-template name="build-directory-index">
				<xsl:with-param name="index-list" select="substring-after($index-list,',')"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>

	<xsl:template name="directory-item">
		<xsl:param name="index"/>
		<xsl:call-template name="navigationitem">
            <xsl:with-param name="id">index-<xsl:value-of select="$index"/></xsl:with-param>
			<xsl:with-param name="title">
				<xsl:value-of select="$index"/>
			</xsl:with-param>
			<xsl:with-param name="panelURI">contacts/DirectoryItems</xsl:with-param>
            <xsl:with-param name="icon">
                <xsl:text>../system/images/icons/contacts/contacts-18.png</xsl:text>
            </xsl:with-param>
            <xsl:with-param name="params">index:'<xsl:value-of select="$index"/>'</xsl:with-param>
            <xsl:with-param name="displayCount" select="true()"/>
		</xsl:call-template>
	</xsl:template>

	<xsl:template name="create-index-counters">
		<xsl:param name="index-list" />
		<xsl:choose>
			<xsl:when test="substring-before($index-list,',')">
				<xsl:call-template name="item-counter">
					<xsl:with-param name="index" select="substring-before($index-list,',')"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="item-counter">
					<xsl:with-param name="index" select="$index-list"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:if test="substring-after($index-list,',')">
			<xsl:call-template name="create-index-counters">
				<xsl:with-param name="index-list" select="substring-after($index-list,',')"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>

    <xsl:template name="item-counter">
        <xsl:param name="index"/>
        var countRequest<xsl:value-of select="$index"/> = new AjaxRequest(
            <xsl:value-of select="$panelID"/>,
            AppController,
            '<xsl:apply-templates select="/RESPONSE/RESULTS[@name='element-template']/*[1]" mode="element-script-count"/>',
            'GET'
        );

        countRequest<xsl:value-of select="$index"/>.addData('index', '<xsl:value-of select="$index"/>');

        countRequest<xsl:value-of select="$index"/>.onSuccess(function(response){
            $('#index-<xsl:value-of select="$index"/> .info').html(response.message+' hit(s)');
        }).send();
    </xsl:template>

	<xsl:template name="start-index-counters">
		<xsl:param name="index-list" />
		<xsl:choose>
			<xsl:when test="substring-before($index-list,',')">
				<xsl:call-template name="counter-start">
					<xsl:with-param name="index" select="substring-before($index-list,',')"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="counter-start">
					<xsl:with-param name="index" select="$index-list"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:if test="substring-after($index-list,',')">
			<xsl:call-template name="start-index-counters">
				<xsl:with-param name="index-list" select="substring-after($index-list,',')"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>

    <xsl:template name="counter-start">
        <xsl:param name="index"/>
        dataCount<xsl:value-of select="$index"/>.start();
    </xsl:template>
</xsl:stylesheet>
