<?xml version="1.0"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/officity/factory/applications/Details.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
    <xsl:import href="include.xsl"/>    
    <xsl:output encoding="UTF-8" method="xml" indent="no"/>
    <xsl:strip-space elements="*"/>
    
    <!-- parameters -->
    <xsl:param name="fields" select="/RESPONSE/RESULTS[@name='fields']/FIELD"/>
    <xsl:param name="depentities" select="/RESPONSE/RESULTS[@name='dependencies']/DEPENDENCYENTITY"/>
  	<!--xsl:param name="descriptions" select="/RESPONSE/RESULTS[@name='descriptions']/DESCRIPTIONCONFIG"/-->
  	
    <xsl:param name="item" select="/RESPONSE/RESULTS[@name='item']/*[1]"/>
    <xsl:param name="itemInfo" select="$item/INFO"/>
    <xsl:param name="itemDeps" select="$item/DEPENDENCIES"/>
    <xsl:param name="itemDescs" select="$item/DESCRIPTIONS"/>
    <xsl:param name="module" select="/RESPONSE/URL/module"/>
    
    <!-- optional -->
    <xsl:param name="dependency" select="/RESPONSE/URL/dependency"/>
    <xsl:param name="targetModule" select="/RESPONSE/URL/targetModule"/>
    <xsl:param name="targetID" select="/RESPONSE/URL/targetID"/>
    
   	<xsl:template match="/RESPONSE">
    	<xsl:call-template name="panel-elementdetails">
    		<xsl:with-param name="element" select= "$item" />
    		<xsl:with-param name="tabsList">
				<xsl:text>details,Details;</xsl:text>
    		</xsl:with-param>
    		 <xsl:with-param name="displayOverviewTab" select="false()" />
    		 <xsl:with-param name="displayAdminTab" select="true()" />
    		 <xsl:with-param name="deleteRight" select="$item/INFO/ISLOCKED=0" />
    		 <xsl:with-param name="deleteConfirm" select="true()"/>
    		 <xsl:with-param name="deleteConfirmText">
           		<p>
            		<br />                
					<xsl:text>By deleting this application, you will also </xsl:text>
					<strong>delete all related folders</strong>
					<xsl:text>.</xsl:text>
					<br /><br />
					<xsl:text>All related objects (modules, processors, etc.) will have to be manually removed from the database.</xsl:text>
					<br /><br />
					<strong>Are you sure?</strong>
                    <br/><br /><br />
                </p>
    		 </xsl:with-param>
    	</xsl:call-template>
	</xsl:template>
	
    <!-- element details : title -->
    <xsl:template name="panel-body-element-title">
    	<xsl:param name="title" />
    	
    	<h2>
    		<xsl:attribute name="class">
	    		<xsl:call-template name="translate-namespace-name">
	        		<xsl:with-param name="name" select="name($item)"/>
	        	</xsl:call-template>
    		</xsl:attribute>
    		<xsl:if test="$item/INFO/ICON/text()">
	    		<xsl:attribute name="style">
	    			background-image:url(<xsl:value-of select="$appsURL" /><xsl:value-of select="$item/DEPENDENCIES/DEPENDENCY[@type='officity:appNamespaces']/NAMESPACE/INFO/NAMESPACE" />/<xsl:value-of select="$item/INFO/ICON" />);
	    		</xsl:attribute>
    		</xsl:if>
			<xsl:apply-templates select="$item" mode="element-label" />
		</h2>
    </xsl:template>
    
    <!-- custom : tabs content -->
	<xsl:template name="panel-body-element-tabs-content">
		<xsl:param name="element" />
		<xsl:param name="newElement" />
		
		<!-- tab : details -->
  		<xsl:call-template name="element-tabform-create">
			<xsl:with-param name="denom" select="'details'" />
			<xsl:with-param name="element" select="$element" />
			<xsl:with-param name="content">
				<xsl:call-template name="element-tab-details">
					<xsl:with-param name="element" select="$element" />
				</xsl:call-template>
			</xsl:with-param>
		</xsl:call-template>
	</xsl:template>
    
    <!-- custom : details tab -->
    <xsl:template name="element-tab-details">
        <xsl:param name="element" />    

		<xsl:call-template name="overview-line">
			<xsl:with-param name="label" select="'Editor:'" />
			<xsl:with-param name="value">
				<xsl:apply-templates select="$element/DEPENDENCIES/DEPENDENCY[@type='officity:appNamespaces']/NAMESPACE" mode="element-label" />
			</xsl:with-param>
		</xsl:call-template>
    	
       	<xsl:apply-templates select="$element/INFO/DENOMINATION" mode="form-info-line">
       		<xsl:with-param name="required" select="true()"  />
       	</xsl:apply-templates>
       	
       	<xsl:apply-templates select="$element/INFO/URL" mode="form-info-line">
       		<xsl:with-param name="label" select="'Folder (no special chars authorized):'"  />
       		<xsl:with-param name="required" select="true()"  />
       	</xsl:apply-templates>
       	
       	<xsl:apply-templates select="$element/INFO/ICON" mode="form-info-line">
       		<xsl:with-param name="label" select="'Icon path (relative to the editor): '" />
       	</xsl:apply-templates>    
       	
       	<!--xsl:apply-templates select="$element/INFO/DOCKABLE" mode="form-info-line" /-->
       	
	  	<xsl:call-template name="form-desc-line">
	  		<xsl:with-param name="moduleName" select="name($element)" />
	  		<xsl:with-param name="fieldName" select="'SUMMARY'" />
		    <xsl:with-param name="label" select="'Short description: '" />
		    <xsl:with-param name="type" select="'styled'" />
		    <xsl:with-param name="languageID" select="'shared'" />
		    <xsl:with-param name="inputValue" select="$element/DESCRIPTIONS/DESCRIPTION[@languageID='shared']/SUMMARY" />
		    <xsl:with-param name="required" select="false()" />
	    </xsl:call-template>
       	 
       	<xsl:apply-templates select="$element" mode="form-info-line-submit" />
    </xsl:template>
    
    <!-- custom : default navigation items -->
    <xsl:template name="panel-block-details-nav-element">
    	<xsl:param name="element" />
    	
		<xsl:call-template name="navigationdetailsitem">
			<xsl:with-param name="title" select="'Editor'"/>
			<xsl:with-param name="panelURI" select="'namespaces/Details'"/>
            <xsl:with-param name="cssclass">first</xsl:with-param>
			<xsl:with-param name="params">
				<xsl:text>ID:'</xsl:text>
				<xsl:value-of select="$element/DEPENDENCIES/DEPENDENCY[@type='officity:appNamespaces']/NAMESPACE/@ID" />
				<xsl:text>'</xsl:text>
			</xsl:with-param>
			<xsl:with-param name="icon">
				<xsl:text>../system/images/icons/namespace/namespace-16.png</xsl:text>
			</xsl:with-param> 
		</xsl:call-template>
		<xsl:call-template name="nav-links">
			<xsl:with-param name="title" select="'Modules'"/>
			<xsl:with-param name="panelURI" select="'modules/ModuleLink'"/>
			<xsl:with-param name="module" select="'app'" />
			<xsl:with-param name="originID" select="$element/@ID" />
			<xsl:with-param name="targetModule" select="'module'" />
			<xsl:with-param name="dependency" select="'officity:appModules'"/>
			<xsl:with-param name="icon">
				<xsl:text>../system/images/icons/modules/module-16.png</xsl:text>
			</xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name="navigationdetailsitem">
			<xsl:with-param name="title" select="'Releases'"/>
			<xsl:with-param name="panelURI" select="'publish/ReleasesList'"/>
			<xsl:with-param name="params">
				<xsl:text>appID:'</xsl:text>
				<xsl:value-of select="$element/@ID" />
				<xsl:text>'</xsl:text>
			</xsl:with-param>
			<xsl:with-param name="icon">
				<xsl:text>../system/images/icons/publish/release-16.png</xsl:text>
			</xsl:with-param> 
		</xsl:call-template>
		<xsl:call-template name="navigationdetailsitem">
			<xsl:with-param name="title" select="'Release notes'"/>
			<xsl:with-param name="panelURI" select="'releasenotes/ReleaseNotesList'"/>
			<xsl:with-param name="params">
				<xsl:text>appID:'</xsl:text>
				<xsl:value-of select="$element/@ID" />
				<xsl:text>'</xsl:text>
			</xsl:with-param>
			<xsl:with-param name="icon">
				<xsl:text>../system/images/icons/publish/releasenote-16.png</xsl:text>
			</xsl:with-param> 
		</xsl:call-template>
		<xsl:if test="$element/DEPENDENCIES/DEPENDENCY[@type='officity:appNamespaces']/NAMESPACE">
			<xsl:call-template name="navigationdetailsitem">
				<xsl:with-param name="title" select="'Go to...'"/>
				<xsl:with-param name="app" select="$element/INFO/URL"/>
				<xsl:with-param name="editor" select="$element/DEPENDENCIES/DEPENDENCY[@type='officity:appNamespaces']/NAMESPACE/INFO/NAMESPACE"/>
				<xsl:with-param name="panelURI" select="'HomePanel'"/>
				<xsl:with-param name="params">
				</xsl:with-param>
				<xsl:with-param name="icon">
				</xsl:with-param> 
			</xsl:call-template>
		</xsl:if>
        <xsl:call-template name="new-followup">
            <xsl:with-param name="title">Follow-up</xsl:with-param>
            <xsl:with-param name="element" select="$element" />
        </xsl:call-template>
		<xsl:call-template name="history-list">
			<xsl:with-param name="title">History</xsl:with-param>
			<xsl:with-param name="element" select="$element" />
			<xsl:with-param name="cssclass">last</xsl:with-param>
		</xsl:call-template>		
    </xsl:template>
</xsl:stylesheet>