<?xml version="1.0"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/officity/factory/applications/Index.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
    <xsl:import href="include.xsl"/>    
    <xsl:output encoding="UTF-8" method="xml" indent="no"/>
    <xsl:strip-space elements="*"/>
    
    <xsl:param name="list" select="/RESPONSE/RESULTS[@name='list']" />

	<xsl:template match="/RESPONSE">
		<xsl:call-template name="panel-quicksearch">
			<xsl:with-param name="module" select="'app'"/>
			<xsl:with-param name="addNew" select="true()" />
		</xsl:call-template>
	</xsl:template>
	
	<!-- custom list header -->
	<xsl:template name="panel-list-header-quicksearch">
        <xsl:param name="list" />
        <xsl:param name="module" />
        <xsl:param name="addNew" />
        <xsl:param name="addNewScript" />
        
		<xsl:if test="boolean($addNew)=true()">
	        <xsl:call-template name="nav-new">
	            <xsl:with-param name="title">Create new...</xsl:with-param>
	            <xsl:with-param name="module" select="$module" />
	            <xsl:with-param name="params">
	            	<xsl:if test="/RESPONSE/URL/namespaceID">
	            		<xsl:text>namespaceID:</xsl:text>
	            		<xsl:value-of select="/RESPONSE/URL/namespaceID" />
	            	</xsl:if>
	            </xsl:with-param>
	            <xsl:with-param name="panelURI" select="'applications/New'" />
	            <xsl:with-param name="cssclass" select="'grey-bkgnd'" />
	        </xsl:call-template>
        </xsl:if>
	</xsl:template>
	
	<!-- custom results list -->
	<xsl:template name="panel-list-quicksearch">
		<xsl:param name="list" />
        <xsl:choose>
            <xsl:when test="$list/@hits > 0">
                <xsl:for-each select="$list/*">
                	<xsl:sort select="INFO/EDITORID" />
                	<xsl:sort select="INFO/DENOMINATION" />
                    <xsl:apply-templates select="." mode="element-navitem" />
                </xsl:for-each>
            </xsl:when>
            <xsl:otherwise>
                <div class="no-result">
                	<xsl:text>No hits</xsl:text>
                    <xsl:if test="/RESPONSE/MESSAGE[@msgType!='0']">
                		<br />
                		<span style="font-size:0.6em;">
                			<xsl:text>Warning: </xsl:text>
                			<xsl:value-of select="/RESPONSE/MESSAGE[@msgType!='0']" />
               			</span>
                	</xsl:if>
                </div>
            </xsl:otherwise>
        </xsl:choose>
	</xsl:template>
</xsl:stylesheet>