<?xml version="1.0"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/officity/factory/modules/DependencyNew.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
    <xsl:import href="include.xsl"/>    
    <xsl:output encoding="UTF-8" method="xml" indent="no"/>
    <xsl:strip-space elements="*"/>
    
    <!-- parameters -->
    <xsl:param name="item" select="/RESPONSE/RESULTS[@name='item']/*[1]"/>
    
    <xsl:param name="fromModuleID" select="/RESPONSE/URL/fromModuleID" />
    <xsl:param name="modules" select="/RESPONSE/RESULTS[@name='modules']/MODULE" />
    <xsl:param name="fromModule" select="$modules[@ID=$fromModuleID]" />
    <xsl:param name="fromModuleDenom" select="$fromModule/INFO/DENOMINATION" />
    
   	<xsl:template match="/RESPONSE">
    	<xsl:call-template name="panel-newelement">
	    	<xsl:with-param name="element" select= "$item" />
	    	<xsl:with-param name="title" select= "'New Dependency'" />
	    	<xsl:with-param name="titlecssclass" select= "'dependency'" />
    	</xsl:call-template>
    </xsl:template>

	<!-- custom : info form -->
    <xsl:template name="element-tab-info">
					
		<input type="hidden" name="from-module-denom" value="{$fromModuleDenom}" />		
   		<xsl:call-template name="overview-line">
   			<xsl:with-param name="label" select="'From Module: '" />
   			<xsl:with-param name="value" select="$fromModuleDenom" />
   		</xsl:call-template>
   		
   		<xsl:call-template name="form-info-line">
   			<xsl:with-param name="label" select="'*To Module: '" />
   			<xsl:with-param name="input">
   				<select id="to-module-denom" name="to-module-denom" class="input-select required">
   					<xsl:attribute name="onchange">
   						var panel = $('#<xsl:value-of select="$panelID" />.panel');   						
   											
   						var depTypeElem = panel.find('#dep-type'); 
   						depTypeElem.closest('tr').show();
   						depTypeElem.val('aow');   						
   						if ($(this).val() == '<xsl:value-of select="$fromModuleDenom" />')
   						{   			
   							depTypeElem.children('option[value=uturn]').show();	 						
   						}
   						else
   						{
   							depTypeElem.children('option[value=uturn]').hide();
   						}		   						
   						
   						panel.find('.to-module-denom').html($(this).children(':selected').text());   	
					   	panel.find('#start-fieldset').show();						   					
  						panel.find('#return-fieldset').hide();  
  						inputsValidator<xsl:value-of select="$panelID"/>.removeRequired(panel.find('#return-dep-name').val(''), true);						
   					</xsl:attribute>
		            <option value="">
		                <xsl:text>(Choose a module)</xsl:text>
		            </option>
		            <xsl:for-each select="$modules">
		                <xsl:sort select="INFO/DENOMINATION" />
		                <option value="{INFO/DENOMINATION}">
		                    <xsl:value-of select="INFO/DENOMINATION"/>
		                </option>
		            </xsl:for-each>
   				</select>
   			</xsl:with-param>
   		</xsl:call-template>
   		<xsl:call-template name="form-info-line">
   			<xsl:with-param name="label" select="'Type: '" />
   			<xsl:with-param name="input">
   				<select id="dep-type" name="dep-type" class="input-select">
   					<xsl:attribute name="onchange">	  
   						var panel = $('#<xsl:value-of select="$panelID" />.panel');
   						switch ($(this).val())
   						{
   							case 'art':
   								inputsValidator<xsl:value-of select="$panelID"/>.addRequired(panel.find('#return-dep-name'), true);
		   						panel.find('#return-fieldset').show();
   								break;
   								
   							default:
   								panel.find('#return-fieldset').hide();
   								inputsValidator<xsl:value-of select="$panelID"/>.removeRequired(panel.find('#return-dep-name').val(''), true);
   								break;
   						}
   					</xsl:attribute>
		            <xsl:for-each select="//LIST[@name='DependencyTypes']/ITEM">
		                <xsl:sort select="@label" />
		                <option value="{@value}">
		                    <xsl:value-of select="@label"/>
		                </option>
		            </xsl:for-each>
   				</select>
   			</xsl:with-param>
   			<xsl:with-param name="hidden" select="true()" />
   			<xsl:with-param name="topLabel" select="true()" />
	    	<xsl:with-param name="extraLabel">
	    		<xsl:text>The meaning of a dependency can be contextualized. For example the dependency "Is capital of" makes sense only if you read it that way "module City "Is capital of" module Country" (Asymmetrical One-way). The dependency "Is my brother" between module Contact and itself makes sense in both reading directions (Symmetrical Round-trip). To define a professional relation between modules Contact and Society we may need to define two dependencies "Works for" and "Employs" (Asymmetrical Round-trip).</xsl:text>
	    	</xsl:with-param>
   		</xsl:call-template>
   		<xsl:call-template name="form-info-line">
   			<xsl:with-param name="label" select="'*Table: '" />
   			<xsl:with-param name="input">
   				<input type="text" id="table" name="table" value="dependencies" class="input-text required" />
			</xsl:with-param>
	    	<xsl:with-param name="extraLabel">
	    		<xsl:text>Database table associated to your dependency(ies). If your dependency(ies) could potentially be used a lot, choose a dedicated table.</xsl:text>
	    	</xsl:with-param>
	    	<xsl:with-param name="topLabel" select="true()" />   				
   		</xsl:call-template>
   		
        <tr>
            <td colspan="2">
		   		<fieldset id="start-fieldset" class="fieldsets" style="display:none;">
		   			<legend>
		   				<xsl:value-of select="$fromModule/INFO/DENOMINATION" />
		   				<xsl:text> </xsl:text>
		   				<img src="{$systemImagesURL}/icons/dependencies/arrow-right.png" style="height: 16px; width: 16px; position: relative; top: 4px; margin: 0 0px 0 0px;"/>
		   				<xsl:text> </xsl:text>
		   				<span class="to-module-denom" />
		  			</legend>
		  			<table class="dependencies">
				   		<xsl:call-template name="form-info-line">
				   			<xsl:with-param name="label" select="'*Name: '" />
				   			<xsl:with-param name="input">
				   				<input type="text" id="start-dep-name" name="start-dep-name" value="" class="input-text required" />
							</xsl:with-param>
					    	<xsl:with-param name="extraLabel">
					    		<xsl:text>Technical name of your dependency. (Spaces and other special characters will be removed.)</xsl:text>
					    	</xsl:with-param>
					    	<xsl:with-param name="topLabel" select="true()" />  
				   		</xsl:call-template>
				   		<xsl:call-template name="form-info-line">
				   			<xsl:with-param name="label" select="'Label: '" />
				   			<xsl:with-param name="input">
				   				<input type="text" id="start-dep-label" name="start-dep-label" value="" class="input-text" />
							</xsl:with-param>
					    	<xsl:with-param name="extraLabel">
					    		<xsl:text>Human-friendly name of your dependency.</xsl:text>
					    	</xsl:with-param>
				   		</xsl:call-template>
				   		<xsl:call-template name="form-info-line">
				   			<xsl:with-param name="label" select="'Search Label: '" />
				   			<xsl:with-param name="input">
				   				<input type="text" id="start-dep-searchlabel" name="start-dep-searchlabel" value="" class="input-text" />
							</xsl:with-param>
					    	<xsl:with-param name="extraLabel">
					    		<text>You may need to rephrase your label in the context of a search. For example the label of a dependency between modules Contact and Society is "Works for". In a "Contact Search Form" that label could be rewritten as "Who is currently working for…".</text>
					    	</xsl:with-param>
					    	<xsl:with-param name="topLabel" select="true()" />  
				   		</xsl:call-template>
		  			</table>
		   		</fieldset>
	   		</td>
   		</tr>
        <tr>
            <td colspan="2">
		   		<fieldset id="return-fieldset" class="fieldsets" style="display:none;">
		   			<legend>   				
			   			<span class="to-module-denom" />
			   			<xsl:text> </xsl:text>
		   				<img src="{$systemImagesURL}/icons/dependencies/arrow-right-blue.png" style="height: 16px; width: 16px; position: relative; top: 4px; margin: 0 0px 0 0px;"/>  
		   				<xsl:text> </xsl:text> 				
		   				<xsl:value-of select="$fromModule/INFO/DENOMINATION" />
		  			</legend>
		  			<table class="dependencies">
				   		<xsl:call-template name="form-info-line">
				   			<xsl:with-param name="label" select="'Name: '" />
				   			<xsl:with-param name="input">
				   				<input type="text" id="return-dep-name" name="return-dep-name" value="" class="input-text" />
							</xsl:with-param>
					    	<xsl:with-param name="extraLabel">
					    		<xsl:text>Technical name of your dependency. (Spaces and other special characters will be removed.)</xsl:text>
					    	</xsl:with-param>
					    	<xsl:with-param name="topLabel" select="true()" />  
				   		</xsl:call-template>
				   		<xsl:call-template name="form-info-line">
				   			<xsl:with-param name="label" select="'Label: '" />
				   			<xsl:with-param name="input">
				   				<input type="text" id="return-dep-label" name="return-dep-label" value="" class="input-text" />
							</xsl:with-param>
					    	<xsl:with-param name="extraLabel">
					    		<xsl:text>Human-friendly name of your dependency.</xsl:text>
					    	</xsl:with-param>
				   		</xsl:call-template>
				   		<xsl:call-template name="form-info-line">
				   			<xsl:with-param name="label" select="'Search Label: '" />
				   			<xsl:with-param name="input">
				   				<input type="text" id="return-dep-searchlabel" name="return-dep-searchlabel" value="" class="input-text" />
							</xsl:with-param>
					    	<xsl:with-param name="extraLabel">
					    		<text>You may need to rephrase your label in the context of a search. For example the label of a dependency between modules Contact and Society is "Works for". In a "Contact Search Form" that label could be rewritten as "Who is currently working for…".</text>
					    	</xsl:with-param>
					    	<xsl:with-param name="topLabel" select="true()" />  
				   		</xsl:call-template>
		  			</table>
		   		</fieldset>
	   		</td>
   		</tr>
	    
	    <xsl:call-template name="form-info-line-submit">
	    	<xsl:with-param name="buttonLabel" select="'Create'"/>
      		<xsl:with-param name="createAndNew" select="true()" />
	    </xsl:call-template>
    </xsl:template>
    
	<!-- custom form js -->
	<xsl:template name="element-form-js">
		<xsl:param name="element" />
		<xsl:param name="newElement" />
		<xsl:param name="tabDenom" />
		<xsl:param name="addInputsValidation" select="true()" />
		<xsl:param name="processingMsg" />
		<xsl:param name="newPanelTitle" />
		
		<xsl:variable name="formID">
			<xsl:call-template name="gen-tabID">
				<xsl:with-param name="denom" select="$tabDenom" />
			</xsl:call-template>
		</xsl:variable>
		
		<!-- inputs validation -->
		var inputsValidator<xsl:value-of select="$panelID"/> = new InputsValidator(<xsl:value-of select="$panelID"/>, '#<xsl:value-of select="$formID" />');
	
    		    $('#<xsl:value-of select="$formID" />').submit(function() {
          			fm = new FormManager(<xsl:value-of select="$panelID"/>, AppController);
					fm.onSuccess(function(response){
					   var elemLabel = (response.label) ? response.label : 'Newly created dependency';
		               <xsl:text>$(AppController).panelslider('replacePanel', </xsl:text>
		                   <xsl:value-of select="$panelID"/>
		                   <xsl:text>,'modules/DependencyDetails',elemLabel,</xsl:text>
		                   <xsl:text>{editor:'officity',app:'factory',module:response.module,startID:response.startID,fromDenom:response['from-module-denom'],toDenom:response['to-module-denom']}</xsl:text>
		               <xsl:text>, 1);</xsl:text>
					});					
					fm.setScript('<xsl:value-of select="$appsURL" /><xsl:text>sushee/shared/dependency/dependency-ops.php?op=create</xsl:text>');
					fm.displayProcess('<xsl:value-of select="$processingMsg" />');		
            
					fm.parseAndSend(this);		
					return false;
        		});
        
		        $('#<xsl:value-of select="$formID" />').find(':button#create-and-new-button').click(function() {
		          	fm = new FormManager(<xsl:value-of select="$panelID"/>, AppController);
		
					fm.onSuccess(function(response){
		               <xsl:text>$(AppController).panelslider('reloadPanel', </xsl:text>
		                   <xsl:value-of select="$panelID"/>
		               <xsl:text>, 1);</xsl:text>
					});						
					fm.setScript('<xsl:value-of select="$appsURL" /><xsl:text>sushee/shared/dependency/dependency-ops.php?op=create</xsl:text>');
		
					fm.displayProcess('<xsl:value-of select="$processingMsg" />');		  
		            
					fm.parseAndSend('#<xsl:value-of select="$formID" />');					
					return false;
		        });
	</xsl:template>
</xsl:stylesheet>