<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/officity/factory/modules/FieldDetails.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
    require_once(dirname(__FILE__).'/include.php');
    
    /* *** */
        
    function addSourceCodeFromTemplate($denomination, &$nql, $tplURI, $name)
    {
    	$tpl_path = SYSTEM_PACKAGES_PATH.$tplURI;
    	$tpl_file = new KernelFile($tpl_path);
    	
    	if ($tpl_file->exists())
    	{
			$content = $tpl_file->toString();
			$src = $content;
			$src = str_replace('%DENOMINATION%', strtoupper($denomination), $src);
	    	$src = xmlpp($src);
    	}
    	else
    	{
    		$src = '!!! Code template file "'.$tplURI.'" does not exist !!!';
    	}
    	
    	$nql->addStatic($src, $name);
    }
    
    /* *** */

    $nql = new Sushee_Shell(false);
    
    // for later
	$nql->addCommand('
        <GET name="item">
            <FIELD ID="'.URLParam::fetch('ID').'"/>
            <RETURN>
            	<INFO>
            		<DENOMINATION />
            	</INFO>
            </RETURN>
        </GET>
    ');
	$nql->execute();
	$denomination = $nql->valueOf('/RESPONSE/RESULTS/FIELD/INFO/DENOMINATION');
	
	$nql = new Officity_Shell();

	$nql->addCommand('
        <GET name="item">
            <FIELD ID="'.URLParam::fetch('ID').'"/>
            <RETURN depth="2">
                <INFO creator_info="small" modifier_info="small" owner_info="small"/>
                <DEPENDENCIES/>
                <DESCRIPTIONS>
                	<DESCRIPTION languageID="all" />
                </DESCRIPTIONS>
            </RETURN>
        </GET>
	');		
	$nql->addModuleFields('FIELD');    
    $nql->addCommand('<SEARCH><LIST /></SEARCH>');
    $nql->addMonths();
     
    $nql->addCommand('
    	<SEARCH name="modules">
    		<MODULE />
    		<RETURN>
    			<INFO>
	    			<DENOMINATION />
    			</INFO>
    		</RETURN>
    	</SEARCH>
    ');
    
    addSourceCodeFromTemplate($denomination, $nql, 'field/source.overview-line.xsl', 'sourceXSLOverview');
    addSourceCodeFromTemplate($denomination, $nql, 'field/source.input-line.xsl', 'sourceXSLInput');
    
    $nql->execute();
    
    echo $nql->transform(dirname(__FILE__).'/FieldDetails.xsl');
?>