<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/officity/factory/modules/ModuleLink.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
    require_once(dirname(__FILE__).'/include.php');
	
	// editor's display
    $nql = new Officity_Shell();

	$element = ElementFactory::build(URLParam::fetch('targetModule'));
    $element->addSharedResourcesCommands($nql); // resources needed for display
    // sorting on DESCRIPTION/HEADER does not return the elements with no DESCRIPTION, why?
    //$element->setDisplayProfile(); // return needed for display
	$element->setReturn(array(
        'INFO/DENOMINATION',
		'INFO/EXTENDS',
		'DEPENDENCY[@type="officity:moduleNamespaces"]/NAMESPACE',
		'DEPENDENCY[@type="officity:moduleNamespaces"]/EDITOR',
		'DESCRIPTION/HEADER'
    ), 2);

	if (URLParam::isNotEmpty('quicksearch-text'))
	{
		$element->addSearchInfo('SEARCHTEXT', 'MATCH', URLParam::fetch('quicksearch-text'));
	}
	else
	{
		$element->setDependencyByName(URLParam::fetch('dependency'), URLParam::fetch('module'), URLParam::fetch('originID'), 'reverse', '');
	}
	
	//$element->setDefaultPaginate(URLParam::fetch('display', 50), URLParam::fetch('page', 1));
	$element->search('list', false);

	$command = $element->getNQLCommand();
	$nql->addCommand($command);

    $dep_element = ElementFactory::build(URLParam::fetch('targetModule'));
    $dep_element->addSharedResourcesCommands($nql); // resources needed for display
    
    $dep_element->setDependencyByName(URLParam::fetch('dependency'), URLParam::fetch('module'), URLParam::fetch('originID'), 'reverse', '');
    $dep_element->setNoReturn();
    $dep_element->search('depsList', false);

    $command = $dep_element->getNQLCommand();
	$nql->addCommand($command);

	$nql->addPaging();
    
    echo $nql->transform(dirname(__FILE__).'/ModuleLink.xsl');
?>