<?xml version="1.0"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/officity/factory/namespaces/Index.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
    <xsl:import href="include.xsl"/>    
    <xsl:output encoding="UTF-8" method="xml" indent="no"/>
    <xsl:strip-space elements="*"/>
    
    <xsl:param name="list" select="/RESPONSE/RESULTS[@name='list']" />

	<xsl:template match="/RESPONSE">
		<xsl:call-template name="panel-results">
			<xsl:with-param name="addNew" select="true()" />
		</xsl:call-template>
	</xsl:template>
	
    <!-- results body -->
	<xsl:template name="panel-body-results">
        <xsl:param name="list" />
        <xsl:param name="module" />
        <xsl:param name="addNew" />
        <xsl:param name="addNewScript" />
        <xsl:param name="pagingStyle" />

        <xsl:call-template name="staticitemheader">
            <xsl:with-param name="title">Editors</xsl:with-param>
            <xsl:with-param name="icon">../system/images/icons/namespace/namespace-32.png</xsl:with-param>
            <xsl:with-param name="info">
            	<xsl:text>Your Editor name is an authoritative name under which you create and publish modules and applications. Only Editors are entitled to do so. This avoids collisions with other Editors' resources or system's resources.</xsl:text>
            </xsl:with-param>
        </xsl:call-template>
                
        <xsl:choose>
	        <xsl:when test="$pagingStyle='browser'">
		        <xsl:call-template name="list-browser">
		            <xsl:with-param name="list" select="$list"/>
		            <xsl:with-param name="event" select="'loadpage'"/>
		        </xsl:call-template>
	        </xsl:when>
	        <xsl:when test="$pagingStyle='pager'">
		        <xsl:call-template name="list-pager">
		            <xsl:with-param name="list" select="$list"/>
		            <xsl:with-param name="event" select="'loadpage'"/>
		        </xsl:call-template>
	        </xsl:when>
        </xsl:choose>
        
		<xsl:call-template name="panel-list-header-results">
	        <xsl:with-param name="list" select="$list" />
	        <xsl:with-param name="module" select="$module" />
	        <xsl:with-param name="addNew" select="$addNew" />
	        <xsl:with-param name="addNewScript" select="$addNewScript" />
		</xsl:call-template>
        
		<xsl:call-template name="panel-list-results">
			<xsl:with-param name="list" select="$list"/>
		</xsl:call-template>

        <xsl:choose>
	        <xsl:when test="$pagingStyle='browser'">
		        <xsl:call-template name="list-browser">
		            <xsl:with-param name="list" select="$list"/>
		            <xsl:with-param name="event" select="'loadpage'"/>
		        </xsl:call-template>
	        </xsl:when>
	        <xsl:when test="$pagingStyle='pager'">
		        <xsl:call-template name="list-pager">
		            <xsl:with-param name="list" select="$list"/>
		            <xsl:with-param name="event" select="'loadpage'"/>
		        </xsl:call-template>
	        </xsl:when>
        </xsl:choose>
	</xsl:template>
</xsl:stylesheet>