<?xml version="1.0"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/officity/lib/documents/FolderDetails.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
    <xsl:import href="include.xsl"/>    
    <xsl:output encoding="UTF-8" method="xml" indent="no"/>
    <xsl:strip-space elements="*"/>
    
    <!-- parameters -->
    <xsl:param name="fields" select="/RESPONSE/RESULTS[@name='fields']/FIELD"/>
    <xsl:param name="depentities" select="/RESPONSE/RESULTS[@name='dependencies']/DEPENDENCYENTITY"/>
  	<!--xsl:param name="descriptions" select="/RESPONSE/RESULTS[@name='descriptions']/DESCRIPTIONCONFIG"/-->
    <xsl:param name="item" select="/RESPONSE/RESULTS[@name='item']/*[1]"/>
    <xsl:param name="itemInfo" select="$item/INFO"/>
    <xsl:param name="itemDeps" select="$item/DEPENDENCIES"/>
    <xsl:param name="itemDescs" select="$item/DESCRIPTIONS"/>
    <xsl:param name="module" select="/RESPONSE/URL/module"/>
    
    <!-- optional -->
    <xsl:param name="dependency" select="/RESPONSE/URL/dependency"/>
    <xsl:param name="targetModule" select="/RESPONSE/URL/targetModule"/>
    <xsl:param name="targetID" select="/RESPONSE/URL/targetID"/>
    
	<!-- IDs -->
    
   	<xsl:template match="/RESPONSE">
    	<xsl:call-template name="panel-elementdetails">
    		<xsl:with-param name="element" select= "$item" />
    		<xsl:with-param name="tabsList">
				<xsl:text>info,Info;</xsl:text>
    		</xsl:with-param>
    		 <xsl:with-param name="displayOverviewTab" select="true()" />
    		 <xsl:with-param name="displayAdminTab" select="true()" />
    		 <xsl:with-param name="deleteRight" select="false()" />
    	</xsl:call-template>
    </xsl:template>
    
    <!-- custom : title -->
    <xsl:template name="panel-body-element-title">
    	<xsl:param name="title" />
    	<xsl:param name="cssclass" />  	
    	<xsl:apply-templates select="$item" mode="element-title" />
    </xsl:template>

    <!-- no preview -->
    <xsl:template name="panel-block-details-preview-element">
    </xsl:template>

    <!-- custom : tabs content -->
	<xsl:template name="panel-body-element-tabs-content">
		<xsl:param name="element" />
		<xsl:param name="newElement" />
		
		<!-- tab : info -->
  		<xsl:call-template name="element-tabform-create">
			<xsl:with-param name="denom" select="'info'" />
			<xsl:with-param name="element" select="$element" />
			<xsl:with-param name="content">
				<xsl:call-template name="element-tab-info">
					<xsl:with-param name="element" select="$element" />
				</xsl:call-template>
			</xsl:with-param>
		</xsl:call-template>	
	</xsl:template>
	
	<!-- custom : overview -->
    <xsl:template name="element-tab-overview">
    	<xsl:param name="element" />  
    	<xsl:param name="legend" />  
    	
        <table class="fields">        	
        	<xsl:call-template name="overview-line">
        		<xsl:with-param name="label" select="'Size:'" />
        		<xsl:with-param name="value">
					<span id="container-size-details">
						<!-- becomes incorrect when adding content then reloading -->
						<!--xsl:choose>
							<xsl:when test="/RESPONSE/URL/sizeDetails">
								<xsl:value-of select="/RESPONSE/URL/sizeDetails" />
							</xsl:when>
							<xsl:otherwise-->
								<xsl:value-of select="$element/INFO/ITEMS" />
								<xsl:text> item(s)</xsl:text>
							<!--/xsl:otherwise>
						</xsl:choose-->
					</span>	
					<a title="Compute folder size" href="#" class="info-action" style="display:inline-block; margin-left:5px; vertical-align:middle;">
						<xsl:call-template name="container-getsize-handler">
							<xsl:with-param name="container" select="$element" />
						</xsl:call-template>
					</a>
				</xsl:with-param>
        	</xsl:call-template>
        	<xsl:apply-templates select="$element/INFO/CREATIONDATE" mode="overview-line" />
        	<xsl:apply-templates select="$element/INFO/MODIFICATIONDATE" mode="overview-line" />
        	<xsl:apply-templates select="$element/INFO/TYPE" mode="overview-line" />
        	<xsl:call-template name="form-empty-line" />
        </table>
        <div class="libitem-actions">
        	<a href="#" title="Download" class="action download">
        		<xsl:attribute name="onclick">
			        fm = new FormManager(<xsl:value-of select="$panelID"/>, AppController);
			
			        fm.onSuccess(delegate(this, function(response){
		                var downloadURL = '<xsl:value-of select="$systemToolsURL"/>file_download.php?target='+response.path;
		                window.location.replace(downloadURL);
			        }));
			
			        fm.displayProcess('Downloading...');
			        fm.setScript('<xsl:apply-templates select="$element" mode="element-script-download" />');
			        fm.parseAndSend(this.parentNode);
			
			        return false;
        		</xsl:attribute>
        		<xsltext>Compress &amp; Download</xsltext>
       		</a>
        	<!--a href="#" title="Copy files links" class="action copylink">
        		<xsl:attribute name="onclick">
        		</xsl:attribute>
        		<xsltext>Copy files links</xsltext>
       		</a-->
       		<xsl:apply-templates select="$element" mode="trash-action"/>
       		<xsl:call-template name="breaker" />
        </div>
 	</xsl:template>
	    
    <!-- custom : info tab -->
    <xsl:template name="element-tab-info">
        <xsl:param name="element" />    
        
        <xsl:apply-templates select="$element/INFO/TITLE" mode="form-info-line">
        	<xsl:with-param name="required" select="true()"  />
		</xsl:apply-templates>        
        <xsl:apply-templates select="$element/INFO/DISPLAY" mode="form-info-line">
        </xsl:apply-templates>
		<xsl:apply-templates select="$element/INFO/SUMMARY" mode="form-info-line">
			<xsl:with-param name="type" select="'styled'"  />
		</xsl:apply-templates>    
       	       	 
       	<xsl:apply-templates select="$element" mode="form-info-line-submit">
       		<xsl:with-param name="buttonLabel" select="'Update'"/>
       	</xsl:apply-templates>
    </xsl:template>
     
  	<!-- custom : navigation details -->
    <xsl:template name="panel-block-details-nav-element">
    	<xsl:param name="element" select="$element" />
 	
		<!--xsl:call-template name="navigationdetailsitem">
			<xsl:with-param name="title" select="'Tools'"/>
			<xsl:with-param name="panelURI" select="''"/>
			<xsl:with-param name="params">
			</xsl:with-param>
			<xsl:with-param name="icon">
			</xsl:with-param> 
			<xsl:with-param name="cssclass">first</xsl:with-param>
		</xsl:call-template-->
		<xsl:call-template name="nav-links">
            <xsl:with-param name="title">
            	<xsl:text>Content</xsl:text>          	 
            </xsl:with-param>
			<xsl:with-param name="module" select="'officity:libitem'" />
			<xsl:with-param name="originID" select="$element/@ID" />
			<xsl:with-param name="targetModule" select="'officity:libitem'" />
			<xsl:with-param name="dependency" select="'officity:content'"/>
			<xsl:with-param name="params">trashed:'<xsl:value-of select="$element/INFO/TRASHED" />'</xsl:with-param>
			<xsl:with-param name="panelURI" select="'documents/ContentList'"/>
			<xsl:with-param name="cssclass">first</xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name="nav-links">
			<xsl:with-param name="title">
				<xsl:text>Parent(s)</xsl:text>
			</xsl:with-param>
			<xsl:with-param name="module" select="'officity:libitem'" />
			<xsl:with-param name="originID" select="$element/@ID" />
			<xsl:with-param name="targetModule" select="'officity:libitem'" />
			<xsl:with-param name="dependency" select="'officity:container'"/>
			<xsl:with-param name="params">trashed:'<xsl:value-of select="$element/INFO/TRASHED" />'</xsl:with-param>
			<xsl:with-param name="panelURI" select="'documents/ParentsList'"/>
		</xsl:call-template>

		<xsl:call-template name="security-permissions">
            <xsl:with-param name="element" select="$element" />
            <xsl:with-param name="tree" select="'true'" />
        </xsl:call-template>

		<!-- <xsl:call-template name="navigationdetailsitem">
			<xsl:with-param name="title" select="'Security'"/>
			<xsl:with-param name="panelURI" select="'documents/SecurityActions'"/>
			<xsl:with-param name="params">
				<xsl:text>targetItemID:</xsl:text>
				<xsl:value-of select="$element/@ID" />
			</xsl:with-param>
			<xsl:with-param name="icon">
			</xsl:with-param> 
		</xsl:call-template> -->
		
		<!--xsl:call-template name="navigationdetailsitem">
			<xsl:with-param name="title" select="'Apply Settings'"/>
			<xsl:with-param name="panelURI" select="''"/>
			<xsl:with-param name="params">
				<xsl:text>targetItemID:</xsl:text>
				<xsl:value-of select="$element/@ID" />
			</xsl:with-param>
			<xsl:with-param name="icon">
			</xsl:with-param> 
		</xsl:call-template-->
		
        <xsl:call-template name="new-followup">
            <xsl:with-param name="title" select="'Notes'"/>
            <xsl:with-param name="element" select="$element" />          
        </xsl:call-template>
		<xsl:call-template name="history-list">
			<xsl:with-param name="title">History</xsl:with-param>
			<xsl:with-param name="element" select="$element" />
			<xsl:with-param name="cssclass">last</xsl:with-param>
		</xsl:call-template>
    </xsl:template>
    	
    <!-- custom : additional js -->
    <xsl:template name="panel-add-js">
    
    </xsl:template>
</xsl:stylesheet>