<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/officity/shared/task/task-op.class.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
	class Officity_TaskElementOperation extends AbstractElementOperation
	{
		function __construct()
		{
			parent::__construct(new Officity_TaskElement());		
		}
		
		function __destruct()
		{
			
		}
		
		/* *** */
		
		public function _count()
		{
			session_write_close(); // optim: unlock session data and allow concurrent accesses to this script
			
            $TYPE = $this->fetchURLParam('type');
            if ($TYPE == 'inbox')
            {                
                $this->element->setSearchDependencyByName('officity:childtasks', 'none');
                $this->element->setSearchDependencyByName('officity:parenttasks', 'none');
                $this->element->setSearchDependencyByName('officity:contexts', 'none');
            }
            else if ($TYPE == 'todo')
            {
        		$this->element->addSearchInfo('OWNERID', '=', 'visitor');
			}
            else if ($TYPE == 'marked')
            {
                $this->element->addSearchInfo('FLAG', '=', '1');
            }
            else if ($TYPE == 'late')
            {
                $this->element->addSearchInfo('DUEDATE', 'LT', 'today');
            }

            $this->element->addSearchInfo('TYPE', '=', 'action');
            $this->element->addSearchInfo('STATUS', 'NE', 'finished');
            $hits = $this->element->count();

            if ($hits !== false)
            {
                $this->success($hits);
            }
            
            return false;
		}
	}
?>