<?xml version="1.0"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/officity/springboard/Login.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
	<xsl:import href="app.include.xsl"/>	
    <xsl:output encoding="UTF-8" method="xml" indent="no"/>
    <xsl:strip-space elements="*"/>
    
    <xsl:template match="/RESPONSE">
		<html>
			<head>
				<meta content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0" name="viewport" />
				<title>
					<xsl:value-of select="$editorName"/> application login - <xsl:value-of select="$appName"/>
				</title>
				<link rel="stylesheet" type="text/css" href="{$systemURL}css/login.css"/>
				<link href="http://www.nectil.com/paperclip.ico" type="image/x-icon" rel="icon" />
				<script type="text/javascript" src="{$systemURL}js/jQuery/jquery-1.4.2.min.js">&#160;</script>
				<script type="text/javascript" src="{$systemURL}js/jquery.detection.utils.js">&#160;</script>
			</head>
			<body>
				<p id="browser-check" class="loginMsg warningMsg" style="visibility:hidden;">
					Unfortunately, your version of Internet Explorer is currently not fully supported by the system.<br />
					Please upgrade to <a href="http://www.microsoft.com/windows/internet-explorer/default.aspx" target="_blank">Internet Explorer 8</a> or use <a href="http://www.firefox.com" target="_blank">Firefox</a>, <a href="http://www.apple.com/safari/" target="_blank">Safari</a> or <a href="http://www.google.com/chrome" target="_blank">Chrome</a>. Thank you.
				</p>
				<p id="cookies-check" class="loginMsg warningMsg" style="visibility:hidden;">
					Warning : cookies are not enabled on your browser but are required by the system.<br />
					Please enable cookies and try again. Thank you.
				</p>
				<xsl:if test="/RESPONSE/URL/loginErrMsg">
					<p id="login-check" class="loginMsg errorMsg">
						<xsl:value-of select="/RESPONSE/URL/loginErrMsg" />
					</p>
				</xsl:if>
				<table align="center" id="loginTable">
					<tr>
						<td>
							<form id="loginForm" action="" method="post">
								<input type="hidden" name="editor" value="{$editorFolder}" />
								<input type="hidden" name="app" value="{$appFolder}" />
								<input type="hidden" name="editorName" value="{$editorName}" />
								<input type="hidden" name="appName" value="{$appName}" />
								
								<table align="center">
									<tr>
										<td class="title-cell" colspan="2">
											<xsl:value-of select="$appName"/><br/>
											<xsl:value-of select="$editorName"/>
										</td>
									</tr>
									<tr>
										<td class="label-cell first">
											<label>E-Mail:</label>
										</td>
										<td class="first">
											<input id="login" name="login" size="30" value="{/RESPONSE/URL/ln}"/>
										</td>
									</tr>
									<tr>
										<td class="label-cell">
											<label>Password:</label>
										</td>
										<td>
											<input type="password" id="password" name="password" size="30" value="{/RESPONSE/URL/lp}"/>
										</td>
									</tr>
									<tr>
										<td class="label-cell">
											<label>Language:</label>
										</td>
										<td>
										<select name="language" id="language">
					                        <xsl:for-each select="/RESPONSE/RESULTS[@name='published_languages']/LANGUAGE">
					                            <option value="{@ID}">
					                                <xsl:if test="@ID=/RESPONSE/URL/lg">
					                                    <xsl:attribute name="selected">
					                                        <xsl:text>selected</xsl:text>
					                                    </xsl:attribute>
					                                </xsl:if>
					                                <xsl:value-of select="LABEL"/>
					                            </option>
					                        </xsl:for-each>					
										</select>
										</td>
									</tr>
									<tr><td colspan="2">&#160;</td></tr>
									<tr>
										<td align="right">
				                            <input id="sc" type="checkbox" value="1" name="sc"  checked="checked"/>
										</td>
										<td style="font-size:.8em;" align="left">
											<label>Stay connected</label>
										</td>
									</tr>
									<tr>
										<td colspan="2" class="submit-cell">
											<input type="submit" value="connect"/>
										</td>
									</tr>
								</table>
							</form>
						</td>
					</tr>
				</table>
				<script type="text/javascript">
					$(document).ready(function(){
				        if ($.browserCheck() == false)
				        {
							$('#browser-check').show();
				        }
				        if ($.cookiesCheck() == false)
				        {
							$('#cookies-check').show();
				        }
					});
				</script>
			</body>
		</html>
    </xsl:template>
    
	<!--xsl:template match="/RESPONSE[not(URL/firstTime)]">
           <div id="login-dialog" title="Nectil login - CRM" class="modal-dialog">
           	<form id="loginForm" action="{$appsURL}{$editor}/{$app}/app.php" method="post">
           		<xsl:if test="not(/RESPONSE/URL/firstTime)">	                
					<div class="info">
						<p align="center">
							<xsl:text>Your session has expired. Please log in.</xsl:text>							
	                 	</p>
	                </div>	
            	</xsl:if>		                
                <div class="info">
                    <label>E-Mail : </label>
                    <input id="login" name="login" size="30" value="{/RESPONSE/URL/ln}"/>
                    <br/><br/>
                    <label>Password : </label>
                    <input type="password" id="password" name="password" size="30" value="{/RESPONSE/URL/lp}"/>
                    <br/><br/>
                	<label>Remember me</label>
                	<input id="rm" type="checkbox" value="1" name="rm"  checked="checked"/>	      
                </div>
                <div class="info">
                    <label>Language : </label>
					<select name="language" id="language">
                        <xsl:for-each select="/RESPONSE/RESULTS[@name='published_languages']/LANGUAGE">
                            <option value="{@ID}">
                                <xsl:if test="@ID=/RESPONSE/URL/language">
                                    <xsl:attribute name="selected">
                                        <xsl:text>selected</xsl:text>
                                    </xsl:attribute>
                                </xsl:if>
                                <xsl:value-of select="LABEL"/>
                            </option>
                        </xsl:for-each>					
					</select>              
                </div>
                <div class="controls">
                	<input type="submit" id="display-ok-button" name="display-ok-button" class="modal-button" value="connect"/>
                </div>
               </form>
           </div>
			<script type="text/javascript">
				$(document).ready(function(){
			        $('#login-dialog').dialog({
			            bgiframe: true,
			            autoOpen: false,
			            width: 360,
			            minHeight: 200,
			            modal:true,
			            closeOnEscape:false
			        });
			        
			        $('#login-dialog').dialog('open');
				});
			</script>
    </xsl:template-->
</xsl:stylesheet>