<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee/shared/dependency/dependency-ops.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
	require_once(dirname(__FILE__).'/include.php');

	class DependencyOperation extends AbstractOperation
	{
		function __construct()
		{
			parent::__construct();		
		}

		function __destruct()
		{
			
		}
		
		protected function _execute($method_name)
		{
			return $this->$method_name();
		}
		
		/* *** */
		
		public function _create()
		{
			$nql = new Sushee_Shell(false);
			
			$dep_type = $this->fetchURLParam('dep-type');
			$type_attr = ($dep_type == 'uturn') ? ' type="uturn"' : '';
			$table = $this->fetchURLParam('table');
			
			$return_dep = ($dep_type != 'aow') ? '					    
				<DEPENDENCYTYPE type="return">
					<TYPE>'.$this->fetchURLParam('return-dep-name').'</TYPE>
					<DENOMINATION>
				        <LABEL languageID="shared">'.$this->fetchURLParam('return-dep-label', '').'</LABEL>
				        <SEARCHLABEL languageID="shared">'.$this->fetchURLParam('return-dep-searchlabel', '').'</SEARCHLABEL>
			      	</DENOMINATION>
			      	<TABLENAME>'.$table.'</TABLENAME>
			    </DEPENDENCYTYPE>
			' : '';
			
			$nql->addCommand('
				<CREATE>
					<DEPENDENCYENTITY'.$type_attr.'>
					  <DEPENDENCYTYPE type="start" from="'.$this->fetchURLParam('from-module-denom').'" to="'.$this->fetchURLParam('to-module-denom').'">
					      <TYPE>'.$this->fetchURLParam('start-dep-name').'</TYPE>
					      <DENOMINATION>
					        <LABEL languageID="shared">'.$this->fetchURLParam('start-dep-label', '').'</LABEL>
					        <SEARCHLABEL languageID="shared">'.$this->fetchURLParam('start-dep-searchlabel', '').'</SEARCHLABEL>
					      </DENOMINATION>
					      <TABLENAME>'.$table.'</TABLENAME>
					    </DEPENDENCYTYPE>
						'.$return_dep.'
					</DEPENDENCYENTITY>
				</CREATE>
			');
			
			/*$nql->addCommand('
				<EMPTY>
					<CACHE>
						<REGEX>DEPENDENCYENTITY</REGEX>
					</CACHE>
				</EMPTY>
			');*/
			
			//xml_out($nql->getQuery());
			
			$message = $nql->getElement('/RESPONSE/MESSAGE');
			if (($message !== false) && ($message->valueOf("@msgType") != '0'))
			{
				$this->abort('Operation failed: '.$message->valueOf('.'));
			}
			
			$this->JSON_response->set('startID', $message->valueOf("@elementID"));
			
			return true;
		}
		
		public function _update()
		{
			$nql = new Sushee_Shell(false);
			
			$nql->addCommand('
				<UPDATE>
					<DEPENDENCYENTITY>
					  <DEPENDENCYTYPE ID="'.$this->fetchURLParam('start-dep-ID').'">
					      <DENOMINATION>
					        <LABEL languageID="shared">'.$this->fetchURLParam('start-dep-label', '').'</LABEL>
					        <SEARCHLABEL languageID="shared">'.$this->fetchURLParam('start-dep-searchlabel', '').'</SEARCHLABEL>
					      </DENOMINATION>
					      <TABLENAME>'.$this->fetchURLParam('table').'</TABLENAME>
					    </DEPENDENCYTYPE>
					</DEPENDENCYENTITY>
				</UPDATE>
			');
			if (URLParam::exists('return-dep-ID'))
			{
				$nql->addCommand('
					<UPDATE>
						<DEPENDENCYENTITY>
						  <DEPENDENCYTYPE ID="'.$this->fetchURLParam('return-dep-ID').'">
						      <DENOMINATION>
						        <LABEL languageID="shared">'.$this->fetchURLParam('return-dep-label', '').'</LABEL>
						        <SEARCHLABEL languageID="shared">'.$this->fetchURLParam('return-dep-searchlabel', '').'</SEARCHLABEL>
						      </DENOMINATION>
						      <TABLENAME>'.$this->fetchURLParam('table').'</TABLENAME>
						    </DEPENDENCYTYPE>
						</DEPENDENCYENTITY>
					</UPDATE>
				');
			}
			
			//xml_out($nql->getQuery());
			
			$nql->execute();
			
			$message = $nql->getElement('/RESPONSE/MESSAGE');
			if (($message !== false) && ($message->valueOf("@msgType") != '0'))
			{
				$this->abort('Operation failed: '.$message->valueOf('.'));
			}
			return true;
		}
		
		public function _delete()
		{
			$nql = new Sushee_Shell(false);
			
			$nql->addCommand('
				<DELETE>
					<DEPENDENCYENTITY>
					  <DEPENDENCYTYPE ID="'.$this->fetchURLParam('start-dep-ID').'" />
					</DEPENDENCYENTITY>
				</DELETE>
			');			
			if (URLParam::exists('return-dep-ID'))
			{
				$nql->addCommand('
					<DELETE>
						<DEPENDENCYENTITY>
						  <DEPENDENCYTYPE ID="'.$this->fetchURLParam('return-dep-ID').'" />
						</DEPENDENCYENTITY>
					</DELETE>
				');
			}
			
			$nql->execute();

			$message = $nql->getElement('/RESPONSE/MESSAGE');
			if (($message !== false) && ($message->valueOf("@msgType") != '0'))
			{
				$this->abort('Operation failed: '.$message->valueOf('.'));
			}
			return true;
		}
	}
	
	/* *** */
	
	try
	{
		$op = new DependencyOperation();
		if ($op->execute(URLParam::fetch('op'), URLParam::fetch('output', 'json')) === false)
		{
			$op->abort();
		}
		else
		{
			$op->success();
		}
	}
	catch (OfficityException $e)
	{
		$e->getJSONResponse()->outputError();
	}
?>