<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee/shared/module/module-op.class.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
	require_once(dirname(__FILE__).'/include.php');

	class Sushee_ModuleElementOperation extends AbstractElementOperation
	{
		function __construct()
		{
			parent::__construct(new Sushee_ModuleElement());		
		}
		
		function __destruct()
		{
			
		}
		
		/* *** */
		
		protected function isCleanTableName($name)
		{
			$clean_name = $name;
			$clean_name = trim($clean_name);
			$clean_name = removeaccents($clean_name);
			$clean_name = strtolower($clean_name);
			$clean_name = preg_replace('/[^a-z0-9_\-:]/', '_', $clean_name);
			
			return ($name == $clean_name);
		}
		
		public function _create()
		{
			$result = false;
						
           	$this->element->parse($_POST);
           	
           	// prevent failure
           	$table_name = trim($this->element->getInfo('TABLENAME'));
           	$this->element->setInfo('TABLENAME', $table_name);
           	
           	// check
           	if (!$this->isCleanTableName($table_name))
           	{
           		$this->abort('Invalid table name "'.$table_name.'"!');
           	}
	
           	// dependency : optional
           	if (URLParam::isNotEmpty('dependency') && 
	           	URLParam::isNotEmpty('targetModule') && 
	           	URLParam::isNotEmpty('targetID'))
           	{                
	        	$this->element->setDependencyByName(
	            	$this->fetchURLParam('dependency'), 
	               	$this->fetchURLParam('targetModule'), 
	               	$this->fetchURLParam('targetID'),
	               	$this->fetchURLParam('mode', 'reverse'), 
	               	'append'
               	);
           	}
           	else
           	{
	    		if (URLParam::isNotEmpty('dependency') || 
	            	URLParam::isNotEmpty('targetModule') || 
	            	URLParam::isNotEmpty('targetID'))
	           	{
	            	// throw exception
	                $this->fetchURLParam('dependency');
	                $this->fetchURLParam('targetModule'); 
	                $this->fetchURLParam('targetID');
	           	}
			}
			
			//$this->element->logCommand();

	        $result = $this->element->create(self::EXECUTE);   
	        if ($result === true)
	        {
	        	$this->JSON_response->set('ID', $this->element->getID());
	        	//$this->element->emptyCache(true); // empty MODULE cache
	        }
	           
	        return $result;
		}
		
		// we will use the module processor responsible for files generation via a "fake" update
		public function _genFiles()
		{
			$this->element->setID($this->fetchURLParam('ID'));
			
			// find out where the processor is...
			$nql = new Sushee_Shell(false);
			$nql->addCommand('
				<SEARCH>
					<PROCESSOR>
						<INFO>
							<MODULEID>32</MODULEID>
							<CLASSNAME>Sushee_ModuleProcessor</CLASSNAME>
							<METHOD>genFiles</METHOD>
						</INFO>
					</PROCESSOR>
					<RETURN>
						<INFO>
							<PATH />
						</INFO>
					</RETURN>
				</SEARCH>
			');
			$nql->execute();
			$processor = $nql->getElement('/RESPONSE/RESULTS/PROCESSOR');
			if (empty($processor))
			{
				$this->abort('Cannot retrieve the module processor responsible for files generation!');
			}
			
			// trigger
			$nql->addCommand('
				<UPDATE>
					<MODULE ID="'.$this->element->getID().'">
						<PROCESSORS type="preprocessor">
							<PROCESSOR path="'.$processor->valueOf('INFO/PATH').'" classname="Sushee_ModuleProcessor" method="genFiles"/>
						</PROCESSORS>
					</MODULE>
				</UPDATE>
			');
			$nql->execute();
			
			$message = $nql->getElement("/RESPONSE/MESSAGE");
			if (($message !== false) &&
				($message->valueOf("@msgType") == '0') && 
				($message->valueOf("@elementID") == $this->element->getID()))
			{
				//$this->info($message->valueOf('.//PROCESSOR'));
				$this->success();
			}
			
			$this->abort($message->valueOf('.'));
		}
	}
?>