<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/system/class/JSONResponse.class.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
	/*
	 * JSONResponse Class
	 * 
	 * @since	2010-10-13
	 *
	*/
	class JSONResponse
	{
        private $return_data, $encode_options;

		function __construct()
		{
            $this->return_data = array(
                'status' => 'success',
                'message' => ''
            );
            $this->encode_options = JSON_HEX_TAG|JSON_HEX_APOS|JSON_HEX_QUOT|JSON_HEX_AMP;
		}

		function __destruct()
		{ 
            $this->return_data = array();
            unset($this->return_data);
		}

        public function set($var, $val)
        {
        	$val = (is_array($val)) ? $val : htmlspecialchars($val, ENT_NOQUOTES); 
            $this->return_data[$var] = $val; // encode => no troubles with iFrame upload (see jQuery/ajaxfileupload.js)
        }

        public function setError($msg)
        {
            $this->set('status', 'error'); 
            if ($msg !== '') $this->set('message', $msg);
        }

        public function setSuccess($msg)
        {
            $this->set('status', 'success');
            if ($msg !== '') $this->set('message', $msg);
        }
        
        public function setWarning($msg)
        {
            $this->set('status', 'warning');
            if ($msg !== '') $this->set('message', $msg);
        }
        
        public function setInfo($msg)
        {
            $this->set('status', 'info');
            if ($msg !== '') $this->set('message', $msg);
        }

        public function outputError($msg='', $die=true)
        {
            $this->setError($msg);
            $this->output($die);
        }

        public function outputSuccess($msg='', $die=true)
        {
            $this->setSuccess($msg);
            $this->output($die);
        }
        
        public function outputWarning($msg='', $die=true)
        {
            $this->setWarning($msg);
            $this->output($die);
        }
        
        public function outputInfo($msg='', $die=true)
        {
            $this->setInfo($msg);
            $this->output($die);
        }

        public function output($die=true) 
        {            
            if ($die == true)
            {
                //header('Content-Type: application/json');
                echo json_encode($this->return_data/*, $this->encode_options*/); // trigger a PHP warning. Why?
                die();
            }
            
            return json_encode($this->return_data/*, $this->encode_options*/); // trigger a PHP warning. Why?
        }
	}
?>