<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/system/class/OfficityException.class.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
	/*
	 * Exception Classes
	 * 
	 * @since	2010-12-07
	 *
	*/

    class OfficityException extends Exception
    {
        protected $title = 'Unexpected Officity error!';
        protected $dump_URL_parms = false;
		protected $JSON_message;
		
		/* *** */
		
        public function __construct($message=null, $JSON_message=null) 
	    { 
            if (!$message)
            {
                throw new $this('Unexpected error : '. get_class($this).' caught!');
            }
            parent::__construct($message, 0);
            
	        $this->JSON_message = $JSON_message;
	    }
	    
        public function __toString()
        {
            return get_class($this) . " '{$this->message}' in {$this->file}({$this->line})\n"
                    . "{$this->getTraceAsString()}";
        }
	    
       	public function setTitle($title)
	    {
	    	$this->title = $title;
	    }
    	public function getTitle()
	    {
	    	return $this->title;
	    }
	    
	    public function enableDump()
	    {
	    	$this->dump_URL_parms = true;
    	}
	    public function disableDump()
	    {
	    	$this->dump_URL_parms = false;
    	}
    	
    	protected function dumpURLParams($data, $label)
    	{
    		uksort($data, "strnatcasecmp");
    		
        	$html = '
				<table class="dump-table">
					<tr class="label">
						<th colspan="2">'.$label.'</th>
					</tr>
					<tr>
						<th>KEY</th><th>VALUE</th>
					</tr>
        	';
			ob_start();
			$class = 'odd';
			foreach ($data as $key => $value)
	    	{
	    		echo '<tr class="'.$class.'">';
	    		echo '<td class="key">'.$key.'</td>';
	    		echo '<td class="value">';
	    		var_dump($value);
	    		echo '</td>';
	    		echo '</tr>';
	    		$class = ($class == 'odd') ? 'even' : 'odd';
	    	}
	    	$dump = ob_get_clean();
	    	$html .= $dump;
        	$html .= '
				</table>
        	';
        	
        	return $html;
    	}
	    
        public function getXMLMessage()
        {
        	$message = $this->getMessage();      
        	  	
        	if ($this->dump_URL_parms == true)
        	{
        		$message .= '<br /><br />';
        		$message .= $this->dumpURLParams($_POST, '$_POST');
        		$message .= '<br />';        		
        		$message .= $this->dumpURLParams($_GET, '$_GET');
        	}
        	
	        $xml_message = '<RESULTS name="errorMessage" static="true">
	                            <TITLE>'.$this->getTitle().'</TITLE>
	                            <MESSAGE>'.$message.'</MESSAGE>
	                            <CLASS>critical-error</CLASS>
	                        </RESULTS>';
        	
        	return $xml_message;
        }
        
        public function getHTMLMessage()
        {
        	$message = $this->getMessage();
        	return $message;
        }
        
        public function getJSONResponse()
        {
        	if (!is_object($this->JSON_message))
        	{
        		$this->JSON_message = new JSONResponse();
        		$this->JSON_message->set('warning', 'JSON message was not an object!');
        	}
        	
        	$this->JSON_message->setError($this->getMessage());        	
			return $this->JSON_message;
        }

        public function getJSONMessage()
        {        	    	
			return $this->getJSONResponse()->output(false);
        }
        
        public function displayErrorPanel()
        {
        	$nql = new Officity_Shell();
        	
        	$nql_command = $this->getXMLMessage();
	
	        $nql->addCommand($nql_command);
		        
	        $error_template_path = SYSTEM_TOOLS_PATH.'/error/Error.xsl';
	        if (isset($_GET['editor']))
	        {
	            $editor_folder = $_GET['editor'];
	            $editor_error_template_path = APPS_PATH.$editor_folder.'/shared/error/Error.xsl';
	            if (file_exists($editor_error_template_path))
	            {
	                $error_template_path = $editor_error_template_path;
	            }
	        }
	        
	        echo $nql->transform($error_template_path);	
			die();
        }
	    
		public static function scriptNotFound($script_name, $script_location) 
		{
			$message = 'The script <strong>'.$script_name.'</strong> could not be loaded.';
    		$message .= '<br /><br />Path : <strong>'.$script_location.'</strong>';    
			return new ScriptNotFoundException($message);
		}
    }
    
    /* *** */
    
    class MissingEditorException extends OfficityException
    {
        public function __construct($message=null, $code=0) 
	    { 	    	
	    	if (is_null($message))
	    	{
	    		$message = 'No editor specified in the request.';
	    	}
	    	parent::__construct($message);
	    	$this->title = 'Missing editor!';
	    }
    }
    class MissingAppException extends OfficityException
    {
        public function __construct($message=null, $code=0) 
	    { 	    	
        	if (is_null($message))
	    	{
	    		$message = 'No application specified in the request.';
	    	}
	    	parent::__construct($message);
	    	$this->title = 'Missing application!';
	    }
    }
    class MissingPanelURIException extends OfficityException
    {
        public function __construct($message=null, $code=0) 
	    { 	    	
	    	if (is_null($message))
	    	{
	    		$message = 'No panel URI specified in the request.';
	    	}
	    	parent::__construct($message);
	    	$this->title = 'Missing panel URI!';
	    }
    }
    class ScriptNotFoundException extends OfficityException
    {
        public function __construct($message=null, $code=0) 
	    { 	    	
	    	if (is_null($message))
	    	{
	    		$message = 'The specified script has not been found.';
	    		$this->enableDump();	    		
	    	}
			parent::__construct($message);
			$this->title = 'Application under construction';
	    }
    }
    class FileNotFoundException extends OfficityException
    {
        public function __construct($message=null, $code=0) 
	    { 	    	
	    	if (is_null($message))
	    	{
	    		$message = 'The specified file does not exist.';
	    		$this->enableDump();	    		
	    	}
			parent::__construct($message);
			$this->title = 'File not found';
	    }
    }
    
    /* *** */
    
    class OfficityAppException extends OfficityException
    {
        public function __construct($message=null, $code=0) 
	    { 	    	
	    	parent::__construct($message);
	    	$this->title = 'Unexpected application error!';
	    }
    }

    /* *** */
    
    class ParamException extends OfficityException
    {
	    public function __construct($message=null, $code=0) 
	    { 	
			parent::__construct($message);
			$this->title = 'Unexpected parameter error!';
			$this->enableDump();
	    }
	    
    	public static function notFound($name) 
		{
			$message = 'The parameter "'.$name.'" has not been found.';
			return new ParamNotFoundException($message);
		}
    }
    
    class ParamNotFoundException extends ParamException
    {
	    public function __construct($message=null, $code=0) 
	    { 	    	
	    	if (is_null($message))
	    	{
	    		$message = 'Some parameter has not been found!';		    		
	    	}
			parent::__construct($message);
			$this->title = 'Missing parameter!';
	    }
    }
?>