
/**
  * NotificationDialog Class
  *
  * @author  Marc Mignonsin
  * @version 2010-12+16
*/

NotificationDialog = function(title, options)
{
	//window.log('NotificationDialog', arguments);
	this.reset(); // just in case

	this.options = options ?
					options :
					{
						bgiframe	: true,
						autoOpen	: false,
						width	   : 400,
						minHeight  : 140,
						modal	   : true
					};

	this.options.close = delegate(this, this.hide);

	this.ID = 'notification-dialog-' + Math.floor(Math.random()*1000);

	var body = $('body');
	body.append('<div id="'+this.ID+'" name="'+this.ID+'"/>');
	this.container = body.children('div#'+this.ID).eq(0);

	this.container.append('<div align="center"/>');
	this.messageContainer = this.container.children().eq(0);

	this.container.dialog(this.options);

	if (title) this.setTitle(title);

	return this;
};

NotificationDialog.prototype.options = { };
NotificationDialog.prototype.ID = 0;
NotificationDialog.prototype.timerID = -1;
NotificationDialog.prototype.container = null;
NotificationDialog.prototype.messageContainer = null;
NotificationDialog.prototype.onClose = null;
NotificationDialog.prototype.fadeOutSpeed = 500; //ms

NotificationDialog.prototype.reset = function()
{
	//window.log('NotificationDialog.reset', arguments);
	this.options = { };
	this.ID = 0;
	this.timerID = -1;
	this.container = null;
	this.messageContainer = null;
	this.onClose = null;
	this.fadeOutSpeed = 500;
};

/* *** */

NotificationDialog.prototype.setTitle = function(title)
{
	//window.log('NotificationDialog.setTitle', arguments);
	this.container.dialog('option', 'title', title);
};

NotificationDialog.prototype.setMessage = function(message)
{
	//window.log('NotificationDialog.setMessage', arguments);
	this.messageContainer.html(message);
};

NotificationDialog.prototype.setProcessingMessage = function(message)
{
	//window.log('NotificationDialog.setProcessingMessage', arguments);
	this.messageContainer.html(
		'<div align="center">'+
			'<br /><br />'+
			message+
			'<br /><br /><br />'+
			'<div class="ajax-loader" /><br /><br />'+
		'</div>'
	);
};

NotificationDialog.prototype.setStatusMessage = function(message, buttonLabel)
{
	//window.log('NotificationDialog.setStatusMessage', arguments);
	var html =
		'<div align="center">'+
			'<br />'+
			message+
			'<br /><br />';

	if (buttonLabel)
	{
		html += '<br /><input type="button" id="ok-button" name="ok-button" class="modal-button" value="'+buttonLabel+'" />';
		html += '<br /><br />';
	}

	html += '</div>';

	this.messageContainer.html(html);

	this.messageContainer.find('#ok-button').bind('click', delegate(this, function() {
	   this.destroy();
	   return true;
	}));
};

NotificationDialog.prototype.show = function(timeout)
{
	//window.log('NotificationDialog.show', arguments);
	this.container.dialog('open');

	if (timeout > 0)
	{
		this.timerID = setTimeout(delegate(this, this.fadeOut), timeout);
	}
};

NotificationDialog.prototype.fadeOut = function()
{
	//window.log('NotificationDialog.fadeOut', arguments);
	$('body div.ui-widget-overlay').fadeOut(this.fadeOutSpeed);
	$('body div.ui-dialog').fadeOut(this.fadeOutSpeed, delegate(this, this.destroy));
};

NotificationDialog.prototype.hide = function()
{
	//window.log('NotificationDialog.hide', arguments);
	if (this.timerID > 0) clearTimeout(this.timerID);
	this.destroy();
};

NotificationDialog.prototype.destroy = function()
{
	//window.log('NotificationDialog.destroy', arguments);
	//window.log('container', this.container);
	if (this.onClose) this.onClose();
	
	this.container.dialog('destroy'); // 'destroy' doesn't automatically remove the dialog container
	this.container.remove(); // ...so, we remove it manually
};

NotificationDialog.prototype.setCloseCallback = function(callback)
{
	//window.log('NotificationDialog.setCloseCallback', arguments);
	this.onClose = callback;
};