<?xml version="1.0"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/system/packages/application/panels/StaticDraggableItems.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
	<xsl:import href="include.xsl"/>    
    <xsl:output encoding="UTF-8" method="xml" indent="no"/>
    <xsl:strip-space elements="*"/>
    
	<!-- parameters -->
    <xsl:param name="list" select="/RESPONSE/RESULTS[@name='list']"/>    
    <xsl:param name="sortFormID">
        <xsl:text>sort-form-</xsl:text>
        <xsl:value-of select="$panelID"/>
    </xsl:param>
    
	<xsl:template match="/RESPONSE">
		<xsl:call-template name="panel-navigation" />
	</xsl:template>
	
	<xsl:template name="panel-header-navigation">
        <form id="{$sortFormID}" name="{$sortFormID}" class="header-form" style="text-align:center;">
            <input type="submit" value="Save sorted elements" class="input-submit-save"/>
        </form>
	</xsl:template>
	
	<xsl:template name="panel-body-navigation">
        <xsl:choose>
            <xsl:when test="$list/@hits > 0">                        
                <xsl:for-each select="$list/*">
                    <xsl:call-template name="staticitem-draggable-action">
                        <xsl:with-param name="id">
                            <xsl:apply-templates select="." mode="element-navitem-id" />
                        </xsl:with-param>
                        <xsl:with-param name="hovertitle">
                            <xsl:text>Drag and drop where desired</xsl:text>
                        </xsl:with-param>
                        <xsl:with-param name="title">
                            <xsl:apply-templates select="." mode="element-label"/>
                        </xsl:with-param>
                        <xsl:with-param name="icon">
                            <xsl:apply-templates select="." mode="element-icon"/>
                        </xsl:with-param>
						<xsl:with-param name="rightactions-elems">
				            <a href="#" class="unlink-action" hover-title="Unlink" title="Remove from dependency">
				                <xsl:attribute name="onclick">
				                    <xsl:call-template name="triggerpanelevent">
				                        <xsl:with-param name="event" select="'updatedependency'"/>
				                        <xsl:with-param name="params">
							                <xsl:text>this, </xsl:text>
							                <xsl:value-of select="@ID" />
							                <xsl:text>, '</xsl:text>
							                <xsl:apply-templates select="." mode="element-script-unlink" />
							                <xsl:text>'</xsl:text>
				                        </xsl:with-param>
				                    </xsl:call-template>
				                </xsl:attribute>
				            </a>
						</xsl:with-param>
                    </xsl:call-template>
                </xsl:for-each>
            </xsl:when>
            <xsl:otherwise>
                <div class="no-result">No hits</div>
            </xsl:otherwise>
        </xsl:choose>
	</xsl:template>

    <xsl:template name="panel-js-navigation">
            <!-- INIT -->
            $('#<xsl:value-of select="$panelID"/>.panel .block-nav').sortable({
                containment : '#<xsl:value-of select="$panelID"/>.panel .block-nav',
                start: function(event, ui) { 
                	ui.item.addClass('dragged'); 
               	},
                stop: function(event, ui) { 
               		ui.item.removeClass('dragged'); 
             	},
             	revert:25,
             	placeholder:'items draggable dragged-placeholder',
             	forcePlaceholderSize:true
            }).disableSelection();

            <!-- PROCESS -->
            $('#<xsl:value-of select="$sortFormID"/>').submit(function(){
                $('#<xsl:value-of select="$panelID"/>.panel').trigger('panel-displayloader', [true, 'body']);
                
                var sortedElems = $('#<xsl:value-of select="$panelID"/>.panel .block-nav').sortable('toArray');

				// get rid of the prefix in order to send an array of element IDs
				for (var i in sortedElems)
				{
					// e. g. : contact-5
					var idParts = sortedElems[i].split('-', 2); 
					sortedElems[i] = idParts[1];
				}
					
                var updateRequest = new AjaxRequest(
                    <xsl:value-of select="$panelID"/>,
                    AppController,
                    '<xsl:apply-templates select="$list/*[1]" mode="element-script-sort-deps"/>',
                    'POST',
                    'json'
                );

                updateRequest.setData({sortedIDs:sortedElems});
                updateRequest.addData('dependency', 'contactWork');
                updateRequest.addData('targetModule', 'CONTACT');
                updateRequest.addData('ID', <xsl:value-of select="/RESPONSE/URL/societyID"/>);
                
				// display error dialog and return errors in long msgs format
				updateRequest.errorDialog(true, false);
				updateRequest.internalErrorDialog(true, false);

                updateRequest.onSuccess(function(response){
                    $('#<xsl:value-of select="$panelID"/>.panel').trigger('panel-displayloader', [false, 'body']);
                }).onError(function(response){
                    $('#<xsl:value-of select="$panelID"/>.panel').trigger('panel-displayloader', [false, 'body']);
                }).send();

                return false;
            });

            $('#<xsl:value-of select="$panelID"/>.panel').bind('updatedependency', function(eventObject, actionElem, ID, actionScript){
		        var navItem = $(actionElem).closest('.items');
		        var actionsLabel = navItem.find('.actions-label');
		        if (!$(actionElem).hasClass('confirm'))
		        {
		            $(actionElem).addClass('confirm');
		            actionsLabel.html('Confirm?');
		            return false;
		        }

                var loaderElem = navItem.find('.ajax-loader-nav');
                loaderElem.show();
                $(actionElem).hide();

                var updateRequest = new AjaxRequest(
                    <xsl:value-of select="$panelID"/>,
                    AppController,
                    actionScript,
                    'POST',
                    'json'
                );

                updateRequest.setData({
                    ID : ID,
                    dependency : 'contactWork',
                    targetModule : 'CONTACT',
                    targetID : '<xsl:value-of select="/RESPONSE/URL/societyID"/>'
                });

                // no error dialog and return errors in short msgs format
                updateRequest.errorDialog(false, true);
                updateRequest.internalErrorDialog(false, true);  

                updateRequest.onSuccess(function(response){
                   navItem.fadeOut(200, function(){ 
					    $(this).remove();
					});
                }).onError(function(response){
                    loaderElem.hide();
                    $(actionElem).show();
                    navItem.find('.actions-label').html(response.message);
                }).send();

                return false;
            });
	</xsl:template>
</xsl:stylesheet>
