<?xml version="1.0" encoding="utf-8"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/system/system.functions.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com" >
    <!-- TOOLS -->
    <xsl:template name="appmodules-tools">
    	<xsl:param name="modules" />    	
        <xsl:if test="$modules">
	        <xsl:call-template name="staticitemheader">
	            <xsl:with-param name="title">Modules linked</xsl:with-param>
	            <xsl:with-param name="icon">../system/images/icons/modules/module-32.png</xsl:with-param>
	            <xsl:with-param name="info">
	            	<xsl:text>These are all the modules linked to the application. For each module, you can create, update, delete and search elements using the navigation items below.</xsl:text>
	            </xsl:with-param>
	        </xsl:call-template>
	        
	        <xsl:for-each select="$modules">
		        <xsl:apply-templates select="." mode="module-tools" />
	        </xsl:for-each>
        </xsl:if>
    </xsl:template>
    
	<xsl:template match="MODULE" mode="module-tools">
        <xsl:call-template name="staticitem">
            <xsl:with-param name="title">
            	<xsl:apply-templates select="." mode="element-label" />
			</xsl:with-param>
            <xsl:with-param name="icon">
            	<!--xsl:apply-templates select="." mode="element-icon" /-->
            </xsl:with-param>
            <xsl:with-param name="info">
            	<!--xsl:apply-templates select="." mode="element-info" /-->
            </xsl:with-param>
        </xsl:call-template>
   		<xsl:call-template name="nav-new">
	    	<xsl:with-param name="module" select="INFO/DENOMINATION" />
       	</xsl:call-template>
   		<xsl:call-template name="nav-quicksearch">
	    	<xsl:with-param name="module" select="INFO/DENOMINATION" />
       	</xsl:call-template>       
    	    <xsl:call-template name="nav-search">
	    	<xsl:with-param name="module" select="INFO/DENOMINATION" />
       	</xsl:call-template>
    	    <xsl:call-template name="nav-savedfilters">
	    	<xsl:with-param name="module" select="INFO/DENOMINATION" />
       	</xsl:call-template>
	</xsl:template>

    <xsl:template name="dev-tools">
        <xsl:if test="$systemEnv='development'">
	        <xsl:call-template name="staticitemheader">
	            <xsl:with-param name="title">Development tools</xsl:with-param>
	            <xsl:with-param name="icon">../system/images/icons/tools-32.png</xsl:with-param>
	            <xsl:with-param name="info">
	            	<xsl:text>Developer's toolkit. Configuration applications under development and other useful applications.</xsl:text>
	            </xsl:with-param>
	        </xsl:call-template>
	
	        <xsl:call-template name="navigationitem">
	            <xsl:with-param name="title">Raw Modules browser</xsl:with-param>
	            <xsl:with-param name="panelURI">../../system/tools/module/Modules</xsl:with-param>
	            <xsl:with-param name="params"></xsl:with-param>
	            <xsl:with-param name="icon">../system/images/icons/modules/module.png</xsl:with-param> 
	            <xsl:with-param name="info"></xsl:with-param>
	        </xsl:call-template>
	        <xsl:call-template name="navigationitem">
	            <xsl:with-param name="title">Factory Modules browser</xsl:with-param>
	            <xsl:with-param name="panelURI">../../officity/factory/modules/ModulesBrowse</xsl:with-param>
	            <xsl:with-param name="params"></xsl:with-param>
	            <xsl:with-param name="icon">../system/images/icons/modules/module.png</xsl:with-param> 
	            <xsl:with-param name="info"></xsl:with-param>
	        </xsl:call-template>
	
	        <xsl:call-template name="navigationitem">
	            <xsl:with-param name="title">Lists browser</xsl:with-param>
	            <xsl:with-param name="panelURI">../../system/tools/list/Domains</xsl:with-param>
	            <xsl:with-param name="params"></xsl:with-param>
	            <xsl:with-param name="icon">../system/images/icons/lists/list.png</xsl:with-param>
	            <xsl:with-param name="info"></xsl:with-param>
	        </xsl:call-template>
	        
	        <xsl:call-template name="navigationitem">
	            <xsl:with-param name="title">Categories browser</xsl:with-param>
	            <xsl:with-param name="panelURI">../../system/tools/category/List</xsl:with-param>
	            <xsl:with-param name="params"></xsl:with-param>
	            <xsl:with-param name="icon">../system/images/icons/categories/v-tree.png</xsl:with-param>
	            <xsl:with-param name="info"></xsl:with-param>
	        </xsl:call-template>
	
	        <xsl:call-template name="navigationitem">
	            <xsl:with-param name="title">Files browser</xsl:with-param>
	            <xsl:with-param name="panelURI">../../system/tools/file/Folder</xsl:with-param>
	            <xsl:with-param name="params">path:'/',parentPath:'/',name:'',sort:''</xsl:with-param>
	            <xsl:with-param name="icon">../system/images/icons/libitems/folder.png</xsl:with-param>
	            <xsl:with-param name="info"></xsl:with-param>
	        </xsl:call-template>
	    </xsl:if>
    </xsl:template>
    
    <xsl:template name="factory-tools">
        <xsl:call-template name="staticitemheader">
            <xsl:with-param name="title">Factory Tools</xsl:with-param>
            <xsl:with-param name="icon">../system/images/icons/factory-32.png</xsl:with-param>
            <xsl:with-param name="info">
            	<xsl:text>These are all our Factory tools...</xsl:text>
            </xsl:with-param>
        </xsl:call-template>

        <xsl:call-template name="navigationitem">
            <xsl:with-param name="title">Environments</xsl:with-param>
            <xsl:with-param name="panelURI">../../officity/factory/environments/Index</xsl:with-param>
            <xsl:with-param name="icon">../system/images/icons/environment/env.png</xsl:with-param>
            <xsl:with-param name="params">
            </xsl:with-param>
        </xsl:call-template>
        
        <xsl:call-template name="navigationitem">
            <xsl:with-param name="title">Editors</xsl:with-param>
            <xsl:with-param name="panelURI">../../officity/factory/namespaces/Index</xsl:with-param>
            <xsl:with-param name="icon">../system/images/icons/namespace/namespace-16.png</xsl:with-param>
            <xsl:with-param name="params">
            	<xsl:text>module:'namespace'</xsl:text>
            </xsl:with-param>
        </xsl:call-template>
        
        <!--xsl:call-template name="navigationitem">
            <xsl:with-param name="title">Publishers</xsl:with-param>
            <xsl:with-param name="panelURI">../../officity/factory/publishers/Index</xsl:with-param>
            <xsl:with-param name="icon">../system/images/icons/publish/publisher.png</xsl:with-param>
            <xsl:with-param name="params">
            </xsl:with-param>
        </xsl:call-template-->
        
        <xsl:call-template name="navigationitem">
            <xsl:with-param name="title">Applications</xsl:with-param>
            <xsl:with-param name="panelURI">../../officity/factory/applications/Index</xsl:with-param>
            <xsl:with-param name="icon">../system/images/icons/applications/applications.png</xsl:with-param>
            <xsl:with-param name="params">
            	<xsl:text>module:'app'</xsl:text>
            </xsl:with-param>
        </xsl:call-template>
        
        <xsl:call-template name="navigationitem">
            <xsl:with-param name="title">Modules</xsl:with-param>
            <xsl:with-param name="panelURI">../../officity/factory/modules/Index</xsl:with-param>
            <xsl:with-param name="icon">../system/images/icons/modules/module-16.png</xsl:with-param>
            <xsl:with-param name="params">
            </xsl:with-param>
        </xsl:call-template>
        
        <xsl:call-template name="navigationitem">
            <xsl:with-param name="title">Publisher</xsl:with-param>
            <xsl:with-param name="panelURI">../../officity/factory/publish/Index</xsl:with-param>
            <xsl:with-param name="icon">../system/images/icons/publish/publish-16.png</xsl:with-param>
            <xsl:with-param name="params">
            </xsl:with-param>
        </xsl:call-template>
        
        <xsl:call-template name="navigationitem">
            <xsl:with-param name="title">System info</xsl:with-param>
            <xsl:with-param name="panelURI">../../officity/factory/../../system/tools/info/system.info</xsl:with-param>
            <xsl:with-param name="params"></xsl:with-param>
            <xsl:with-param name="icon">../system/images/icons/info.png</xsl:with-param>
            <xsl:with-param name="info"></xsl:with-param>
        </xsl:call-template>
    </xsl:template>
	
	<!-- ITEMS HANDLERS -->
    <xsl:template name="navhandler">
        <xsl:param name="title"/>
		<xsl:param name="editor" select="/RESPONSE/URL/editor" />
		<xsl:param name="app"  select="/RESPONSE/URL/app" />
		<xsl:param name="panelURI"/>
		<xsl:param name="icon"/>
		<xsl:param name="params"/>

		<xsl:variable name="shorttitle">
			<xsl:value-of select="$title" />
		</xsl:variable>

        <xsl:text>$(AppController).panelslider('loadPanel', '</xsl:text>
        <xsl:value-of select="$panelURI"/>
        <xsl:text>', {</xsl:text>
        <xsl:text>srcElem:this, </xsl:text>
        <xsl:text>parentID: </xsl:text>
        <xsl:value-of select="$panelID"/>
        <xsl:text>, title: '</xsl:text>
        <xsl:call-template name="escape-javascript">
            <xsl:with-param name="string" select="$shorttitle"/>
        </xsl:call-template>
        <xsl:text>', app: '</xsl:text>
            <xsl:value-of select="$app"/>
        <xsl:text>'</xsl:text>
        <xsl:text>, editor: '</xsl:text>
            <xsl:value-of select="$editor"/>
        <xsl:text>', icon: '</xsl:text>
        	<xsl:value-of select="$systemURL" />
        	<xsl:text>../</xsl:text>
        	<xsl:value-of select="$editor"/>
        	<xsl:text>/</xsl:text>
        	<xsl:value-of select="$icon"/>
        <xsl:text>'}, {</xsl:text>
        <xsl:if test="$params">
            <xsl:value-of select="$params"/>            
        </xsl:if>
        <xsl:text>});</xsl:text>
    </xsl:template>

    <xsl:template name="navactionhandler">
        <xsl:param name="title"/>
		<xsl:param name="editor" select="/RESPONSE/URL/editor" />
		<xsl:param name="app"  select="/RESPONSE/URL/app" />
		<xsl:param name="panelURI"/>
		<xsl:param name="icon" />
		<xsl:param name="params"/>
	
        <xsl:text>var e = jQuery.event.fix( arguments[0] || window.event );</xsl:text>
        <xsl:text>if ($(e.target).parents('.actions-block').length > 0) return false; </xsl:text>
        <xsl:text>if ($(e.target).is('input:checkbox')) return true; </xsl:text>
        <xsl:text>if ($(e.target).is('.drag-handle')) return false; </xsl:text>

        <xsl:call-template name="navhandler">
            <xsl:with-param name="title" select="$title"/>
            <xsl:with-param name="editor" select="$editor" />
            <xsl:with-param name="app"  select="$app" />
            <xsl:with-param name="panelURI" select="$panelURI"/>
            <xsl:with-param name="icon" select="$icon"/>
            <xsl:with-param name="params" select="$params"/>
        </xsl:call-template>
    </xsl:template>

    <xsl:template name="actionhandler">
		<xsl:param name="func"/>
		<xsl:param name="params"/>

        <xsl:text>var e = jQuery.event.fix( arguments[0] || window.event );</xsl:text>
        <xsl:text>if ($(e.target).parents('.actions-block').length > 0) return false; </xsl:text>
        <xsl:text>if ($(e.target).is('input:checkbox')) return true; </xsl:text>
        <xsl:text>if ($(e.target).is('.drag-handle')) return false; </xsl:text>

        <xsl:call-template name="returncallback">
            <xsl:with-param name="func" select="$func"/>
            <xsl:with-param name="params" select="$params"/>
        </xsl:call-template>
    </xsl:template>

    <xsl:template name="returncallback">
        <xsl:param name="func"/>
        <xsl:param name="params"/>

        <xsl:text>return </xsl:text>
        <xsl:value-of select="$func" />
        <xsl:text>(</xsl:text>
        <xsl:if test="$params">
            <xsl:value-of select="$params" />
        </xsl:if>
        <xsl:text>);</xsl:text>
    </xsl:template>
    
    <xsl:template name="triggerpanelevent">
    	<xsl:param name="panelID" select="$panelID" />
        <xsl:param name="event"/>
        <xsl:param name="params" select="''"/>

        <xsl:text>$('#</xsl:text>
        <xsl:value-of select="$panelID"/>
        <xsl:text>.panel').trigger('</xsl:text>
        <xsl:value-of select="$event"/>
        <xsl:text>'</xsl:text>
        <xsl:if test="$params">
            <xsl:text>, [</xsl:text>
            <xsl:value-of select="$params"/>
            <xsl:text>]</xsl:text>
        </xsl:if>
        <xsl:text>);</xsl:text>
        <xsl:text>return false;</xsl:text>
    </xsl:template>
		
    <!-- NAVIGATION ITEMS -->
	<xsl:template name="navigationitem">
		<xsl:param name="id" select="''"/>
        <xsl:param name="icon"/>
		<xsl:param name="title"/>
		<xsl:param name="hovertitle"/>
        <xsl:param name="info"/>
        <xsl:param name="cssclass" select="''"/>
		<xsl:param name="editor" select="/RESPONSE/URL/editor" />
		<xsl:param name="app"  select="/RESPONSE/URL/app" />
		<xsl:param name="panelURI"/>
		<xsl:param name="params"/>
		<xsl:param name="displayCount" select="false()"/>

		<div id="{$id}" class="items {$cssclass}" title="{$hovertitle}">
			<xsl:attribute name="onclick">
                <xsl:call-template name="navhandler">
                    <xsl:with-param name="title" select="$title"/>
                    <xsl:with-param name="editor" select="$editor" />
                    <xsl:with-param name="app"  select="$app" />
                    <xsl:with-param name="panelURI" select="$panelURI" />
                    <xsl:with-param name="icon" select="$icon"/>
                    <xsl:with-param name="params" select="$params"/>                    
                </xsl:call-template>
			</xsl:attribute>
			<xsl:if test="$icon">
				<div class="icon">
					<img src="{$systemURL}../{$editor}/{$icon}"/>
				</div>
			</xsl:if>
			<div class="label">
				<xsl:copy-of select="$title"/>
			</div>
			<xsl:if test="$info or ($displayCount=true())">
				<div class="info">
					<xsl:copy-of select="$info"/>
					<xsl:if test="$displayCount=true()">
						<div class="ajax-loader-nav" style="display:block;"/>
					</xsl:if>
				</div>
			</xsl:if>
			<div class="nav-arrow"/>
		</div>
	</xsl:template>
	
    <xsl:template name="navigationdetailsitem">
		<xsl:param name="id" select="''"/>
        <xsl:param name="icon"/>
		<xsl:param name="title"/>
		<xsl:param name="hovertitle"/>
        <xsl:param name="info"/>
        <xsl:param name="cssclass" select="''"/>
		<xsl:param name="editor" select="/RESPONSE/URL/editor" />
		<xsl:param name="app"  select="/RESPONSE/URL/app" />
		<xsl:param name="panelURI"/>
		<xsl:param name="params"/>

		<xsl:call-template name="navigationitem">
            <xsl:with-param name="id" select="$id" />
            <xsl:with-param name="icon" select="$icon" />
            <xsl:with-param name="title" select="$title" />
            <xsl:with-param name="hovertitle" select="$hovertitle" />
            <xsl:with-param name="info" select="$info" />
            <xsl:with-param name="cssclass" select="$cssclass" />
            <xsl:with-param name="editor" select="$editor" />
            <xsl:with-param name="app" select="$app" />
            <xsl:with-param name="panelURI" select="$panelURI" />
            <xsl:with-param name="params" select="$params" />
        </xsl:call-template>
	</xsl:template>

    <xsl:template name="navigationitem-actions">
		<xsl:param name="id" select="''"/>
        <xsl:param name="icon"/>
		<xsl:param name="title"/>
		<xsl:param name="hovertitle"/>
		<xsl:param name="info"/>
		<xsl:param name="cssclass" select="''"/>
		<xsl:param name="editor" select="/RESPONSE/URL/editor" />
		<xsl:param name="app" select="/RESPONSE/URL/app" />
		<xsl:param name="panelURI"/>
		<xsl:param name="params"/>
        <xsl:param name="leftactions-elems"/>
        <xsl:param name="rightactions-elems"/>

		<div id="{$id}" class="items {$cssclass}" title="{$hovertitle}">
			<xsl:attribute name="onclick">
                <xsl:call-template name="navactionhandler">
                    <xsl:with-param name="title" select="$title"/>
                    <xsl:with-param name="editor" select="$editor" />
                    <xsl:with-param name="app"  select="$app" />
                    <xsl:with-param name="panelURI" select="$panelURI"/>
                    <xsl:with-param name="icon" select="$icon"/>
                    <xsl:with-param name="params" select="$params"/>
                </xsl:call-template>
			</xsl:attribute>
            <div class="icon">
                <xsl:choose>
                    <xsl:when test="$leftactions-elems">
                        <div class="actions-block" style="">
                            <xsl:copy-of select="$leftactions-elems" />
                        </div>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:if test="$icon">
                            <img src="{$systemURL}../{$editor}/{$icon}"/>
                        </xsl:if>
                    </xsl:otherwise>
                </xsl:choose>
            </div>
			<div class="label">
				<xsl:copy-of select="$title"/>
			</div>
            <div class="info">
                <xsl:choose>
                    <xsl:when test="$rightactions-elems">
                        <div class="actions-block" style="">
                            <xsl:copy-of select="$rightactions-elems" />
                        </div>
                        <div class="actions-label">
                            <xsl:if test="$info">
                                <xsl:copy-of select="$info"/>
                            </xsl:if>
                        </div>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:copy-of select="$info"/>
                    </xsl:otherwise>
                </xsl:choose>
            </div>
			<div class="nav-arrow"/>
		</div>
    </xsl:template>
	
	<xsl:template name="navigationitem-check">
		<xsl:param name="id" select="''"/>
		<xsl:param name="checkValue" select="1" />
		<xsl:param name="icon" />
		<xsl:param name="title"/>
		<xsl:param name="hovertitle"/>
        <xsl:param name="info"/>
        <xsl:param name="cssclass" select="''"/>
		<xsl:param name="editor" select="/RESPONSE/URL/editor" />
		<xsl:param name="app"  select="/RESPONSE/URL/app" />
		<xsl:param name="panelURI"/>
		<xsl:param name="params"/>
		<xsl:param name="tab" select="false()" />
		<xsl:param name="checked" select="false()" />
		<xsl:param name="disabled" select="false()" />
		<xsl:param name="rightactions-elems"/>
		
		<xsl:variable name="cssclasses">
			<xsl:text>items </xsl:text>
			<xsl:value-of select="$cssclass" />
			<xsl:if test="$tab=true()">
				<xsl:text> subitems</xsl:text>
			</xsl:if>
		</xsl:variable>

		<div id="{$id}" class="{$cssclasses}" title="{$hovertitle}">
			<xsl:attribute name="onclick">
                <xsl:call-template name="navactionhandler">
                    <xsl:with-param name="title" select="$title"/>
                    <xsl:with-param name="editor" select="$editor" />
                    <xsl:with-param name="app"  select="$app" />
                    <xsl:with-param name="panelURI" select="$panelURI"/>
                    <xsl:with-param name="icon" select="$icon"/>
                    <xsl:with-param name="params" select="$params"/>
                </xsl:call-template>
			</xsl:attribute>
			<div class="icon">
                <input type="checkbox" id="check-{$id}" name="check-{$id}" value="{$checkValue}" class="input-checkbox">
                	<xsl:if test="$checked=true()">
                		<xsl:attribute name="checked"><xsl:text>checked</xsl:text></xsl:attribute>
                	</xsl:if>
                	<xsl:if test="$disabled=true()">
                		<xsl:attribute name="disabled"><xsl:text>disabled</xsl:text></xsl:attribute>
                	</xsl:if>
                </input>
			</div>
			<div class="label">
				<xsl:copy-of select="$title"/>
			</div>
            <div class="info">
                <xsl:choose>
                    <xsl:when test="$rightactions-elems">
                        <div class="actions-block" style="">
                            <xsl:copy-of select="$rightactions-elems" />
                        </div>
                        <div class="actions-label">
                            <xsl:if test="$info">
                                <xsl:copy-of select="$info"/>
                            </xsl:if>
                        </div>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:copy-of select="$info"/>
                    </xsl:otherwise>
                </xsl:choose>
            </div>
			<div class="nav-arrow"/>
		</div>
	</xsl:template>
	
	<xsl:template name="navigationitem-draggable">
		<xsl:param name="id" select="''"/>
        <xsl:param name="icon"/>
		<xsl:param name="title"/>
		<xsl:param name="hovertitle" select="'Drag and drop where desired'" />
        <xsl:param name="info"/>
        <xsl:param name="cssclass" select="''"/>
		<xsl:param name="editor" select="/RESPONSE/URL/editor" />
		<xsl:param name="app"  select="/RESPONSE/URL/app" />
		<xsl:param name="panelURI"/>
		<xsl:param name="params"/>
		<xsl:param name="rightactions-elems"/>

		<div id="{$id}" class="items nav-draggable {$cssclass}">
			<xsl:attribute name="onclick">
                <xsl:call-template name="navactionhandler">
                    <xsl:with-param name="title" select="$title"/>
                    <xsl:with-param name="editor" select="$editor" />
                    <xsl:with-param name="app"  select="$app" />
                    <xsl:with-param name="panelURI" select="$panelURI" />
                    <xsl:with-param name="params" select="$params"/>
                </xsl:call-template>
			</xsl:attribute>
			<xsl:if test="$icon">
				<div class="icon">
					<img src="{$systemURL}../{$editor}/{$icon}"/>
				</div>
			</xsl:if>
			<div class="label">
				<xsl:value-of select="$title"/>
			</div>
			<div class="info">
	            <xsl:choose>
	                <xsl:when test="$rightactions-elems">
	                    <div class="actions-block" style="">
	                        <xsl:copy-of select="$rightactions-elems" />
	                    </div>
	                    <div class="actions-label">
	                        <xsl:copy-of select="$info"/>
	                        <div class="drag-handle" title="{$hovertitle}"/>
	                    </div>
	                </xsl:when>
	                <xsl:otherwise>
	                   	<xsl:copy-of select="$info"/>
	                   	<div class="drag-handle" title="{$hovertitle}"/>
	                </xsl:otherwise>
	            </xsl:choose>
            </div>
			<div class="nav-arrow"/>
		</div>
	</xsl:template>
	
	<xsl:template name="navigationitem-50-50">
		<xsl:param name="id" select="''"/>
        <xsl:param name="icon"/>
		<xsl:param name="title"/>
		<xsl:param name="hovertitle"/>
        <xsl:param name="info"/>
        <xsl:param name="cssclass" select="''"/>
		<xsl:param name="editor" select="/RESPONSE/URL/editor" />
		<xsl:param name="app"  select="/RESPONSE/URL/app" />
		<xsl:param name="panelURI"/>
		<xsl:param name="params"/>

		<div id="{$id}" class="items items-50-50 {$cssclass}" title="{$hovertitle}">
			<xsl:attribute name="onclick">
                <xsl:call-template name="navhandler">
                    <xsl:with-param name="title" select="$title"/>
                    <xsl:with-param name="editor" select="$editor" />
                    <xsl:with-param name="app"  select="$app" />
                    <xsl:with-param name="panelURI" select="$panelURI" />
                    <xsl:with-param name="icon" select="$icon"/>
                    <xsl:with-param name="params" select="$params"/>                    
                </xsl:call-template>
			</xsl:attribute>
			<div class="icon">
				<img src="{$systemURL}../{$editor}/{$icon}"/>
			</div>
			<div class="label">
				<xsl:copy-of select="$title"/>
			</div>
			<div class="info">
				<xsl:copy-of select="$info"/>
			</div>
			<div class="nav-arrow"/>
		</div>
	</xsl:template>

    <!-- STATIC ITEMS -->
    <xsl:template name="staticitem">
		<xsl:param name="id" select="''"/>
        <xsl:param name="icon"/>
		<xsl:param name="title"/>
		<xsl:param name="hovertitle"/>
		<xsl:param name="info"/>
        <xsl:param name="cssclass" select="'grey-bkgnd'"/>
		<xsl:param name="editor" select="/RESPONSE/URL/editor" />
		<xsl:param name="app" select="/RESPONSE/URL/app" />

		<div id="{$id}" class="items static {$cssclass}" title="{$hovertitle}">
			<xsl:if test="$icon">
				<div class="icon">
					<img src="{$systemURL}../{$editor}/{$icon}"/>
				</div>
			</xsl:if>
			<div class="label">
				<!--xsl:attribute name="class">
					<xsl:choose>
						<xsl:when test="$icon!=''">
							<xsl:text>label</xsl:text>
						</xsl:when>
						<xsl:otherwise>
							<xsl:text>label-noicon</xsl:text>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:attribute-->
				<xsl:copy-of select="$title"/>
			</div>
			<xsl:if test="$info">
				<div class="info">
					<xsl:copy-of select="$info"/>
				</div>
			</xsl:if>
		</div>
	</xsl:template>
	
	<xsl:template name="staticitem-download">
		<xsl:param name="id" select="''"/>
		<xsl:param name="icon"/>
        <xsl:param name="title"/>
        <xsl:param name="hovertitle" select="'Download'"/>
        <xsl:param name="info"/>
        <xsl:param name="cssclass" select="''"/>
		<xsl:param name="editor" select="/RESPONSE/URL/editor" />
		<xsl:param name="app"  select="/RESPONSE/URL/app" />
        <xsl:param name="path"/>

        <xsl:call-template name="staticitem-action">
            <xsl:with-param name="id" select="$id"/>
            <xsl:with-param name="icon" select="$icon"/>
            <xsl:with-param name="title" select="$title"/>
            <xsl:with-param name="hovertitle" select="$hovertitle"/>
            <xsl:with-param name="info" select="$info"/>
            <xsl:with-param name="cssclass" select="$cssclass"/>
            <xsl:with-param name="callback" select="'window.location.replace'"/>
            <xsl:with-param name="params">
                <xsl:text>'</xsl:text>
                <xsl:value-of select="$systemToolsURL"/>
                <xsl:text>file_download.php?target=</xsl:text>
                <xsl:value-of select="$path"/>
                <xsl:text>'</xsl:text>
            </xsl:with-param>
        </xsl:call-template>
	</xsl:template>

    <xsl:template name="staticitem-action">
		<xsl:param name="id" select="''"/>
        <xsl:param name="icon"/>
		<xsl:param name="title"/>
		<xsl:param name="hovertitle"/>
		<xsl:param name="info"/>
		<xsl:param name="cssclass" select="''"/>
		<xsl:param name="editor" select="/RESPONSE/URL/editor" />
		<xsl:param name="app"  select="/RESPONSE/URL/app" />
		<xsl:param name="panelURI"/>
		<xsl:param name="callback"/>
		<xsl:param name="params"/>
        <xsl:param name="leftactions-elems"/>
        <xsl:param name="rightactions-elems"/>

		<div id="{$id}" class="items static {$cssclass}" title="{$hovertitle}">
			<xsl:attribute name="onclick">
                <xsl:call-template name="actionhandler">
                    <xsl:with-param name="func" select="$callback"/>
                    <xsl:with-param name="params" select="$params"/>
                </xsl:call-template>
			</xsl:attribute>
            <div class="icon">
                <xsl:choose>
                    <xsl:when test="$leftactions-elems">
                        <div class="actions-block" style="">
                            <xsl:copy-of select="$leftactions-elems" />
                        </div>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:if test="$icon">
                            <img src="{$systemURL}../{$editor}/{$icon}"/>
                        </xsl:if>
                    </xsl:otherwise>
                </xsl:choose>
            </div>
			<div class="label">
				<xsl:copy-of select="$title"/>
			</div>
            <div class="info">
                <xsl:choose>
                    <xsl:when test="$rightactions-elems">
                        <div class="actions-block" style="">
                            <xsl:copy-of select="$rightactions-elems" />
                        </div>
                        <div class="actions-label">
                            <xsl:if test="$info">
                                <xsl:copy-of select="$info"/>
                            </xsl:if>
                        </div>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:copy-of select="$info"/>
                    </xsl:otherwise>
                </xsl:choose>
            </div>
		</div>
    </xsl:template>

	<xsl:template name="staticitem-check">
		<xsl:param name="id" select="''"/>
		<xsl:param name="checkValue" select="1" />
		<xsl:param name="icon" />
		<xsl:param name="title"/>
		<xsl:param name="hovertitle"/>
        <xsl:param name="info"/>
        <xsl:param name="cssclass" select="''"/>
		<xsl:param name="editor" select="/RESPONSE/URL/editor" />
		<xsl:param name="app"  select="/RESPONSE/URL/app" />
		<xsl:param name="tab" select="false()" />
		<xsl:param name="checked" select="false()" />
		<xsl:param name="disabled" select="false()" />
		
		<xsl:variable name="cssclasses">
			<xsl:text>items static </xsl:text>
			<xsl:value-of select="$cssclass" />
			<xsl:if test="$tab=true()">
				<xsl:text> subitems</xsl:text>
			</xsl:if>
		</xsl:variable>

		<div id="{$id}" class="{$cssclasses}" title="{$hovertitle}">
			<div class="icon">
                <input type="checkbox" id="check-{$id}" name="check-{$id}" value="{$checkValue}" class="input-checkbox">
                	<xsl:if test="$checked=true()">
                		<xsl:attribute name="checked"><xsl:text>checked</xsl:text></xsl:attribute>
                	</xsl:if>
                	<xsl:if test="$disabled=true()">
                		<xsl:attribute name="disabled"><xsl:text>disabled</xsl:text></xsl:attribute>
                	</xsl:if>
                </input>
			</div>
			<div class="label">
				<xsl:copy-of select="$title"/>
			</div>
			<xsl:if test="$info">
				<div class="info">
					<xsl:copy-of select="$info"/>					
				</div>
			</xsl:if>
		</div>
	</xsl:template>

    <xsl:template name="staticitem-draggable-action">
		<xsl:param name="id" select="''"/>
        <xsl:param name="icon"/>
		<xsl:param name="title"/>
		<xsl:param name="hovertitle" />
		<xsl:param name="info"/>
		<xsl:param name="cssclass" select="''"/>
		<xsl:param name="editor" select="/RESPONSE/URL/editor" />
		<xsl:param name="app"  select="/RESPONSE/URL/app" />
		<xsl:param name="panelURI"/>        
		<xsl:param name="leftactions-elems"/>
        <xsl:param name="rightactions-elems"/>

		<div id="{$id}" class="items draggable {$cssclass}" title="{$hovertitle}">
            <div class="icon">
                <xsl:choose>
                    <xsl:when test="$leftactions-elems">
                        <div class="actions-block" style="">
                            <xsl:copy-of select="$leftactions-elems" />
                        </div>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:if test="$icon">
                            <img src="{$systemURL}../{$editor}/{$icon}"/>
                        </xsl:if>
                    </xsl:otherwise>
                </xsl:choose>
            </div>
			<div class="label">
				<xsl:copy-of select="$title"/>
			</div>
            <div class="info">
                <xsl:choose>
                    <xsl:when test="$rightactions-elems">
                        <div class="actions-block" style="">
                            <xsl:copy-of select="$rightactions-elems" />
                        </div>
                        <div class="actions-label">
                            <xsl:if test="$info">
                                <xsl:copy-of select="$info"/>
                            </xsl:if>
                        </div>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:copy-of select="$info"/>
                    </xsl:otherwise>
                </xsl:choose>
            </div>
            <div class="nav-arrow"/>
		</div>
    </xsl:template>
    
    <xsl:template name="staticitemheader">
	    <xsl:param name="id" select="''"/>
        <xsl:param name="icon"/>
		<xsl:param name="title"/>
		<xsl:param name="info"/>
        <xsl:param name="cssclass" select="''"/>
		<xsl:param name="editor" select="/RESPONSE/URL/editor" />
		<xsl:param name="app"  select="/RESPONSE/URL/app" />

		<div id="{$id}" class="items-static-header {$cssclass}">
			<h2>
				<xsl:if test="$icon">
					<xsl:attribute name="style">
						background-image:url(<xsl:value-of select="$systemURL" />../<xsl:value-of select="$editor" />/<xsl:value-of select="$icon" />);
					</xsl:attribute>
				</xsl:if>			
				<xsl:copy-of select="$title"/>
			</h2>
			<xsl:if test="$info">
				<p>
					<xsl:copy-of select="$info"/>
				</p>
			</xsl:if>
		</div>
	</xsl:template>
    
    <!-- HIGH LEVEL NAVIGATION ITEMS -->
    <xsl:template name="nav-resultslist">
    	<xsl:param name="title" />
    	<xsl:param name="module" />
    	<xsl:param name="panelURI" select="'../../system/tools/element/ResultsList'"/>
    	<xsl:param name="params" />
    	<xsl:param name="icon" />
    	<xsl:param name="info" />
    	<xsl:param name="cssclass" />
		<xsl:param name="editor" select="/RESPONSE/URL/editor" />
		<xsl:param name="app"  select="/RESPONSE/URL/app" />
    	
		<xsl:call-template name="navigationitem">
            <xsl:with-param name="title" select="$title" />
            <xsl:with-param name="panelURI" select="$panelURI" />
            <xsl:with-param name="params">
            	<xsl:text>module:'</xsl:text>
            	<xsl:value-of select="$module"/>
            	<xsl:text>'</xsl:text>
            	<xsl:if test="$params">
            		<xsl:text>, </xsl:text>
            		<xsl:value-of select="$params" />
            	</xsl:if>
            </xsl:with-param>
            <xsl:with-param name="icon" select="$icon" />
            <xsl:with-param name="info" select="$info" />
            <xsl:with-param name="cssclass" select="$cssclass" />
            <xsl:with-param name="editor" select="$editor" />
            <xsl:with-param name="app" select="$app" />
		</xsl:call-template>
	</xsl:template>
	
    <xsl:template name="nav-quicksearch">
    	<xsl:param name="title" select="'Browse...'"/>
    	<xsl:param name="module" />
    	<xsl:param name="panelURI" select="'../../system/tools/element/QuickSearch'"/>
    	<xsl:param name="params" />
    	<xsl:param name="icon" />
    	<xsl:param name="info" />
    	<xsl:param name="cssclass" />
		<xsl:param name="editor" select="/RESPONSE/URL/editor" />
		<xsl:param name="app"  select="/RESPONSE/URL/app" />
    	
		<xsl:call-template name="navigationitem">
            <xsl:with-param name="title" select="$title" />
            <xsl:with-param name="panelURI" select="$panelURI" />
            <xsl:with-param name="params">
            	<xsl:text>module:'</xsl:text>
            	<xsl:value-of select="$module"/>
            	<xsl:text>'</xsl:text>
            	<xsl:if test="$params">
            		<xsl:text>, </xsl:text>
            		<xsl:value-of select="$params" />
            	</xsl:if>
            </xsl:with-param>
            <xsl:with-param name="icon" select="$icon" />
            <xsl:with-param name="info" select="$info" />
            <xsl:with-param name="cssclass" select="$cssclass" />
            <xsl:with-param name="editor" select="$editor" />
            <xsl:with-param name="app" select="$app" />
		</xsl:call-template>
	</xsl:template>
	
    <xsl:template name="nav-new">
    	<xsl:param name="title" select="'Create new...'" />
    	<xsl:param name="module" />
    	<xsl:param name="panelURI" select="'../../system/tools/element/New'"/>
    	<xsl:param name="params" />
    	<xsl:param name="icon" select="'../system/images/icons/add/add-new.png'"/>
    	<xsl:param name="info" />
    	<xsl:param name="cssclass" />
		<xsl:param name="editor" select="/RESPONSE/URL/editor" />
		<xsl:param name="app"  select="/RESPONSE/URL/app" />
    	
		<xsl:call-template name="navigationitem">
            <xsl:with-param name="title" select="$title" />
            <xsl:with-param name="panelURI" select="$panelURI" />
            <xsl:with-param name="params">
            	<xsl:text>module:'</xsl:text>
            	<xsl:value-of select="$module"/>
            	<xsl:text>'</xsl:text>
            	<xsl:if test="$params">
            		<xsl:text>, </xsl:text>
            		<xsl:value-of select="$params" />
            	</xsl:if>
            </xsl:with-param>
            <xsl:with-param name="icon" select="$icon" />
            <xsl:with-param name="info" select="$info" />
            <xsl:with-param name="cssclass" select="$cssclass" />
            <xsl:with-param name="editor" select="$editor" />
            <xsl:with-param name="app" select="$app" />
		</xsl:call-template>
	</xsl:template>
	
    <xsl:template name="nav-details">
    	<xsl:param name="title" />
    	<xsl:param name="module" />
    	<xsl:param name="panelURI" select="'../../system/tools/element/Details'"/>
    	<xsl:param name="params" />
    	<xsl:param name="id" />
    	<xsl:param name="icon" />
    	<xsl:param name="info" />
		<xsl:param name="editor" select="/RESPONSE/URL/editor" />
		<xsl:param name="app"  select="/RESPONSE/URL/app" />
		
		<xsl:call-template name="navigationitem">
            <xsl:with-param name="title" select="$title" />
            <xsl:with-param name="panelURI" select="$panelURI" />
            <xsl:with-param name="params">
	            <xsl:text>module:'</xsl:text>
	            <xsl:value-of select="$module"/>
	            <xsl:text>',ID:</xsl:text>
	            <xsl:value-of select="$id"/>
            	<xsl:if test="$params">
            		<xsl:text>, </xsl:text>
            		<xsl:value-of select="$params" />
            	</xsl:if>
            </xsl:with-param>
            <xsl:with-param name="icon" select="$icon" />
            <xsl:with-param name="info" select="$info" />
            <xsl:with-param name="editor" select="$editor" />
            <xsl:with-param name="app" select="$app" />
		</xsl:call-template>
	</xsl:template>
	
    <xsl:template name="nav-search">
    	<xsl:param name="title" select="'Advanced search'" />
    	<xsl:param name="module" />
    	<xsl:param name="callbackPanel" select="'../../system/tools/element/Search'"/>
    	<xsl:param name="icon" select="'../system/images/icons/search/advancedsearch.png'"/>
    	<xsl:param name="info" />
		<xsl:param name="editor" select="/RESPONSE/URL/editor" />
		<xsl:param name="app"  select="/RESPONSE/URL/app" />
		
		<xsl:call-template name="navigationitem">
            <xsl:with-param name="title" select="$title" />
            <xsl:with-param name="panelURI">../../system/tools/element/NewSearch-light</xsl:with-param>
            <xsl:with-param name="params">module:'<xsl:value-of select="$module"/>',callbackPanel:'<xsl:value-of select="$callbackPanel"/>'</xsl:with-param>
            <xsl:with-param name="icon" select="$icon" />
            <xsl:with-param name="info" select="$info" />
            <xsl:with-param name="editor" select="$editor" />
            <xsl:with-param name="app" select="$app" />
		</xsl:call-template>
	</xsl:template>
	
    <xsl:template name="nav-savedfilters">
    	<xsl:param name="title" select="'Saved filters'" />
    	<xsl:param name="module" />
    	<xsl:param name="callbackPanel" select="'../../system/tools/element/Search'"/>
    	<xsl:param name="icon" select="'../system/images/icons/search/advancedsearch-filter.png'"/>
    	<xsl:param name="info" />
		<xsl:param name="editor" select="/RESPONSE/URL/editor" />
		<xsl:param name="app"  select="/RESPONSE/URL/app" />
		
        <xsl:call-template name="navigationitem">
            <xsl:with-param name="title" select="$title" />
            <xsl:with-param name="panelURI">../../system/tools/filter/QueryList</xsl:with-param>
            <xsl:with-param name="params">module:'<xsl:value-of select="$module"/>',callbackPanel:'<xsl:value-of select="$callbackPanel"/>'</xsl:with-param>
            <xsl:with-param name="icon" select="$icon" />
            <xsl:with-param name="info" select="$info" />
            <xsl:with-param name="editor" select="$editor" />
            <xsl:with-param name="app" select="$app" />
        </xsl:call-template>
	</xsl:template>
	
    <xsl:template name="nav-links">
    	<xsl:param name="title" />
    	<xsl:param name="module" />
    	<xsl:param name="originID" />
    	<xsl:param name="targetModule" />
    	<xsl:param name="dependency" />
    	<xsl:param name="panelURI" select="'../../system/tools/element/Link'"/>
    	<xsl:param name="params" />
    	<xsl:param name="icon" />
    	<xsl:param name="info" />
    	<xsl:param name="cssclass" />
		<xsl:param name="editor" select="/RESPONSE/URL/editor" />
		<xsl:param name="app"  select="/RESPONSE/URL/app" />
		
		<xsl:call-template name="navigationitem">
            <xsl:with-param name="title" select="$title" />
            <xsl:with-param name="panelURI" select="$panelURI" />
            <xsl:with-param name="params">
	            <xsl:text>module:'</xsl:text>
	            <xsl:value-of select="$module"/>
	            <xsl:text>',originID:'</xsl:text>
	            <xsl:value-of select="$originID"/>
	            <xsl:text>',targetModule:'</xsl:text>
	            <xsl:value-of select="$targetModule"/>
	            <xsl:text>',dependency:'</xsl:text>
	            <xsl:value-of select="$dependency"/>
	            <xsl:text>'</xsl:text>
            	<xsl:if test="$params">
            		<xsl:text>, </xsl:text>
            		<xsl:value-of select="$params" />
            	</xsl:if>
            </xsl:with-param>
            <xsl:with-param name="icon" select="$icon" />
            <xsl:with-param name="info" select="$info" />
            <xsl:with-param name="cssclass" select="$cssclass" />
            <xsl:with-param name="editor" select="$editor" />
            <xsl:with-param name="app" select="$app" />
		</xsl:call-template>
	</xsl:template>
	
    <xsl:template name="nav-export-pdf">
    	<xsl:param name="title" />
    	<xsl:param name="module" />
    	<xsl:param name="panelURI" select="'../../system/tools/report/List'"/>
		<xsl:param name="editor" select="/RESPONSE/URL/editor" />
		<xsl:param name="app"  select="/RESPONSE/URL/app" />
		
		<xsl:call-template name="navigationitem">
            <xsl:with-param name="title" select="$title" />
            <xsl:with-param name="panelURI" select="$panelURI" />
            <xsl:with-param name="params">
	            <xsl:text>module:'</xsl:text>
	            <xsl:value-of select="$module"/>
	            <xsl:text>',exportFormat:'pdf'</xsl:text>
            </xsl:with-param>
            <xsl:with-param name="icon" select="'../system/images/icons/documents/pdf-16.png'" />
            <xsl:with-param name="editor" select="$editor" />
            <xsl:with-param name="app" select="$app" />
		</xsl:call-template>
	</xsl:template>
	
    <xsl:template name="nav-export-csv">
    	<xsl:param name="title" />
    	<xsl:param name="module" />
    	<xsl:param name="moduleDesc" />
    	<xsl:param name="panelURI" select="'../../system/tools/report/List'"/>
		<xsl:param name="editor" select="/RESPONSE/URL/editor" />
		<xsl:param name="app"  select="/RESPONSE/URL/app" />
		
		<xsl:call-template name="navigationitem">
            <xsl:with-param name="title" select="$title" />
            <xsl:with-param name="panelURI" select="$panelURI" />
            <xsl:with-param name="params">
	            <xsl:text>module:'</xsl:text>
	            <xsl:value-of select="$module"/>
	            <xsl:text>',moduleDesc:'</xsl:text>
	            <xsl:value-of select="$moduleDesc"/>
	            <xsl:text>',exportFormat:'csv'</xsl:text>
            </xsl:with-param>
            <xsl:with-param name="icon" select="'../system/images/icons/documents/excel-16.png'" />
            <xsl:with-param name="editor" select="$editor" />
            <xsl:with-param name="app" select="$app" />
		</xsl:call-template>
	</xsl:template>
	
    <xsl:template name="nav-appshortcut">
    	<xsl:param name="denomination" />
    	<xsl:param name="appElement" select="//APP[INFO/DENOMINATION=$denomination]" />
    	<xsl:param name="title" select="$appElement/INFO/DENOMINATION"/>
    	<xsl:param name="panelURI" select="'HomePanel'" />
		<xsl:param name="editor" select="$appElement/DEPENDENCIES/DEPENDENCY[@type='officity:appNamespaces']/NAMESPACE/INFO/NAMESPACE" />
		<xsl:param name="app"  select="$appElement/INFO/URL" />
		<xsl:param name="icon"  select="$appElement/INFO/ICON" />
		<xsl:param name="params" />
		
		<xsl:call-template name="navigationitem">
            <xsl:with-param name="title" select="$title" />
            <xsl:with-param name="panelURI" select="$panelURI" />
            <xsl:with-param name="params" select="$params" />
            <xsl:with-param name="icon" select="$icon" />
            <xsl:with-param name="editor" select="$editor" />
            <xsl:with-param name="app" select="$app" />
		</xsl:call-template>
	</xsl:template>

    <!-- MODULE NAME TRANSLATION : lowercase and no colon -->
    <xsl:template name="translate-namespace-name">
        <xsl:param name="name"/>
        <xsl:call-template name="replace-string">
            <xsl:with-param name="text" select="translate($name, 'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxyz')"/>
            <xsl:with-param name="from">:</xsl:with-param>
            <xsl:with-param name="to">__</xsl:with-param>
        </xsl:call-template>
   	</xsl:template>
   	
    <!-- SEARCH/REPORTS: FIELDS DISPLAY -->
    <xsl:template name="get-module-field-name">
        <xsl:param name="moduleName"/>
        <xsl:param name="nodeName"/>
		<xsl:variable name="field" select="/RESPONSE/RESULTS/FIELD[INFO/MODULE=$moduleName and INFO/DENOMINATION=$nodeName]"/>
		<xsl:variable name="field-desc" select="$field/DESCRIPTIONS/DESCRIPTION"/>
        <xsl:choose>
            <xsl:when test="$field-desc/TITLE/text()">
                <xsl:value-of select="$field-desc/TITLE"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$field/INFO/DENOMINATION"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="get-module-field-shortname">
        <xsl:param name="moduleName"/>
        <xsl:param name="nodeName"/>
        <xsl:variable name="field" select="/RESPONSE/RESULTS/FIELD[INFO/MODULE=$moduleName and INFO/DENOMINATION=$nodeName]"/>
		<xsl:variable name="field-desc" select="$field/DESCRIPTIONS/DESCRIPTION"/>
        <xsl:choose>
            <xsl:when test="$field-desc/SUMMARY/text()">
                <xsl:value-of select="$field-desc/SUMMARY"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="get-module-field-name">
                    <xsl:with-param name="moduleName" select="$moduleName"/>
                    <xsl:with-param name="nodeName" select="$nodeName"/>
                </xsl:call-template>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="get-module-field-value">
        <xsl:param name="moduleName"/>
        <xsl:param name="node"/>
        <xsl:variable name="field" select="/RESPONSE/RESULTS/FIELD[INFO/MODULE=$moduleName and INFO/DENOMINATION=name($node)]"/>

        <xsl:choose>
            <xsl:when test="$field/INFO/TYPE/text()='list'">
                <xsl:variable name="list" select="/RESPONSE/RESULTS/LIST[@name=$field/INFO/LISTNAME]"/>
                <xsl:value-of select="$list/*[@value=$node/text()]/@label"/>
            </xsl:when>
            <xsl:when test="$field/INFO/TYPE/text()='systemList'">
                <xsl:variable name="list" select="/RESPONSE/RESULTS[@name=$field/INFO/LISTNAME]"/>
                <xsl:value-of select="$list/*[@ID=$node/text()]/LABEL"/>
            </xsl:when>
            <xsl:when test="$field/INFO/TYPE/text()='date'">
                <xsl:apply-templates select="$node" mode="date"/>
            </xsl:when>
            <xsl:when test="$field/INFO/TYPE/text()='datetime'">
                <xsl:apply-templates select="$node" mode="datetime"/>
            </xsl:when>
            <xsl:when test="$field/INFO/TYPE/text()='boolean'">
                <xsl:choose>
                    <xsl:when test="$node/text()='1'">
                        <xsl:text>Yes</xsl:text>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:text>No</xsl:text>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:when test="contains($field/INFO/DENOMINATION, 'XML')">
                <xsl:copy-of select="$node/*" />
            </xsl:when>
			<xsl:when test="count($node/*) &gt; 1">
				<xsl:apply-templates select="$node" mode="multiline"/>
			</xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$node"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template match="*[text()] | @*[.!='']" mode="display-value">
        <xsl:value-of select="."/>
    </xsl:template>

    <xsl:template match="*[not(text())] | @*[.='']" mode="display-value">
        <xsl:text>? </xsl:text>
    </xsl:template>

	<!-- FORMATTING -->

	<xsl:template match="text()" mode="multiline">
		<xsl:value-of select="."/>
	</xsl:template>

	<xsl:template match="br" mode="multiline">
		<xsl:text>&#10;</xsl:text>
	</xsl:template>

	<xsl:template name="breaker">
		<div class="clear">&#160;</div>
	</xsl:template>

	<xsl:template name="escape-javascript">
	  <xsl:param name="string" />
	  <xsl:choose>
		<xsl:when test='contains($string, "&apos;")'>
		  <xsl:call-template name="escape-javascript">
			<xsl:with-param name="string"
			  select='substring-before($string, "&apos;")' />
		  </xsl:call-template>
		  <xsl:text>\'</xsl:text>
		  <xsl:call-template name="escape-javascript">
			<xsl:with-param name="string"
			  select='substring-after($string, "&apos;")' />
		  </xsl:call-template>
		</xsl:when>
		<xsl:when test="contains($string, '&#xA;')">
		  <xsl:call-template name="escape-javascript">
			<xsl:with-param name="string"
			  select="substring-before($string, '&#xA;')" />
		  </xsl:call-template>
		  <xsl:text>\n</xsl:text>
		  <xsl:call-template name="escape-javascript">
			<xsl:with-param name="string"
			  select="substring-after($string, '&#xA;')" />
		  </xsl:call-template>
		</xsl:when>
		<xsl:when test="contains($string, '\')">
		  <xsl:value-of select="substring-before($string, '\')" />
		  <xsl:text>\\</xsl:text>
		  <xsl:call-template name="escape-javascript">
			<xsl:with-param name="string"
			  select="substring-after($string, '\')" />
		  </xsl:call-template>
		</xsl:when>
		<xsl:otherwise><xsl:value-of select="$string" /></xsl:otherwise>
	  </xsl:choose>
	</xsl:template>

	<xsl:template name="truncate-phrase">
		<xsl:param name="phrase" />
		<xsl:param name="length" select="64"/>
		<xsl:param name="trailing_string" select="'...'" />
		<xsl:param name="to-word-boundary" select="0" />
		<xsl:choose>
			<xsl:when test="string-length($phrase)>number($length)">
				<xsl:choose>
					<xsl:when test="$to-word-boundary">
						<xsl:call-template name="truncate-to-word-boundary">
							<xsl:with-param name="str">
								<xsl:value-of select="substring($phrase,0,number($length))" />
							</xsl:with-param>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="substring($phrase,0,number($length))" />
					</xsl:otherwise>
				</xsl:choose>
				<xsl:value-of select="$trailing_string" />
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$phrase" />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="truncate-to-word-boundary">
		<xsl:param name="str" />
		<xsl:variable name="ret" select="substring($str,0,string-length($str))" />
		<xsl:choose>
			<xsl:when test="$str=''" />
			<xsl:when test="substring($str,string-length($str),1)=' '">
				<xsl:value-of select="$ret" />
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="truncate-to-word-boundary">
					<xsl:with-param name="str">
						<xsl:value-of select="$ret" />
					</xsl:with-param>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

    <xsl:template match="* | @*" mode="date">
        <xsl:variable name="year" select="substring(.,1,4)" />
        <xsl:variable name="month" select="substring(.,6,2)" />
        <xsl:variable name="day" select="substring(.,9,2)" />
        <xsl:if test="$day">
            <xsl:value-of select="$day"/><xsl:text>/</xsl:text>
        </xsl:if>
        <xsl:if test="$month">
            <xsl:value-of select="$month"/><xsl:text>/</xsl:text>
        </xsl:if>
        <xsl:value-of select="$year"/>
    </xsl:template>

    <xsl:template match="* | @*" mode="datetime">
        <xsl:variable name="year" select="substring(.,1,4)" />
        <xsl:variable name="month" select="substring(.,6,2)" />
        <xsl:variable name="day" select="substring(.,9,2)" />
        <xsl:variable name="time" select="substring(.,12,8)" />
        <xsl:if test="$day">
            <xsl:value-of select="$day"/><xsl:text>/</xsl:text>
        </xsl:if>
        <xsl:if test="$month">
            <xsl:value-of select="$month"/><xsl:text>/</xsl:text>
        </xsl:if>
        <xsl:value-of select="$year"/>
        <xsl:if test="$time">
            <xsl:text> </xsl:text>
            <xsl:value-of select="$time" />
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="* | @*" mode="datetime-short">
        <xsl:variable name="year" select="substring(.,3,2)" />
        <xsl:variable name="month" select="substring(.,6,2)" />
        <xsl:variable name="day" select="substring(.,9,2)" />
        <xsl:variable name="time" select="substring(.,12,5)" />
        <xsl:if test="$day">
            <xsl:value-of select="$day"/><xsl:text>/</xsl:text>
        </xsl:if>
        <xsl:if test="$month">
            <xsl:value-of select="$month"/><xsl:text>/</xsl:text>
        </xsl:if>
        <xsl:value-of select="$year"/>
        <xsl:if test="$time">
            <xsl:text> </xsl:text>
            <xsl:value-of select="$time" />
        </xsl:if>
    </xsl:template>

	<xsl:template match="* | @*" mode="date-long">
        <xsl:variable name="time" select="substring(.,12,8)"/>
		<xsl:value-of select="number(substring(.,9,2))"/>
		<xsl:text> </xsl:text>
		<xsl:value-of select="//MONTH[@ID = substring(current(),6,2)]/LABEL"/>
		<xsl:text> </xsl:text>
		<xsl:value-of select="substring(.,1,4)"/>
	</xsl:template>
	
	<xsl:template match="* | @*" mode="datetime-long">
        <xsl:variable name="time" select="substring(.,12,8)"/>
		<xsl:value-of select="number(substring(.,9,2))"/>
		<xsl:text> </xsl:text>
		<xsl:value-of select="//MONTH[@ID = substring(current(),6,2)]/LABEL"/>
		<xsl:text> </xsl:text>
		<xsl:value-of select="substring(.,1,4)"/>
        <xsl:if test="$time">
            <xsl:text> </xsl:text>
            <xsl:value-of select="$time"/>
        </xsl:if>
	</xsl:template>
	
    <xsl:template name="format-date">
        <xsl:param name="rawdate"/>
        <xsl:variable name="year" select="substring($rawdate,1,4)" />
        <xsl:variable name="month" select="substring($rawdate,6,2)" />
        <xsl:variable name="day" select="substring($rawdate,9,2)" />
        <xsl:variable name="time" select="substring($rawdate,12,8)" />

        <xsl:if test="$day">
            <xsl:value-of select="$day"/><xsl:text>/</xsl:text>
        </xsl:if>
        <xsl:if test="$month">
            <xsl:value-of select="$month"/><xsl:text>/</xsl:text>
        </xsl:if>
        <xsl:value-of select="$year"/>
    </xsl:template>
	
    <xsl:template name="format-datetime">
        <xsl:param name="rawdate"/>
        <xsl:variable name="year" select="substring($rawdate,1,4)" />
        <xsl:variable name="month" select="substring($rawdate,6,2)" />
        <xsl:variable name="day" select="substring($rawdate,9,2)" />
        <xsl:variable name="time" select="substring($rawdate,12,8)" />

        <xsl:if test="$day">
            <xsl:value-of select="$day"/><xsl:text>/</xsl:text>
        </xsl:if>
        <xsl:if test="$month">
            <xsl:value-of select="$month"/><xsl:text>/</xsl:text>
        </xsl:if>
        <xsl:value-of select="$year"/>

        <xsl:if test="$time != '' and $time!='00:00:00'">
            <xsl:text> </xsl:text>
            <xsl:value-of select="$time" />
        </xsl:if>
    </xsl:template>

	<xsl:template match="*" mode="bankaccount">
		<xsl:value-of select="substring(.,1,3)"/>
		<xsl:text>-</xsl:text>
		<xsl:value-of select="substring(.,4,7)"/>
		<xsl:text>-</xsl:text>
		<xsl:value-of select="substring(.,11,2)"/>
	</xsl:template>

    <xsl:template name="basename">
      <xsl:param name="path"/>
      <xsl:choose>
         <xsl:when test="contains($path, '/')">
            <xsl:call-template name="basename">
               <xsl:with-param name="path" select="substring-after($path, '/')"/>
            </xsl:call-template>
         </xsl:when>
         <xsl:otherwise>
            <xsl:value-of select="$path"/>
         </xsl:otherwise>
      </xsl:choose>
    </xsl:template>

    <!-- JAVASCRIPT -->

	<xsl:template name="js-init-datepicker">
        <xsl:param name="panelID" select="$panelID"/>
		<xsl:param name="selector"/>
		$('#<xsl:value-of select="$panelID"/>.panel').find('<xsl:value-of select="$selector"/>').datepicker({
			<!--
				dayNames: ['Dimanche', 'Lundi', 'Mardi', 'Mercredi', 'Jeudi', 'Vendredi', 'Samedi'],
				dayNamesMin: ['Di', 'Lu', 'Ma', 'Me', 'Je', 'Ve', 'Sa'],
				dayNamesShort: ['Dim', 'Lun', 'Mar', 'Mer', 'Jeu', 'Ven', 'Sam'],
				monthNames: ['Janvier','Février','Mars','Avril','Mai','Juin','Juillet','Août','Septembre','Octobre','Novembre','Décembre'],
				monthNamesShort: ['Jan','Fév','Mar','Avr','Mai','Jun','Jul','Aoû','Sep','Oct','Nov','Déc'],
				clearText: 'Effacer', clearStatus: '',
				closeText: 'Fermer', closeStatus: 'Fermer sans modifier',
				prevText: 'Précédent', prevStatus: 'Voir le mois précédent',
				nextText: 'Suivant', nextStatus: 'Voir le mois suivant',
				currentText: 'Courant', currentStatus: 'Voir le mois courant',
				monthStatus: 'Voir un autre mois', yearStatus: 'Voir un autre année',
				weekHeader: 'Sm', weekStatus: '',
				dayStatus: 'Utiliser DD comme premier jour de la semaine', dateStatus: 'Choisir le DD, MM d',
				initStatus: 'Choisir la date',
			-->
			dateFormat: 'dd/mm/yy',
			buttonImage: '<xsl:value-of select="$systemURL"/>images/icons/calendar.png',
			buttonImageOnly: true,
			buttonText: 'Choose date',
			showOn: 'button',
			firstDay: 1,
			showOtherMonths: true,
			isRTL: false,
            changeYear: true,
            yearRange: '1900:2100',
            showAnim: 'fadeIn' 
		});
	</xsl:template>

    <xsl:template name="js-init-autocomplete">
        <xsl:param name="panelID" select="$panelID"/>
        <xsl:param name="textInput" />
        <xsl:param name="IDInput" />
        <xsl:param name="hiddenListSelector" />

        $('#<xsl:value-of select="$panelID"/>.panel').find('<xsl:value-of select="$textInput"/>').autocomplete({
            delay:0,
            minLength: 0,
            source: function(request, response){
                var matcher = new RegExp(request.term, "i");
                var select = $('#<xsl:value-of select="$panelID"/>.panel').find('<xsl:value-of select="$hiddenListSelector"/>');
                var list = select.children("option").map(function() {
                    var text = $(this).text();
                    if (!request.term || matcher.test(text))
                    {
                        return {
                            id: $(this).val(),
                            label: text
                        };
                    }
                });

                $('#<xsl:value-of select="$panelID"/>.panel').find('<xsl:value-of select="$IDInput"/>').val('');

                if (list.length == 0)
                {
                    $('#<xsl:value-of select="$panelID"/>.panel').find('<xsl:value-of select="$textInput"/>').addClass('text-error');
                    list = [{
                        id: '',
                        label: 'No match'
                    }];
                }
                else
                {
                    $('#<xsl:value-of select="$panelID"/>.panel').find('<xsl:value-of select="$textInput"/>').removeClass('text-error');

                    if (list.length == 1)
                    {
                        if (list[0].label == $('#<xsl:value-of select="$panelID"/>.panel').find('<xsl:value-of select="$textInput"/>').val())
                        {
                            $('#<xsl:value-of select="$panelID"/>.panel').find('<xsl:value-of select="$IDInput"/>').val(list[0].id);
                        }
                    }
                }

                response(list);
            },
            focus: function(event, ui) {
                //window.log('focus');
                //window.log(ui);
                if (!ui.item) return false;
                if (ui.item.id == '') return false;
                $('#<xsl:value-of select="$panelID"/>.panel').find('<xsl:value-of select="$IDInput"/>').val(ui.item.id);
                $('#<xsl:value-of select="$panelID"/>.panel').find('<xsl:value-of select="$textInput"/>').val(ui.item.label);
                return false;
            },
            select: function(event, ui) {
                //window.log('select');
                //window.log(ui);
                if (!ui.item) return false;
                if (ui.item.id == '') return false;
                $('#<xsl:value-of select="$panelID"/>.panel').find('<xsl:value-of select="$IDInput"/>').val(ui.item.id);
                $('#<xsl:value-of select="$panelID"/>.panel').find('<xsl:value-of select="$textInput"/>').val(ui.item.label);
                return false;
            }
        });
    </xsl:template>

    <xsl:template name="js-init-autocomplete-ajax">
        <xsl:param name="panelID" select="$panelID"/>
        <xsl:param name="textInput" />
        <xsl:param name="IDInput" />
        <xsl:param name="script" />

        $('#<xsl:value-of select="$panelID"/>.panel').find('<xsl:value-of select="$textInput"/>').autocomplete({
            delay:200,
            minLength: 2,
            source: "<xsl:value-of select="$script" disable-output-escaping="yes"/>",
            focus: function(event, ui) {
                //window.log('focus');
                //window.log(ui);
                if (!ui.item) return false;
                if (ui.item.id == '') return false;
                $('#<xsl:value-of select="$panelID"/>.panel').find('<xsl:value-of select="$IDInput"/>').val(ui.item.id);
                $('#<xsl:value-of select="$panelID"/>.panel').find('<xsl:value-of select="$textInput"/>').val(ui.item.label);
                return false;
            },
            select: function(event, ui) {
                //window.log('select');
                //window.log(ui);
                if (!ui.item) return false;
                if (ui.item.id == '') return false;
                $('#<xsl:value-of select="$panelID"/>.panel').find('<xsl:value-of select="$IDInput"/>').val(ui.item.id);
                $('#<xsl:value-of select="$panelID"/>.panel').find('<xsl:value-of select="$textInput"/>').val(ui.item.label);
                return false;
            }
        });
    </xsl:template>
    
     <xsl:template match="CATEGORY" mode="js-init-autocomplete-category-data">
		{ <xsl:if test="CATEGORY">isCateg:1, </xsl:if>category:"<xsl:value-of select="parent::CATEGORY/LABEL" />", name:"<xsl:value-of select="UNIQUENAME" />", label:"<xsl:value-of select="LABEL" />", assignable:<xsl:value-of select="ISASSIGNABLE" /> },
		<xsl:apply-templates select="CATEGORY" mode="js-init-autocomplete-category-data">
			<xsl:sort select="not(CATEGORY)" order="descending"/>
			<xsl:sort select="LABEL" />
		</xsl:apply-templates>
     </xsl:template>
     
    <xsl:template name="js-init-autocomplete-category">
    	<xsl:param name="panelID" select="$panelID"/>
    	<xsl:param name="element" />
       	<xsl:param name="categName" />        	
       	<xsl:param name="fetchInputID" />
       	<xsl:param name="searchOnFocus" select="false()" />

		<xsl:variable name="categPath">
			<xsl:text>/</xsl:text>
			<xsl:value-of select="$categName" />
			<xsl:text>/</xsl:text>
		</xsl:variable>     	
     	
		$('#<xsl:value-of select="$panelID"/>.panel').find('#<xsl:value-of select="$fetchInputID" />').catcomplete({
            delay:0,
            minLength: 0,
			source: [<xsl:apply-templates select="$categories[contains(@path, $categPath)]" mode="js-init-autocomplete-category-data">
				<xsl:sort select="not(CATEGORY)" order="descending"/>
				<xsl:sort select="LABEL" />
			</xsl:apply-templates>{}],
            select: function(event, ui) {
                //window.log('select');
                //window.log(ui);
                if (!ui.item) return false;
                
                $('#<xsl:value-of select="$panelID"/>.panel').find('#<xsl:value-of select="$fetchInputID"/>').val('');
                
                var template = $('#<xsl:value-of select="$panelID" />.panel').find('#fetchcategory-template');
				var newLine = template.clone();								
				newLine.removeAttr('id'); 
				newLine.find('input#fetchcategory-name').attr('name', '<xsl:call-template name="gen-categ-input-name"><xsl:with-param name="moduleName" select="name($element)" /><xsl:with-param name="categName" select="''" /></xsl:call-template>' + ui.item.name);					
				newLine.find('.skill').append(ui.item.category + ' / ' + ui.item.label);
				newLine.insertAfter(template).show();

                return false;
            },
			open: function(event, ui) {
				//window.log('open');
				var ul = $(this).catcomplete('widget');
				//window.log(ul);
				var hpx = ($(window).height() - parseInt(ul.css('top')) - 20)+'px';
				ul.css({'max-height':hpx, 'overflow-y':'auto'});
			}
		}).defaultInputValue('Type a keyword...');
		
		<xsl:if test="$searchOnFocus=true()">
			$('#<xsl:value-of select="$panelID" />.panel').find('#<xsl:value-of select="$fetchInputID" />').click(function(){
				$(this).catcomplete('search', $(this).val());
			});
		</xsl:if>
    </xsl:template>
    
    <xsl:template name="js-embed-mediaplayer">
    	<xsl:param name="file" />
    	<xsl:param name="containerID" />
    	<xsl:param name="width" select="320" />
    	<xsl:param name="height" select="20" />
    	<xsl:param name="params" />
    	
		var flashvars = {
			file:'<xsl:value-of select="$filesURL" /><xsl:value-of select="$file" />'
			<xsl:if test="$params">
				<xsl:text>,</xsl:text>
				<xsl:value-of select="$params" />
			</xsl:if>
		};
		var params = {
			allowfullscreen:'true',
			allowscriptaccess:'always',
			wmode:'opaque'
		};
		var attributes = {
			id:'<xsl:value-of select="$containerID"/>'
		};
   	
		swfobject.embedSWF('<xsl:value-of select="$systemURL" />flash/flvplayer.swf','<xsl:value-of select="$containerID"/>','<xsl:value-of select="$width"/>','<xsl:value-of select="$height"/>','9.0.0', 'false', flashvars, params, attributes);
    </xsl:template>
    
    <xsl:template name="js-init-autoresize">
    	<xsl:param name="extraSpace" select="14" />
    	<xsl:param name="excludeClass" />
    	
    	<xsl:choose>
    		<xsl:when test="$excludeClass">    	
				$('#<xsl:value-of select="$panelID"/>.panel').find('textarea:not([class~="<xsl:value-of select="$excludeClass" />"])').autoResize({
					animate:'false',
					extraSpace:<xsl:value-of select="$extraSpace" />
				});
			</xsl:when>
			<xsl:otherwise>
				$('#<xsl:value-of select="$panelID"/>.panel').find('textarea').autoResize({
					animate:'false',
					extraSpace:<xsl:value-of select="$extraSpace" />
				});
			</xsl:otherwise>
		</xsl:choose>
    </xsl:template>
    
    <xsl:template name="js-init-tabs">
	    $('#<xsl:value-of select="$panelID"/>.panel').find('.tab').tabs({ 
	    	selected: 0,
	    	show: function(event, ui) {
	    		/*$(ui.panel).find('textarea[name*="styled"]').each(function(){
	    			tinyMCE.execCommand('mceAddControl', false, $(this).attr('id'));
	    		});*/
	    	},
	    	select: function(event, ui) {
	    	}
	    });
    </xsl:template>
    
	<!-- tinyMCE js initialization -->
	<xsl:template name="js-init-tinyMCE">	
		<xsl:param name="textareaClass" />
			if (!$('#<xsl:value-of select="$panelID" />.panel').panel('hasExternalResource', 'tinyCleaner'))
			{
				var tinyCleaner = { 
					destroy : function() {
						//window.log(tinyMCE.editors);
						for (var eID in tinyMCE.editors)
						{
							//window.log(eID);
							//$('#<xsl:value-of select="$panelID" />.panel').find('#'+eID).log();
							if ($('#<xsl:value-of select="$panelID" />.panel').find('#'+eID).length != 0)
							{
								tinyMCE.execCommand('mceFocus', false, eID);
								tinyMCE.execCommand('mceRemoveControl', false, eID);
							}
						}
						delete this;
					}
				}
				$('#<xsl:value-of select="$panelID" />.panel').panel('addExternalResource', tinyCleaner, 'tinyCleaner');
			}
			
			/*$.getSafeScript('<xsl:value-of select="$systemURL" />js/tiny_mce/tiny_mce.js', delegate(this, function(){
				window.log(tinyMCE);*/
				tinyMCE.init({
				   	mode :								'specific_textareas',
				   	editor_selector :					/<xsl:value-of select="$textareaClass" />/,
				    width : 							'100%',
				    height : 							'400',
				    theme : 							'advanced',
				    plugins : 							'inlinepopups,searchreplace,paste',
				    theme_advanced_buttons1 : 			'formatselect,|,justifyleft,justifycenter,justifyright,justifyfull,|,bullist,numlist',
				    theme_advanced_buttons2 : 			'outdent,indent,|,bold,italic,underline,removeformat,|,link,unlink,|,code',
				    theme_advanced_buttons3 : 			'undo,redo,|,cut,copy,paste,|,search,replace',
				    theme_advanced_buttons4 : 			'',
				    theme_advanced_toolbar_location : 	'top',
				    theme_advanced_toolbar_align : 		'left',
				    theme_advanced_statusbar_location : 'bottom',
				    theme_advanced_resizing : 			false,
				    force_br_newlines : 				true,
				    force_p_newlines : 					true,
				    forced_root_block : 				'',
				    entity_encoding : 					'raw',          
				    relative_urls : 					false,
				    remove_script_host : 				false
				});	
			/*}), null);*/
	</xsl:template>	
	
	<xsl:template name="js-init-display-xml">	
    	$('#<xsl:value-of select="$panelID" />.panel').bind('toggle', function(event, linkElem){
    		$(linkElem).toggleClass('collapsable').toggleClass('expandable').next('span').children('div').toggle();
    	});
	</xsl:template>
	
    <xsl:template match="*" mode="display-xml">
	    <xsl:param name="collapsed" select="true()" />
	    
    	<a href="#" class="node expandable" onclick="$('#{$panelID}.panel').trigger('toggle', [this]);">
    		<xsl:if test="$collapsed=false()">
    			<xsl:attribute name="class">
    				<xsl:text>node collapsable</xsl:text>
    			</xsl:attribute>
    		</xsl:if>
    	</a>
    	
   		<span>
	   		<xsl:text>&lt;</xsl:text>
	   		<xsl:value-of select="name(.)" />
	   		<xsl:apply-templates select="./@*" mode="display-xml"/>
	   		<xsl:text>&gt;</xsl:text>
	   		<div style="margin-left:11px;">
	    		<xsl:if test="$collapsed=true()">
	    			<xsl:attribute name="class">
	    				<xsl:text>hidden</xsl:text>
	    			</xsl:attribute>
	    		</xsl:if>
	   			<xsl:apply-templates select="./node()" mode="display-xml">
		   			 <xsl:with-param name="collapsed" select="$collapsed" />
	   			</xsl:apply-templates>
	   		</div>
	   		<xsl:text>&lt;/</xsl:text>
	   		<xsl:value-of select="name(.)" />
	   		<xsl:text>&gt;</xsl:text>
   		</span>
   		<br />
    </xsl:template>
    
    <xsl:template match="*[text()]" mode="display-xml">
    	<span>
   			<xsl:text>&lt;</xsl:text>
	   		<xsl:value-of select="name(.)" />
	   		<xsl:apply-templates select="./@*" mode="display-xml"/>
	   		<xsl:text>&gt;</xsl:text>
			<xsl:apply-templates select="./node()" mode="display-xml" />   		
	   		<xsl:text>&lt;/</xsl:text>
	   		<xsl:value-of select="name(.)" />
	   		<xsl:text>&gt;</xsl:text>
   		</span>
   		<br />
    </xsl:template>
    
    <xsl:template match="*[not(node())]" mode="display-xml">
    	<span>
	   		<xsl:text>&lt;</xsl:text>
   			<xsl:value-of select="name(.)" />
   			<xsl:apply-templates select="./@*" mode="display-xml"/>
   			<xsl:text> /&gt;</xsl:text>
  		</span>
   		<br />
    </xsl:template>
    
    <xsl:template match="text()" mode="display-xml">
   		<xsl:value-of select="." />
    </xsl:template>
    
    <xsl:template match="@*" mode="display-xml">
    	<span>
	    	<xsl:text> </xsl:text>
	    	<xsl:value-of select="name(.)" />
	    	<xsl:text>="</xsl:text>
	    	<xsl:value-of select="." />
	    	<xsl:text>"</xsl:text>
    	</span>
    </xsl:template>
    
     <xsl:template match="node()" mode="strip-xml-namespaces">
     	<xsl:copy>
    	 	<xsl:apply-templates select="@*|node()" mode="strip-xml-namespaces" />
     	</xsl:copy>
     </xsl:template>
     
    <xsl:template match="@xmlns" mode="strip-xml-namespaces">
    </xsl:template>
     
    <xsl:template match="@*" mode="strip-xml-namespaces">
		<xsl:copy>
			<xsl:apply-templates select="."/>
		</xsl:copy>	
    </xsl:template>
</xsl:stylesheet>