<?xml version="1.0"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/system/tools/category/List.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
    <xsl:import href="include.xsl"/>
    <xsl:output encoding="UTF-8" method="xml" indent="no"/>
    <xsl:strip-space elements="*"/>

    <xsl:param name="categories" select="/RESPONSE/RESULTS[@name='list']/CATEGORY" />
    <xsl:param name="currentCategory" select="/RESPONSE/RESULTS[@name='item']/CATEGORY" />
        
	<xsl:template match="/RESPONSE">
    	<xsl:call-template name="panel-navigation" />
    </xsl:template>

	<xsl:template name="panel-title">
		<xsl:call-template name="truncate-phrase">
			<xsl:with-param name="phrase">
				<xsl:choose>
					<xsl:when test="$currentCategory">
						<xsl:value-of select="$currentCategory/LABEL" />
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="/RESPONSE/URL/title" />
					</xsl:otherwise>
				</xsl:choose>
				<xsl:text> (</xsl:text>
				<xsl:value-of select="count($categories)" />
				<xsl:text>)</xsl:text>
			</xsl:with-param>
		</xsl:call-template>
	</xsl:template>
    
   	<xsl:template name="panel-body-navigation">
		<xsl:apply-templates select="$currentCategory" mode="element-naviteminfo" />
		
	    <xsl:call-template name="nav-newcategitem">
	    	<xsl:with-param name="fatherID" select="$currentCategory/@ID" />
	    </xsl:call-template>
	    
	    <xsl:variable name="distinctModules" select="$categories[not(@module=preceding-sibling::CATEGORY/@module)]/@module" />
	    <xsl:choose>
	    	<xsl:when test="count($distinctModules) &gt;1">
			    <xsl:for-each select="$distinctModules">
			    	<xsl:sort select="." />
			    	<xsl:if test="current()!=''">
				        <xsl:call-template name="staticitem">
				            <xsl:with-param name="title">
				            	<xsl:value-of select="." />
				            </xsl:with-param>
				            <xsl:with-param name="icon">../system/images/icons/modules/generic.png</xsl:with-param>
				            <xsl:with-param name="info"></xsl:with-param>
				        </xsl:call-template>
			        </xsl:if>
				    <xsl:for-each select="$categories[@module=current()]">		    	
				        <xsl:sort select="translate(LABEL, $xsltsl-str-lower, $xsltsl-str-upper)" />
				        <xsl:apply-templates select="." mode="element-navitem" />
				    </xsl:for-each>
			    </xsl:for-each>
	    	</xsl:when>
	    	<xsl:otherwise>
	    		<xsl:choose>
	    			<xsl:when test="count($categories)&gt;0">
					    <xsl:for-each select="$categories">		    	
					        <xsl:sort select="translate(LABEL, $xsltsl-str-lower, $xsltsl-str-upper)" />
					        <xsl:apply-templates select="." mode="element-navitem" />
					    </xsl:for-each>
				    </xsl:when>
				    <xsl:otherwise>
				    	<div class="no-result">No subcategories</div>
				    </xsl:otherwise>
			    </xsl:choose>
	    	</xsl:otherwise>
	    </xsl:choose>
   	</xsl:template>
   	
   	<xsl:template name="panel-add-js">
		<!-- temporary trick -->
		<!--xsl:if test="(/RESPONSE/URL/ID!=0) and (not($currentCategory))">
			$(AppController).panelslider('removePanel', <xsl:value-of select="$panelID"/>, 1);
		</xsl:if-->
   	</xsl:template>
</xsl:stylesheet>