<?xml version="1.0"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/system/tools/filter/QueryList.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
    <xsl:import href="include.xsl"/>
    <xsl:output encoding="UTF-8" method="xml" indent="no"/>
    <xsl:strip-space elements="*"/>
    
    <xsl:param name="list" select="/RESPONSE/RESULTS[@name='filters']"/>            
    
	<xsl:template match="/RESPONSE">
    	<xsl:call-template name="panel-navigation" />
    </xsl:template>
    
   	<xsl:template name="panel-body-navigation">
        <xsl:choose>
            <xsl:when test="count($list/*) &gt; 0">
                <xsl:for-each select="$list/OFFICITY:FILTER">
                    <xsl:sort select="INFO/DEFAULT" order="descending"/>
                    <xsl:sort select="INFO/OWNERID" order="descending"/>
                    <xsl:apply-templates select="." mode="element-navitem">
                        <xsl:with-param name="callbackpanel" select="/RESPONSE/URL/callbackPanel"/>
                    </xsl:apply-templates>
                </xsl:for-each>                
            </xsl:when>
            <xsl:otherwise>
				<div class="no-result">No filter found</div>
            </xsl:otherwise>
        </xsl:choose>
	</xsl:template>
	
	<xsl:template name="panel-js-navigation">
	    <xsl:call-template name="panel-bind-delete-event" />
	
	    <xsl:if test="$list/OFFICITY:FILTER[INFO/COUNT=1]">
	        <xsl:apply-templates select="$list/OFFICITY:FILTER[INFO/COUNT=1]" mode="counter"/>
	    </xsl:if>
	</xsl:template>

    <xsl:template match="OFFICITY:FILTER[INFO/COUNT=1]" mode="counter">
            var countRequest<xsl:value-of select="@ID"/> = new AjaxRequest(
                <xsl:value-of select="$panelID"/>,
                AppController,
                '<xsl:value-of select="$systemToolsURL"/>filter/count.php',
                'GET'
            );

            countRequest<xsl:value-of select="@ID"/>.addData('filterID', <xsl:value-of select="@ID"/>);

            countRequest<xsl:value-of select="@ID"/>.onSuccess(function(response){
                $('#officity__filter-<xsl:value-of select="@ID"/> .info .actions-label').html(response.message+' hit(s)').attr('default-value', response.message+' hit(s)');
            }).send();
    </xsl:template>
</xsl:stylesheet>
