<?xml version="1.0" encoding="utf-8"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/system/tools/filter/filter.definitions.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
	<!-- LABEL(s) -->
	<xsl:template match="OFFICITY:FILTER" mode="element-label">
		<xsl:value-of select="INFO/DENOMINATION" />
	</xsl:template>

	<!-- ICON(s) -->
    <xsl:template match="OFFICITY:FILTER" mode="element-icon">
        <xsl:text>../system/images/icons/search/advancedsearch.png</xsl:text>
    </xsl:template>

    <xsl:template match="OFFICITY:FILTER[INFO/DEFAULT=1]" mode="element-icon">
        <xsl:text>../system/images/icons/search/advancedsearch-filter.png</xsl:text>
    </xsl:template>

    <xsl:template match="OFFICITY:FILTER[INFO/OWNERID=0]" mode="element-icon">
        <xsl:text>../system/images/icons/contacts/group-16.png</xsl:text>
    </xsl:template>
    
	<!-- INFO LABEL(s) -->
    <xsl:template match="OFFICITY:FILTER" mode="element-info">
		<xsl:value-of select="INFO/MODULE" />
		<xsl:text> (</xsl:text>
		<xsl:value-of select="@ID" />
		<xsl:text>)</xsl:text>
    </xsl:template>

	<!-- NAVIGATION ITEM(s) -->
	<xsl:template match="OFFICITY:FILTER" mode="element-navitem-parms">
         <xsl:text>filterID:</xsl:text><xsl:value-of select="./@ID"/>
         <xsl:text>,module:'</xsl:text>
         <xsl:value-of select="./INFO/MODULE"/>
         <xsl:text>',callbackPanel:'</xsl:text>
         <xsl:value-of select="'../../system/tools/element/Search'"/>
         <xsl:text>'</xsl:text>
    </xsl:template>
	
	<!-- query filters -->
	<xsl:template match="OFFICITY:FILTER[INFO/ISQUERY=1]" mode="element-navitem">
        <xsl:param name="callbackpanel" select="'../../system/tools/element/Search'" />
        
        <xsl:variable name="module">
    		<xsl:call-template name="translate-namespace-name">
        		<xsl:with-param name="name" select="name(.)"/>
        	</xsl:call-template>
        </xsl:variable>

        <xsl:call-template name="navigationitem-actions">
			<xsl:with-param name="id">
                <xsl:value-of select="$module" />
                <xsl:text>-</xsl:text>
                <xsl:value-of select="@ID"/>
            </xsl:with-param>
            <xsl:with-param name="title">
                <xsl:apply-templates select="." mode="element-label"/>
            </xsl:with-param>
            <xsl:with-param name="icon">
                <xsl:apply-templates select="." mode="element-icon"/>
            </xsl:with-param>
			<xsl:with-param name="info">
				<xsl:if test="INFO/COUNT=1">
					<div class="ajax-loader-nav" style="display:block;"/>
				</xsl:if>
			</xsl:with-param>
			<xsl:with-param name="panelURI">
				<xsl:text>../../system/tools/element/NewSearch</xsl:text>
			</xsl:with-param>
			<xsl:with-param name="params">
                <xsl:text>filterID:</xsl:text><xsl:value-of select="./@ID"/>
                <xsl:text>,module:'</xsl:text>
                <xsl:value-of select="./INFO/MODULE"/>
                <xsl:text>',callbackPanel:'</xsl:text>
                <xsl:value-of select="$callbackpanel"/>
                <xsl:text>'</xsl:text>
            </xsl:with-param>
			<xsl:with-param name="rightactions-elems">
	            <a href="#" class="delete-action" hover-title="Delete" title="Delete this filter">
	                <xsl:attribute name="onclick">
	                    <xsl:call-template name="triggerpanelevent">
	                        <xsl:with-param name="event" select="'deleteitem'"/>
	                        <xsl:with-param name="params">
				                <xsl:text>this, </xsl:text>
				                <xsl:value-of select="@ID" />
				                <xsl:text>, </xsl:text>
				                <xsl:text>'</xsl:text>
				                <xsl:apply-templates select="." mode="element-script-delete" />
				                <xsl:text>'</xsl:text>
	                        </xsl:with-param>
	                    </xsl:call-template>
	                </xsl:attribute>
	            </a>
			</xsl:with-param>
        </xsl:call-template>
    </xsl:template>

	<!-- display configurations -->
    <xsl:template match="*[INFO/DEFAULT=1]" mode="filterdisplay-staticitem">
        <xsl:variable name="module">
    		<xsl:call-template name="translate-namespace-name">
        		<xsl:with-param name="name" select="name(.)"/>
        	</xsl:call-template>
        </xsl:variable>
        
        <xsl:call-template name="staticitem-action">
			<xsl:with-param name="id">
                <xsl:value-of select="$module" />
                <xsl:text>-display-</xsl:text>
                <xsl:value-of select="@ID"/>
            </xsl:with-param>
            <xsl:with-param name="title">
                <xsl:apply-templates select="." mode="element-label"/>
            </xsl:with-param>
            <xsl:with-param name="hovertitle" select="'Load and apply'" />
            <xsl:with-param name="icon">
                <xsl:apply-templates select="." mode="element-icon"/>
            </xsl:with-param>
            <xsl:with-param name="callback">
            	<xsl:text>$('#</xsl:text>
            	<xsl:value-of select="$parentPanelID"/>
            	<xsl:text>.panel').trigger</xsl:text>
            </xsl:with-param>
            <xsl:with-param name="params">
            	<xsl:text>'search-loaddisplay', [this, </xsl:text>
            	<xsl:value-of select="@ID"/>
            	<xsl:text>]</xsl:text>
            </xsl:with-param>
            <xsl:with-param name="info">
            	<span style="display:none;">loading...&#160;</span>
            	<div class="ajax-loader-nav" />
            </xsl:with-param>
        </xsl:call-template>
    </xsl:template>

    <xsl:template match="*[INFO/DEFAULT=0]" mode="filterdisplay-staticitem">
        <xsl:variable name="module">
    		<xsl:call-template name="translate-namespace-name">
        		<xsl:with-param name="name" select="name(.)"/>
        	</xsl:call-template>
        </xsl:variable>
        
        <xsl:call-template name="staticitem-action">
			<xsl:with-param name="id">
                <xsl:value-of select="$module" />
                <xsl:text>-display-</xsl:text>
                <xsl:value-of select="@ID"/>
            </xsl:with-param>
            <xsl:with-param name="title">
                <xsl:apply-templates select="." mode="element-label"/>
            </xsl:with-param>
            <xsl:with-param name="hovertitle" select="'Load and apply'" />
            <xsl:with-param name="icon">
                <xsl:apply-templates select="." mode="element-icon"/>
            </xsl:with-param>
            <xsl:with-param name="callback">
            	<xsl:text>$('#</xsl:text>
            	<xsl:value-of select="$parentPanelID"/>
            	<xsl:text>.panel').trigger</xsl:text>
            </xsl:with-param>
            <xsl:with-param name="params">
            	<xsl:text>'search-loaddisplay', [this, </xsl:text>
            	<xsl:value-of select="@ID"/>
            	<xsl:text>]</xsl:text>
            </xsl:with-param>
			<xsl:with-param name="rightactions-elems">
				<div class="ajax-loader-nav" style="float:none;" />
	            <a href="#" class="delete-action" hover-title="Delete" title="Delete this filter">
	                <xsl:attribute name="onclick">
	                    <xsl:call-template name="triggerpanelevent">
	                        <xsl:with-param name="event" select="'deleteitem'"/>
	                        <xsl:with-param name="params">
				                <xsl:text>this, </xsl:text>
				                <xsl:value-of select="@ID" />
				                <xsl:text>, </xsl:text>
				                <xsl:text>'</xsl:text>
				                <xsl:apply-templates select="." mode="element-script-delete" />
				                <xsl:text>'</xsl:text>
	                        </xsl:with-param>
	                    </xsl:call-template>
	                </xsl:attribute>
	            </a>
			</xsl:with-param>
            <xsl:with-param name="info">
            	<span style="display:none;">loading...&#160;</span>
            </xsl:with-param>
        </xsl:call-template>
    </xsl:template>
   
   	<!-- TITLE(s) -->
   	
   	<!-- SCRIPTS -->
    <xsl:template match="OFFICITY:FILTER" mode="element-script-detail">
		<xsl:text>../../system/tools/element/NewSearch</xsl:text>
	</xsl:template>
	
    <xsl:template match="OFFICITY:FILTER" mode="element-script-create">
		<xsl:text>../../system/tools/filter/save.php</xsl:text>
	</xsl:template>

    <xsl:template match="OFFICITY:FILTER" mode="element-script-update">
		<xsl:text>../../system/tools/filter/save.php</xsl:text>
	</xsl:template>

    <xsl:template match="OFFICITY:FILTER" mode="element-script-delete">
		<xsl:text>../../system/tools/filter/delete.php</xsl:text>
	</xsl:template>

    <xsl:template match="OFFICITY:FILTER" mode="element-script-count">
		<xsl:text>../../system/tools/filter/count.php</xsl:text>
	</xsl:template>
</xsl:stylesheet>
