<?xml version="1.0"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/system/tools/history/List.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
	<xsl:import href="include.xsl"/>
	<xsl:output encoding="UTF-8" method="xml" indent="no"/>
	<xsl:strip-space elements="*"/>

    <xsl:template match="/RESPONSE">
        <xsl:choose>
            <xsl:when test="/RESPONSE/URL/page">
                <xsl:call-template name="paging-list"/>
                <script type="text/javascript">
                	setTimeout( checkItemsHeight, 1 );
                </script>
            </xsl:when>
            <xsl:otherwise>
				<div class="panel-title-bar">
					<xsl:call-template name="panel-title-bar"/>
				</div>
		        <div class="panel-header">
		        	<xsl:call-template name="panel-header"/>
		       	</div>
                <div class="panel-body" optimal-width="600">
                    <div class="panel-body-loader">
                        <div class="flower"/>
                    </div>
                    <div class="block block-nav block-history">
                        <xsl:call-template name="paging-list"/>
                    </div>
                </div>
                <script type="text/javascript">
                    var loadPageRequest<xsl:value-of select="$panelID"/> = new AjaxRequest(
			            <xsl:value-of select="$panelID"/>,
			            AppController,
			            '<xsl:value-of select="/RESPONSE/URL/panelURI" />.php',
			            'POST',
			            'html'
			        );

			        $('#<xsl:value-of select="$panelID"/>.panel').bind('loadpage', function(eventObject, page){
			            $('#<xsl:value-of select="$panelID"/>.panel').trigger('panel-displayloader', [true, 'body']);
			
			            loadPageRequest<xsl:value-of select="$panelID"/>.setData({
			                panelID : <xsl:value-of select="$panelID"/>,
			                app : '<xsl:value-of select="/RESPONSE/URL/app" />',
			                editor : '<xsl:value-of select="/RESPONSE/URL/editor" />',
			                module : '<xsl:value-of select="/RESPONSE/URL/module"/>',
			                page : page,
			                ID : <xsl:value-of select="/RESPONSE/URL/ID"/>
			            });
			
			            loadPageRequest<xsl:value-of select="$panelID"/>.onSuccess(function(response){
			            	$('#<xsl:value-of select="$panelID"/>.panel').trigger('panel-displayloader', [false, 'body']).trigger('panel-blockcontent', ['.block-nav', response]);
			            }).onError(function(response){
							$('#<xsl:value-of select="$panelID"/>.panel').trigger('panel-displayloader', [false, 'body']).trigger('panel-blockcontent', ['.block-nav', response]);
			            }).send();
			            
			            return false;
		            });
		            
		            /* *** */
		            
		            function checkItemsHeight()
                    {
                        $('#<xsl:value-of select="$panelID"/>.panel').find('.items').each(function(){
                            //window.log($(this).height());
                            if ($(this).height() != 30)
                            {
                                $(this).children('.icon').toggle();
                            }
                            $(this).toggleClass('open');
                        });
                    }

                    setTimeout( checkItemsHeight, 1 );
                </script>
            </xsl:otherwise>
        </xsl:choose>
	</xsl:template>

    <!-- LIST TEMPLATE -->
    <xsl:template name="paging-list">
        <xsl:variable name="list" select="/RESPONSE/RESULTS[@name='list']"/>
        <xsl:variable name="logs" select="$list/LOG"/>
        
        <xsl:call-template name="list-browser">
            <xsl:with-param name="list" select="$list"/>
            <xsl:with-param name="event" select="'loadpage'"/>
        </xsl:call-template>

        <xsl:choose>
            <xsl:when test="$list/@hits > 0">
				<xsl:apply-templates select="$logs" mode="list"/>
            </xsl:when>
            <xsl:otherwise>
                <div class="no-result">No modifications have been logged</div>
            </xsl:otherwise>
        </xsl:choose>

        <xsl:call-template name="list-browser">
            <xsl:with-param name="list" select="$list"/>
            <xsl:with-param name="event" select="'loadpage'"/>
        </xsl:call-template>
    </xsl:template>
</xsl:stylesheet>