<?xml version="1.0"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/system/tools/list/Values.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
    <xsl:import href="include.xsl"/>
    <xsl:output encoding="UTF-8" method="xml" indent="no"/>
    <xsl:strip-space elements="*"/>

    <xsl:param name="lists" select="//LIST" />
    
	<xsl:template match="/RESPONSE">
    	<xsl:call-template name="panel-navigation" />
    </xsl:template>
    
    <xsl:template name="panel-title">
    	<xsl:value-of select="/RESPONSE/URL/domain" />
    	<xsl:text> : </xsl:text>
    	<xsl:value-of select="/RESPONSE/URL/list" />
	</xsl:template>
    
   	<xsl:template name="panel-body-navigation">
	    <xsl:call-template name="navigationitem">
		    <xsl:with-param name="title" select="'Export list values...'" />
		    <xsl:with-param name="panelURI">../../system/tools/list/Export</xsl:with-param>
		    <xsl:with-param name="params">
		        <xsl:text>domain:'</xsl:text>
		        <xsl:value-of select="/RESPONSE/URL/domain"/>
		        <xsl:text>'</xsl:text>
		        <xsl:if test="/RESPONSE/URL/list">
		        	<xsl:text>,list:'</xsl:text>
		        	<xsl:value-of select="/RESPONSE/URL/list"/>
		        	<xsl:text>'</xsl:text>
		        </xsl:if>
		    </xsl:with-param>
		    <xsl:with-param name="icon">../system/images/icons/documents/excel-16.png</xsl:with-param>
		    <xsl:with-param name="info">
		    </xsl:with-param>
		    <xsl:with-param name="cssclass">grey-bkgnd</xsl:with-param>
	    </xsl:call-template>
	    
        <xsl:call-template name="shared-values" />
        
        <xsl:apply-templates select="/RESPONSE/RESULTS[@name='published_languages']/LANGUAGE" />
   	</xsl:template>
   	
    <xsl:template match="LANGUAGE">
        <xsl:param name="languageID" select="@ID" />
        <xsl:param name="listItems" select="/RESPONSE/RESULTS[@name=$languageID]/LIST/ITEM[not(/RESPONSE/RESULTS[@name='shared']/LIST/ITEM/@label=@label and /RESPONSE/RESULTS[@name='shared']/LIST/ITEM/@value=@value)]" />

	    <xsl:call-template name="nav-newlistitem">
	     	<xsl:with-param name="title" select="LABEL" />
	    	<xsl:with-param name="domain" select="/RESPONSE/URL/domain" />
	    	<xsl:with-param name="list" select="/RESPONSE/URL/list" />
	    	<xsl:with-param name="languageID" select="$languageID" />
	    	<xsl:with-param name="info">
				<xsl:value-of select="count($listItems)"/>
				<xsl:text> value(s)</xsl:text>
	    	</xsl:with-param>
	    </xsl:call-template>
	   
        <xsl:for-each select="$listItems">
            <xsl:sort select="translate(@label, $xsltsl-str-lower, $xsltsl-str-upper)" />
            <xsl:apply-templates select="." mode="element-navitem" />
        </xsl:for-each>
    </xsl:template>

    <xsl:template name="shared-values">
    	<xsl:param name="languageID" select="'shared'" />
        <xsl:param name="listItems" select="/RESPONSE/RESULTS[@name=$languageID]/LIST/*" />
        
	    <xsl:call-template name="nav-newlistitem">
	     	<xsl:with-param name="title" select="'Shared'" />
	    	<xsl:with-param name="domain" select="/RESPONSE/URL/domain" />
	    	<xsl:with-param name="list" select="/RESPONSE/URL/list" />
	    	<xsl:with-param name="languageID" select="$languageID" />
	    	<xsl:with-param name="info">
				<xsl:value-of select="count($listItems)"/>
				<xsl:text> value(s)</xsl:text>
	    	</xsl:with-param>
	    </xsl:call-template>

        <xsl:for-each select="$listItems">
            <xsl:sort select="translate(@label, $xsltsl-str-lower, $xsltsl-str-upper)" />
            <xsl:apply-templates select="." mode="element-navitem" />
        </xsl:for-each>
    </xsl:template>
</xsl:stylesheet>