<?xml version="1.0"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/system/tools/module/Dependencies.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
    <xsl:import href="include.xsl"/>
    <xsl:output encoding="UTF-8" method="xml" indent="no"/>
    <xsl:strip-space elements="*"/>
    
    <xsl:param name="entities" select="/RESPONSE/RESULTS/DEPENDENCYENTITY" />

	<xsl:template match="/RESPONSE">
    	<xsl:call-template name="panel-navigation" />
    </xsl:template>
    
    <xsl:template name="panel-title">
        <xsl:choose>
            <xsl:when test="not(/RESPONSE/URL/module)">
				<xsl:call-template name="truncate-phrase">
					<xsl:with-param name="phrase">
		                <xsl:value-of select="/RESPONSE/URL/title" />  
					</xsl:with-param>
				</xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
			<xsl:call-template name="truncate-phrase">
				<xsl:with-param name="phrase">
	                <xsl:text>DEPENDENCY TYPES : </xsl:text>
	                <xsl:value-of select="/RESPONSE/URL/module" />  
				</xsl:with-param>
			</xsl:call-template>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>  
	
	<xsl:template name="panel-body-navigation">  
        <xsl:choose>
            <xsl:when test="$entities">
                <xsl:for-each select="$entities">
                    <xsl:sort select="DEPENDENCYTYPE[@from=/RESPONSE/URL/module]/TYPE" />
                    <xsl:call-template name="navigationitem">
                        <xsl:with-param name="title">
                            <xsl:value-of select="DEPENDENCYTYPE[1]/TYPE"/>
                        </xsl:with-param>
                        <xsl:with-param name="panelURI">../../system/tools/module/Fields</xsl:with-param>
                        <xsl:with-param name="params">
                            <xsl:text>module:'</xsl:text>
                            <xsl:value-of select="DEPENDENCYTYPE[1]/@to"/>
                            <xsl:text>'</xsl:text>
                        </xsl:with-param>
                        <xsl:with-param name="icon">
                            <xsl:text>../system/images/icons/dependencies/link-16.png</xsl:text>
                        </xsl:with-param>
                        <xsl:with-param name="info">
                            <xsl:value-of select="DEPENDENCYTYPE[1]/@from"/>
                            <xsl:text> =&gt; </xsl:text>
                            <xsl:value-of select="DEPENDENCYTYPE[1]/@to"/>
                                <xsl:text> (</xsl:text>
                                <xsl:value-of select="DEPENDENCYTYPE[1]/@ID" />
                                <xsl:text>)</xsl:text>
                        </xsl:with-param>
                    </xsl:call-template>
                    <xsl:if test="DEPENDENCYTYPE[2] and (DEPENDENCYTYPE[1]/TYPE!=DEPENDENCYTYPE[2]/TYPE)">
                        <xsl:call-template name="navigationitem">
                            <xsl:with-param name="title">
                                <xsl:value-of select="DEPENDENCYTYPE[2]/TYPE"/>
                            </xsl:with-param>
                            <xsl:with-param name="panelURI">../../system/tools/module/Fields</xsl:with-param>
                            <xsl:with-param name="params">
                                <xsl:text>module:'</xsl:text>
                                <xsl:value-of select="/RESPONSE/URL/module"/>
                                <xsl:text>'</xsl:text>
                            </xsl:with-param>
                            <xsl:with-param name="icon">
                                <xsl:text>../system/images/icons/dependencies/link-16.png</xsl:text>
                            </xsl:with-param>
                            <xsl:with-param name="info">
                                <xsl:value-of select="DEPENDENCYTYPE[2]/@from"/>
                                <xsl:text> =&gt; </xsl:text>
                                <xsl:value-of select="DEPENDENCYTYPE[2]/@to"/>
                                <xsl:text> (</xsl:text>
                                <xsl:value-of select="DEPENDENCYTYPE[2]/@ID" />
                                <xsl:text>)</xsl:text>
                            </xsl:with-param>
                        </xsl:call-template>
                    </xsl:if>
                </xsl:for-each>
            </xsl:when>
            <xsl:otherwise>
                <div class="no-result">No dependencies found</div>
            </xsl:otherwise>
        </xsl:choose>
	</xsl:template>
</xsl:stylesheet>