<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/system/tools/report/csv/generic-csv-export.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
	<xsl:import href="../include.xsl"/>
	<xsl:output method="text" media-type="text/plain" />
    <!--xsl:preserve-space elements="*"/-->

    <xsl:param name="search-config" select="/RESPONSE/RESULTS[@name='search-config']/CONFIGXML"/>
    <xsl:param name="search-module-denom" select="$search-config/MODULE"/>
    <xsl:param name="search-filter" select="/RESPONSE/RESULTS[@name='search-filter']"/>
    <xsl:param name="filter-info" select="$search-filter/INFO"/>
    <xsl:param name="filter-display" select="$filter-info/DISPLAYXML"/>

	<xsl:param name="csv-config" select="/RESPONSE/RESULTS[@name='csv-config']"/>
	<xsl:param name="sep-char" select="$csv-config/SEPCHAR"/>
	<xsl:param name="eol-seq">
        <xsl:text>&#10;</xsl:text>
    </xsl:param>

	<xsl:param name="items" select="/RESPONSE/RESULTS[@name='data']/*"/>

	<xsl:param name="total-cols">
		<xsl:call-template name="get-total-cols"/>
	</xsl:param>

	<xsl:template match="/RESPONSE">
		<xsl:if test="$csv-config/SUBTITLE/text()">
			<xsl:call-template name="line">
				<xsl:with-param name="data">
					<xsl:choose>
						<xsl:when test="$csv-config/TITLE/text()">
							<xsl:value-of select="$csv-config/TITLE/text()"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="$search-config/MODULEDESC"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:with-param>
			</xsl:call-template>
		</xsl:if>
		<xsl:if test="$csv-config/SUBTITLE/text()">
			<xsl:call-template name="line">
				<xsl:with-param name="data" select="$csv-config/SUBTITLE/text()"/>
			</xsl:call-template>
		</xsl:if>
		<xsl:if test="$csv-config/SUBTITLE/text() or $csv-config/SUBTITLE/text()">
			<xsl:call-template name="line"/>
		</xsl:if>
		<xsl:for-each select="$filter-display/RETURN/INFO/* | $filter-display/RETURN/DEPENDENCIES/DEPENDENCY">
			<xsl:sort select=".//@order" order="ascending" data-type="number"/>
			<xsl:apply-templates select="." mode="header"/>
			<xsl:choose>
				<xsl:when test="position()!=last()">
					<xsl:value-of select="$sep-char"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$eol-seq"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:for-each>
		<xsl:for-each select="$items">
			<xsl:apply-templates select="." mode="item"/>
		</xsl:for-each>
	</xsl:template>

	<!-- HEADERS -->
	<xsl:template match="INFO/*" mode="header">
		<xsl:text>"</xsl:text>
			<xsl:call-template name="get-module-field-name">
				<xsl:with-param name="moduleName" select="$search-module-denom"/>
				<xsl:with-param name="nodeName" select="name()"/>
			</xsl:call-template>
		<xsl:text>"</xsl:text>
	</xsl:template>

	<xsl:template match="DEPENDENCY" mode="header">
		<xsl:call-template name="dep-header">
			<xsl:with-param name="max-deps" select="$filter-display/RETURN/DEPENDENCIES/DEPENDENCY[@type=current()/@type]/@max" />
			<xsl:with-param name="target-name" select="$search-config/DEPENDENCIES/DEPENDENCY[TYPE=current()/@type]/MODULEDESC" />
		</xsl:call-template>
	</xsl:template>

	<xsl:template name="dep-header">
		<xsl:param name="max-deps" />
		<xsl:param name="target-name" />
		<xsl:param name="index" select="1" />
		<xsl:choose>
			<xsl:when test="$index &lt; $max-deps">
				<xsl:text>"</xsl:text>
				<xsl:value-of select="$target-name"/>
				<xsl:text> (</xsl:text><xsl:value-of select="$index" /><xsl:text>)</xsl:text>
				<xsl:text>"</xsl:text>
				<xsl:value-of select="$sep-char"/>
				<xsl:call-template name="dep-header">
					<xsl:with-param name="index" select="$index+1" />
					<xsl:with-param name="max-deps" select="$max-deps" />
					<xsl:with-param name="target-name" select="$target-name" />
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:text>"</xsl:text>
				<xsl:value-of select="$target-name"/>
				<xsl:text> (</xsl:text><xsl:value-of select="$index" /><xsl:text>)</xsl:text>
				<xsl:text>"</xsl:text>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!-- ITEMS -->
	<xsl:template match="*" mode="item">
		<xsl:variable name="item" select="."/>
		<xsl:for-each select="$filter-display/RETURN/INFO/* | $filter-display/RETURN/DEPENDENCIES/DEPENDENCY">
			<xsl:sort select=".//@order" order="ascending" data-type="number"/>
			<xsl:choose>
				<xsl:when test="parent::INFO">
					<xsl:text>"</xsl:text>
						<xsl:call-template name="get-module-field-value">
							<xsl:with-param name="moduleName" select="$search-module-denom"/>
							<xsl:with-param name="node" select="$item/INFO/*[name()=name(current())]"/>
						</xsl:call-template>
					<xsl:text>"</xsl:text>
				</xsl:when>
				<xsl:otherwise>					
					<xsl:call-template name="dep-data">
						<xsl:with-param name="max-deps" select="$filter-display/RETURN/DEPENDENCIES/DEPENDENCY[@type=current()/@type]/@max" />
						<xsl:with-param name="filter-dep-info" select="current()/INFO" />
						<xsl:with-param name="module-denom" select="$search-config/DEPENDENCIES/DEPENDENCY[TYPE=current()/@type]/MODULE" />
						<xsl:with-param name="current-dep-item" select="$item/DEPENDENCIES/DEPENDENCY[@type=current()/@type]/*[1]" />
					</xsl:call-template>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:choose>
				<xsl:when test="position()!=last()">
					<xsl:value-of select="$sep-char"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$eol-seq"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="dep-data">
		<xsl:param name="max-deps" />
		<xsl:param name="filter-dep-info" />
		<xsl:param name="current-dep-item" />
		<xsl:param name="module-denom" />
		<xsl:param name="index" select="1" />		
		<xsl:choose>
			<xsl:when test="$index &lt; $max-deps">
				<xsl:text>"</xsl:text>
				<xsl:if test="$current-dep-item">
					<xsl:for-each select="$filter-dep-info/*">
						<xsl:sort select="@order" order="ascending" data-type="number"/>
						<xsl:call-template name="get-module-field-value">
							<xsl:with-param name="moduleName" select="$module-denom"/>
							<xsl:with-param name="node" select="$current-dep-item/INFO/*[name()=name(current())]"/>
						</xsl:call-template>
						<xsl:if test="position()!=last()">
							<xsl:text>, </xsl:text>
						</xsl:if>
					</xsl:for-each>
				</xsl:if>
				<xsl:text>"</xsl:text>
				<xsl:value-of select="$sep-char"/>
				<xsl:call-template name="dep-data">
					<xsl:with-param name="index" select="$index+1" />
					<xsl:with-param name="max-deps" select="$max-deps" />
					<xsl:with-param name="filter-dep-info" select="$filter-dep-info" />
					<xsl:with-param name="module-denom" select="$module-denom" />
					<xsl:with-param name="current-dep-item" select="$current-dep-item/following-sibling::*[1]" />
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:text>"</xsl:text>
				<xsl:if test="$current-dep-item">
					<xsl:for-each select="$filter-dep-info/*">
						<xsl:sort select="@order" order="ascending" data-type="number"/>
						<xsl:call-template name="get-module-field-value">
							<xsl:with-param name="moduleName" select="$module-denom"/>
							<xsl:with-param name="node" select="$current-dep-item/INFO/*[name()=name(current())]"/>
						</xsl:call-template>
						<xsl:if test="position()!=last()">
							<xsl:text>, </xsl:text>
						</xsl:if>
					</xsl:for-each>
				</xsl:if>
				<xsl:text>"</xsl:text>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!-- UTILS -->
	<xsl:template name="get-total-cols">
		<xsl:param name="total" select="count($filter-display/RETURN/INFO/*)"/>
		<xsl:param name="current-dep" select="$filter-display/RETURN/DEPENDENCIES/DEPENDENCY[1]"/>
		<xsl:choose>
			<xsl:when test="$current-dep">
				<xsl:call-template name="get-total-cols">
					<xsl:with-param name="total" select="$total+$current-dep/@max"/>
					<xsl:with-param name="current-dep" select="$current-dep/following-sibling::DEPENDENCY[1]"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$total"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="line">
		<xsl:param name="data" />
		<xsl:param name="index" select="1"/>
		<xsl:choose>
			<xsl:when test="$index &lt; $total-cols">
				<xsl:text>"</xsl:text>
				<xsl:if test="$index = 1">
					<xsl:value-of select="$data"/>
				</xsl:if>
				<xsl:text>"</xsl:text>
				<xsl:value-of select="$sep-char"/>
				<xsl:call-template name="line">
					<xsl:with-param name="index" select="$index+1" />
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:text>""</xsl:text>
				<xsl:value-of select="$eol-seq"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
