<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/system/tools/report/pdf/reporting.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" version="1.0">
	<xsl:import href="../include.xsl"/>	
	<xsl:output method="xml" indent="yes" encoding="utf-8"/>

	<xsl:param name="formats" select="document('page-formats.xml')/formats/format"/>
	
    <!-- setting template params -->
	<xsl:param name="user" select="/RESPONSE/RESULTS[@name='user']/CONTACT"/>
	<xsl:param name="data" select="/RESPONSE/RESULTS[@name='data']/*"/>
	<xsl:param name="template" select="/RESPONSE/RESULTS[@name='template']"/>	
	<xsl:param name="format" select="$formats[@id = $template/INFO/FORMAT]"/>
	<xsl:param name="orientation" select="$template/INFO/ORIENTATION"/>
    
    <xsl:param name="search-config" select="/RESPONSE/RESULTS[@name='search-config']/CONFIGXML"/>
    <xsl:param name="search-module-denom" select="$search-config/MODULE"/>
    <xsl:param name="search-filter" select="/RESPONSE/RESULTS[@name='search-filter']"/>
    <xsl:param name="filter-info" select="$search-filter/INFO"/>
    <xsl:param name="filter-display" select="$filter-info/DISPLAYXML"/>

	<xsl:param name="margin" select="5"/>
	<xsl:param name="header">
		<xsl:choose>
			<xsl:when test="$template/INFO/HEADER/text()">15</xsl:when>
			<xsl:otherwise>8</xsl:otherwise>
		</xsl:choose>
	</xsl:param>
	<xsl:param name="footer">
		<xsl:choose>
			<xsl:when test="$template/INFO/FOOTER/text()">15</xsl:when>
			<xsl:otherwise>8</xsl:otherwise>
		</xsl:choose>
	</xsl:param>

	<xsl:param name="page-unit" select="$format/@unit"/>
	<xsl:param name="page-width">
		<xsl:choose>
			<xsl:when test="$orientation = 'portrait'">
				<xsl:value-of select="$format/@width"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$format/@height"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:param>

	<xsl:param name="page-height">
		<xsl:choose>
			<xsl:when test="$orientation = 'portrait'">
				<xsl:value-of select="$format/@height"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$format/@width"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:param>
	
	<xsl:param name="inner-width" select="$page-width - (2 * $margin)"/>
	<xsl:param name="inner-height" select="$page-height - (2 * $margin)"/>
	
	<xsl:param name="scale">
		<xsl:choose>
			<xsl:when test="$template/INFO/FONTSIZE/text()">
				<xsl:value-of select="$template/INFO/FONTSIZE"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:text>100</xsl:text>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:param>

	<xsl:param name="fields" select="/RESPONSE/RESULTS/FIELD"/>
	<xsl:param name="table-profile" select="$filter-display/RETURN"/>
	<xsl:param name="table-headers" select="$table-profile//*[@order != '']"/>
	
	<xsl:param name="table-width">
		<xsl:call-template name="head-sum">
			<xsl:with-param name="nod" select="$table-headers[1]"/>
		</xsl:call-template>
	</xsl:param>
	
	<xsl:template name="head-sum">
		<xsl:param name="nod"/>
		<xsl:param name="in" select="0"/>
		<xsl:param name="nodename" select="name($nod)"/>
		<xsl:param name="out" select="$in + $fields[INFO/DENOMINATION = $nodename]/INFO/DISPLAYLENGTH"/>
		<xsl:choose>
			<xsl:when test="$nod/following-sibling::*[1]">
				<xsl:call-template name="head-sum">
					<xsl:with-param name="nod" select="$nod/following-sibling::*[1]"/>
					<xsl:with-param name="in" select="$out"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$out"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template match="/RESPONSE">
		<fo:root>
			
<!-- setting page masters -->

			<fo:layout-master-set>
				<fo:simple-page-master master-name="page-master" page-width="{$page-width}{$page-unit}" page-height="{$page-height}{$page-unit}" margin-top="{$margin}{$page-unit}" margin-bottom="{$margin}{$page-unit}" margin-left="{$margin}{$page-unit}" margin-right="{$margin}{$page-unit}">
					<fo:region-body margin-top="{$header + 2}{$page-unit}" margin-bottom="{$footer + 2}{$page-unit}" region-name="body"/>
					<fo:region-before extent="{$header + 2}{$page-unit}" region-name="header"/>
					<fo:region-after extent="{$footer + 2}{$page-unit}" region-name="footer"/>
				</fo:simple-page-master>
			</fo:layout-master-set>

<!-- start layouting -->

			<fo:page-sequence master-reference="page-master" xsl:use-attribute-sets="text">

				<fo:static-content flow-name="header">
					
					<fo:table height="{$header}{$page-unit}">
						<fo:table-column column-width="{4 * $header}{$page-unit}"/>
						<fo:table-column />
						<fo:table-column column-width="{4 * $header}{$page-unit}"/>
						<fo:table-body>
							<fo:table-row height="{$header}{$page-unit}">
								<fo:table-cell>
									<fo:block>
										<!--fo:external-graphic src="{$appURL}pdf/citoyenparent.jpg" content-width="scale-to-fit" content-height="scale-to-fit" height="{$header}{$page-unit}"/-->
									</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<xsl:if test="$template/INFO/TITLE/text()">
										<fo:block xsl:use-attribute-sets="h1">
											<xsl:value-of select="$template/INFO/TITLE"/>
										</fo:block>
									</xsl:if>
									<xsl:if test="$template/INFO/HEADER/text()">
										<fo:block xsl:use-attribute-sets="h2">
											<xsl:value-of select="$template/INFO/HEADER"/>
										</fo:block>
									</xsl:if>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block xsl:use-attribute-sets="user">
										<xsl:choose>
											<xsl:when test="$user">
												<xsl:value-of select="$user/INFO/FIRSTNAME"/>
												<xsl:text> </xsl:text>
												<fo:inline font-weight="bold">
													<xsl:value-of select="$user/INFO/LASTNAME"/>
												</fo:inline>
											</xsl:when>
											<xsl:otherwise>
												<xsl:text>Anonymous User</xsl:text>
											</xsl:otherwise>
										</xsl:choose>
									</fo:block>
									<fo:block xsl:use-attribute-sets="user">
										<xsl:apply-templates select="$template/INFO/DATE" mode="date"/>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
				</fo:static-content>

				<fo:static-content flow-name="footer">
					<xsl:if test="$template/INFO/FOOTER/text()">
						<fo:block xsl:use-attribute-sets="h4">
							<xsl:value-of select="$template/INFO/FOOTER"/>
						</fo:block>
					</xsl:if>
					<fo:block xsl:use-attribute-sets="pagination">
						<xsl:text>Page </xsl:text>
						<fo:inline font-weight="bold">
							<fo:page-number/>
						</fo:inline>
						<xsl:text> / </xsl:text>
						<fo:page-number-citation ref-id="end-of-document" />
					</fo:block>
				</fo:static-content>

<!-- body -->

				<fo:flow flow-name="body">
					<fo:table font-size="9pt">

						<!--xsl:for-each select="$table-headers">
							<xsl:sort select="@order"/>
							<xsl:variable name="head" select="."/>
							<xsl:value-of select="$fields[INFO/DENOMINATION = name($head)]/INFO/DISPLAYLENGTH"/>
							<fo:table-column column-width="{ ($fields[INFO/DENOMINATION = name($head)]/INFO/DISPLAYLENGTH div $table-width) * $inner-width }{ $page-unit }"/>
						</xsl:for-each-->

                        <xsl:for-each select="$filter-display/RETURN/INFO/* | $filter-display/RETURN/DEPENDENCIES/DEPENDENCY">
                            <xsl:sort select=".//@order" order="ascending" data-type="number"/>
							<xsl:variable name="nname" select="name(.)"/>
                            <xsl:variable name="headWidth">
                                <xsl:choose>
                                    <xsl:when test="parent::INFO">
									
                                        <xsl:value-of select="$fields[INFO/DENOMINATION = $nname]/INFO/DISPLAYLENGTH"/>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:variable name="headWidth">
                                            <xsl:call-template name="head-sum">
                                                <xsl:with-param name="nod" select="./INFO/*[1]"/>
                                            </xsl:call-template>
                                        </xsl:variable>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </xsl:variable>
                            
                            <fo:table-column column-width="{ ($headWidth div $table-width) * $inner-width }{ $page-unit }"/>
                        </xsl:for-each>

						<fo:table-body>
								<fo:table-row xsl:use-attribute-sets="h3" background-color="#dedede">
									<xsl:call-template name="table-header"/>
								</fo:table-row>
								<xsl:for-each select="$data">
									<fo:table-row xsl:use-attribute-sets="data">
										<xsl:if test="position() mod 2 = 0">
											<xsl:attribute name="background-color">#efefef</xsl:attribute>
										</xsl:if>
										<xsl:apply-templates select="." mode="table-body"/>
									</fo:table-row>
								</xsl:for-each>
						</fo:table-body>
					</fo:table>

					<!-- for pagination purpose -->
					<fo:block id="end-of-document"/>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
		
	<xsl:template name="table-header">
            <xsl:for-each select="$filter-display/RETURN/INFO/* | $filter-display/RETURN/DEPENDENCIES/DEPENDENCY">
                <xsl:sort select=".//@order" order="ascending" data-type="number"/>
                <fo:table-cell padding-top="2mm" padding-bottom="2mm" padding-left="1mm" padding-right="1mm" border="solid 1pt #ffffff">
                    <fo:block>
                        <xsl:choose>
                            <!-- main module fields -->
                            <xsl:when test="parent::INFO">
                                <xsl:call-template name="get-module-field-name">
                                    <xsl:with-param name="moduleName" select="$search-module-denom"/>
                                    <xsl:with-param name="nodeName" select="name()"/>
                                </xsl:call-template>
                            </xsl:when>
                            <xsl:otherwise>
                                <!-- dependency module fields -->
                                <xsl:variable name="depType" select="./@type"/>
                                <xsl:value-of select="$search-config/DEPENDENCIES/DEPENDENCY[TYPE=$depType]/MODULEDESC"/>
                            </xsl:otherwise>
                        </xsl:choose>
                    </fo:block>
                </fo:table-cell>
            </xsl:for-each>
	</xsl:template>

	<xsl:template match="*" mode="table-body">
		<xsl:variable name="currentData" select="."/>
            <xsl:for-each select="$filter-display/RETURN/INFO/* | $filter-display/RETURN/DEPENDENCIES/DEPENDENCY">
                <xsl:sort select=".//@order" order="ascending" data-type="number"/>
                <xsl:choose>
                    <!-- main module fields -->
                    <xsl:when test="parent::INFO">
                        <fo:table-cell padding-top="1mm" padding-bottom="1mm" padding-left="1mm" padding-right="1mm" border="solid 1pt #ffffff">
                            <fo:block>
                                <xsl:call-template name="get-module-field-value">
                                    <xsl:with-param name="moduleName" select="$search-module-denom"/>
                                    <xsl:with-param name="node" select="$currentData/INFO/*[name()=name(current())]"/>
                                </xsl:call-template>
                            </fo:block>
                        </fo:table-cell>
                    </xsl:when>
                    <xsl:otherwise>
                        <!-- dependency module fields -->
                        <xsl:variable name="dep" select="."/>
                        <xsl:variable name="depType" select="./@type"/>
                        <xsl:variable name="depConfig" select="$search-config/DEPENDENCIES/DEPENDENCY[TYPE=$depType]"/>
                        <xsl:variable name="targetModuleDenom" select="translate($depConfig/MODULE, 'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxyz')"/>

                        <fo:table-cell padding-top="1mm" padding-bottom="1mm" padding-left="1mm" padding-right="1mm" border="solid 1pt #ffffff">
                            <fo:block>
                                <xsl:for-each select="$currentData/DEPENDENCIES/DEPENDENCY[@type=$depType]/*">
                                    <xsl:variable name="currentElemTarget" select="."/>
                                    <fo:block>
                                        <xsl:for-each select="$dep/INFO/*">
                                            <xsl:sort select="@order" order="ascending" data-type="number"/>
                                            <xsl:call-template name="get-module-field-value">
                                                <xsl:with-param name="moduleName" select="$targetModuleDenom"/>
                                                <xsl:with-param name="node" select="$currentElemTarget/INFO/*[name()=name(current())]"/>
                                            </xsl:call-template>
                                            <xsl:if test="position()!=last()">,&#160;</xsl:if>
                                        </xsl:for-each>
                                    </fo:block>
                                </xsl:for-each>
                            </fo:block>
                        </fo:table-cell>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:for-each>
	</xsl:template>
	
	<xsl:template name="scale-size">
		<xsl:param name="size"/>
		<xsl:value-of select="$size * $scale div 100"/>
		<xsl:text>pt</xsl:text>
	</xsl:template>

	<!-- styles -->
	<xsl:attribute-set name="text">
		<xsl:attribute name="font-family">Helvetica,Arial,sans-serif</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="h1">
		<xsl:attribute name="font-size">
			<xsl:call-template name="scale-size">
				<xsl:with-param name="size" select="13"/>
			</xsl:call-template>
		</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="text-align">center</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="h2">
		<xsl:attribute name="text-align">center</xsl:attribute>
		<xsl:attribute name="font-size">
			<xsl:call-template name="scale-size">
				<xsl:with-param name="size" select="10"/>
			</xsl:call-template>
		</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="h3">
		<xsl:attribute name="font-size">
			<xsl:call-template name="scale-size">
				<xsl:with-param name="size" select="10"/>
			</xsl:call-template>
		</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="h4">
		<xsl:attribute name="text-align">center</xsl:attribute>
		<xsl:attribute name="space-before">3mm</xsl:attribute>
		<xsl:attribute name="font-size">
			<xsl:call-template name="scale-size">
				<xsl:with-param name="size" select="9"/>
			</xsl:call-template>
		</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="data">
		<xsl:attribute name="font-size">
			<xsl:call-template name="scale-size">
				<xsl:with-param name="size" select="10"/>
			</xsl:call-template>
		</xsl:attribute>
		<xsl:attribute name="line-height">
			<xsl:call-template name="scale-size">
				<xsl:with-param name="size" select="15"/>
			</xsl:call-template>
		</xsl:attribute>
		<xsl:attribute name="space-after">2mm</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="pagination">
		<xsl:attribute name="text-align">center</xsl:attribute>
		<xsl:attribute name="space-before">3mm</xsl:attribute>
		<xsl:attribute name="font-size">
			<xsl:call-template name="scale-size">
				<xsl:with-param name="size" select="9"/>
			</xsl:call-template>
		</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="user">
		<xsl:attribute name="text-align">right</xsl:attribute>
		<xsl:attribute name="space-after">1.5mm</xsl:attribute>
		<xsl:attribute name="font-size">
			<xsl:call-template name="scale-size">
				<xsl:with-param name="size" select="9"/>
			</xsl:call-template>
		</xsl:attribute>
	</xsl:attribute-set>

</xsl:stylesheet>