<?xml version="1.0"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/system/tools/security/include.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
    <xsl:import href="../../system.include.xsl"/>
    <xsl:import href="functions.xsl"/>
    
	<!-- "select all" actions -->
    <xsl:template name="staticitem-selectall">
		<xsl:param name="id" select="'id'" />
		<xsl:param name="title"/>
        <xsl:param name="cssclass" select="'grey-bkgnd'"/>
		<xsl:param name="editor" select="/RESPONSE/URL/editor" />
		<xsl:param name="app" select="/RESPONSE/URL/app" />
		<xsl:param name="module" select="/RESPONSE/URL/module" />
		<xsl:param name="displayRemoveOption" select="true()" />
		<xsl:param name="applyToWho" />
		<xsl:param name="element" />

		<div id="{$id}" class="items {$cssclass}">
			<div class="icon">
		        <input type="checkbox" class="input-checkbox" name="check-selectall" id="check-selectall">
		        	<xsl:attribute name="onclick">
		        		if ($(this).is(':checked'))
		        		{
		        			$('#<xsl:value-of select="$panelID" />.panel').find('.block-nav :checkbox').attr('checked','checked');
		        		}
		        		else
		        		{
		        			$('#<xsl:value-of select="$panelID" />.panel').find('.block-nav :checkbox').removeAttr('checked');
		        		}		        		
		        	</xsl:attribute>
		        </input>
			</div>
			<div class="label" style="width:30%;">
				<a class="normal-link" href="#">
		        	<xsl:attribute name="onclick">
		        		var checkAllElem = $('#<xsl:value-of select="$panelID" />.panel').find('#check-selectall');
		        		if (checkAllElem.is(':checked'))
		        		{
		        			$('#<xsl:value-of select="$panelID" />.panel').find('.block-nav :checkbox').removeAttr('checked');
		        			checkAllElem.removeAttr('checked');
		        		}
		        		else
		        		{
		        			$('#<xsl:value-of select="$panelID" />.panel').find('.block-nav :checkbox').attr('checked','checked');		
		        			checkAllElem.attr('checked','checked');    			
		        		}		        		
		        	</xsl:attribute>
					<xsl:copy-of select="$title"/>
				</a>
			</div>
			<div class="info" style="width:60%; right:3px;">
				<xsl:text>With selected:&#160;</xsl:text>
                <select id="permissions-all" name="permissions-all" class="input-select" style="width:auto;">
                	<xsl:attribute name="onchange">
                		$('#<xsl:value-of select="$panelID"/>.panel').trigger('apply-all-permissions', [this, '<xsl:value-of select="$applyToWho" />', '<xsl:value-of select="name($element)" />', <xsl:value-of select="$element/@ID" />]);
                	</xsl:attribute>
                    <option value="">(Choose an option)</option>
                    
                    <xsl:choose>
                    	<xsl:when test="$displayRemoveOption=true()">
		                    <xsl:for-each select="/RESPONSE/RESULTS/LIST[@name='PermissionsAssignations']/*">
		                        <xsl:sort select="@label" />
		                        <option value="{@value}">
				                    <xsl:value-of select="@label"/>
		                        </option>
		                    </xsl:for-each>		                    
						</xsl:when>
						<xsl:otherwise>
		                    <xsl:for-each select="/RESPONSE/RESULTS/LIST[@name='PermissionsAssignations']/*[@value!='remove']">
		                        <xsl:sort select="@label" />
		                        <option value="{@value}">
				                    <xsl:value-of select="@label"/>
		                        </option>
		                    </xsl:for-each>
		                </xsl:otherwise>
	                </xsl:choose>
                </select>
			</div>
		</div>
	</xsl:template>
	
	<xsl:template name="security-actions-js">
		$('#<xsl:value-of select="$panelID"/>.panel').bind('apply-single-permission', function(eventObject, selectElem, targetsName, targetModule, targetID){
			if ($(selectElem).val() == '') return;							
  			
  			$(selectElem).hide();
  			$(selectElem).closest('.info').find('.actions-label').html('');
  			$(selectElem).closest('.info').find('.ajax-loader-nav').show();

			var ajaxRequest = new AjaxRequest(
				<xsl:value-of select="/RESPONSE/URL/panelID" />,
				AppController,
				'<xsl:apply-templates select="$item" mode="element-script-assign-security"/>',
				'POST'
			);

			var newSetting = $(selectElem).val();
			ajaxRequest.setData({
				type : targetsName,
				targetIDs : [$(selectElem).closest('.items').find(':checkbox').val()],
				newSetting : newSetting,
				ID : targetID,
				module : targetModule
			});

			// no error dialog and return errors in short msgs format
			ajaxRequest.errorDialog(false, true);
			ajaxRequest.internalErrorDialog(false, true);			
			
			ajaxRequest.onSuccess(delegate(this, function(response){
				if (newSetting == 'remove')
				{
					var remainingCheckedItems = $('#<xsl:value-of select="$panelID" />.panel').find('.block-nav :checkbox:not(#check-selectall)');	
				
					$(selectElem).closest('.items').fadeOut(200, function(){ 
						$(this).remove();
					});
														
					if (remainingCheckedItems.length == 1)
					{
						$('#<xsl:value-of select="$panelID" />.panel').find('#check-selectall').closest('.items').fadeOut(200, function(){ 
							$(this).remove();
						});
					}
				}
				else
				{
					$(selectElem).closest('.info').find('.ajax-loader-nav').hide();
					quickSearcher<xsl:value-of select="$panelID" />.refresh();
				}
			})).onError(delegate(this, function(response){
				$(selectElem).closest('.info').find('.ajax-loader-nav').hide();
				$(selectElem).closest('.info').find('.actions-label').html(response.message);
			})).send();
		}).bind('apply-all-permissions', function(eventObject, selectElem, targetsName, targetModule, targetID){
			if ($(selectElem).val() == '') return;			

			var checkedItems = $('#<xsl:value-of select="$panelID" />.panel').find('.block-nav :checked:not(#check-selectall)');
			if (checkedItems.length == 0)
			{
				$(selectElem).val('');
				return;
			}
				
			var ajaxRequest = new AjaxRequest(
				<xsl:value-of select="/RESPONSE/URL/panelID" />,
				AppController,
				'<xsl:apply-templates select="$item" mode="element-script-assign-security"/>',
				'POST'
			);
			
	 		var IDs = [];
	  		checkedItems.each(function(){
	 			IDs.push($(this).val());
				//$(this).removeAttr('checked');
			});
			
			var newSetting = $(selectElem).val();
			
			ajaxRequest.setData({
				type : targetsName,
				targetIDs : IDs,
				newSetting : newSetting,
				ID : targetID,
				module : targetModule
			});
			
			$(selectElem).val('');

			// display error dialog and return errors in long msgs format
			ajaxRequest.errorDialog(true, false);
			ajaxRequest.internalErrorDialog(true, false);	 
			
			$(this).trigger('panel-displayloader', [true, 'body']);	   
			
			ajaxRequest.onSuccess(delegate(this, function(response){			
			   if (newSetting == 'remove')
				{
					checkedItems.closest('.items').remove();
					
					var selectAllElem = $('#<xsl:value-of select="$panelID" />.panel').find('#check-selectall');
					selectAllElem.removeAttr('checked');
					
					var remainingCheckedItems = $('#<xsl:value-of select="$panelID" />.panel').find('.block-nav :checkbox:not(#check-selectall)');					
					if (remainingCheckedItems.length == 0)
					{
						selectAllElem.closest('.items').remove();
					}

					$(this).trigger('panel-displayloader', [false, 'body']);					
				}
				else
				{
					quickSearcher<xsl:value-of select="$panelID" />.refresh();
		   		}
			})).onError(delegate(this, function(response){
				$(this).trigger('panel-displayloader', [false, 'body']); 
			})).send();
		});
	</xsl:template>	
</xsl:stylesheet>