<?xml version="1.0"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/system/tools/xsl/flattener.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
	<xsl:output encoding="utf-8" method="xml" indent="yes"/>
	
<!-- 

1. déclarer stylesheet avec en attribut tous les namespaces des imports/includes
2. parser les includes/imports et les intégrer
3. par feuille, copier le contenu  SANS les nœuds includes/imports

 -->
	<xsl:strip-space elements="*"/>

	<xsl:template match="/xsl:stylesheet">
		<xsl:element name="xsl:stylesheet">
			<xsl:copy-of select="./namespace::*"/>
			<xsl:copy-of select="./attribute::*"/>
			<xsl:apply-templates select="xsl:import|xsl:include" mode="flatten-attributes"/>
			<xsl:apply-templates select="*" mode="flatten-stylesheets"/>
		</xsl:element>
    </xsl:template>

	<xsl:template match="xsl:import|xsl:include" mode="flatten-attributes">
		<xsl:variable name="path" select="@href"/>
		<xsl:variable name="stylesheet" select="document($path)/xsl:stylesheet"/>
		<xsl:copy-of select="$stylesheet/namespace::*"/>
		<xsl:copy-of select="$stylesheet/attribute::*"/>
		<xsl:apply-templates select="$stylesheet/xsl:import|xsl:include" mode="flatten-attributes"/>
    </xsl:template>

	<xsl:template match="xsl:import|xsl:include" mode="flatten-stylesheets">
		<xsl:variable name="path" select="@href"/>
		<xsl:variable name="stylesheet" select="document($path)/xsl:stylesheet"/>
		<xsl:apply-templates select="$stylesheet/xsl:import|xsl:include" mode="flatten-stylesheets"/>
		<xsl:copy-of select="$stylesheet/*[name() != 'xsl:import' and name() != 'xsl:include']" />
    </xsl:template>

	<xsl:template match="*" mode="flatten-stylesheets">
		<xsl:element name="{local-name()}">
        	<xsl:copy-of select="./attribute::*"/>
			<xsl:apply-templates/>
      	</xsl:element>
	</xsl:template>
</xsl:stylesheet>