<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee-source/sushee/Library/updates/20090312-stats-v4/resources/request_function.inc.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
require_once(dirname(__FILE__)."/../common/common_functions.inc.php");

function request($stringofXML,$no_response_node = false,$supp_params = false,$include_navigation=false,$forced_language=false,$restrict_language=false,$priority_language=false,$php_request=false,$public=false){
	$GLOBALS["restrict_language"] = $restrict_language;
	$GLOBALS["dev_request"] = $public;
	$GLOBALS["php_request"] = $php_request;
	$GLOBALS["priority_language"] = $priority_language;
	
	if(isset($_GET['language']) && $_GET['language']!='' && $_GET['language']!=$GLOBALS["NectilLanguage"]){
		$GLOBALS["NectilLanguage"] = $_SESSION[$GLOBALS["nectil_url"]]["language"] = $_GET['language'];
	}
	
	if($GLOBALS['php_request']!==true)
		set_time_limit(300);
	$lifeTimes = $GLOBALS['cache_Lifetimes'];

	$perm = 'a+';
	if(file_exists($GLOBALS["nectil_dir"]."/Files/log.txt") && filesize($GLOBALS["nectil_dir"]."/Files/log.txt")>1048576)
		$perm = 'w+';
	if ( (file_exists($GLOBALS["nectil_dir"]."/Files/log.txt") && is_writable($GLOBALS["nectil_dir"]."/Files/log.txt")) || (!file_exists($GLOBALS["nectil_dir"]."/Files/log.txt") && is_writable($GLOBALS["nectil_dir"]."/Files/")) ){
		$file = fopen($GLOBALS["nectil_dir"]."/Files/log.txt", $perm); // binary update mode
		fwrite($file, "\n---------------------------------------------------\n".$stringofXML);
		fclose($file);
	}
	$stringofXML=trim($stringofXML);

	//special patch used for the "SAFARI" bug
	if( $stringOfXML!="" && substr($stringofXML,-1) != ">" ){
	    $stringofXML.=">";
	}
	
	// building a tree with the xmlString
	$xml = new XML($stringofXML);
	//debug_log("tree from request built");
	if (!$xml->loaded)
		$strResponse="<MESSAGE msgType='1'>Invalid XML Message</MESSAGE>";

	if ($xml->loaded ){
		// checking the request is "signed" -> must have a userID
		//$xml->setCaseFolding(true);
		if ( isset($_SESSION[$GLOBALS['nectil_url']]['SESSIONuserID']) ){
			$private_request = TRUE;
		}else
			$private_request = FALSE;
		if($forced_language===false)
			$forced_language = $xml->getAttributes('/QUERY[1]','languageID');
		if($forced_language){
			$save_language = $GLOBALS["NectilLanguage"];
			$save_restrict = $GLOBALS['restrict_language'];
			$GLOBALS['restrict_language'] = true;
			$GLOBALS["NectilLanguage"] = $forced_language;
		}
		// query given through the php function "query"
		if($supp_params===true){
			if(sizeof($_GET)>0){
				$strResponse.='<URL>';
				foreach($_GET as $param_name=>$param_value){
					$param_name = str_replace(array(',',';','/',':'),'',$param_name);
					if(is_numeric(substr($param_name,0,1)))
						$param_name = '_'.$param_name;
					$strResponse.='<'.$param_name.'>'.encode_to_XML(utf8_decode(utf8_To_UnicodeEntities(stripcslashes($param_value)))).'</'.$param_name.'>';
				}
				$strResponse.='</URL>';
			}
			$strResponse.='<NECTIL>';
			$nectil_vars = array('language'=>$GLOBALS["NectilLanguage"],'this_script'=>basename($_SERVER['SCRIPT_NAME']));
			if($GLOBALS['resident_name'])
				$nectil_vars['resident_name']=$GLOBALS['resident_name'];
			if($GLOBALS['no_variable_nectil_vars']!==true){
				//$nectil_vars['random_number']=rand();
				if (isset($_SESSION[$GLOBALS["nectil_url"]]['SESSIONuserID']))
				$nectil_vars['logged']='true';
				else
				$nectil_vars['logged']='false';
			}
			$nectil_vars['nectil_url']=$GLOBALS["nectil_url"];
			$nectil_vars['files_url']=$GLOBALS["files_url"];
			$nectil_vars['public_url']=$GLOBALS["Public_url"];
			$nectil_vars['kernel_url']=$GLOBALS["backoffice_url"];
			$nectil_vars['host']="http://".$_SERVER['HTTP_HOST'];
		
			if(isset($GLOBALS['original_url']))
				$nectil_vars['original_url']=$GLOBALS['original_url'];
			$nectil_vars['this_url']=$_SERVER['REQUEST_URI'];
			$nectil_vars["language_url"]=$nectil_vars["this_url"];
			$nectil_vars["language_url"]=str_replace(array("cache=false&","cache=false"),"",$nectil_vars["language_url"]);
			$nectil_vars["language_url"]=preg_replace ( '/&language=.[^&]*/i', '', $nectil_vars["language_url"]);
			$nectil_vars["language_url"]=preg_replace ( '/\?language=.[^&]*$/i', '?', $nectil_vars["language_url"]);
			$nectil_vars["language_url"]=preg_replace ( '/\?language=.[^&]*&/i', '?', $nectil_vars["language_url"]);
			if (strpos($nectil_vars["language_url"],'?')===FALSE)
			$nectil_vars["language_url"]=$nectil_vars["language_url"].'?';
			else if(substr($nectil_vars["language_url"],-1)!='&' && substr($nectil_vars["language_url"],-1)!='?')
			$nectil_vars["language_url"]=$nectil_vars["language_url"].'&';
		
			foreach($nectil_vars as $param_name=>$param_value)
				$strResponse.='<'.$param_name.'>'.encode_to_XML($param_value).'</'.$param_name.'>';
			$strResponse.='</NECTIL>';
		}
		if ($GLOBALS['php_request']===true){
			$public_request = TRUE;
			// including the params in the url
			if($include_navigation){
				// now including the navigation
				$navigation_file = getcwd().'/navigation.php';
				if (!file_exists($navigation_file))
					$navigation_file = getcwd().'/navigation.xml';
				else{
					$navigation_file = include($navigation_file);
					$included_nav=true;
				}
				if ( file_exists($navigation_file) || $included_nav){
					$navigation_xml = new XML($navigation_file);
					if($navigation_xml->loaded){
						$sub_queries_array = $navigation_xml->match('/QUERY/*');
						$navigation_xml->setAttribute('/QUERY/*', 'fromFile', 'navigation.xml');
						if (!$xml->match('/QUERY/*[1]')){
							foreach($sub_queries_array as $path){
								$xml->appendChild('/QUERY',$navigation_xml->toString($path),FALSE,FALSE);
							}
							$xml->reindexNodeTree();
						}else{
							for($i=sizeof($sub_queries_array);$i>=0;$i--){
								$path = $sub_queries_array[$i];
								$xml->insertBefore('/QUERY/*[1]',$navigation_xml->toString($path),TRUE,FALSE);
							}
							$xml->reindexNodeTree();
						}

					}
				}
			}
			
		
		}else
			$public_request = FALSE;
		
		$db_conn = db_connect();
		// get all queries
		$queries_array = $xml->match("/QUERY[1]/*");
	
		$cache_dir = $GLOBALS["nectil_dir"].'/Files/cache/';
	
		foreach($queries_array as $current_path){
			$static = $xml->getAttributes($current_path,'static');
			if($static==='true'){
				$query_result = $xml->toString($current_path,'',false);
				$query_result = str_replace(array("\r\n","\r","\n"),'',$query_result);
			}else{
			$refresh = $xml->getAttributes($current_path,'refresh');
			$name = $xml->getData($current_path.'/@name');
		
			$firstNode = strtoupper($xml->nodeName($current_path.'/*[1]'));
			
			$query_result ="";
			$cached = false;
			$must_get_cached = false;
			$must_get_respawn = false;
			
			if ($refresh!==FALSE && $refresh!=='live' && $_GET['cache']!=='false' && array_key_exists($refresh,$lifeTimes)){
				$respawn = $xml->getAttributes($current_path,'auto-refresh');
				if($respawn==='true')
					$must_get_respawn = true;
				$lifeTime = $lifeTimes[$refresh][0];
				$options = array('cacheDir' => $cache_dir,'lifeTime' => $lifeTime );
				
				include_once(dirname(__FILE__)."/../common/Cache/Lite.php");
				$Cache_Lite = new Cache_Lite($options);
				$xml->removeAttribute($current_path, 'refresh');
				$xml->removeAttribute($current_path, 'auto-refresh');
				$stringofSubquery = $xml->toString($current_path);
				$id = generateID(array($stringofSubquery,$restrict_language,$public,$GLOBALS["NectilLanguage"],$GLOBALS["priority_language"]));
				$cache_section = 'subquery';
				if($firstNode=='TRADUCTION')
					$cache_section = 'os_trads';
				if ($_GET['cache']!=='refresh' && ($data = $Cache_Lite->get($id,$cache_section)) ) {
					$query_result=$data;
					$cached = true;
				}else
					$must_get_cached = true;
			}
			if (!$cached || $firstNode=='TRADUCTION'){
				$requestName = strtoupper($xml->nodeName($current_path));
				$firstNodePath = $current_path.'/*[1]';
				$requestElementID=$xml->getData($firstNodePath.'/@ID');
				$mustconfirm=$xml->getData($current_path.'/@confirm');
				// we save the number of queries at that moment
				$nb_queries= $GLOBALS["EXECS"];
				$beginRequestTime = getTimer();
			
				if ( 
					$mustconfirm===false 
					&& 
					(		$requestName=='CONNECT' || $public_request || $private_request 
							|| 
							( 
								($requestName=="GET" || $requestName=="SEARCH") 
								&&  
								($firstNode=="DESCRIPTIONCONFIG" || $firstNode=="LANGUAGES" || $firstNode=="COMMENTSCONFIG" || $firstNode=="TRADUCTION" || $firstNode=="COUNTRIES" || $firstNode=="MONTHS" || $firstNode=="DAYS" || $firstNode=="CATEGORIES" || $firstNode=='LABELS' || $firstNode=='LIST')
							 ) 
							|| 
							($requestName=="CREATE" && $firstNode=="RESIDENT-LICENSE")
							||
							($requestName=="SEARCH" && $firstNode=="NECTIL:PUBLISHER")
					) 
					){
					if($requestName=='SEARCH' || $requestName=='GET' || $requestName=='GETCHILDREN' || $requestName=='GETPARENT' || $requestName=='GETANCESTOR' || $requestName=='COUNT'){
						switch($firstNode){
							case 'MEDIA':
								include_once dirname(__FILE__)."/../private/search.inc.php";
								$query_result = search($name,$xml,$requestName,$current_path,$firstNode,$firstNodePath);
								break;
							case 'DEPENDENCY_TYPES':
							case 'DEPENDENCYENTITY':
								include_once dirname(__FILE__)."/../private/searchDeptype.inc.php";
								$nqlOp = new searchDeptype($name,new XMLNode($xml,$current_path));
								$query_result = $nqlOp->execute();
								break;
							case 'MEDIATYPE':
							case 'MEDIATYPES': 
								include_once dirname(__FILE__)."/../private/searchMediatype.inc.php";
								$query_result = searchMediatype($name,$xml,$requestName,$current_path,$firstNode,$firstNodePath);
								break;
							case 'CONNECTED':
								include_once dirname(__FILE__)."/../private/searchConnected.inc.php";
								$query_result = searchConnected($name,$xml,$requestName,$current_path,$firstNode,$firstNodePath);
								break;
							case 'LANGUAGES': 
								include_once dirname(__FILE__)."/../private/languages.inc.php";
								$query_result = searchLanguages($name,$xml,$requestName,$current_path,$firstNode,$firstNodePath);
								break;
							case 'COUNTRY':
							case 'COUNTRIES': 
								include_once dirname(__FILE__)."/../private/countries.inc.php";
								$nqlOp = new searchCountries($name,new XMLNode($xml,$current_path));
								$query_result = $nqlOp->execute();
								break;
							case 'TRADUCTION': 
								/*include_once dirname(__FILE__)."/../private/labels.inc.php";
								$query_result = searchTraductions($name,$xml,$requestName,$current_path,$firstNode,$firstNodePath);*/
								include_once dirname(__FILE__)."/../private/searchTraductions.inc.php";
								$nqlOp = new searchTraductions($name,new XMLNode($xml,$current_path));
								$query_result = $nqlOp->execute();
								break;
							case 'MAILING_GROUP': 
								include_once dirname(__FILE__)."/../private/mailing.inc.php";
								$query_result = searchMailingGroup($name,$xml,$requestName,$current_path,$firstNode,$firstNodePath);
								break;
							case 'APPLICATION': 
								include_once dirname(__FILE__)."/../private/application.inc.php";
								$query_result = searchApplication($name,$xml,$requestName,$current_path,$firstNode,$firstNodePath);
								break;
							case 'CALENDAR':
								include_once dirname(__FILE__)."/../private/searchCalendar.inc.php";
								$nqlOp = new searchCalendar($name,new XMLNode($xml,$current_path));
								$query_result = $nqlOp->execute();
								break;
							case 'CATEGORIES': 
								include_once dirname(__FILE__)."/../private/searchCategories.inc.php";
								$nqlOp = new searchCategories($name,new XMLNode($xml,$current_path));
								$query_result = $nqlOp->execute();
								break;
							case 'CATEGORY': 
								include_once dirname(__FILE__)."/../private/searchCategory.inc.php";
								$nqlOp = new searchCategory($name,new XMLNode($xml,$current_path));
								$query_result = $nqlOp->execute();
								break;
							case 'COMMENTSCONFIG': 
								include_once dirname(__FILE__)."/../private/searchCommentsConfig.inc.php";
								$query_result = searchCommentsConfig($name,$xml,$requestName,$current_path,$firstNode,$firstNodePath);
								break;
							case 'DESCRIPTIONCONFIG': 
								include_once dirname(__FILE__)."/../private/searchDescConfig.inc.php";
								$nqlOp = new searchDescriptionConfig($name,new XMLNode($xml,$current_path));
								$query_result = $nqlOp->execute();
								break;
							case 'DESCRIPTION':
								include_once dirname(__FILE__)."/../private/searchDescription.inc.php";
								$nqlOp = new searchDescription($name,new XMLNode($xml,$current_path));
								$query_result = $nqlOp->execute();
								break;
							case 'ENUM':
								include_once dirname(__FILE__)."/../private/getenum.inc.php";
								$nqlOp = new getEnum($name,new XMLNode($xml,$current_path));
								$query_result = $nqlOp->execute();
								break;
							case 'IMAGE':
								include_once dirname(__FILE__)."/../private/getimage.inc.php";
								$nqlOp = new getImage($name,new XMLNode($xml,$current_path));
								$query_result = $nqlOp->execute();
								break;
							case 'PROPERTIESCONFIG': 
								include_once dirname(__FILE__)."/../private/searchPropertiesConfig.inc.php";
								$query_result = searchPropertiesConfig($name,$xml,$requestName,$current_path,$firstNode,$firstNodePath);
								break;
							case 'LABEL':
							case 'LABELS': 
								include_once dirname(__FILE__)."/../private/searchLabels.inc.php";
								$query_result = searchLabels($name,$xml,$requestName,$current_path,$firstNode,$firstNodePath);
								break;
							case 'STATS': 
								include_once dirname(__FILE__)."/../private/searchStatsV4.class.php";
								$nqlOp = new searchStats($name,new XMLNode($xml,$current_path));
								$query_result = $nqlOp->execute();
								break;
							case 'FIRSTWEBLOG':
								include_once dirname(__FILE__)."/../private/searchWeblogs.inc.php";
								$query_result = getFirstWeblog($name,$xml,$requestName,$current_path,$firstNode,$firstNodePath);
								break;
							case 'MAILING_RECIPIENTS':
								include_once dirname(__FILE__)."/../private/searchMailingRecipients.inc.php";
								$query_result = searchMailingRecipients($name,$xml,$requestName,$current_path,$firstNode,$firstNodePath);
								break;
							case 'MONTHS':
							case 'MONTH': 
								include_once dirname(__FILE__)."/../private/getmonths.inc.php";
								$nqlOp = new getMonths($name,new XMLNode($xml,$current_path));
								$query_result = $nqlOp->execute();
								break;
							case 'DAYS':
							case 'DAY':
							case 'WEEKDAY':
								include_once dirname(__FILE__)."/../private/getdays.inc.php";
								$nqlOp = new getDays($name,new XMLNode($xml,$current_path));
								$query_result = $nqlOp->execute();
								break;
							case 'LISTS':
							case 'LIST':
								include_once dirname(__FILE__)."/../private/searchLists.inc.php";
								$nqlOp = new searchLists($name,new XMLNode($xml,$current_path));
								$query_result = $nqlOp->execute();
								break;
							case 'PREFS':
								include_once dirname(__FILE__)."/../private/searchPrefs.inc.php";
								$query_result = searchPrefs($name,$xml,$requestName,$current_path,$firstNode,$firstNodePath);
								break;
							case 'WEBSERVICE':
								include_once dirname(__FILE__)."/../private/searchWebservice.inc.php";
								$nqlOp = new searchWebservice($name,new XMLNode($xml,$current_path));
								$query_result = $nqlOp->execute();
								break;
							case 'MODULES':
							case 'MODULE':
								include_once dirname(__FILE__)."/../private/searchModule.inc.php";
								$nqlOp = new searchModule($name,new XMLNode($xml,$current_path));
								$query_result = $nqlOp->execute();
								break;
							case 'APPLICATIONS':
							case 'APPLICATION':
									include_once dirname(__FILE__)."/../private/searchApplication.inc.php";
									$nqlOp = new searchApplication($name,new XMLNode($xml,$current_path));
									$query_result = $nqlOp->execute();
									break;
							default:
								include_once dirname(__FILE__)."/../private/search.inc.php";
								$query_result = search($name,$xml,$requestName,$current_path,$firstNode,$firstNodePath);
						}
					}else if($requestName=='GETDESCENDANT'){
						include_once dirname(__FILE__)."/../private/getdescendant.inc.php";
						$query_result = getdescendant($name,$xml,$requestName,$current_path,$firstNode,$firstNodePath);
					}else if($requestName=='SKELETON'){
						include_once dirname(__FILE__)."/../private/skeleton.inc.php";
						$query_result = skeleton($name,$xml,$requestName,$current_path,$firstNode,$firstNodePath);
					}else if($requestName=="FEEDBACK"){
						include_once dirname(__FILE__)."/../private/feedback.inc.php";
						$query_result = createFeedback($name,$xml,$requestName,$current_path,$firstNode,$firstNodePath);
					}else if($requestName=="CREATE"){
						if ($firstNode=="DEPENDENCYENTITY" && !$public_request){
							include_once dirname(__FILE__)."/../private/createDeptype.inc.php";
							$nqlOp = new createDeptype($name,new XMLNode($xml,$current_path));
							$query_result = $nqlOp->execute();
						}else if ($firstNode=="CATEGORY"){
							include_once dirname(__FILE__)."/../private/createCategory.inc.php";
							$query_result = createCategory($name,$xml,$requestName,$current_path,$firstNode,$firstNodePath);
						}else if ($firstNode=="COMMENT"){
							include_once dirname(__FILE__)."/../private/comments.nql.php";
							$nqlOp = new createComment($name,new XMLNode($xml,$current_path));
							$query_result = $nqlOp->execute();
						}else if ($firstNode=="SOUND_ART" && $xml->getData($firstNodePath.'/@source')!==FALSE){
							include_once dirname(__FILE__)."/../private/createAutoSoundArt.inc.php";
							$query_result = createAutoSoundArt($name,$xml,$requestName,$current_path,$firstNode,$firstNodePath);
						}else if ($firstNode=="CONTACT" && $xml->getData($firstNodePath.'/@source')!==FALSE){
							include_once dirname(__FILE__)."/../private/import_vcard.inc.php";
							$query_result = importVCard($name,$xml,$requestName,$current_path,$firstNode,$firstNodePath);
						}else if ($firstNode=="SERVERMAIL"){
							include_once dirname(__FILE__)."/../private/createMail.inc.php";
							$nqlOp = new createServerMail($name,new XMLNode($xml,$current_path));
							$query_result = $nqlOp->execute();
						}else if ($firstNode=="PDF"){
							include_once dirname(__FILE__)."/../private/createPDF.inc.php";
							$query_result = createPDF($name,$xml,$requestName,$current_path,$firstNode,$firstNodePath);
						}else if ($firstNode=="ARCHIVE"){
							include_once dirname(__FILE__)."/../private/createArchive.inc.php";
							//$query_result = createArchive($name,$xml,$requestName,$current_path,$firstNode,$firstNodePath);
							$nqlOp = new createArchive($name,new XMLNode($xml,$current_path));
							$query_result = $nqlOp->execute();
						}else if ($firstNode=="XLIFF"){
							include_once dirname(__FILE__)."/../private/createXLIFF.inc.php";
							$query_result = createXLIFF($name,$xml,$requestName,$current_path,$firstNode,$firstNodePath);
						}else if ($firstNode=="LABEL"){
							include_once dirname(__FILE__)."/../private/updateLabels.inc.php";
							$query_result = updateLabels($name,$xml,$requestName,$current_path,$firstNode,$firstNodePath);
						}else if ($firstNode=="CSV"){
							include_once dirname(__FILE__)."/../private/createCSV.inc.php";
							$nqlOp = new createCSV($name,new XMLNode($xml,$current_path));
							$query_result = $nqlOp->execute();
						}else if($firstNode=='CAPTCHA'){
							include_once dirname(__FILE__)."/../private/createCaptcha.inc.php";
							$nqlOp = new createCaptcha($name,new XMLNode($xml,$current_path));
							$query_result = $nqlOp->execute();
						}else if($firstNode=='RESIDENT-LICENSE'){
							include_once dirname(__FILE__)."/../private/createResidentLicense.inc.php";
							$nqlOp = new createResidentLicense($name,new XMLNode($xml,$current_path));
							$query_result = $nqlOp->execute();
						}else if($firstNode=='VCALENDAR'){
							include_once dirname(__FILE__)."/../private/createVCal.inc.php";
							$nqlOp = new createVCal($name,new XMLNode($xml,$current_path));
							$query_result = $nqlOp->execute();
						}else if($firstNode=='MODULE'){
							include_once dirname(__FILE__)."/../private/createModule.inc.php";
							$nqlOp = new createModule($name,new XMLNode($xml,$current_path));
							$query_result = $nqlOp->execute();
						}else if($firstNode=='APPLICATION'){
							include_once dirname(__FILE__)."/../private/createApplication.inc.php";
							$nqlOp = new createApplication($name,new XMLNode($xml,$current_path));
							$query_result = $nqlOp->execute();
						}else{
							include_once dirname(__FILE__)."/../private/create.nql.php";
							$nqlOp = new createElement($name,new XMLNode($xml,$current_path));
							$query_result = $nqlOp->execute();
						}
					}else if($requestName=="DELETE"){
						if ($firstNode=="DEPENDENCYENTITY" && !$public_request){
							include_once dirname(__FILE__)."/../private/deleteDeptype.inc.php";
							$query_result = deleteDeptype($name,$xml,$requestName,$current_path,$firstNode,$firstNodePath);
						}else if ($firstNode=="CATEGORY"){
							include_once dirname(__FILE__)."/../private/deleteCategory.inc.php";
							$query_result = deleteCategory($name,$xml,$requestName,$current_path,$firstNode,$firstNodePath);
						}else if ($firstNode=="COMMENT"){
							include_once dirname(__FILE__)."/../private/comments.nql.php";
							$nqlOp = new deleteComment($name,new XMLNode($xml,$current_path));
							$query_result = $nqlOp->execute();
						}else if($firstNode=='MODULE'){
							include_once dirname(__FILE__)."/../private/deleteModule.inc.php";
							$nqlOp = new deleteModule($name,new XMLNode($xml,$current_path));
							$query_result = $nqlOp->execute();
						}else if($firstNode=='APPLICATION'){
							include_once dirname(__FILE__)."/../private/deleteApplication.inc.php";
							$nqlOp = new deleteApplication($name,new XMLNode($xml,$current_path));
							$query_result = $nqlOp->execute();
						}else{
							include_once dirname(__FILE__)."/../private/delete.inc.php";
							$nqlOp = new deleteElement($name,new XMLNode($xml,$current_path));
							$query_result = $nqlOp->execute();
						}
					}else if($requestName=="KILL"){
						include_once dirname(__FILE__)."/../private/delete.inc.php";
						$nqlOp = new deleteElement($name,new XMLNode($xml,$current_path));
						$query_result = $nqlOp->execute();
					}else if($requestName=="UPDATE"){
						if ($firstNode=="DEPENDENCYENTITY" && !$public_request){
							include_once dirname(__FILE__)."/../private/updateDeptype.inc.php";
							$query_result = updateDeptype($name,$xml,$requestName,$current_path,$firstNode,$firstNodePath);
						}else if ($firstNode=="DESCRIPTIONCONFIG"){
							include_once dirname(__FILE__)."/../private/updateDescConfig.inc.php";
							$query_result = updateDescConfig($name,$xml,$requestName,$current_path,$firstNode,$firstNodePath);
						}else if ($firstNode=="MEDIATYPE"){
							include_once dirname(__FILE__)."/../private/createMediatype.inc.php";
							$nqlOp = new createMediatype($name,new XMLNode($xml,$current_path));
							$query_result = $nqlOp->execute();
						}else if ($firstNode=="CATEGORIES"){
							include_once dirname(__FILE__)."/../private/updateCategories.inc.php";
							$query_result = updateCategories($name,$xml,$requestName,$current_path,$firstNode,$firstNodePath);
						}else if ($firstNode=="MEDIALANGUAGES" && !$public_request){
							include_once dirname(__FILE__)."/../private/updateMedialanguages.inc.php";
							$query_result = updateMedialanguages($name,$xml,$requestName,$current_path,$firstNode,$firstNodePath);
						}else if ($firstNode=="CATEGORY"){
							include_once dirname(__FILE__)."/../private/updateCategory.inc.php";
							$query_result = updateCategory($name,$xml,$requestName,$current_path,$firstNode,$firstNodePath);
						}else if ($firstNode=="COMMENT"){
							include_once dirname(__FILE__)."/../private/comments.nql.php";
							$nqlOp = new updateComment($name,new XMLNode($xml,$current_path));
							$query_result = $nqlOp->execute();
						}else if ($firstNode=="SOUND_ART" && $xml->getData($firstNodePath.'/@source')!==FALSE){
							include_once dirname(__FILE__)."/../private/matchSoundArt.inc.php";
							$query_result = matchSoundArt($name,$xml,$requestName,$current_path,$firstNode,$firstNodePath);
						}else if ($firstNode=="PREFS"){
							include_once dirname(__FILE__)."/../private/updatePrefs.inc.php";
							$query_result = updatePrefs($name,$xml,$requestName,$current_path,$firstNode,$firstNodePath);
						}else if ($firstNode=="LABEL"){
							include_once dirname(__FILE__)."/../private/updateLabels.inc.php";
							$query_result = updateLabels($name,$xml,$requestName,$current_path,$firstNode,$firstNodePath);
						}else if ($firstNode=="PROPERTIESCONFIG"){
							include_once dirname(__FILE__)."/../private/updatePropertiesConfig.inc.php";
							$query_result = updatePropertiesConfig($name,$xml,$requestName,$current_path,$firstNode,$firstNodePath);
						}else if($firstNode=='MODULE'){
							include_once dirname(__FILE__)."/../private/updateModule.inc.php";
							$nqlOp = new updateModule($name,new XMLNode($xml,$current_path));
							$query_result = $nqlOp->execute();
						}else if($firstNode=='APPLICATION'){
							include_once dirname(__FILE__)."/../private/updateApplication.inc.php";
							$nqlOp = new updateApplication($name,new XMLNode($xml,$current_path));
							$query_result = $nqlOp->execute();
						}else{
							include_once dirname(__FILE__)."/../private/update.nql.php";
							$nqlOp = new updateElement($name,new XMLNode($xml,$current_path));
							$query_result = $nqlOp->execute();
						}
					}else if($requestName=='CHECK'){
						if ($firstNode=='MAILING'){
							include_once(dirname(__FILE__)."/../private/check_mailing.inc.php");
							$query_result = check_mailing($name,$xml,$requestName,$current_path,$firstNode,$firstNodePath);
						}else if($firstNode=='MAILSACCOUNT'){
							include_once(dirname(__FILE__)."/../private/check_mailsaccount.inc.php");
							$nqlOp = new checkMailsAccount($name,new XMLNode($xml,$current_path));
							$query_result = $nqlOp->execute();
						}
					}else if($requestName=='SEND'){
						if ($firstNode=='MAILINGPREVIEW'){
							include_once dirname(__FILE__)."/../private/sendMailingPreview.inc.php";
							$query_result = sendMailingPreview($name,$xml,$requestName,$current_path,$firstNode,$firstNodePath);
						}
					}else if($requestName=='INCLUDE'){
						$include_file = $xml->getData($current_path.'/@file');
						if($include_file){
							$include_xml = new XML($include_file);
							if(!$include_xml->loaded)
								$include_xml = new XML($GLOBALS["nectil_dir"].$include_file);
							if($include_xml->loaded){
								 $isquery = $include_xml->nodeName('/*[1]');
								if($isquery =='QUERY'){
									$include_xml->setAttribute('/QUERY/*', 'fromFile', $include_file);
									$query_result = request($include_xml->toString(),true,false,false,false,$GLOBALS["restrict_language"],$GLOBALS["priority_language"],$GLOBALS["php_request"],$GLOBALS["dev_request"]);
								}else{
									$query_result = '<FILE path="'.$include_file.'">' . $include_xml->toString() . '</FILE>';
								}
							}else
								$query_result = generateMsgXML(1,"File doesn't exist or couldn't be parsed ($include_file).",0,'',$name);
						}else
							$query_result = generateMsgXML(1,"Include has no file specified.",0,'',$name);
					}else if($requestName=='IMPORT'){
						
						if($firstNode=='CSV'){
							include_once dirname(__FILE__)."/../private/importCSV.inc.php";
							$nqlOp = new importCSV($name,new XMLNode($xml,$current_path));
							$query_result = $nqlOp->execute();
						}else if($firstNode=='XLIFF'){
							include_once dirname(__FILE__)."/../private/importXLIFF.inc.php";
							$query_result = importXLIFF($name,$xml,$requestName,$current_path,$firstNode,$firstNodePath);
						}
					}else if($requestName=='EXPORT'){
						if($firstNode=='OFFICITY'){
							include_once(dirname(__FILE__)."/../private/exportOfficity.inc.php");
							$nqlOp = new exportOfficity($name,new XMLNode($xml,$current_path));
							$query_result = $nqlOp->execute();
						}
					}else if($requestName=='FILEORDIRECTORY'){
						include_once dirname(__FILE__)."/../file/file_request.inc.php";
						$query_result = filerequest($name,$xml,$requestName,$current_path,$firstNode,$firstNodePath);
					}else if($requestName=='CONFIRM'){
						include_once dirname(__FILE__)."/../private/confirmOperation.inc.php";
						$query_result = confirmOperation($name,$xml,$requestName,$current_path,$firstNode,$firstNodePath);
					}else if($requestName=='DUPLICATE'){
						include_once dirname(__FILE__)."/../private/duplicate.inc.php";
						$query_result = duplicate($name,$xml,$requestName,$current_path,$firstNode,$firstNodePath);
					}else if($requestName=='SAVE' && $firstNode=='MAIL'){
						include_once dirname(__FILE__)."/../private/saveMail.inc.php";
						$query_result = saveMail($name,$xml,$requestName,$current_path,$firstNode,$firstNodePath);
					}else if($requestName=='UNSUSCRIBE' && $firstNode=='CONTACT'){
						include_once dirname(__FILE__)."/../private/unsuscribeContact.inc.php";
						$query_result = unsuscribeContact($name,$xml,$requestName,$current_path,$firstNode,$firstNodePath);
					}else if($requestName=='PROCESS'){
						switch($firstNode){
							case 'MOVIE':
								include_once dirname(__FILE__)."/../private/processMovie.inc.php";
								$nqlOp = new processMovie($name,new XMLNode($xml,$current_path));
								$query_result = $nqlOp->execute();
								break;
							case 'IMAGE':
								break;
						}
					}else if($requestName=='CONNECT'){
						login($xml->valueOf($current_path.'/LOGIN'),$xml->valueOf($current_path.'/PASSWORD'));
						if ( isset($_SESSION[$GLOBALS['nectil_url']]['SESSIONuserID']) ){
							$private_request = TRUE;
						}else
							$private_request = FALSE;
					}else if($requestName=='ANALYSE'){
						switch($firstNode){
							case 'CSV':
								include_once dirname(__FILE__)."/../private/analyseCSV.inc.php";
								$nqlOp = new analyseCSV($name,new XMLNode($xml,$current_path));
								$query_result = $nqlOp->execute();
								break;
							default:
								break;
						}
					}else{
						$query_result = generateMsgXML(1,"Operation '$requestName' unknown.");
					}
					
				
				}else if($mustconfirm!==false){
					if($mustconfirm!=='true'){
						$confirm_id = $mustconfirm;
					}else{
						$confirm_id = str_replace(array('.',' '),'',microtime());
					}
					
					include_once dirname(__FILE__)."/../common/file.class.php";
					$xml->removeAttribute($current_path, 'confirm');
					$mustconfirm_operation = $xml->toString($current_path,'');
					$confirm_dir = new Folder('/confirm/');
					$confirm_dir->create();
					$confirm_file = new File('/confirm/subquery_'.$confirm_id.'.xml');
					if($confirm_file->exists()){
						$current_content = $confirm_file->toString();
						$new_content = str_replace('</QUERY>',$mustconfirm_operation.'</QUERY>',$current_content);
						$confirm_file->save($new_content);
					}else{
						$confirm_file->save('<?xml version="1.0"?><QUERY>'.$mustconfirm_operation.'</QUERY>');
					}
					$query_result = generateMsgXML(4,"Operation was postponed until further user confirmation",0,$confirm_id,$name,'','','confirm_url="'.$GLOBALS["backoffice_url"].'public/confirm.php?ID='.$confirm_id.'"');
				}else{
					$query_result = generateMsgXML(3,"Operation unauthorized : your session must have expired, try to login again.",0,'',$name);
				}
			}
			// osLogs
			if (!$public_request){ // from flash
				osLogs($requestName,$firstNode,$beginRequestTime,$requestElementID,$xml->toString($current_path,''));
			}
			if ($must_get_cached===TRUE){
				$Cache_Lite->save($query_result,$id,$cache_section);
			}
			}
			$strResponse.=$query_result;
			unset($query_result);
		}
		unset($queries_array);
		if($forced_language){
			$GLOBALS["NectilLanguage"] = $save_language;
			$GLOBALS["restrict_language"] = $save_restrict;
		}
	}

	if($no_response_node===true)
		$strRet=$strResponse;
	else{
		// enclosing the results of the differents requests in a unique node
		
		// handling the namespaces necessary for the external objects
		require_once(dirname(__FILE__)."/../common/namespace.class.php");
		$namespaces = new NamespaceCollection();
		$namespaces_str = $namespaces->getXMLHeader();
		
		if($GLOBALS['no_variable_nectil_vars']!==true && !$GLOBALS["php_request"])
			$strRet="<?xml version=\"1.0\" encoding=\"utf-8\"?><RESPONSE".$namespaces_str." userID=\"".$_SESSION[$GLOBALS["nectil_url"]]['SESSIONuserID']."\" sessionID=\"".session_id()."\">$strResponse";
		else
			$strRet="<?xml version=\"1.0\" encoding=\"utf-8\"?><RESPONSE".$namespaces_str.">$strResponse";
		// adding some stats
		if (!$GLOBALS["php_request"] || $_GET['stats']=='true'){
			$strRet.="<SQL_STATS><TOTALQUERIES>".($GLOBALS["EXECS"]+$GLOBALS["CACHED"])."</TOTALQUERIES><SearchQUERIES>".$GLOBALS["SearchQUERIES"]."</SearchQUERIES></SQL_STATS>";
			$strRet.="<TotalNectilElements>".$GLOBALS["TotalNectilElements"]."</TotalNectilElements>";
			$time_elapsed = getTimer(/*true*/);
			$strRet.="<TIME>$time_elapsed</TIME>";
		}
		$strRet.="</RESPONSE>";
	
	}

	return $strRet;
}
?>
