<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee-source/sushee/common/exception.class.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
require_once(dirname(__FILE__)."/../common/nectil_object.class.php");


if(class_exists('Exception')){
	class SusheeException extends Exception{
	}

}else{
	// mimic the behaviour of exceptions in PHP4
	class SusheeException extends SusheeObject{

		var $message = 'Unknown exception';   // exception message
		var $string;                          // __toString cache
		var $code = 0;                        // user defined exception code
		var $file;                            // source filename of exception
		var $line;                            // source line of exception
		var $trace;                           // backtrace
		var $previous;                        // previous exception if nested exception

		function SusheeException($message = null, $code = 0, SusheeException $previous = null){
			$this->message = $message;
			$this->code = $code;
			$this->previous = $previous;
		}

		function getMessage(){// message of exception

		}        
		function getCode(){// code of exception

		}           
		function getFile(){// code of exception

		}           
		function getLine(){// source line

		}
		function getTrace(){// an array of the backtrace()

		}
		function getPrevious(){// previous exception

		}
		function getTraceAsString(){// formatted string of trace

		}
		function __toString(){

		}
	}
	
}
/* errors sent by pre and postprocessors */
class SusheeProcessorException extends SusheeException{
	var $code = SUSHEE_ERROR_PROCESSOREXCEPTION;
	
}
class SusheeProcessorWarning extends SusheeException{}

/* return message sent by a pre or postprocessor */
class SusheeProcessorMessage extends SusheeObject{
	
	var $message;
	
	function SusheeProcessorMessage($message){
		$this->message = $message;
	}
	
	function getMessage(){
		return $this->message;
	}
}
class SusheeXSLTException extends SusheeException{}
?>