<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee-source/sushee/file/file_download.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
include_once(dirname(__FILE__)."/../common/common_functions.inc.php");
require_once(dirname(__FILE__)."/../file/file_functions.inc.php");
require_once(dirname(__FILE__)."/../file/file_config.inc.php");

global $slash;
global $directoryRoot;
session_write_close();
if(isset($_GET["target"]))
	$target = transformPath($_GET["target"]);

//check if target exist
if (isset($target)){
    //check security for this target
	$right = 'R';
	$subdir = substr($target,0,5);
	if($subdir!='/pdf/' && $subdir!='/tmp/')
		$right =  getPathSecurityRight($target);
    
    if($right===0){
		debug_log("Access to this directory refused ".$target);
        htmlErrorMsg("Download error","Access to this directory refused");
    }
    if(!hidecheck($target)){
		debug_log("This file is blocked. ".$target);
        htmlErrorMsg("Download error","This file is blocked.");
    }
	
    global $slash;
	global $directoryRoot;
    $location = $directoryRoot.$target;
    if(is_dir($location)){
		$complete_archivePath = $GLOBALS["directoryRoot"].$slash."tmp".$slash.str_replace('.','',getmicrotime()).".zip";
		zip($location,$complete_archivePath);
		chmod_Nectil($complete_archivePath);
		if(isset($_GET['rename'])){
			fileUpload($complete_archivePath,$_GET['rename'].'.zip');
		}else
        	fileUpload($complete_archivePath,BaseFilename(removeAccents($target)).'.zip');
        unlink($complete_archivePath);
        exit();
    }else{
		if(isset($_GET['rename'])){
			$ext = getFileExt($location);
			fileUpload($location,utf8_encode($_GET['rename']).(($ext)?'.':'').$ext);
		}else
			fileUpload($location);
        exit();
    }
}else{
    htmlErrorMsg("Download error","Target filename is missing");
}

?>