<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee-source/sushee/file/file_request.inc.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
require_once(dirname(__FILE__)."/../file/file_functions.inc.php");
require_once(dirname(__FILE__)."/../file/file_config.inc.php");


function filerequest($name,&$xml,$requestName,$current_path,$firstNode,$firstNodePath){
	$action = $xml->getData($current_path.'/@action');
	
	if($action=="delete" || $action== "recdelete"){
		
		$target = $xml->getData($current_path."/*[1]");
		
		include_once dirname(__FILE__)."/../file/file_delete.inc.php";
		
		$query_result = file_delete($name,$action,$target);
		
	}else if($action=="move"){
		
		$target = $xml->getData($current_path."/SOURCE[1]");
		$target2 = $xml->getData($current_path."/TARGET[1]");
		
		include_once dirname(__FILE__)."/../file/file_move.inc.php";
		
		$query_result = file_move($name,$action,$target,$target2);
		
	}else if($action=="copy"){
		
		$target = $xml->getData($current_path."/SOURCE[1]");
		$target2 = $xml->getData($current_path."/TARGET[1]");
		
		include_once dirname(__FILE__)."/../file/file_move.inc.php";
		
		$query_result = file_move($name,$action,$target,$target2);
		
	}else if($action=="rename"){
		
		$target = $xml->getData($current_path."/SOURCE[1]");
		$target2 = $xml->getData($current_path."/TARGET[1]");
		
		include_once dirname(__FILE__)."/../file/file_rename.inc.php";
		
		
		$query_result = file_rename($name,$action,$target,$target2);
		
	}else if($action=="new" || $action=="mkdir"){
		
		$target = $xml->getData($current_path."/TARGET[1]");
		if(!$target)
			$target = $xml->getData($current_path."/SOURCE[1]");
			
		include_once dirname(__FILE__)."/../file/file_mkdir.inc.php";
		
		
		$query_result = file_mkdir($name,$action,$target);
		
	}else if($action=="zip"){
		
		$target = $xml->getData($current_path."/*[1]");
		
		include_once dirname(__FILE__)."/../file/file_zip.inc.php";
		
		$query_result = file_zip($name,$action,$target);
		
	}else if($action=="unzip"){
		$target = $xml->getData($current_path."/*[1]");
		
		include_once dirname(__FILE__)."/../file/file_unzip.inc.php";
		
		$query_result = file_unzip($name,$action,$target);
		
	}else if($action=="transform"){
		
		$source = $xml->getData($current_path."/SOURCE[1]");
		$target = $xml->getData($current_path."/TARGET[1]");
		
		include_once dirname(__FILE__)."/../file/image_transform.inc.php";
		
		
		$query_result = image_transform($name,$xml,$current_path,$action,$source,$target);
		
	}else if($action=="list"){
		
		$path = $xml->getData($current_path);
		$query_result = filesList($name,$path);
		
	}else if($action=="deploy"){
		
		$path = $xml->getData($current_path);
		$query_result = getTree($name,$path);
		
	}else{
		
		$str = "File action error: action: $action doesn't exist";
		return generateMsgXML(1,$str,0,'',$name);
		
	}
	
	return $query_result;
}
?>
