<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee-source/sushee/private/exportOfficity.inc.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
require_once(dirname(__FILE__).'/../common/nqlOperation.class.php');
require_once(dirname(__FILE__).'/../common/file.class.php');
require_once(dirname(__FILE__).'/../common/nectil_user.class.php');
require_once(dirname(__FILE__).'/../common/db_manip.class.php');

class exportOfficity extends RetrieveOperation{
	
	var $export_files = true;
	var $export_db = true;
	var $export_public = true;
	var $export_library = true;
	var $file = false;
	
	function parse(){
		$user = new NectilUser();
		if(!$user->isAuthentified()){
			$this->setError('You must be authenticated to use this feature');
			return false;
		}
		$keyring = $user->getKeyring();
		if(!$keyring->isSuperAdmin()){
			$this->setError('You must be super administrator to use this feature');
			return false;
		}
		
		if($this->firstNode){
			$returnNode = $this->firstNode->getElement('RETURN');
			if($returnNode){
				$this->export_files = $returnNode->exists('FILES');
				$this->export_db = $returnNode->exists('DATABASE');
				$this->export_public = $returnNode->exists('PUBLIC');
				$this->export_library = $returnNode->exists('LIBRARY');
			}
		}
		
		return true;
	}
	
	function operate(){
		$xml = '';
		$attributes = $this->getOperationAttributes();
		$xml.='<RESULTS'.$attributes.'>';
		$tmpDir = new TempDirectory();
		$tmpDir->create();
		$this->file = new ZipFile();
		/*if($this->export_files){
			$exportFilesDir = $tmpDir->createDirectory('Files');
			$filesDir = new Folder('/');
			while($child = $filesDir->getNextChildren()){
				if(!$child->isWorkDirectory() && $child->isDirectory()){
					$child->copy($exportFilesDir);
				}
			}
			$this->file->add($exportFilesDir);
		}*/
		if($this->export_db){
			$request = new Sushee_Request();
			$db = $request->getDatabase();
			$DbFile = $tmpDir->createFile('database.sql');
			$tmpDbFile = $db->export();
			$tmpDbFile->copy($DbFile);
			$tmpDbFile->delete();
			$this->file->add($DbFile);
		}
		/*if($this->export_public){
			$publicDir = new KernelFolder('/Public');
			$this->file->add($publicDir);
		}
		if($this->export_library){
			$libraryDir = new KernelFolder('/Library');
			$this->file->add($libraryDir);
		}*/
		$this->file->compress();
		$xml.='<ARCHIVE>'.encode_to_xml($this->file->getPath()).'</ARCHIVE>';
		$xml.='</RESULTS>';
		$this->setXML($xml);
		return $xml;
	}
}
?>