<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee-source/sushee/private/metasearch_comments.inc.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
function tags_COMMENT(&$xml,$nodes_array,$varName){
	$search_str="";
	$first = true;
	foreach($nodes_array as $path){
		$query_str= tag_COMMENT($xml,$path,$varName);
		if($query_str != ""){
			//ensure no "OR" for the first tag instance
			if($first != true) 
				$search_str.=" OR ";
			else
				$first=false;
			$search_str.="(".$query_str.")";
		}
	}
	return $search_str;
}



function tag_COMMENT(&$xml,$parentPath,$varName){
	$search_str="";
	$allowed_fields = array("TYPE"=>'Type',"CHECKED"=>'Checked',"FULLTEXT"=>'SearchText',"TITLE"=>"Title","BODY"=>"Body","CREATIONDATE"=>"CreationDate","MODIFICATIONDATE"=>"ModificationDate","CREATORID"=>"CreatorID");
	$field_types = array('Type'=>'C','Checked'=>'I','SearchText'=>'C','Title'=>'C','Body'=>'C','CreationDate'=>'D','ModificationDate'=>'D');
	$xml_array = $xml->match($parentPath."/*");
	
	// preparing a matrix with all the possible values for all the fields
	foreach($xml_array as $path){
		$n = $xml->nodeName($path);
		if (isset($allowed_fields[$n])){
			$data = $xml->getData($path);
			$fieldname = $allowed_fields[$n];
			if($n=='FULLTEXT')
				$data = decode_from_XML(strtolower(removeaccents(trim($data))));
			$fields[$fieldname][sizeof($fields[$fieldname])]=array("value"=>$data,"operator"=>$xml->getxSusheeOperator($path));
		}
	}
	$first = true;
	foreach($fields as $fieldname => $possible_values){
		$field_str="";
		$first2 = true;
		
		for($i=0;$i<sizeof($possible_values);$i++){
			$possible = $possible_values[$i];
			$fieldType = $field_types[$fieldname];
			$str = manageFieldType($fieldname,$fieldType,$possible['value'],$possible['operator'],$varName);
			if($str != ""){
				//ensure no "OR" for the first tag instance
				if($first2 != true) 
					$field_str.=" OR ";
				else
					$first2=false;
				$field_str.="(".$str.")";
			}
		}
		if($field_str != ""){
			//ensure no "OR" for the first tag instance
			if($first != true) 
				$search_str.=" AND ";
			else
				$first=false;
			$search_str.="(".$field_str.")";
		}
	}
	return $search_str;
}

function getElementWithCommentsMatching(&$xml,$element_path,$moduleInfo){
	$varName= 'cmt';
	$targetIDs = array();
	$excludeIDs = array();
	$db_conn = db_connect();
	$nodes_array = $xml->match($element_path."/COMMENT[not(@operator) or @operator='exists']");
	$query_string = tags_COMMENT($xml,$nodes_array,$varName);
	
	if($query_string || sizeof($nodes_array)){
		$collect_sql = 'SELECT DISTINCT `TargetID` FROM `comments` AS '.$varName.' WHERE '.$varName.'.`ModuleTargetID`=\''.$moduleInfo->ID.'\'';
		if($query_string){
			$collect_sql.=' AND '.$query_string;
		}
		sql_log($collect_sql);
		$collect_rs = $db_conn->Execute($collect_sql);
		while( $row = $collect_rs->FetchRow() ){
			$targetIDs[]=$row['TargetID'];
		}
		if(sizeof($targetIDs)==0)
			$targetIDs[]=-1;
	}
	$nodes_array = $xml->match($element_path."/COMMENT[@operator='not_exists' or @operator='not']");
	$query_string = tags_COMMENT($xml,$nodes_array,$varName);
	
	if($query_string){
		$collect_sql = 'SELECT  DISTINCT `TargetID` FROM `comments` AS '.$varName.' WHERE '.$varName.'.`ModuleTargetID`=\''.$moduleInfo->ID.'\' AND '.$query_string;
		sql_log($collect_sql);
		$collect_rs = $db_conn->Execute($collect_sql);
		while( $row = $collect_rs->FetchRow() ){
			$excludeIDs[]=$row['TargetID'];
		}
	}
	return array($targetIDs,$excludeIDs);
}

?>