<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee-source/sushee/private/searchTraductions.inc.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
require_once(dirname(__FILE__).'/../common/nqlOperation.class.php');
require_once(dirname(__FILE__).'/../common/nectil_user.class.php');
require_once(dirname(__FILE__).'/../common/application.class.php');

define('OFFICIAL_APPLICATION',1);
define('CUSTOM_APPLICATION',2);


class searchTraductions extends RetrieveOperation{
	var $applicationName = false;
	var $languageID = false;
	var $applicationType = OFFICIAL_APPLICATION;
	var $getShared = false;
	
	function parse(){
		$this->applicationName = $this->firstNode->valueOf('APPLICATION[1]');
		if(!$this->applicationName){
			$this->applicationName = $this->firstNode->valueOf('APPLICATION_CUSTOM[1]');
			$this->applicationType = CUSTOM_APPLICATION;
		}
		
		if(!$this->applicationName){
			$this->setError('Missing application name.');
			return false;
		}
		$this->languageID = $this->firstNode->valueOf('LANGUAGEID[1]');
		if(!$this->languageID){
			$request = new Sushee_Request();
			$this->languageID = $request->getLanguage();
		}
		
		$this->getShared = ($this->firstNode->valueOf('@shared')=='true');
		
		return true;
	}
	
	function operate(){
		$xml = '';
		$attributes = $this->getOperationAttributes();
		$xml.='<RESULTS'.$attributes.'>';
		
		$languageID = $this->languageID;
		$application = $this->applicationName;
		
		switch($this->applicationType){
			case OFFICIAL_APPLICATION:
				$app = new OfficialApplication($this->applicationName);
			
				break;
			case CUSTOM_APPLICATION:
				$app = new CustomApplication($this->applicationName);
			
				break;
		}
		if($app){
			$xml.=$app->getTraductionXML($languageID);
		}
		
		
		if($this->getShared){
			$apps = new ApplicationCollection();
			$xml.=$apps->getSharedXML($languageID);
		}
		$xml.='</RESULTS>';
		$this->setXML($xml);
		return true;
	}
}


?>