<?xml version="1.0"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/officity/factory/modules/DisplayConfig.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
    <xsl:import href="include.xsl"/>
	<xsl:output encoding="UTF-8" method="xml" indent="no"/>
	<xsl:strip-space elements="*"/>
	
	<xsl:param name="modules" select="/RESPONSE/RESULTS/MODULE"/>
	<xsl:param name="targetModuleDenom" select="/RESPONSE/URL/module" />
    <xsl:param name="targetModule" select="/RESPONSE/RESULTS[@name=$targetModuleDenom]/MODULE"/>
    <xsl:param name="targetModuleFields" select="/RESPONSE/RESULTS[@name=concat('fields-', $targetModuleDenom)]/FIELD"/>
    <xsl:param name="dependencyTypes" select="/RESPONSE/RESULTS[@name='dependencies']/DEPENDENCYENTITY/DEPENDENCYTYPE[1]"/>
    <xsl:param name="defaultFilter" select="/RESPONSE/RESULTS[@name='default-filter']/OFFICITY:FILTER"/>
    <xsl:param name="filterDisplay" select="$defaultFilter/INFO/DISPLAYXML"/>
    <xsl:param name="defaultReports" select="/RESPONSE/RESULTS[@name='default-reports']/OFFICITY:REPORT"/>
    <xsl:param name="defaultSearchConfig" select="/RESPONSE/RESULTS[@name='default-search-config']/OFFICITY:SEARCHCONFIG"/>
    
	<xsl:template match="MODULE[DESCRIPTIONS/DESCRIPTION/HEADER/text()!='']" mode="element-label">
       	<xsl:value-of select="DESCRIPTIONS/DESCRIPTION/HEADER" />
       	<!--xsl:text> (</xsl:text>
        <xsl:apply-templates select="INFO/DENOMINATION" mode="display-value"/>
        <xsl:text>)</xsl:text-->
	</xsl:template>
	
	<xsl:template match="MODULE" mode="element-label">
        <xsl:apply-templates select="INFO/DENOMINATION" mode="display-value"/>
	</xsl:template>
    
	<xsl:template match="DEPENDENCYTYPE[DENOMINATION/LABEL/text()!='']" mode="element-label">
		<xsl:value-of select="DENOMINATION/LABEL" />
		<xsl:text> => </xsl:text>
		<xsl:apply-templates select="$modules[INFO/DENOMINATION=current()/@to]" mode="element-label"/>
	</xsl:template>
	
	<xsl:template match="DEPENDENCYTYPE" mode="element-label">
		<xsl:value-of select="TYPE" />
		<xsl:text> => </xsl:text>
		<xsl:apply-templates select="$modules[INFO/DENOMINATION=current()/@to]" mode="element-label"/>
	</xsl:template>
	
	<xsl:template match="/RESPONSE">
    	<xsl:call-template name="panel">
    	</xsl:call-template>
    </xsl:template>
    
	<!-- PANEL TITLE -->
    <xsl:template name="panel-title">
    	<xsl:text>Default display configuration</xsl:text>
    </xsl:template>
    
	<!-- PANEL BODY -->
	<xsl:template name="panel-body">
		<div class="block block-details" style="margin-bottom:20px">
			<xsl:call-template name="panel-block-details"/>
		</div>
	</xsl:template>
	
	<!-- PANEL HEADER -->
   	<xsl:template name="panel-header">
		<p style="font-size:1.2em; text-align:center; margin:15px auto 0 auto;">			
			This configuration will be used as the default display for advanced search and for default reports.<br />
			<strong>
				<xsl:if test="not($defaultFilter)">
					<br />
					<xsl:text>This module does not have a default search display.</xsl:text>
				</xsl:if>
				<xsl:if test="not($defaultSearchConfig)">
					<br />
					<xsl:text>This module does not have a default search configuration.</xsl:text>
				</xsl:if>
				<xsl:if test="not($defaultReports)">
					<br />
					<xsl:text>This module does not have the default reports configured.</xsl:text>
				</xsl:if>
				<xsl:if test="not($defaultFilter) or not($defaultReports) or not($defaultSearchConfig)">
					<br /><br />
					<xsl:text>The necessary element(s) will be created when saving.</xsl:text>
				</xsl:if>
			</strong>
		</p>
		
        <form id="display-config-form" name="display-config-form" class="display-config-form">
            <table>
                <tr>
                    <td class="left">
                        <label>Results per page:</label>
                    </td>
                    <td class="right">
                        <select id="paginate-display" name="paginate-display">
                            <xsl:for-each select="/RESPONSE/RESULTS[@name='results']/VALUE">
                                <option value="{.}">
                                    <xsl:if test="$filterDisplay/PAGINATE/@display=.">
                                        <xsl:attribute name="selected">selected</xsl:attribute>
                                    </xsl:if>
                                    <xsl:value-of select="."/> results
                                </option>
                            </xsl:for-each>
                        </select>
                    </td>
                </tr>
                <tr>
                    <td class="left">
                        <label>Sort value:</label>
                    </td>
                    <td class="right">
                        <select id="sort-service" name="sort-service" class="input-small" style="float:left">
                            <option value="INFO">
                                <xsl:if test="substring-before($filterDisplay/SORT/@select, '/')='INFO'">
                                    <xsl:attribute name="selected">selected</xsl:attribute>
                                </xsl:if>
                                <xsl:text>INFO</xsl:text>
                            </option>
                            <!--option value="DESCRIPTION">
                                <xsl:if test="substring-before($filterDisplay/SORT/@select, '/')='DESCRIPTION'">
                                    <xsl:attribute name="selected">selected</xsl:attribute>
                                </xsl:if>
                                <xsl:text>DESCRIPTION</xsl:text>
                            </option-->
                        </select>
                        <select id="sort-select" name="sort-select" class="input-small" style="float:right">
                            <xsl:for-each select="$targetModuleFields">
                                <xsl:sort select="translate(DESCRIPTIONS/DESCRIPTION/TITLE, $xsltsl-str-upper, $xsltsl-str-lower)"/>
                                <xsl:sort select="INFO/DENOMINATION"/>

                                <option value="{./INFO/DENOMINATION}">
                                    <xsl:if test="substring-after($filterDisplay/SORT/@select, '/')=INFO/DENOMINATION">
                                        <xsl:attribute name="selected">selected</xsl:attribute>
                                    </xsl:if>
                                    <xsl:choose>
                                        <xsl:when test="./DESCRIPTIONS/DESCRIPTION/TITLE/text()">
                                            <xsl:value-of select="./DESCRIPTIONS/DESCRIPTION/TITLE"/>
                                        </xsl:when>
                                        <xsl:otherwise>
                                            <xsl:value-of select="./INFO/DENOMINATION"/>
                                        </xsl:otherwise>
                                    </xsl:choose>
                                </option>
                            </xsl:for-each>
                        </select>
                    </td>
                </tr>
                <tr>
                    <td class="left">
                        <label>Sort order:</label>
                    </td>
                    <td class="right">
                        <select id="sort-order" name="sort-order">
                            <option value="ascending">
                                <xsl:if test="$filterDisplay/SORT/@order='ascending'">
                                    <xsl:attribute name="selected">selected</xsl:attribute>
                                </xsl:if>
                                Ascending (from the lowest to the highest)
                            </option>
                            <option value="descending">
                                <xsl:if test="$filterDisplay/SORT/@order='descending'">
                                    <xsl:attribute name="selected">selected</xsl:attribute>
                                </xsl:if>
                                Descending (from the highest to the lowest)
                            </option>
                        </select>
                    </td>
                </tr>
                <tr>
                    <td class="left">&#160;</td>
                    <td class="right">
                        <input type="button" name="save-display-button" id="save-display-button" class="input-submit-save" value="Save default configuration" />
                    </td>
                </tr>
            </table>
        </form>
	</xsl:template>
	
	<!-- BODY: DETAILS BLOCK -->
	<xsl:template name="panel-block-details">  
        <xsl:attribute name="class">
        	<xsl:text>block block-details block-details-display-config</xsl:text>
        </xsl:attribute>
        <table class="columns-config">
            <tr id="topline">
                <td>
                    <h2>Displayed data</h2>
                    <p>Order the data as desired or drag and drop them in the column at the right ('Available data') to remove them</p>
                </td>
                <td>
                    <h2 id="title-available">Available data</h2>
                    <p id="text-available">Move the data to the left column ('Displayed data') and order them as desired</p>
                    <select id="module-selector" style="wdth:100%;">
                    	<xsl:attribute name="onchange">
						    <xsl:call-template name="triggerpanelevent">
						    	<xsl:with-param name="panelID" select="$panelID" />
						        <xsl:with-param name="event" select="'config-displayavailfields'"/>
						        <xsl:with-param name="params">
						        	<xsl:text>this, this.options[this.selectedIndex].value</xsl:text>
						        </xsl:with-param>
					        </xsl:call-template>
                    	</xsl:attribute>
                        <option value="">
                            <xsl:apply-templates select="$targetModule" mode="element-label"/>
                        </option>
                        <xsl:if test="$dependencyTypes">
	                        <optgroup label="DEPENDENCIES">
	                            <xsl:for-each select="$dependencyTypes">
	                                <xsl:sort select="DENOMINATION/LABEL" />
	                                <option value="{./TYPE}">
		                                <xsl:text>&#160;&#160;&#160;</xsl:text>
	                                    <xsl:apply-templates select="." mode="element-label"/>
	                                </option>
	                            </xsl:for-each>
	                        </optgroup>
                        </xsl:if>
                        <option value="categories">
                       		<xsl:text>CATEGORIES</xsl:text>
                        </option>
                    </select>
                    <p>&#160;</p>
                </td>
            </tr>
            <tr>
                <td>
                    <!-- SELECTED FIELDS -->
                    <div id="container-selected">
                        <ul id="fields-selected" class="connectedSortable">
                            <xsl:for-each select="$filterDisplay/RETURN/INFO/* | $filterDisplay/RETURN/DEPENDENCIES/DEPENDENCY | $filterDisplay/RETURN/CATEGORIES">
                                <xsl:sort select=".//@order" order="ascending" data-type="number"/>
                                <xsl:choose>
                                    <xsl:when test="name() = 'CATEGORIES'">
	                                    <!-- categories -->
		                               <li title="" class="ui-state-default">
					                    	<xsl:attribute name="onmousedown">
											    <xsl:call-template name="triggerpanelevent">
											    	<xsl:with-param name="panelID" select="$panelID" />
											        <xsl:with-param name="event" select="'config-displayavailfields'"/>
											        <xsl:with-param name="params">
											        	<xsl:text>null, 'categories'</xsl:text>
											        </xsl:with-param>
										        </xsl:call-template>
					                    	</xsl:attribute>
					                    	<em>
	                                            <xsl:text>CATEGORIES</xsl:text>
                                            </em>
                                            <input type="hidden" value="CATEGORIES"/>
                                        </li>
                                    </xsl:when>                                    
                                    <xsl:when test="name() = 'DEPENDENCY'">
                                        <!-- dependency module -->
                                        <xsl:variable name="depType" select="./@type"/>
                                        <xsl:variable name="depConfig" select="$dependencyTypes[TYPE=$depType]"/>
                                        <xsl:variable name="depTargetModule" select="$modules[INFO/DENOMINATION=$depConfig/@to]"/>
                                      
                                        <xsl:variable name="subGroupID">
                                            <xsl:text>fields-subgroup-</xsl:text>
                                            <xsl:call-template name="replace-string">
                                                <xsl:with-param name="text"><xsl:value-of select="$depType"/></xsl:with-param>
                                                <xsl:with-param name="from">:</xsl:with-param>
                                                <xsl:with-param name="to">__</xsl:with-param>
                                            </xsl:call-template>
                                        </xsl:variable>
                                        <ul id="{$subGroupID}" class="subConnectedSortable" title="{$depType}">
					                    	<xsl:attribute name="onmousedown">
											    <xsl:call-template name="triggerpanelevent">
											    	<xsl:with-param name="panelID" select="$panelID" />
											        <xsl:with-param name="event" select="'config-displayavailfields'"/>
											        <xsl:with-param name="params">
											        	<xsl:text>null, '</xsl:text>
											        	<xsl:value-of select="$depType" />
											        	<xsl:text>'</xsl:text>
											        </xsl:with-param>
										        </xsl:call-template>
					                    	</xsl:attribute>
                                            <li class="subGroupHeader">
                                                <xsl:apply-templates select="$depTargetModule" mode="element-label" />
                                            </li>
                                            <xsl:for-each select="./INFO/*">
                                                <xsl:sort select="@order" order="ascending" data-type="number"/>
                                                <li title="{$depType}" class="ui-state-default">
                                                    <xsl:call-template name="get-module-field-name">
                                                        <xsl:with-param name="moduleName" select="$depConfig/@to"/>
                                                        <xsl:with-param name="nodeName" select="name()"/>
                                                    </xsl:call-template>

                                                    <input type="hidden" value='DEPENDENCY[@type="{$depType}"]/{name()}'/>
                                                </li>
                                            </xsl:for-each>
                                        </ul>
                                    </xsl:when>
                                    <xsl:otherwise>
	                                    <!-- main module -->
                                        <li title="" class="ui-state-default">
					                    	<xsl:attribute name="onmousedown">
											    <xsl:call-template name="triggerpanelevent">
											    	<xsl:with-param name="panelID" select="$panelID" />
											        <xsl:with-param name="event" select="'config-displayavailfields'"/>
											        <xsl:with-param name="params">
											        	<xsl:text>null, ''</xsl:text>
											        </xsl:with-param>
										        </xsl:call-template>
					                    	</xsl:attribute>
                                            <xsl:call-template name="get-module-field-name">
                                                <xsl:with-param name="moduleName" select="$targetModuleDenom"/>
                                                <xsl:with-param name="nodeName" select="name(.)"/>
                                            </xsl:call-template>
                                            <input type="hidden" value="INFO/{name()}"/>
                                        </li>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </xsl:for-each>
                        </ul>
                    </div>
                </td>
                <td>
                    <!-- AVAILABLE FIELDS -->
                    <div id="container-available">
                        <!-- main module -->
                        <ul id="fields-available" class="connectedSortable fields-available">
                        	<li class="sortable-static"><xsl:apply-templates select="$targetModule" mode="element-label"/></li>
                            <xsl:for-each select="$targetModuleFields">
                                <xsl:sort select="translate(DESCRIPTIONS/DESCRIPTION/TITLE, $xsltsl-str-upper, $xsltsl-str-lower)"/>

                                <xsl:if test="not($filterDisplay/RETURN/INFO/*[current()/INFO/DENOMINATION=name()])">
                                    <li title="" class="ui-state-highlight">
					                    	<xsl:attribute name="onmousedown">
											    <xsl:call-template name="triggerpanelevent">
											    	<xsl:with-param name="panelID" select="$panelID" />
											        <xsl:with-param name="event" select="'config-displayavailfields'"/>
											        <xsl:with-param name="params">
											        	<xsl:text>null, ''</xsl:text>
											        </xsl:with-param>
										        </xsl:call-template>
					                    	</xsl:attribute>
                                        <input type="hidden" value="INFO/{./INFO/DENOMINATION}"/>
                                        
                                        <xsl:choose>
                                            <xsl:when test="./DESCRIPTIONS/DESCRIPTION/TITLE/text()">
                                                <xsl:value-of select="./DESCRIPTIONS/DESCRIPTION/TITLE"/>
                                            </xsl:when>
                                            <xsl:otherwise>
                                                <xsl:value-of select="./INFO/DENOMINATION"/>
                                            </xsl:otherwise>
                                        </xsl:choose>
                                    </li>
                                </xsl:if>
                            </xsl:for-each>
                        </ul>
                        <!-- dependency modules -->
                        <xsl:for-each select="$dependencyTypes">
                            <xsl:variable name="depType" select="TYPE"/>
                            <xsl:variable name="depInfo" select="$filterDisplay/RETURN/DEPENDENCIES/DEPENDENCY[@type=$depType]/INFO"/>
                            <xsl:variable name="depTargetModuleDenom" select="@to"/>
                            <xsl:variable name="depTargetModule" select="$modules[INFO/DENOMINATION=$depTargetModuleDenom]"/>
                            <xsl:variable name="depTargetModuleDesc">
                            	<xsl:apply-templates select="$depTargetModule" mode="element-label" />
                            </xsl:variable>

                            <ul class="connectedSortable fields-available" style="display:none;" title="{$depTargetModuleDesc}">
                                <xsl:attribute name="id">
                                    <xsl:text>fields-available-</xsl:text>
                                    <xsl:call-template name="replace-string">
                                        <xsl:with-param name="text"><xsl:value-of select="$depType"/></xsl:with-param>
                                        <xsl:with-param name="from">:</xsl:with-param>
                                        <xsl:with-param name="to">__</xsl:with-param>
                                    </xsl:call-template>
                                </xsl:attribute>
                                
								<li class="sortable-static"><xsl:apply-templates select="$depTargetModule" mode="element-label"/></li>
                                <xsl:for-each select="/RESPONSE/RESULTS[@name=concat('fields-', $depTargetModuleDenom)]/FIELD">
                                    <xsl:sort select="translate(DESCRIPTIONS/DESCRIPTION/TITLE, $xsltsl-str-upper, $xsltsl-str-lower)"/>
                                    <xsl:sort select="INFO/DENOMINATION"/>
									
                                    <xsl:if test="not($depInfo/*[current()/INFO/DENOMINATION=name()])">
                                        <li title="{$depType}" class="ui-state-highlight">
					                    	<xsl:attribute name="onmousedown">
											    <xsl:call-template name="triggerpanelevent">
											    	<xsl:with-param name="panelID" select="$panelID" />
											        <xsl:with-param name="event" select="'config-displayavailfields'"/>
											        <xsl:with-param name="params">
											        	<xsl:text>null, '</xsl:text>
											        	<xsl:value-of select="$depType" />
											        	<xsl:text>'</xsl:text>
											        </xsl:with-param>
										        </xsl:call-template>
					                    	</xsl:attribute>
                                            <input type="hidden" value='DEPENDENCY[@type="{$depType}"]/{./INFO/DENOMINATION}'/>

                                            <xsl:choose>
                                                <xsl:when test="./DESCRIPTIONS/DESCRIPTION/TITLE/text()">
                                                    <xsl:value-of select="./DESCRIPTIONS/DESCRIPTION/TITLE"/>
                                                </xsl:when>
                                                <xsl:otherwise>
                                                    <xsl:value-of select="./INFO/DENOMINATION"/>
                                                </xsl:otherwise>
                                            </xsl:choose>
                                        </li>
                                    </xsl:if>
                                </xsl:for-each>
                            </ul>
                        </xsl:for-each>
                        <!-- CATEGORIES -->
                        <ul class="connectedSortable fields-available" id="fields-available-categories" style="display:none;" title="Categories">
							<xsl:if test="not($filterDisplay/RETURN/CATEGORIES)">
                                <li title="" class="ui-state-highlight">
			                    	<xsl:attribute name="onmousedown">
									    <xsl:call-template name="triggerpanelevent">
									    	<xsl:with-param name="panelID" select="$panelID" />
									        <xsl:with-param name="event" select="'config-displayavailfields'"/>
									        <xsl:with-param name="params">
									        	<xsl:text>null, 'categories'</xsl:text>
									        </xsl:with-param>
								        </xsl:call-template>
			                    	</xsl:attribute>
                                    <input type="hidden" value="CATEGORIES"/>
                                    <em>
	                                    <xsl:text>CATEGORIES</xsl:text>
                                    </em>
                                </li>                                    
	                         </xsl:if>
                         </ul>
                    </div>
                </td>
            </tr>
        </table>
	</xsl:template>

	<xsl:template name="panel-js">
        <!-- AVAILABLE FIELDS CONTAINER : max. height -->
        $('#<xsl:value-of select="$panelID" />.panel').panel({
        	afterLayout : function(panelElem){
		       	var containerHeight = $(AppController).panelslider('getHeight');
		        containerHeight -= panelElem.panel('getNonBodyElemsHeight');
		        containerHeight -= panelElem.find('#topline').outerHeight(true);
		        containerHeight -= 20; // safety
		        panelElem.find('#container-available').height(containerHeight);
        	}
        });
        
        <!-- FUNCTIONS -->     
        function onAvailableReceived(event, ui)
        {
            //window.log('onAvailableReceived', event);
            //window.log(ui);
            var listElem = ui.item;
            var depType = listElem.attr('title');
            
            if (listElem.hasClass('subConnectedSortable')) // reception of the whole subgroup
            {
                listElem.after(listElem.children('li:not(.subGroupHeader)')).remove();

                // reset drag'n'drop connection
                var availableList = $('#fields-available-'+depType.replace(/:/, '__'));

                availableList.sortable('destroy');
                availableList.sortable({
                    connectWith: '.connectedSortable',
                    containment : '.columns-config'
                }).disableSelection();
            }
            else 
            {
                if (ui.sender.children('li:not(.subGroupHeader)').length == 0) // reception of the last subgroup item
                {
                    ui.sender.remove();

                    // reset drag'n'drop connection
                    var availableList = $('#fields-available-'+depType.replace(/:/, '__'));

                    availableList.sortable('destroy');
                    availableList.sortable({
                        connectWith: '.connectedSortable',
                        containment : '.columns-config'
                    }).disableSelection();
                }
            }
        }
        
        function onSelectedReceived(event, ui)
        {
            //window.log('onSelectedReceived', event);
            //window.log(ui);
            var listElem = ui.item;

            var depType = listElem.attr('title');                
            if (depType == '') // main module fields
            {
                return; // do nothing
            }

            var subGroupID = 'fields-subgroup-' + depType.replace(/:/, '__');
            var subGroupSelector = 'ul#'+subGroupID;

            var selList = $('#fields-selected');
            var subGroup = selList.find(subGroupSelector);
            if (subGroup.length == 0)
            {
                // create a new sugroup for this dependency
                var target = event.originalTarget;
                var moduleDesc = ui.sender.attr('title').toUpperCase();

				var panelSelector = '#<xsl:value-of select="$panelID" />.panel';				
                $(target).after('<ul id="'+subGroupID+'" class="subConnectedSortable" title="'+depType+'" onmousedown="$(\''+panelSelector+'\').trigger(\'config-displayavailfields\', [null, \''+depType+'\']);">' +
                                    '<li class="subGroupHeader">'+moduleDesc+'</li>'+
                                '</ul>');

                // set lists drag'n'drop connection
                ui.sender.sortable('destroy');
                ui.sender.sortable({
                    connectWith: subGroupSelector,
                    containment : '.columns-config'
                }).disableSelection();
                ui.sender.sortable({
                	receive : onAvailableReceived
                });

                subGroup = selList.find(subGroupSelector);

                subGroup.sortable({
                    connectWith: '#'+ui.sender.attr('id'),
                    items: 'li:not(.subGroupHeader)'
                }).disableSelection();
            }
            
            subGroup.append(listElem);
        }

        <!-- INIT jQuery SORTABLE -->        
        
        <!-- AVAILABLE FIELDS -->         
        // available fields : main module
        $('ul#fields-available').sortable({
            connectWith: '.connectedSortable',
            containment : '.columns-config',
            cancel: '.sortable-static'
        }).disableSelection();
        
        // available fields : categories
        $('ul#fields-available-categories').sortable({
            connectWith: '.connectedSortable',
            containment : '.columns-config',
            cancel: '.sortable-static'
        }).disableSelection();

        // available fields : dependency modules
        <xsl:for-each select="$dependencyTypes">
            <xsl:if test="not($filterDisplay/RETURN/DEPENDENCIES/DEPENDENCY[@type=TYPE])">
                <xsl:variable name="id">
                    <xsl:call-template name="replace-string">
                        <xsl:with-param name="text"><xsl:value-of select="./TYPE"/></xsl:with-param>
                        <xsl:with-param name="from">:</xsl:with-param>
                        <xsl:with-param name="to">__</xsl:with-param>
                    </xsl:call-template>
                </xsl:variable>
                $('ul#fields-available-<xsl:value-of select="$id"/>').sortable({
                    connectWith: '.connectedSortable',
                    containment : '.columns-config'
                }).disableSelection();
            </xsl:if>
        </xsl:for-each>
        
        <!-- SELECTED FIELDS -->         
        // selected fields (main module)
        $('ul#fields-selected').sortable({
            connectWith: '.connectedSortable',
            containment : '.columns-config'
        }).disableSelection();        
        $('ul#fields-selected').sortable({
        	receive : onSelectedReceived
       	});
       	
        // selected fields : dependency modules subgroups
        <xsl:for-each select="$filterDisplay/RETURN/DEPENDENCIES/DEPENDENCY">
            <xsl:variable name="id">
                <xsl:call-template name="replace-string">
                    <xsl:with-param name="text"><xsl:value-of select="./@type"/></xsl:with-param>
                    <xsl:with-param name="from">:</xsl:with-param>
                    <xsl:with-param name="to">__</xsl:with-param>
                </xsl:call-template>
            </xsl:variable>
            $('ul#fields-available-<xsl:value-of select="$id"/>').sortable({
                connectWith: '#fields-subgroup-<xsl:value-of select="$id"/>',
                containment : '.columns-config'
            }).disableSelection();
            $('ul#fields-available-<xsl:value-of select="$id"/>').sortable({
        		receive : onAvailableReceived
       		});

            $('ul#fields-selected').find('#fields-subgroup-<xsl:value-of select="$id"/>').sortable({
                connectWith: '#fields-available-<xsl:value-of select="$id"/>',
                items: 'li:not(.subGroupHeader)'
            }).disableSelection();
        </xsl:for-each>

        <!-- DISPLAY AVAILABLE FIELDS -->
        $('#<xsl:value-of select="$panelID"/>.panel').bind('config-displayavailfields', function(eventObject, srcElem, depType){
        	//window.log(arguments);
            if (srcElem == null) // via li onmousedown events
            {
                srcElem = $('#module-selector')
                if (srcElem.val() == depType) 
                {
                    return;
                }
                else
                {
                    srcElem.val(depType);
                }
            }

            // display chosen fields list
            $('#container-available').find('ul:visible').hide();
            if (depType == '')
            {
                $('#fields-available').show();
            }
            else if (depType == 'categories')
            {
	            $('#fields-available-categories').show();
            }
            else
            {
                depType = depType.replace(/:/, '__');
                $('#fields-available-'+depType).show();
            }
        });
    
        <!-- SAVE -->
        $('#<xsl:value-of select="$panelID"/>.panel').find('input#save-display-button').click(function(){
        	var panel = $('#<xsl:value-of select="$panelID"/>.panel');
        	
            var selection = [ ];
            panel.find('#fields-selected li:not(.subGroupHeader) input:hidden').each(function(){
                selection.push($(this).val());
            });

            var sort = panel.find('#display-config-form #sort-service').val() + '/' + panel.find('#display-config-form #sort-select').val();
            var order = panel.find('#display-config-form #sort-order').val();
            var display = panel.find('#display-config-form #paginate-display').val();
            
			var reportsIDs = []; 
            <xsl:for-each select="$defaultReports">reportsIDs.push(<xsl:value-of select="@ID" />);</xsl:for-each>


			var depsData = [];
			<xsl:for-each select="$dependencyTypes"><xsl:sort select="DENOMINATION/LABEL" />depsData.push({ type : '<xsl:value-of select="TYPE" />', module:'<xsl:value-of select="@to" />', moduledesc:'<xsl:apply-templates select="$modules[INFO/DENOMINATION=current()/@to]" mode="element-label"/>', searchdesc:'<xsl:value-of select="DENOMINATION/SEARCHLABEL" />' });</xsl:for-each>

            var filterConfig = {
            	ID				: '<xsl:value-of select="$defaultFilter/@ID"/>',
                columns 		: selection.join(','),
                sort    		: sort,
                order   		: order,
                display 		: display,
                module  		: '<xsl:value-of select="$targetModuleDenom"/>',
                label			: '<xsl:apply-templates select="$targetModule" mode="element-label"/>',
                reportsIDs		: reportsIDs.join(','),
                searchConfigID	: '<xsl:value-of select="$defaultSearchConfig/@ID"/>',
				depsData		: depsData
            };

	        var request = new AjaxRequest(
	            <xsl:value-of select="$panelID"/>,
	            AppController,
	            '<xsl:value-of select="$systemToolsURL" />filter/save-default.php',
	            'POST',
	            'json'
	        );
	        
	        request.setData(filterConfig);
	        
        	// error dialog and return errors in long msgs format
        	request.errorDialog(true, false);
        	request.internalErrorDialog(true, false);
        	// warnings as well
        	request.warningDialog(true, false);
	        	        
	        $('#<xsl:value-of select="$panelID"/>.panel').trigger('panel-displayloader', [true]);
        	
	        request.onSuccess(function(response){
	        	$('#<xsl:value-of select="$panelID"/>.panel').trigger('panel-displayloader', [false]);
	        	
				var statusDialog = new NotificationDialog('');	
				statusDialog.setTitle('<strong>Operation successful!</strong>');
				statusDialog.setStatusMessage('Configuration successfully saved.', 'Ok');
				statusDialog.show(1500);
	        }).onError(function(response){
	            $('#<xsl:value-of select="$panelID"/>.panel').trigger('panel-displayloader', [false]);
	        }).send();
    
			return true;
        });
	</xsl:template>
</xsl:stylesheet>
