<?xml version="1.0"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/officity/factory/modules/FieldDetails.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
    <xsl:import href="include.xsl"/>    
    <xsl:output encoding="UTF-8" method="xml" indent="no"/>
    <xsl:strip-space elements="*"/>
    
    <!-- parameters -->    
    <xsl:param name="fields" select="/RESPONSE/RESULTS[@name='fields']/FIELD"/>
    <xsl:param name="depentities" select="/RESPONSE/RESULTS[@name='dependencies']/DEPENDENCYENTITY"/>
  	<!--xsl:param name="descriptions" select="/RESPONSE/RESULTS[@name='descriptions']/DESCRIPTIONCONFIG"/-->
  	
    <xsl:param name="item" select="/RESPONSE/RESULTS[@name='item']/*[1]"/>
    <xsl:param name="itemInfo" select="$item/INFO"/>
    <xsl:param name="itemDeps" select="$item/DEPENDENCIES"/>
    <xsl:param name="itemDescs" select="$item/DESCRIPTIONS"/>
    <xsl:param name="module" select="/RESPONSE/URL/module"/>
    <xsl:param name="templateItem" select="/RESPONSE/RESULTS[@name='templateItem']/*[1]"/>
    
    <!-- optional -->
    <xsl:param name="dependency" select="/RESPONSE/URL/dependency"/>
    <xsl:param name="targetModule" select="/RESPONSE/URL/targetModule"/>
    <xsl:param name="targetID" select="/RESPONSE/URL/targetID"/>
    
    <xsl:param name="isSusheeField">
    	<xsl:apply-templates select="$item" mode="is-sushee-field"/>
    </xsl:param>
    
   	<xsl:template match="/RESPONSE">
    	<xsl:call-template name="panel-elementdetails">
    		<xsl:with-param name="element" select= "$item" />
    		<xsl:with-param name="tabsList">
				<xsl:text>details,Details;display,Display;code,Source code;</xsl:text>
    		</xsl:with-param>
    		 <xsl:with-param name="displayOverviewTab" select="false()" />
    		 <xsl:with-param name="displayAdminTab" select="true()" />
    		 <xsl:with-param name="deleteRight" select="$isSusheeField='false'" />
    	</xsl:call-template>
    </xsl:template>
    
    <!-- custom : tabs content -->
	<xsl:template name="panel-body-element-tabs-content">
		<xsl:param name="element" />
		<xsl:param name="newElement" />
		
		<!-- tab : details -->
  		<xsl:call-template name="element-tabform-create">
			<xsl:with-param name="denom" select="'details'" />
			<xsl:with-param name="element" select="$element" />
			<xsl:with-param name="content">
				<xsl:call-template name="element-tab-details">
					<xsl:with-param name="element" select="$element" />
				</xsl:call-template>
			</xsl:with-param>
		</xsl:call-template>
		
		<!-- tab : display -->
  		<xsl:call-template name="element-tabform-create">
			<xsl:with-param name="denom" select="'display'" />
			<xsl:with-param name="element" select="$element" />
			<xsl:with-param name="content">
				<xsl:call-template name="element-tab-display">
					<xsl:with-param name="element" select="$element" />
				</xsl:call-template>
			</xsl:with-param>
		</xsl:call-template>
		
		<!-- tab : source code -->
  		<xsl:call-template name="element-tabform-create">
			<xsl:with-param name="denom" select="'code'" />
			<xsl:with-param name="element" select="$element" />
			<xsl:with-param name="content">
				<xsl:call-template name="element-tab-code">
					<xsl:with-param name="element" select="$element" />
				</xsl:call-template>
			</xsl:with-param>
		</xsl:call-template>
	</xsl:template>
    
    <!-- custom : details tab -->
    <xsl:template name="element-tab-details">
        <xsl:param name="element" />    
           
		<xsl:call-template name="overview-line">
			<xsl:with-param name="label" select="'Module:'" />
			<xsl:with-param name="value" select="$element/INFO/MODULE" />
		</xsl:call-template>
		             	
		<xsl:choose>
			<xsl:when test="$isSusheeField='true'">
		       	<xsl:apply-templates select="$element/INFO/DENOMINATION" mode="overview-line" />
		       	<xsl:apply-templates select="$element/INFO/TYPE" mode="overview-line" />
		       	<xsl:apply-templates select="$element/INFO/LISTNAME" mode="overview-line">
		       		<xsl:with-param name="hidden" select="($element/INFO/TYPE!='list') and ($element/INFO/TYPE!='systemList') and ($element/INFO/TYPE!='enum')" />
		       	</xsl:apply-templates>
		       	<xsl:apply-templates select="$element/INFO/TARGETMODULE" mode="overview-line">
		       		<xsl:with-param name="hidden" select="$element/INFO/TYPE!='elementsList'" />
		       	</xsl:apply-templates>
		       	<xsl:apply-templates select="$element/INFO/TARGETFIELD" mode="overview-line">
		       		<xsl:with-param name="hidden" select="$element/INFO/TYPE!='elementsList'" />
		       	</xsl:apply-templates>
		       	<xsl:apply-templates select="$element/INFO/DEFAULTVALUE" mode="overview-line" />
			</xsl:when>
			<xsl:otherwise>
		       	<xsl:apply-templates select="$element/INFO/DENOMINATION" mode="form-info-line">
       				<xsl:with-param name="required" select="true()"  />
       			</xsl:apply-templates>
       	
				<xsl:call-template name="edit-types">
					<xsl:with-param name="element" select="$element" />
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
      	
       	<xsl:apply-templates select="$element/INFO/SEARCHABLE" mode="form-info-line">
       	</xsl:apply-templates>
       	
       	<xsl:apply-templates select="$element/INFO/DISPLAYABLE" mode="form-info-line">
       	</xsl:apply-templates>
       	
       	<xsl:apply-templates select="$element/INFO/DISPLAYLENGTH" mode="form-info-line">
	       	<xsl:with-param name="cssclass" select="'input-number-small'" />
	    	<xsl:with-param name="extraLabel">
	    		<em>Characters average</em>
	    	</xsl:with-param>
	    	<xsl:with-param name="topLabel" select="true()" />
       	</xsl:apply-templates>
       	 
       	<xsl:apply-templates select="$element" mode="form-info-line-submit" />
    </xsl:template>
    
    <xsl:template name="edit-types">
        <xsl:param name="element" />    
           
		<xsl:variable name="typeInputID">
			<xsl:call-template name="gen-info-input-ID">
				<xsl:with-param name="moduleName" select="'field'" />
				<xsl:with-param name="fieldName" select="'type'" />
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="typeInputName">
			<xsl:call-template name="gen-info-input-name">
				<xsl:with-param name="moduleName" select="'field'" />
				<xsl:with-param name="fieldName" select="'type'" />
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="listInputID">
			<xsl:call-template name="gen-info-input-ID">
				<xsl:with-param name="moduleName" select="'field'" />
				<xsl:with-param name="fieldName" select="'listname'" />
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="listInputName">
			<xsl:call-template name="gen-info-input-name">
				<xsl:with-param name="moduleName" select="'field'" />
				<xsl:with-param name="fieldName" select="'listname'" />
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="targetModuleInputID">
			<xsl:call-template name="gen-info-input-ID">
				<xsl:with-param name="moduleName" select="'field'" />
				<xsl:with-param name="fieldName" select="'targetmodule'" />
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="targetModuleInputName">
			<xsl:call-template name="gen-info-input-name">
				<xsl:with-param name="moduleName" select="'field'" />
				<xsl:with-param name="fieldName" select="'targetmodule'" />
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="targetFieldInputID">
			<xsl:call-template name="gen-info-input-ID">
				<xsl:with-param name="moduleName" select="'field'" />
				<xsl:with-param name="fieldName" select="'targetfield'" />
				<xsl:with-param name="type" select="'text'" />
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="targetFieldInputName">
			<xsl:call-template name="gen-info-input-name">
				<xsl:with-param name="moduleName" select="'field'" />
				<xsl:with-param name="fieldName" select="'targetfield'" />
				<xsl:with-param name="type" select="'text'" />
			</xsl:call-template>
		</xsl:variable>
		
       	<xsl:call-template name="form-info-line">
			<xsl:with-param name="label" select="'Type:'"  />
			<xsl:with-param name="input">
		        <select class="input-select" id="{$typeInputID}" name="{$typeInputName}">
		        	<xsl:attribute name="onchange">
		        		switch ($(this).val())
		        		{
		        			case 'enum':
		        			case 'list':
				        		// hide elements list
				        		$('#<xsl:value-of select="$panelID" />.panel').find('#<xsl:value-of select="$targetModuleInputID" />').val('<xsl:value-of select="$element/INFO/TARGETMODULE" />').closest('tr').hide();
				        		$('#<xsl:value-of select="$panelID" />.panel').find('#<xsl:value-of select="$targetFieldInputID" />').val('<xsl:value-of select="$element/INFO/TARGETFIELD" />').closest('tr').hide();
				        		
			        			var listElem = $('#<xsl:value-of select="$panelID" />.panel').find('#<xsl:value-of select="$listInputID" />');
			        			listElem.find('option.classicitem').show();
			        			listElem.find('option.sysitem').hide();
			        			<xsl:choose>
			        				<xsl:when test="($element/INFO/TYPE='list') or ($element/INFO/TYPE='enum')">
				        				listElem.val('<xsl:value-of select="$element/INFO/LISTNAME" />').closest('tr').show();
			        				</xsl:when>
									<xsl:otherwise>
										listElem.val('').closest('tr').show();
									</xsl:otherwise>
			        			</xsl:choose>	
			        			
			        			$('#<xsl:value-of select="$panelID" />.panel').find('#list-values').closest('tr').hide();
			        			break;
			        			
		        			case 'systemList':
				        		// hide elements list
				        		$('#<xsl:value-of select="$panelID" />.panel').find('#<xsl:value-of select="$targetModuleInputID" />').val('<xsl:value-of select="$element/INFO/TARGETMODULE" />').closest('tr').hide();
				        		$('#<xsl:value-of select="$panelID" />.panel').find('#<xsl:value-of select="$targetFieldInputID" />').val('<xsl:value-of select="$element/INFO/TARGETFIELD" />').closest('tr').hide();
				        		
			        			var listElem = $('#<xsl:value-of select="$panelID" />.panel').find('#<xsl:value-of select="$listInputID" />');
			        			listElem.find('option.sysitem').show();
			        			listElem.find('option.classicitem').hide();
			        			<xsl:choose>
			        				<xsl:when test="$element/INFO/TYPE='systemList'">
				        				listElem.val('<xsl:value-of select="$element/INFO/LISTNAME" />').closest('tr').show();
			        				</xsl:when>
									<xsl:otherwise>
										listElem.val('').closest('tr').show();
									</xsl:otherwise>
			        			</xsl:choose>
			        			
			        			$('#<xsl:value-of select="$panelID" />.panel').find('#list-values').closest('tr').hide();
		        				break;
		        				
		        			case 'elementsList':
		        				// hide classic list
			        			$('#<xsl:value-of select="$panelID" />.panel').find('#<xsl:value-of select="$listInputID" />').val('<xsl:value-of select="$element/INFO/LISTNAME" />').closest('tr').hide();
		        			
			        			$('#<xsl:value-of select="$panelID" />.panel').find('#<xsl:value-of select="$targetModuleInputID" />').val('<xsl:value-of select="$element/INFO/TARGETMODULE" />').closest('tr').show();
			        			$('#<xsl:value-of select="$panelID" />.panel').find('#<xsl:value-of select="$targetFieldInputID" />').val('<xsl:value-of select="$element/INFO/TARGETFIELD" />').closest('tr').show();
			        			
			        			$('#<xsl:value-of select="$panelID" />.panel').find('#list-values').closest('tr').hide();
		        				break;
		        				
	        				default:
			        			$('#<xsl:value-of select="$panelID" />.panel').find('#<xsl:value-of select="$listInputID" />').val('<xsl:value-of select="$element/INFO/LISTNAME" />').closest('tr').hide();
				        		$('#<xsl:value-of select="$panelID" />.panel').find('#<xsl:value-of select="$targetModuleInputID" />').val('<xsl:value-of select="$element/INFO/TARGETMODULE" />').closest('tr').hide();
				        		$('#<xsl:value-of select="$panelID" />.panel').find('#<xsl:value-of select="$targetFieldInputID" />').val('<xsl:value-of select="$element/INFO/TARGETFIELD" />').closest('tr').hide();
				        		
				        		$('#<xsl:value-of select="$panelID" />.panel').find('#list-values').closest('tr').hide();
	        					break;
		        		}
		        	</xsl:attribute>
		            <option value="">
		                <xsl:text>(Choose a type)</xsl:text>
		            </option>
		            <xsl:for-each select="/RESPONSE/RESULTS/LIST[@name='FieldTypes']/ITEM">
		                <xsl:sort select="@label" />
		                <option value="{@value}">
		                	<xsl:if test="@value=$element/INFO/TYPE">
		                		<xsl:attribute name="selected">selected</xsl:attribute>
		                	</xsl:if>
		                    <xsl:value-of select="@label"/>
		                </option>
		            </xsl:for-each>
		        </select>
			</xsl:with-param>
    	</xsl:call-template>

       	<xsl:call-template name="form-info-line">
			<xsl:with-param name="label" select="'List:'"  />
			<xsl:with-param name="input">
		        <select class="input-select" id="{$listInputID}" name="{$listInputName}">
		        	<xsl:attribute name="onchange">
		        		if ($(this).val() == 'new')
		        		{
		        			$('#<xsl:value-of select="$panelID" />.panel').find('#list-values').show().closest('tr').show();
	        			}
	        			else
	        			{
	        				$('#<xsl:value-of select="$panelID" />.panel').find('#list-values').show().closest('tr').hide();
	        			}
		        	</xsl:attribute>
		            <option value="">
		                <xsl:text>(Choose a list)</xsl:text>
		            </option>
		            <option value="new">
		                <xsl:text>Create a new list...</xsl:text>
		            </option>
		            <xsl:for-each select="/RESPONSE/RESULTS/LIST[@name!='']">
		                <xsl:sort select="@domain" />
		                <xsl:sort select="@name" />
		                <option value="{@name}" class="classicitem">
		                	<xsl:if test="@name=$element/INFO/LISTNAME">
		                		<xsl:attribute name="selected">selected</xsl:attribute>
		                	</xsl:if>
		                    <xsl:value-of select="@domain"/>
		                    <xsl:text> : </xsl:text>
		                    <xsl:apply-templates select="@name" mode="display-value"/>
		                </option>
		            </xsl:for-each>
		            <option value="Countries" class="sysitem">
	                	<xsl:if test="'Countries'=$element/INFO/LISTNAME">
	                		<xsl:attribute name="selected">selected</xsl:attribute>
	                	</xsl:if>
		                <xsl:text>Countries</xsl:text>
		            </option>
		            <option value="Languages" class="sysitem">
	                	<xsl:if test="'Languages'=$element/INFO/LISTNAME">
	                		<xsl:attribute name="selected">selected</xsl:attribute>
	                	</xsl:if>
		                <xsl:text>Languages</xsl:text>
		            </option>
		        </select>
			</xsl:with-param>
	    	<xsl:with-param name="hidden" select="($element/INFO/TYPE!='list') and ($element/INFO/TYPE!='systemList') and ($element/INFO/TYPE!='enum')" />
		</xsl:call-template>

       	<xsl:call-template name="form-info-line">
			<xsl:with-param name="label" select="'List values:'"  />
			<xsl:with-param name="input">
				<textarea class="input-textarea" id="list-values" name="list-values">
					<xsl:value-of select="translate(/RESPONSE/URL/targetModuleDenom, ':', '/')" />
					<xsl:text>,listname</xsl:text>
					<xsl:text>,shared</xsl:text>
					<xsl:text>,label</xsl:text>
					<xsl:text>,value</xsl:text>
				</textarea>
			</xsl:with-param>
	    	<xsl:with-param name="extraLabel">
	    		Insert CSV list values according to the following format:<br />
	    		[domain],[list name],[language ID],[label],[value]
	    	</xsl:with-param>
	    	<xsl:with-param name="topLabel" select="true()" />
	    	<xsl:with-param name="hidden" select="true()" /> 
		</xsl:call-template>
		
       	<xsl:call-template name="form-info-line">
			<xsl:with-param name="label" select="'Target Module:'"  />
			<xsl:with-param name="input">
		        <select class="input-select" id="{$targetModuleInputID}" name="{$targetModuleInputName}">
		            <option value="">
		                <xsl:text>(Choose a module)</xsl:text>
		            </option>
		            <xsl:for-each select="/RESPONSE/RESULTS[@name='modules']/MODULE">
		                <xsl:sort select="INFO/DENOMINATION" />
		                <option value="{INFO/DENOMINATION}">
		                	<xsl:if test="INFO/DENOMINATION=$element/INFO/TARGETMODULE">
		                		<xsl:attribute name="selected">selected</xsl:attribute>
		                	</xsl:if>
		                    <xsl:value-of select="INFO/DENOMINATION"/>
		                </option>
		            </xsl:for-each>
		        </select>
			</xsl:with-param>
	    	<xsl:with-param name="hidden" select="$element/INFO/TYPE!='elementsList'" />
		</xsl:call-template>
       	
       	<xsl:apply-templates select="$element/INFO/TARGETFIELD" mode="form-info-line">
	       	<xsl:with-param name="hidden" select="$element/INFO/TYPE!='elementsList'" />
       	</xsl:apply-templates>

       	<xsl:apply-templates select="$element/INFO/DEFAULTVALUE" mode="form-info-line">
       	</xsl:apply-templates>
    </xsl:template>
    
    <!-- custom : display tab -->
    <xsl:template name="element-tab-display">
        <xsl:param name="element" />  
        
	  	<xsl:call-template name="form-desc-line">
	  		<xsl:with-param name="moduleName" select="name($element)" />
	  		<xsl:with-param name="fieldName" select="'TITLE'" />
		    <xsl:with-param name="label" select="'Label: '" />
		    <xsl:with-param name="type" select="'text'" />
		    <xsl:with-param name="languageID" select="'shared'" />
		    <xsl:with-param name="inputValue" select="$element/DESCRIPTIONS/DESCRIPTION[@languageID='shared']/TITLE" />
	   </xsl:call-template>
	  	<xsl:call-template name="form-desc-line">
	  		<xsl:with-param name="moduleName" select="name($element)" />
	  		<xsl:with-param name="fieldName" select="'SUMMARY'" />
		    <xsl:with-param name="label" select="'Abbreviation: '" />
		    <xsl:with-param name="type" select="'text'" />
	     	<xsl:with-param name="languageID" select="'shared'" />
	     	<xsl:with-param name="inputValue" select="$element/DESCRIPTIONS/DESCRIPTION[@languageID='shared']/SUMMARY" />
	    </xsl:call-template>
       	
       	<xsl:apply-templates select="$element" mode="form-desc-line-submit" />
    </xsl:template>
    
    <!-- custom : code tab -->
    <xsl:template name="element-tab-code">
        <xsl:param name="element" />  
        
        <xsl:call-template name="form-line">
        	<xsl:with-param name="content">
        		<xsl:text>Copy and paste the following XSL code in your stylesheet to add a line that will display the field name and value of the element:</xsl:text>
        	</xsl:with-param>
        </xsl:call-template>
        <xsl:call-template name="form-empty-line" />
        
	  	<xsl:call-template name="form-info-line">
		    <xsl:with-param name="label" select="'Overview line code: '" />
		    <xsl:with-param name="input">
		    	<textarea class="input-textarea">
		    		<xsl:apply-templates select="/RESPONSE/RESULTS[@name='sourceXSLOverview']/node()" mode="multiline" />
		    	</textarea>
		    </xsl:with-param>
	    </xsl:call-template>
	    <xsl:call-template name="form-empty-line" />
	    
        <xsl:call-template name="form-line">
        	<xsl:with-param name="content">
        		<xsl:text>The following XSL code will add a form line to display the field name and an input to update the element's field value:</xsl:text>
        	</xsl:with-param>
        </xsl:call-template>
        <xsl:call-template name="form-empty-line" />
        
        <xsl:call-template name="form-info-line">
		    <xsl:with-param name="label" select="'Input line code: '" />
		    <xsl:with-param name="input">
		    	<textarea class="input-textarea">
		    		<xsl:apply-templates select="/RESPONSE/RESULTS[@name='sourceXSLInput']/node()" mode="multiline" />
		    	</textarea>
		    </xsl:with-param>
	   </xsl:call-template>
    </xsl:template>
    
    <!-- custom : default navigation items -->
    <xsl:template name="panel-block-details-nav-element">
    	<xsl:param name="element" />
    	
		<xsl:call-template name="navigationdetailsitem">
			<xsl:with-param name="title" select="'Module'"/>
			<xsl:with-param name="panelURI" select="'modules/ModuleDetails'"/>
            <xsl:with-param name="cssclass">first</xsl:with-param>
			<xsl:with-param name="params">
				<xsl:text>denomination:'</xsl:text>
				<xsl:value-of select="$element/INFO/MODULE" />
				<xsl:text>'</xsl:text>
			</xsl:with-param>
			<xsl:with-param name="icon">
			</xsl:with-param> 
		</xsl:call-template>
		<xsl:if test="$element/INFO/TARGETMODULE/text()">
			<xsl:call-template name="navigationdetailsitem">
				<xsl:with-param name="title" select="'Target Module'"/>
				<xsl:with-param name="panelURI" select="'modules/ModuleDetails'"/>
				<xsl:with-param name="params">
					<xsl:text>denomination:'</xsl:text>
					<xsl:value-of select="$element/INFO/TARGETMODULE" />
					<xsl:text>'</xsl:text>
				</xsl:with-param>
				<xsl:with-param name="icon">
				</xsl:with-param> 
			</xsl:call-template>
		</xsl:if>
		<xsl:if test="$element/INFO/TYPE='list'">
			<xsl:call-template name="navigationdetailsitem">
				<xsl:with-param name="title" select="'List'"/>
				<xsl:with-param name="panelURI" select="'../../system/tools/list/Values'"/>
				<xsl:with-param name="params">
					<xsl:text>list:'</xsl:text>
					<xsl:value-of select="$element/INFO/LISTNAME" />
					<xsl:text>'</xsl:text>
					<xsl:text>,domain:'</xsl:text>
					<xsl:value-of select="//LIST[@name=$element/INFO/LISTNAME]/@domain" />
					<xsl:text>'</xsl:text>
				</xsl:with-param>
				<xsl:with-param name="icon">
				</xsl:with-param> 
			</xsl:call-template>
		</xsl:if>
        <xsl:call-template name="new-followup">
            <xsl:with-param name="title">Follow-up</xsl:with-param>
            <xsl:with-param name="element" select="$element" />
        </xsl:call-template>
		<xsl:call-template name="history-list">
			<xsl:with-param name="title">History</xsl:with-param>
			<xsl:with-param name="element" select="$element" />
			<xsl:with-param name="cssclass">last</xsl:with-param>
		</xsl:call-template>		
    </xsl:template>
</xsl:stylesheet>