<?xml version="1.0"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/officity/factory/modules/ModuleNew.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
    <xsl:import href="include.xsl"/>    
    <xsl:output encoding="UTF-8" method="xml" indent="no"/>
    <xsl:strip-space elements="*"/>
    
    <!-- parameters -->
    <xsl:param name="fields" select="/RESPONSE/RESULTS[@name='fields']/FIELD"/>
    <xsl:param name="item" select="/RESPONSE/RESULTS[@name='item']/*[1]"/>
    <xsl:param name="module" select="/RESPONSE/URL/module"/>
    
    <!-- optional -->
    <xsl:param name="dependency" select="/RESPONSE/URL/dependency"/>
    <xsl:param name="targetModule" select="/RESPONSE/URL/targetModule"/>
    <xsl:param name="targetID" select="/RESPONSE/URL/targetID"/>
    
   	<xsl:template match="/RESPONSE">
    	<xsl:call-template name="panel-newelement">
    		<xsl:with-param name="element" select= "$item" />
    		<xsl:with-param name="title" select= "'New Module'" />
    		<xsl:with-param name="titlecssclass" select= "'module'" />
    		<xsl:with-param name="tabsList" select= "'info,Details;'" />
    		<!--xsl:with-param name="displayNavDetails" select="true()" /-->
    	</xsl:call-template>
    </xsl:template>
    
    <!-- custom : info form -->
    <xsl:template name="element-tab-info">
        <xsl:param name="element" />  
       	<xsl:variable name="editorInputName">
			<xsl:call-template name="gen-dep-input-name">
				<xsl:with-param name="dependencyType" select="'officity:moduleNamespaces'" />
				<xsl:with-param name="moduleName" select="'namespace'" />
				<xsl:with-param name="serviceName" select="'info'" />
				<xsl:with-param name="fieldName" select="'ID'" />
				<xsl:with-param name="type" select="'int'"/>
			</xsl:call-template>
       	</xsl:variable> 
 
     	<xsl:call-template name="form-info-line">
       		<xsl:with-param name="label" select="'*Editor:'" />
	    	<xsl:with-param name="input">
                <select name="{$editorInputName}" class="input-select required">
                	<xsl:attribute name="onchange">
                		var namespaces = [];
                		<xsl:for-each select="/RESPONSE/RESULTS[@name='editors']/*">
                			namespaces[<xsl:value-of select="@ID" />] = '<xsl:value-of select="INFO/NAMESPACE" />';
                		</xsl:for-each>
                		var denomElemID = <xsl:text>'</xsl:text>
           					<xsl:apply-templates select="$element/INFO/DENOMINATION" mode="gen-info-input-ID" />
                		<xsl:text>';</xsl:text>
                		var denomElem = $('#<xsl:value-of select="$panelID" />.panel').find('#'+denomElemID);
                		var denom = trim(denomElem.val());
                		var denomSlices = denom.split(':');
                		if (denomSlices[0] != denom)
                		{
                			denom = denomSlices[1];
                		}
                		denomElem.val(namespaces[$(this).val()]+':'+denom);
               			
                	</xsl:attribute>
                    <option value="">
                        <xsl:text>(Choose an editor)</xsl:text>
                    </option>
                    <xsl:for-each select="/RESPONSE/RESULTS[@name='editors']/*">
                        <xsl:sort select="INFO/EDITOR" />
                        <option value="{@ID}">
                            <xsl:apply-templates select="." mode="element-label" />
                        </option>
                    </xsl:for-each>
                </select>
	    	</xsl:with-param> 
	    	<xsl:with-param name="extraLabel">
	    		<xsl:text>Link your module to an existing Editor. By doing so, we can avoid collision with other Editors' modules.</xsl:text>
	    	</xsl:with-param>
	    	<xsl:with-param name="topLabel" select="true()" />
    	</xsl:call-template>
    	
       	<xsl:apply-templates select="$element/INFO/DENOMINATION" mode="form-info-line">
       		<xsl:with-param name="inputValue" select="' '"  />
       		<xsl:with-param name="required" select="true()"  />
	    	<xsl:with-param name="extraLabel">
	    		<xsl:text> Technical name of your module. (Spaces and other special characters will be removed.)</xsl:text>
	    	</xsl:with-param>
	    	<xsl:with-param name="topLabel" select="true()" />
       	</xsl:apply-templates>
       	
		<xsl:variable name="extendInputID">
			<xsl:call-template name="gen-info-input-ID">
				<xsl:with-param name="moduleName" select="'module'" />
				<xsl:with-param name="fieldName" select="'extends'" />
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="extendInputName">
			<xsl:call-template name="gen-info-input-name">
				<xsl:with-param name="moduleName" select="'module'" />
				<xsl:with-param name="fieldName" select="'extends'" />
			</xsl:call-template>
		</xsl:variable>
		
       	<xsl:call-template name="form-info-line">
			<xsl:with-param name="label" select="'Type:'"  />
			<xsl:with-param name="input">
		        <select class="input-select" id="module-type" name="">
		        	<xsl:attribute name="onchange">
		        		if ($(this).val() == 'extends')
		        		{
		        			$('#<xsl:value-of select="$panelID" />.panel').find('#<xsl:value-of select="$extendInputID" />').closest('tr').show();
		        		}
		        		else
		        		{
		        			 $('#<xsl:value-of select="$panelID" />.panel').find('#<xsl:value-of select="$extendInputID" />').val('').closest('tr').hide();
		        		}
		        	</xsl:attribute>
		            <xsl:for-each select="/RESPONSE/RESULTS/LIST[@name='ModuleTypes']/ITEM">
		                <xsl:sort select="@label" />
		                <option value="{@value}">
		                    <xsl:value-of select="@label"/>
		                </option>
		            </xsl:for-each>
		        </select>
			</xsl:with-param>
	    	<xsl:with-param name="extraLabel">
	    		<xsl:text>You can either create a brand new module or enrich an existing one.</xsl:text>
	    	</xsl:with-param>
	    	<xsl:with-param name="topLabel" select="true()" />
		</xsl:call-template>
       	<xsl:apply-templates select="$element/INFO/EXTENDS" mode="form-info-line">
			<xsl:with-param name="label" select="'Extends:'"  />
			<xsl:with-param name="input">
		        <select class="input-select" id="{$extendInputID}" name="{$extendInputName}">
		            <option value="">
		                <xsl:text>(Choose a module)</xsl:text>
		            </option>
		            <xsl:for-each select="/RESPONSE/RESULTS[@name='modules']/MODULE">
		                <xsl:sort select="INFO/DENOMINATION" />
		                <option value="{@ID}">
		                    <xsl:value-of select="INFO/DENOMINATION"/>
		                </option>
		            </xsl:for-each>
		        </select>
			</xsl:with-param>
			<xsl:with-param name="hidden" select="true()"  />
	    	<xsl:with-param name="topLabel" select="true()" />
       	</xsl:apply-templates>
       	
       	<xsl:apply-templates select="$element/INFO/TABLENAME" mode="form-info-line">
	       	<xsl:with-param name="inputValue" select="' '"  />
	       	<xsl:with-param name="required" select="true()"  />
	    	<xsl:with-param name="extraLabel">
	    		<xsl:text> Database table associated to your module.</xsl:text>
	    	</xsl:with-param>
	    	<xsl:with-param name="topLabel" select="true()" />
       	</xsl:apply-templates> 
       	
       	<xsl:apply-templates select="$element/INFO/ADVANCEDSECURITY" mode="form-info-line">
	    	<xsl:with-param name="extraLabel">
	    		<br />
				<xsl:text>By default everyone can manipulate your module elements. If this is not what you want, check this.</xsl:text>
	    	</xsl:with-param>
	    	<xsl:with-param name="topLabel" select="true()" />
       	</xsl:apply-templates> 
       	
	  	<xsl:call-template name="form-desc-line">
	  		<xsl:with-param name="moduleName" select="name($element)" />
	  		<xsl:with-param name="fieldName" select="'TITLE'" />
		    <xsl:with-param name="label" select="'Label: '" />
		    <xsl:with-param name="type" select="'text'" />
		    <xsl:with-param name="languageID" select="'shared'" />
		    <xsl:with-param name="inputValue" select="$element/DESCRIPTIONS/DESCRIPTION[@languageID='shared']/TITLE" />
	    	<xsl:with-param name="extraLabel">
				<xsl:text>Give a human-friendly name to your module that can be used in search results or reports for example.</xsl:text>
	    	</xsl:with-param>
	    	<xsl:with-param name="topLabel" select="true()" />
	   </xsl:call-template>
	   
	  	<xsl:call-template name="form-desc-line">
	  		<xsl:with-param name="moduleName" select="name($element)" />
	  		<xsl:with-param name="fieldName" select="'HEADER'" />
		    <xsl:with-param name="label" select="'Plural form: '" />
		    <xsl:with-param name="type" select="'text'" />
		    <xsl:with-param name="languageID" select="'shared'" />
		    <xsl:with-param name="inputValue" select="$element/DESCRIPTIONS/DESCRIPTION[@languageID='shared']/HEADER" />
		    <xsl:with-param name="required" select="true()" />
	    	<xsl:with-param name="extraLabel">
				<xsl:text>Same as above but in its plural form.</xsl:text>
	    	</xsl:with-param>
	    	<xsl:with-param name="topLabel" select="true()" />
	    </xsl:call-template>
       	 
       	<xsl:apply-templates select="$element" mode="form-info-line-submit">
       		<xsl:with-param name="buttonLabel" select="'Create'"/>
      		<xsl:with-param name="createAndNew" select="true()" />
       	</xsl:apply-templates>
    </xsl:template>
    
    <!-- custom : default navigation items -->
    <!--xsl:template name="panel-block-details-nav-element">
    	<xsl:param name="element" />
    	
		<xsl:call-template name="navigationdetailsitem">
			<xsl:with-param name="title" select="'Publishers'"/>
			<xsl:with-param name="panelURI" select="'factory/modules/Help'"/>
            <xsl:with-param name="cssclass">first last</xsl:with-param>
			<xsl:with-param name="params">
			</xsl:with-param>
			<xsl:with-param name="icon">
				<xsl:text>../system/images/icons/help-16.png</xsl:text>
			</xsl:with-param> 
		</xsl:call-template>		
    </xsl:template-->
</xsl:stylesheet>