<?xml version="1.0"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/officity/factory/namespaces/Details.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
    <xsl:import href="include.xsl"/>    
    <xsl:output encoding="UTF-8" method="xml" indent="no"/>
    <xsl:strip-space elements="*"/>
    
    <!-- parameters -->
    <xsl:param name="fields" select="/RESPONSE/RESULTS[@name='fields']/FIELD"/>
    <xsl:param name="depentities" select="/RESPONSE/RESULTS[@name='dependencies']/DEPENDENCYENTITY"/>
  	<!--xsl:param name="descriptions" select="/RESPONSE/RESULTS[@name='descriptions']/DESCRIPTIONCONFIG"/-->
  	
    <xsl:param name="item" select="/RESPONSE/RESULTS[@name='item']/*[1]"/>
    <xsl:param name="itemInfo" select="$item/INFO"/>
    <xsl:param name="itemDeps" select="$item/DEPENDENCIES"/>
    <xsl:param name="itemDescs" select="$item/DESCRIPTIONS"/>
    <xsl:param name="module" select="/RESPONSE/URL/module"/>
    
    <!-- optional -->
    <xsl:param name="dependency" select="/RESPONSE/URL/dependency"/>
    <xsl:param name="targetModule" select="/RESPONSE/URL/targetModule"/>
    <xsl:param name="targetID" select="/RESPONSE/URL/targetID"/>
    
   	<xsl:template match="/RESPONSE">
    	<xsl:call-template name="panel-elementdetails">
    		<xsl:with-param name="element" select= "$item" />
    		<xsl:with-param name="tabsList">
				<xsl:text>details,Details;</xsl:text>
    		</xsl:with-param>
    		 <xsl:with-param name="displayOverviewTab" select="false()" />
    		 <xsl:with-param name="displayAdminTab" select="true()" />
    		 <xsl:with-param name="deleteRight" select="$item/INFO/ISLOCKED=0" />
    		 <xsl:with-param name="deleteConfirm" select="true()"/>
    		 <xsl:with-param name="deleteConfirmText">
           		<p>
            		<br />                
					<xsl:text>By deleting this namespace, you will also </xsl:text>
					<strong>delete all related folders</strong>
					<xsl:text>.</xsl:text>
					<br /><br />
					<xsl:text>All related objects (modules, processors, etc.) will have to be manually removed from the database.</xsl:text>
					<br /><br />
					<strong>Are you sure?</strong>
                    <br/><br /><br />
                </p>
    		 </xsl:with-param>
    	</xsl:call-template>
	</xsl:template>
	
    <!-- custom : tabs content -->
	<xsl:template name="panel-body-element-tabs-content">
		<xsl:param name="element" />
		<xsl:param name="newElement" />
		
		<!-- tab : details -->
  		<xsl:call-template name="element-tabform-create">
			<xsl:with-param name="denom" select="'details'" />
			<xsl:with-param name="element" select="$element" />
			<xsl:with-param name="content">
				<xsl:call-template name="element-tab-details">
					<xsl:with-param name="element" select="$element" />
				</xsl:call-template>
			</xsl:with-param>
		</xsl:call-template>
	</xsl:template>
    
    <!-- custom : details tab -->
    <xsl:template name="element-tab-details">
        <xsl:param name="element" />    

       	<xsl:apply-templates select="$element/INFO/EDITOR" mode="form-info-line">
       		<xsl:with-param name="label" select="'Editor name: '" />
       	</xsl:apply-templates>            
       	<xsl:apply-templates select="$element/INFO/NAMESPACE" mode="overview-line" />
       	<xsl:apply-templates select="$element/INFO/URL" mode="form-info-line">
       		<xsl:with-param name="required" select="true()"  />
       	</xsl:apply-templates>
       	<xsl:apply-templates select="$element/INFO/ICON" mode="form-info-line">
       		<xsl:with-param name="label" select="'Icon path (relative to this editor): '" />
       	</xsl:apply-templates>          
       	<xsl:apply-templates select="$element/INFO/REGISTERED" mode="overview-line" />     
       	 
       	<xsl:apply-templates select="$element" mode="form-info-line-submit" />
    </xsl:template>
    
    <!-- custom : default navigation items -->
    <xsl:template name="panel-block-details-nav-element">
    	<xsl:param name="element" />
    	
		<!--xsl:call-template name="navigationdetailsitem">
			<xsl:with-param name="title" select="'Publishers'"/>
			<xsl:with-param name="panelURI" select="'publishers/Index'"/>
            <xsl:with-param name="cssclass">first</xsl:with-param>
			<xsl:with-param name="params">
				<xsl:text>namespace:'</xsl:text>
				<xsl:value-of select="$element/INFO/NAMESPACE" />
				<xsl:text>'</xsl:text>
			</xsl:with-param>
			<xsl:with-param name="icon">
				<xsl:text>../system/images/icons/publish/publishers.png</xsl:text>
			</xsl:with-param> 
		</xsl:call-template--> 
		<xsl:call-template name="navigationdetailsitem">
			<xsl:with-param name="title" select="'Applications'"/>
			<xsl:with-param name="panelURI" select="'applications/Index'"/>
			<xsl:with-param name="params">
				<xsl:text>namespaceID:'</xsl:text>
				<xsl:value-of select="$element/@ID" />
				<xsl:text>'</xsl:text>
			</xsl:with-param>
			<xsl:with-param name="icon">
				<xsl:text>../system/images/icons/applications/applications.png</xsl:text>
			</xsl:with-param> 
			<xsl:with-param name="cssclass">first</xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name="navigationdetailsitem">
			<xsl:with-param name="title" select="'Modules'"/>
			<xsl:with-param name="panelURI" select="'modules/ModulesBrowse'"/>
			<xsl:with-param name="params">
				<xsl:text>namespaceID:'</xsl:text>
				<xsl:value-of select="$element/@ID" />
				<xsl:text>'</xsl:text>
			</xsl:with-param>
			<xsl:with-param name="icon">
				<xsl:text>../system/images/icons/modules/module-16.png</xsl:text>
			</xsl:with-param> 
			<xsl:with-param name="cssclass">first</xsl:with-param>
		</xsl:call-template>
        <xsl:call-template name="new-followup">
            <xsl:with-param name="title">Follow-up</xsl:with-param>
            <xsl:with-param name="element" select="$element" />
        </xsl:call-template>
		<xsl:call-template name="history-list">
			<xsl:with-param name="title">History</xsl:with-param>
			<xsl:with-param name="element" select="$element" />
			<xsl:with-param name="cssclass">last</xsl:with-param>
		</xsl:call-template>		
    </xsl:template>
</xsl:stylesheet>