<?xml version="1.0"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/officity/lib/documents/FileDetails.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
	<xsl:import href="include.xsl"/>	
	<xsl:output encoding="UTF-8" method="xml" indent="no"/>
	<xsl:strip-space elements="*"/>
	
	<!-- parameters -->
	<xsl:param name="fields" select="/RESPONSE/RESULTS[@name='fields']/FIELD"/>
	<xsl:param name="depentities" select="/RESPONSE/RESULTS[@name='dependencies']/DEPENDENCYENTITY"/>
  	<!--xsl:param name="descriptions" select="/RESPONSE/RESULTS[@name='descriptions']/DESCRIPTIONCONFIG"/-->
	<xsl:param name="item" select="/RESPONSE/RESULTS[@name='item']/*[1]"/>
	<xsl:param name="itemInfo" select="$item/INFO"/>
	<xsl:param name="itemDeps" select="$item/DEPENDENCIES"/>
	<xsl:param name="itemDescs" select="$item/DESCRIPTIONS"/>
	<xsl:param name="module" select="/RESPONSE/URL/module"/>
	<xsl:param name="categories" select="/RESPONSE/RESULTS/CATEGORY"/>
	
	<!-- optional -->
	<xsl:param name="dependency" select="/RESPONSE/URL/dependency"/>
	<xsl:param name="targetModule" select="/RESPONSE/URL/targetModule"/>
	<xsl:param name="targetID" select="/RESPONSE/URL/targetID"/>
	
	<!-- IDs -->
	<xsl:param name="newVersionFormID">
		<xsl:call-template name="gen-tabID">
			<xsl:with-param name="denom" select="'newversion'" />
		</xsl:call-template>
	</xsl:param>
	
   	<xsl:template match="/RESPONSE">
		<xsl:call-template name="panel-elementdetails">
			<xsl:with-param name="element" select= "$item" />
			<xsl:with-param name="tabsList">
				<xsl:text>info,Info;</xsl:text>
			</xsl:with-param>
			 <xsl:with-param name="displayOverviewTab" select="true()" />
			 <xsl:with-param name="displayAdminTab" select="true()" />
			 <xsl:with-param name="deleteRight" select="false()" />
		</xsl:call-template>
	</xsl:template>

    <!-- no preview -->
    <xsl:template name="panel-block-details-preview-element">
    </xsl:template>

	<!-- custom : tabs content -->
	<xsl:template name="panel-body-element-tabs-content">
		<xsl:param name="element" />
		<xsl:param name="newElement" />

		<!-- tab : info -->
  		<xsl:call-template name="element-tabform-create">
			<xsl:with-param name="denom" select="'info'" />
			<xsl:with-param name="element" select="$element" />
			<xsl:with-param name="content">
				<xsl:call-template name="element-tab-info">
					<xsl:with-param name="element" select="$element" />
				</xsl:call-template>
			</xsl:with-param>
		</xsl:call-template>
	</xsl:template>
	
	<!-- custom : overview -->
	<xsl:template name="element-tab-overview">
		<xsl:param name="element" />  
		<xsl:param name="legend" />  
		
		<table width="100%">
			<tr>
				<td valign="top">
					<xsl:apply-templates select="$element" mode="overview-details" />
				</td>
				<td valign="top" align="right">					
   					<xsl:apply-templates select="$element" mode="overview-preview" />
				</td>
			</tr>
		</table>
		<div class="libitem-actions">
			<a href="{$systemToolsURL}file_download.php?target={$element/INFO/PATH}" title="Download" class="action download">
				<xsltext>Download</xsltext>
	   		</a>
			<a href="{$systemToolsURL}file_download.php?target={$element/INFO/PATH}&amp;zip=true" title="Compress" class="action compress">
				<xsltext>Compress &amp; download</xsltext>
	   		</a>
			<!--a href="#" title="Copy link" class="action copylink">
				<xsl:attribute name="onclick">
				</xsl:attribute>
				<xsltext>Copy link</xsltext>
	   		</a-->
			<xsl:apply-templates select="$element" mode="trash-action"/>
	   		<xsl:call-template name="breaker" />
		</div>
		<xsl:if test="$element/INFO/TRASHED='no'">
			<div class="libitem-operations">
				<h3 id="new-version-title">New Version</h3>
				
				<xsl:call-template name="element-tabform-create">
					<xsl:with-param name="denom" select="'newversion'"/>
					<xsl:with-param name="element" select="$element" />
					<xsl:with-param name="hiddenValues" select="false()"/>
					<xsl:with-param name="content">
						<input type="hidden" name="ID" value="{$element/@ID}" />					
						<input type="hidden" name="version-number" value="{number($element/DEPENDENCIES/DEPENDENCY[@type='officity:versions']/@hits)+1}" />
											
	   					<xsl:call-template name="form-empty-line" />
	   					<xsl:apply-templates select="$element/INFO/PATH" mode="form-info-line">
	   						<xsl:with-param name="label" select="''" />
	   						<xsl:with-param name="required" select="true()" />
	   					</xsl:apply-templates>
	 					<xsl:call-template name="form-empty-line" />
	 					
	 					<xsl:call-template name="form-info-line">
	 						<xsl:with-param name="label" select="''" />
	 						<xsl:with-param name="input">
	   							<textarea id="version-notes" name="version-notes" class="input-textarea" default-value="Version notes..."></textarea>
	  						</xsl:with-param>
	   					</xsl:call-template>
	   					<xsl:call-template name="form-empty-line" />
	   					
	   					<xsl:call-template name="form-info-line-submit">
	   						<xsl:with-param name="buttonLabel" select="'New version'" />
	   					</xsl:call-template>
					</xsl:with-param>
				</xsl:call-template>
			</div>
		</xsl:if>
 	</xsl:template>   	

	<xsl:template match="OFFICITY:LIBITEM" mode="overview-details">
		<table class="fields">			
			<xsl:apply-templates select="INFO/FILENAME" mode="overview-line" />
			<xsl:apply-templates select="INFO/SIZE" mode="overview-line">
				<xsl:with-param name="value">
					<xsl:value-of select="INFO/SIZEHUMAN" />
					<xsl:text> (</xsl:text>
					<xsl:value-of select="INFO/SIZE" />
					<xsl:text> bytes)</xsl:text>
				</xsl:with-param>
			</xsl:apply-templates>
			<xsl:apply-templates select="INFO/CREATIONDATE" mode="overview-line" />
			<xsl:call-template name="overview-line">
				<xsl:with-param name="label" select="'Created by:'" />
				<xsl:with-param name="value">
					<xsl:apply-templates select="INFO/CREATOR/CONTACT" mode="element-label"/>
				</xsl:with-param>
			</xsl:call-template>
			<xsl:apply-templates select="INFO/MODIFICATIONDATE" mode="overview-line" />
			<xsl:call-template name="overview-line">
				<xsl:with-param name="label" select="'Modified by:'" />
				<xsl:with-param name="value">
					<xsl:apply-templates select="INFO/MODIFIER/CONTACT" mode="element-label"/>
				</xsl:with-param>
			</xsl:call-template>
			<xsl:apply-templates select="INFO/KIND" mode="overview-line" />
			<xsl:call-template name="form-empty-line" />
		</table>
	 </xsl:template>
	 
	 <xsl:template match="OFFICITY:LIBITEM" mode="overview-preview">
	 </xsl:template>
	 
    <xsl:template match="OFFICITY:LIBITEM[INFO/KIND='audio']" mode="overview-preview">
    	<div class="file-container">
    		<div id="mediaplayer-{$panelID}" />
    	</div>
    	<script type="text/javascript">
	 		<xsl:call-template name="js-embed-mediaplayer">
	    		<xsl:with-param name="file" select="INFO/PATH" />
	    		<xsl:with-param name="containerID" select="concat('mediaplayer-', $panelID)" />
		    	<xsl:with-param name="width" select="16" />
	    		<xsl:with-param name="height" select="20" />
	    		<xsl:with-param name="params">
	    			<!--xsl:text>controlbar:'none'</xsl:text-->
	    		</xsl:with-param>
	    	</xsl:call-template>
    	</script>
    </xsl:template>
    
    <xsl:template match="OFFICITY:LIBITEM[INFO/KIND='video']" mode="overview-preview">
    	<div class="file-container">
    		<div id="mediaplayer-{$panelID}" />
    	</div>
    	<script type="text/javascript">
	 		<xsl:call-template name="js-embed-mediaplayer">
	    		<xsl:with-param name="file" select="INFO/PATH" />
	    		<xsl:with-param name="containerID" select="concat('mediaplayer-', $panelID)" />
		    	<xsl:with-param name="width" select="160" />
	    		<xsl:with-param name="height" select="100" />
	    	</xsl:call-template>
    	</script>
    </xsl:template>
	 
	<xsl:template match="OFFICITY:LIBITEM[INFO/KIND='image' and INFO/PREVIEW = '1']" mode="overview-preview">
		<a href="{$systemToolsURL}file_download.php?target={INFO/PATH}" title="Download">
			<img src="{$filesURL}{substring-before(INFO/PATH,INFO/FILENAME)}resources/preview.jpg" style="padding:10px;"/>
		</a>
	</xsl:template>

	<!-- custom : info tab -->
	<xsl:template name="element-tab-info">
		<xsl:param name="element" />	
		
		<xsl:apply-templates select="$element/INFO/TITLE" mode="form-info-line">
			<xsl:with-param name="type" select="'styled'"  />
			<xsl:with-param name="required" select="true()"  />
		</xsl:apply-templates>	  
		<xsl:apply-templates select="$element/INFO/DOCUMENTTYPE" mode="form-info-line">
		</xsl:apply-templates>
		<xsl:apply-templates select="$element/INFO/SUMMARY" mode="form-info-line">
			<xsl:with-param name="type" select="'styled'"  />
		</xsl:apply-templates>  
		<xsl:apply-templates select="$element/INFO/DATE" mode="form-info-line" /> 
	   		   	 
	   	<xsl:apply-templates select="$element" mode="form-info-line-submit">
	   		<xsl:with-param name="buttonLabel" select="'Update'"/>
	   	</xsl:apply-templates>
	</xsl:template>
		 
  	<!-- custom : navigation details -->
	<xsl:template name="panel-block-details-nav-element">
		<xsl:param name="element" select="$element" />
 	
		<!--xsl:call-template name="navigationdetailsitem">
			<xsl:with-param name="title" select="'Tools'"/>
			<xsl:with-param name="panelURI" select="'documents/FileTools'"/>
			<xsl:with-param name="params">
				<xsl:text>ID:</xsl:text>
				<xsl:value-of select="$element/@ID" />
			</xsl:with-param>
			<xsl:with-param name="icon">
			</xsl:with-param> 
			<xsl:with-param name="cssclass">first</xsl:with-param>
		</xsl:call-template-->
		<xsl:call-template name="nav-links">
			<xsl:with-param name="title">
				<xsl:text>Parent(s)</xsl:text>
			</xsl:with-param>
			<xsl:with-param name="module" select="'officity:libitem'" />
			<xsl:with-param name="originID" select="$element/@ID" />
			<xsl:with-param name="targetModule" select="'officity:libitem'" />
			<xsl:with-param name="dependency" select="'officity:container'"/>
			<xsl:with-param name="params">trashed:'<xsl:value-of select="$element/INFO/TRASHED" />'</xsl:with-param>
			<xsl:with-param name="panelURI" select="'documents/ParentsList'"/>
			<xsl:with-param name="cssclass">first</xsl:with-param>
		</xsl:call-template>

		<xsl:call-template name="navigationdetailsitem">
			<xsl:with-param name="title">
				<xsl:text>Versions (</xsl:text>
				<xsl:value-of select="$element/DEPENDENCIES/DEPENDENCY[@type='officity:versions']/@hits"></xsl:value-of>
				<xsl:text>)</xsl:text>
			</xsl:with-param>
			<xsl:with-param name="panelURI" select="'documents/VersionsList'"/>
			<xsl:with-param name="params">
				<xsl:text>ID:</xsl:text>
				<xsl:value-of select="$element/@ID" />
			</xsl:with-param>
			<xsl:with-param name="icon">
			</xsl:with-param> 
		</xsl:call-template>
		
		<xsl:call-template name="security-permissions">
			<xsl:with-param name="element" select="$element" />
		</xsl:call-template>

		<!-- <xsl:call-template name="navigationdetailsitem">
			<xsl:with-param name="title" select="'Groups'"/>
			<xsl:with-param name="panelURI" select="'documents/GroupsPermissions'"/>
			<xsl:with-param name="params">
				<xsl:text>targetItemID:</xsl:text>
				<xsl:value-of select="$element/@ID" />
			</xsl:with-param>
			<xsl:with-param name="icon">
			</xsl:with-param> 
		</xsl:call-template>
		<xsl:call-template name="navigationdetailsitem">
			<xsl:with-param name="title" select="'Users'"/>
			<xsl:with-param name="panelURI" select="'documents/OwnersPermissions'"/>
			<xsl:with-param name="params">
				<xsl:text>targetItemID:</xsl:text>
				<xsl:value-of select="$element/@ID" />
			</xsl:with-param>
			<xsl:with-param name="icon">
			</xsl:with-param> 
		</xsl:call-template> -->
		
		<!--xsl:call-template name="navigationdetailsitem">
			<xsl:with-param name="title" select="'Notification'"/>
			<xsl:with-param name="panelURI" select="'DocNotification/NotificationNew'"/>
			<xsl:with-param name="params">
				<xsl:text>documentID:</xsl:text>
				<xsl:value-of select="$element/@ID" />
			</xsl:with-param>
			<xsl:with-param name="icon">
				<xsl:text>../system/images/icons/notifications/enveloppe-16.png</xsl:text>
			</xsl:with-param> 
		</xsl:call-template-->
		
		<xsl:call-template name="new-followup">
			<xsl:with-param name="title" select="'Notes'"/>
			<xsl:with-param name="element" select="$element" />		  
		</xsl:call-template>
		<xsl:call-template name="history-list">
			<xsl:with-param name="title">History</xsl:with-param>
			<xsl:with-param name="element" select="$element" />
			<xsl:with-param name="cssclass">last</xsl:with-param>
		</xsl:call-template>
	</xsl:template>
	
	<!-- custom : additional js -->
	<xsl:template name="panel-add-js">
		<!-- new version -->	
		var inputsValidator<xsl:value-of select="$panelID"/> = new InputsValidator(<xsl:value-of select="$panelID"/>, '#<xsl:value-of select="$newVersionFormID" />');
		
		$('#<xsl:value-of select="$panelID"/>.panel').find('#<xsl:value-of select="$newVersionFormID" />').placeHolders().submit(function(){
			fm = new FormManager(<xsl:value-of select="$panelID"/>, AppController);
	
			fm.onSuccess(delegate(this, function(response){
				$('#<xsl:value-of select="$panelID"/>.panel').trigger('panel-reload', [{ID:response.ID}]);
			}));
			
			var versionNotesName = '<xsl:call-template name="gen-info-input-name"><xsl:with-param name="moduleName" select="'officity:libitem'" /><xsl:with-param name="fieldName" select="'VERSIONNOTES'" /><xsl:with-param name="type" select="'textarea'" /></xsl:call-template>';
			fm.addDefaultValue('version-notes', 'Version notes...');
	
			fm.displayProcess('Creating new version...');
			fm.setScript('<xsl:apply-templates select="$item" mode="element-script-newversion" />');
			fm.parseAndSend(this);
			
 			return false;
		});
	</xsl:template>
</xsl:stylesheet>