<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/officity/lib/documents/ParentsList.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
    require_once(dirname(__FILE__).'/include.php');
    
    /* *** */
    
    $nql = new Officity_Shell();

	$module = new Officity_LibitemElement();

	if (URLParam::isNotEmpty('quicksearch-text'))
	{
		// set display mode
		$nql->addParam2XML('mode', 'searchitems');
		$module->addSearchInfo('SEARCHTEXT', 'MATCH', URLParam::fetch('quicksearch-text'));
		$module->addSearchInfo('TYPE', '=', 'disk');
		$module->addSearchInfo('TYPE', '=', 'folder');
		$module->addSearchInfo('TYPE', '=', 'book');
		$module->addSearchInfo('TYPE', '=', 'chapter');
	}
	else
	{
		$module->setDependencyByName(URLParam::fetch('dependency'), URLParam::fetch('module'), URLParam::fetch('originID'), 'reverse', '');
	}
	
	if (URLParam::fetch('trashed') != 'no')
	{
		$module->removeInfo('TRASHED');
	}
	
	$module->setDisplayProfile();
	$module->setDefaultSort('INFO/TITLE', 'ascending');
	$module->setDefaultPaginate(URLParam::fetch('display', 50), URLParam::fetch('page', 1));
	$module->search('list', false);

	$command = $module->getNQLCommand();
	$nql->addCommand($command);

	/* *** */

    $dep_module = new Element(URLParam::fetch('targetModule'));
    $dep_module->setDependencyByName(URLParam::fetch('dependency'), URLParam::fetch('module'), URLParam::fetch('originID'), 'reverse', '');
    $dep_module->setNoReturn();
    $dep_module->search('depsList', false);

    $command = $dep_module->getNQLCommand();
	$nql->addCommand($command);

	/* *** */

	$nql->addPaging();
    
    echo $nql->transform(dirname(__FILE__).'/ParentsList.xsl');
?>