<?xml version="1.0" encoding="utf-8"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/officity/lib/documents/include.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
	<xsl:import href="../app.include.xsl"/>
	<xsl:import href="../../../system/tools/security/functions.xsl"/>
	
	<!-- panel actions -->
	<xsl:template name="create-header-action-form">
		<xsl:param name="container" />
		<xsl:param name="createScript" />
		<xsl:param name="linkcssclass" /> 
		<xsl:param name="content" />
		
		<form class="form-{$linkcssclass} form-header-actions">
			<xsl:attribute name="onsubmit">
		        var createRequest = new AjaxRequest(
		            <xsl:value-of select="$panelID"/>,
		            AppController,
		            '<xsl:value-of select="$createScript" />',
		            'POST',
		            'json'
		        );
		        
	        	// error dialog and return errors in long msgs format
	        	createRequest.errorDialog(true, false);
	        	createRequest.internalErrorDialog(true, false);
	        	// warnings as well
	        	createRequest.warningDialog(true, false);
	        	
	        	var fm = new FormManager(<xsl:value-of select="$panelID"/>, AppController);
	        	
	        	<xsl:if test="$linkcssclass='header-action-newfile'">
	        		var filenameElemName = '<xsl:call-template name="gen-info-input-name"><xsl:with-param name="moduleName" select="'officity:libitem'" /><xsl:with-param name="fieldName" select="'TITLE'" /></xsl:call-template>';
	        		fm.addDefaultValue(filenameElemName, 'Automatic');
	        	</xsl:if>
	        	
	        	fm.parse(this);
		        createRequest.setData(fm.getAllData());
		        createRequest.setFiles(fm.getAllFiles());
		        
		        $('#<xsl:value-of select="$panelID"/>.panel').trigger('panel-displayloader', [true, 'header']);
	        	
		        createRequest.onSuccess(function(response){
		        	$('#<xsl:value-of select="$panelID"/>.panel').trigger('panel-displayloader', [false, 'header']);
		        	$('#<xsl:value-of select="$panelID"/>.panel').trigger('panel-header-reset').trigger('panel-refresh');
		        }).onError(function(response){
		            $('#<xsl:value-of select="$panelID"/>.panel').trigger('panel-displayloader', [false, 'header']);
		        }).send();
	    
				return false;
			</xsl:attribute>
			<input type="hidden" name="dependency">
				<xsl:attribute name="value">
					<xsl:choose>
						<xsl:when test="name($container)='CONTACT'">
							<xsl:text>officity:contactFavorites</xsl:text>
						</xsl:when>
						<xsl:otherwise>
							<xsl:text>officity:content</xsl:text>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
			</input>
			<input type="hidden" name="targetModule" value="{name($container)}" />
			<input type="hidden" name="targetID" value="{$container/@ID}" />
			
			<table class="fields" style="margin-top:0">
				<xsl:copy-of select="$content" />
			</table>
		</form>
	</xsl:template>
	
	<xsl:template name="form-actions">
		<xsl:param name="container" />
		<xsl:param name="createScript">
			<xsl:apply-templates select="$container" mode="element-script-create" />
		</xsl:param>
		
		<form class="header-actions" onsubmit="return false;">
			<a href="#" title="Panel actions" class="header-action-custom" />
			<a href="#" title="Add new page..." class="header-action-newpage" />
			<a href="#" title="Add new book..." class="header-action-newbook" />
			<a href="#" title="Add new file..." class="header-action-newfile" />
			<label title="Quick upload" class="upload-button header-action-quickupload">
				<input class="upload-file" type="file">
					<xsl:attribute name="name">
						<xsl:call-template name="gen-info-input-name">
							<xsl:with-param name="moduleName" select="'officity:libitem'" />
							<xsl:with-param name="fieldName" select="'PATH'" />
							<xsl:with-param name="type" select="'file'" />
						</xsl:call-template>
					</xsl:attribute>
					<xsl:attribute name="id">
						<xsl:call-template name="gen-info-input-ID">
							<xsl:with-param name="moduleName" select="'officity:libitem'" />
							<xsl:with-param name="fieldName" select="'PATH'" />
							<xsl:with-param name="type" select="'file'" />
						</xsl:call-template>
						<xsl:text>-quickupload</xsl:text>
					</xsl:attribute>
					<xsl:attribute name="onchange">
				        var createRequest = new AjaxRequest(
				            <xsl:value-of select="$panelID"/>,
				            AppController,
				            '<xsl:value-of select="$createScript" />',
				            'POST',
				            'json'
				        );
				        
			        	// error dialog and return errors in long msgs format
			        	createRequest.errorDialog(true, false);
			        	createRequest.internalErrorDialog(true, false);
			        	// warnings as well
			        	createRequest.warningDialog(true, false);
			        	
				        createRequest.addFile($(this).attr('id'));
				        
				        createRequest.addData('<xsl:call-template name="gen-info-input-ID"><xsl:with-param name="moduleName" select="'officity:libitem'" /><xsl:with-param name="fieldName" select="'TYPE'" /></xsl:call-template>', 'file');
				        createRequest.addData('targetModule', '<xsl:value-of select="name($container)" />');
				        createRequest.addData('targetID', '<xsl:value-of select="$container/@ID" />');
						<xsl:choose>
							<xsl:when test="name($container)='CONTACT'">									
								<xsl:text>createRequest.addData('dependency', 'officity:contactFavorites');</xsl:text>
							</xsl:when>
							<xsl:otherwise>
								<xsl:text>createRequest.addData('dependency', 'officity:content');</xsl:text>
							</xsl:otherwise>
						</xsl:choose>
				        
				        $('#<xsl:value-of select="$panelID"/>.panel').trigger('panel-displayloader', [true, 'header']);
			        	
				        createRequest.onSuccess(function(response){
				        	$('#<xsl:value-of select="$panelID"/>.panel').trigger('panel-displayloader', [false, 'header']);
				        	$('#<xsl:value-of select="$panelID"/>.panel').trigger('panel-header-reset').trigger('panel-refresh');
				        }).onError(function(response){
				            $('#<xsl:value-of select="$panelID"/>.panel').trigger('panel-displayloader', [false, 'header']);
				        }).send();
			    
						return true;
					</xsl:attribute>
				</input>
			</label>
		</form>
		<div class="clear" />
		
		<!-- new page -->
		<xsl:call-template name="create-header-action-form">
			<xsl:with-param name="container" select="$container" />
			<xsl:with-param name="createScript" select="$createScript" />
			<xsl:with-param name="linkcssclass" select="'header-action-newpage'" />
			<xsl:with-param name="content">
	  			<input type="hidden" value="page">
					<xsl:attribute name="name">
						<xsl:call-template name="gen-info-input-name">
							<xsl:with-param name="moduleName" select="'officity:libitem'" />
							<xsl:with-param name="fieldName" select="'TYPE'" />
						</xsl:call-template>
					</xsl:attribute>
	   			</input>
				<xsl:call-template name="form-info-line">
					<xsl:with-param name="label" select="'Page title:'"/>
					<xsl:with-param name="value" select="''"/>
					<xsl:with-param name="input">
						<input type="text" class="input-text">
							<xsl:attribute name="name">
								<xsl:call-template name="gen-desc-input-name">
									<xsl:with-param name="languageID" select="/RESPONSE/NECTIL/language" />
									<xsl:with-param name="moduleName" select="'officity:libitem'" />
									<xsl:with-param name="fieldName" select="'TITLE'" />
								</xsl:call-template>
							</xsl:attribute>
						</input>
					</xsl:with-param>
				</xsl:call-template>
				<xsl:call-template name="form-info-line">
					<xsl:with-param name="label" select="'Type:'"/>
					<xsl:with-param name="value" select="''"/>
					<xsl:with-param name="input">
						<select>
							<xsl:attribute name="name">
								<xsl:call-template name="gen-info-input-name">
									<xsl:with-param name="moduleName" select="'officity:libitem'" />
									<xsl:with-param name="fieldName" select="'DOCUMENTTYPE'" />
								</xsl:call-template>
							</xsl:attribute>
		                    <option value="">
		                        <xsl:text>(Choose an option)</xsl:text>
		                    </option>
		                    <xsl:for-each select="/RESPONSE/RESULTS/LIST[@name='DocumentsTypes']/*">
		                        <xsl:sort select="@label" />
		                        <option value="{@value}">
		                            <xsl:value-of select="@label"/>
		                        </option>
		                    </xsl:for-each>
						</select>
					</xsl:with-param>
				</xsl:call-template>
				<xsl:call-template name="form-info-line-submit">
					<xsl:with-param name="input">
		                <input type="submit" name="create-update-button" class="input-submit-save" value="Add" />
	    	   			<input type="button" id="cancel-button" class="input-submit-cancel" value="Cancel" />
    	   			</xsl:with-param>
				</xsl:call-template>
			</xsl:with-param>
		</xsl:call-template>
		
		<!-- new book -->
		<xsl:call-template name="create-header-action-form">
			<xsl:with-param name="container" select="$container" />
			<xsl:with-param name="createScript" select="$createScript" />
			<xsl:with-param name="linkcssclass" select="'header-action-newbook'" />
			<xsl:with-param name="content">
	  			<input type="hidden" value="book">
					<xsl:attribute name="name">
						<xsl:call-template name="gen-info-input-name">
							<xsl:with-param name="moduleName" select="'officity:libitem'" />
							<xsl:with-param name="fieldName" select="'TYPE'" />
						</xsl:call-template>
					</xsl:attribute>
	   			</input>
				<xsl:call-template name="form-info-line">
					<xsl:with-param name="label" select="'Book title:'"/>
					<xsl:with-param name="value" select="''"/>
					<xsl:with-param name="input">
						<input type="text" class="input-text">
							<xsl:attribute name="name">
								<xsl:call-template name="gen-desc-input-name">
									<xsl:with-param name="languageID" select="/RESPONSE/NECTIL/language" />
									<xsl:with-param name="moduleName" select="'officity:libitem'" />
									<xsl:with-param name="fieldName" select="'TITLE'" />
								</xsl:call-template>
							</xsl:attribute>
						</input>
					</xsl:with-param>
				</xsl:call-template>
				<xsl:call-template name="form-info-line">
					<xsl:with-param name="label" select="'Type:'"/>
					<xsl:with-param name="value" select="''"/>
					<xsl:with-param name="input">
						<select>
							<xsl:attribute name="name">
								<xsl:call-template name="gen-info-input-name">
									<xsl:with-param name="moduleName" select="'officity:libitem'" />
									<xsl:with-param name="fieldName" select="'DOCUMENTTYPE'" />
								</xsl:call-template>
							</xsl:attribute>
		                    <option value="">
		                        <xsl:text>(Choose an option)</xsl:text>
		                    </option>
		                    <xsl:for-each select="/RESPONSE/RESULTS/LIST[@name='DocumentsTypes']/*">
		                        <xsl:sort select="@label" />
		                        <option value="{@value}">
		                            <xsl:value-of select="@label"/>
		                        </option>
		                    </xsl:for-each>
						</select>
					</xsl:with-param>
				</xsl:call-template>
				<xsl:call-template name="form-info-line">
					<xsl:with-param name="label" select="'Summary:'"/>
					<xsl:with-param name="value" select="''"/>
					<xsl:with-param name="input">
						<textarea class="input-textarea">
							<xsl:attribute name="name">
								<xsl:call-template name="gen-desc-input-name">
									<xsl:with-param name="languageID" select="/RESPONSE/NECTIL/language" />
									<xsl:with-param name="moduleName" select="'officity:libitem'" />
									<xsl:with-param name="fieldName" select="'SUMMARY'" />
								</xsl:call-template>
							</xsl:attribute>
						</textarea>
					</xsl:with-param>
				</xsl:call-template>
				<xsl:call-template name="form-info-line-submit">
					<xsl:with-param name="input">
		                <input type="submit" name="create-update-button" class="input-submit-save" value="Add" style="float:right; position:relative;right:-6px;"/>
	    	   			<input type="button" id="cancel-button" class="input-submit-cancel" value="Cancel" style="float:right; margin-right:20px;"/>
    	   			</xsl:with-param>
				</xsl:call-template>
			</xsl:with-param>
		</xsl:call-template>
		
		<!-- new file -->
		<xsl:call-template name="create-header-action-form">
			<xsl:with-param name="container" select="$container" />
			<xsl:with-param name="createScript" select="$createScript" />
			<xsl:with-param name="linkcssclass" select="'header-action-newfile'" />
			<xsl:with-param name="content">
	  			<input type="hidden" value="file">
					<xsl:attribute name="name">
						<xsl:call-template name="gen-info-input-name">
							<xsl:with-param name="moduleName" select="'officity:libitem'" />
							<xsl:with-param name="fieldName" select="'TYPE'" />
						</xsl:call-template>
					</xsl:attribute>
	   			</input>
				<xsl:call-template name="form-info-line">
					<xsl:with-param name="label" select="'Upload:'"/>
					<xsl:with-param name="value" select="''"/>
					<xsl:with-param name="input">
						<input class="input-file" type="file">
							<xsl:attribute name="name">
								<xsl:call-template name="gen-info-input-name">
									<xsl:with-param name="moduleName" select="'officity:libitem'" />
									<xsl:with-param name="fieldName" select="'PATH'" />
									<xsl:with-param name="type" select="'file'" />
								</xsl:call-template>
							</xsl:attribute>
							<xsl:attribute name="id">
								<xsl:call-template name="gen-info-input-ID">
									<xsl:with-param name="moduleName" select="'officity:libitem'" />
									<xsl:with-param name="fieldName" select="'PATH'" />
									<xsl:with-param name="type" select="'file'" />
								</xsl:call-template>
							</xsl:attribute>
						</input>
					</xsl:with-param>
				</xsl:call-template>
				<xsl:call-template name="form-info-line">
					<xsl:with-param name="label" select="'File name:'"/>
					<xsl:with-param name="value" select="''"/>
					<xsl:with-param name="input">
						<input type="text" class="input-text" value="Automatic" default-value="Automatic">
							<xsl:attribute name="name">
								<xsl:call-template name="gen-info-input-name">
									<xsl:with-param name="moduleName" select="'officity:libitem'" />
									<xsl:with-param name="fieldName" select="'TITLE'" />
								</xsl:call-template>
							</xsl:attribute>
							<xsl:attribute name="id">
								<xsl:call-template name="gen-info-input-ID">
									<xsl:with-param name="moduleName" select="'officity:libitem'" />
									<xsl:with-param name="fieldName" select="'TITLE'" />
								</xsl:call-template>
							</xsl:attribute>
						</input>
					</xsl:with-param>
				</xsl:call-template>
				<xsl:call-template name="form-info-line">
					<xsl:with-param name="label" select="'Auto unzip:'"/>
					<xsl:with-param name="value" select="''"/>
					<xsl:with-param name="input">
						<input type="checkbox" class="input-checkbox" name="auto-unzip" value="1" />
					</xsl:with-param>
					<xsl:with-param name="extraLabel">
						<xsl:text>use the zip content to create file(s) and folder(s)</xsl:text>
					</xsl:with-param>
				</xsl:call-template>
				<xsl:call-template name="form-info-line">
					<xsl:with-param name="label" select="'Type:'"/>
					<xsl:with-param name="value" select="''"/>
					<xsl:with-param name="input">
						<select>
							<xsl:attribute name="name">
								<xsl:call-template name="gen-info-input-name">
									<xsl:with-param name="moduleName" select="'officity:libitem'" />
									<xsl:with-param name="fieldName" select="'DOCUMENTTYPE'" />
								</xsl:call-template>
							</xsl:attribute>
		                    <option value="">
		                        <xsl:text>(Choose an option)</xsl:text>
		                    </option>
		                    <xsl:for-each select="/RESPONSE/RESULTS/LIST[@name='DocumentsTypes']/*">
		                        <xsl:sort select="@label" />
		                        <option value="{@value}">
		                            <xsl:value-of select="@label"/>
		                        </option>
		                    </xsl:for-each>
						</select>
					</xsl:with-param>
				</xsl:call-template>
				<xsl:call-template name="form-info-line">
					<xsl:with-param name="label" select="'Summary:'"/>
					<xsl:with-param name="value" select="''"/>
					<xsl:with-param name="input">
						<textarea class="input-textarea">
							<xsl:attribute name="name">
								<xsl:call-template name="gen-info-input-name">
									<xsl:with-param name="moduleName" select="'officity:libitem'" />
									<xsl:with-param name="fieldName" select="'SUMMARY'" />
								</xsl:call-template>
							</xsl:attribute>
						</textarea>
					</xsl:with-param>
				</xsl:call-template>
				<xsl:call-template name="form-info-line-submit">
					<xsl:with-param name="input">
		                <input type="submit" name="create-update-button" class="input-submit-save" value="Add" style="float:right; position:relative;right:-6px;"/>
	    	   			<input type="button" id="cancel-button" class="input-submit-cancel" value="Cancel" style="float:right; margin-right:20px;"/>
    	   			</xsl:with-param>
				</xsl:call-template>
			</xsl:with-param>
		</xsl:call-template>
	</xsl:template>
		
	<xsl:template name="init-panel-header-actions-js">
		// toggle form event on panel
		$('#<xsl:value-of select="$panelID" />.panel').bind('toggle-form', function(event, form){
			if (form.is(':visible'))
			{				
				form.slideUp('fast', function(){
					// re-enable header layout
					form.closest('.header-toolbar').css({
						'height':'',
						'overflow-y':'auto'
					});
					$('#<xsl:value-of select="$panelID"/>.panel').trigger('panel-layout');
				});
			}
			else
			{
				// disable header layout
				form.closest('.header-toolbar').css({
					'max-height':'', 
					'height':'auto',
					'overflow-y':'visible'
				});
				
				var formSiblings = form.siblings('form.form-header-actions:visible');				
				if (formSiblings.length)
				{
					formSiblings.slideUp(100, function(){
						if (!form.is(':visible'))
						{
							form.slideDown('fast', function(){
								$('#<xsl:value-of select="$panelID"/>.panel').trigger('panel-layout', ['body']);
							});
						}
					});
				}
				else
				{
					form.slideDown('fast', function(){
						$('#<xsl:value-of select="$panelID"/>.panel').trigger('panel-layout', ['body']);
					});
				}
			}
		});
		
		// display chosen form
		$('#<xsl:value-of select="$panelID" />.panel').find('.header-toolbar').find('form.header-actions a').click(function(){
			$('#<xsl:value-of select="$panelID" />.panel').trigger('toggle-form', [$(this).closest('.header-toolbar').find('form.form-'+$(this).attr('class'))]);
			return false;
		});
		
		// hide form on cancel click
		$('#<xsl:value-of select="$panelID" />.panel').find('.header-toolbar').find('.input-submit-cancel').click(function(){
			$('#<xsl:value-of select="$panelID" />.panel').trigger('toggle-form', [$(this).closest('form')]);
			return false;
		});
		
		// default value for filename in the new file form
        $('#<xsl:value-of select="$panelID" />.panel').find('.form-header-action-newfile').placeHolders();
        
        // quick upload button trick
		SI.Files.stylize($('#<xsl:value-of select="$panelID" />.panel').find('#<xsl:call-template name="gen-info-input-ID"><xsl:with-param name="moduleName" select="'officity:libitem'" /><xsl:with-param name="fieldName" select="'PATH'" /><xsl:with-param name="type" select="'file'" /></xsl:call-template>-quickupload').get(0));
		
		// autoresize for form textareas
		<xsl:call-template name="js-init-autoresize" />
		
		// reset header inputs
		$('#<xsl:value-of select="$panelID" />.panel').bind('panel-header-reset', function(){
			quickSearcher<xsl:value-of select="$panelID"/>.reset(false);

			if (typeof quickFavsSearcher<xsl:value-of select="$panelID"/> !== 'undefined')
			{
				quickFavsSearcher<xsl:value-of select="$panelID"/>.reset(false);
			}
			
			$('#<xsl:value-of select="$panelID"/>.panel').find('.panel-header').find('form.form-header-actions:visible').reset().placeHolders('reset');
			$('#<xsl:value-of select="$panelID"/>.panel').find('.panel-header').find('form.quickadd-form').placeHolders('reset');
		});
	</xsl:template>
	
	<xsl:template name="init-panel-header-quickadd-js">
		<xsl:param name="formID"  /> 
		<xsl:param name="container" />
		<xsl:param name="processingMsg" /> 
		
		$('#<xsl:value-of select="$formID"/>').placeHolders().submit(function(){
	        fm = new FormManager(<xsl:value-of select="$panelID"/>, AppController);
	
	        fm.onSuccess(delegate(this, function(response){
	            $('#<xsl:value-of select="$panelID"/>.panel').trigger('panel-header-reset').trigger('panel-refresh');
	        }));
	
	        fm.displayProcess('<xsl:value-of select="$processingMsg"/>');
	        fm.setScript('<xsl:apply-templates select="$container" mode="element-script-batchcreate" />');
	        fm.parseAndSend(this);
	
	        return false;
        });
	</xsl:template>
	
	<!--  container (disk or folder) details summary item -->
	<xsl:template name="container-details-item">
		<xsl:param name="container" />
		<xsl:param name="containerName" />
		<xsl:param name="itemsCount" select="$container/INFO/ITEMS" />
		
		<div class="items container-summary">
			<div class="label">
				<img>
					<xsl:attribute name="src">
						<xsl:value-of select="$systemURL" />
						<xsl:text>../</xsl:text>
						<xsl:value-of select="/RESPONSE/URL/editor" />
						<xsl:text>/</xsl:text>
						<xsl:apply-templates select="$container" mode="element-icon"/>
					</xsl:attribute>
				</img>
				<xsl:apply-templates select="$container/INFO/TITLE" mode="display-value"/>		
				<xsl:text>, </xsl:text>
				<span id="container-size-details"><xsl:value-of select="$itemsCount" /> item(s)</span>							
				<a title="Compute total {$containerName} size" href="#" class="info-action" style="margin-left:5px; display:inline-block; display:-moz-inline-box; vertical-align:middle;">
					<xsl:call-template name="container-getsize-handler">
						<xsl:with-param name="container" select="$container" />
					</xsl:call-template>
				</a>
			</div>
			<a class="edit-action" href="#" title="View/edit {$containerName} details">
				<xsl:attribute name="onclick">
					<xsl:text>var sizeDetails = $(this).closest('.items').find('#container-size-details').html();</xsl:text>
	                <xsl:call-template name="navhandler">
	                    <xsl:with-param name="title">
	                    	<xsl:apply-templates select="$container" mode="element-label" />
                    	</xsl:with-param>
	                    <xsl:with-param name="panelURI">
	                    	<xsl:apply-templates select="$container" mode="element-script-detail" />
	                    </xsl:with-param>
	                    <xsl:with-param name="params">
	                    	<xsl:apply-templates select="$container" mode="element-navitem-parms" />
	                    	<xsl:text>, sizeDetails:sizeDetails</xsl:text>
	                    </xsl:with-param>                    
	                </xsl:call-template>
				</xsl:attribute>
			</a>
		</div>
	</xsl:template>
	
	<xsl:template name="container-getsize-handler">
		<xsl:param name="container" />
		<xsl:attribute name="onclick">
			if ($(this).hasClass('ajax-loader'))
			{
				return false;
			}
			$(this).removeClass('info-action').addClass('ajax-loader');
     							            
            var countRequest = new AjaxRequest(
                <xsl:value-of select="$panelID"/>,
                AppController,
                '<xsl:apply-templates select="$container" mode="element-script-count" />',
                'POST',
                'json'
            );
            var data2Send = { };
            data2Send['ID'] = <xsl:value-of select="$container/@ID" />;
            data2Send['type'] = 'content';
            countRequest.setData(data2Send);
            
            // no error dialog and return errors in short msgs format
            countRequest.errorDialog(false, true);
            countRequest.internalErrorDialog(false, true);
            
            var self = $(this);
            
            countRequest.onSuccess(function(response){
            	self.removeClass('ajax-loader').addClass('info-action');
            	self.prev('#container-size-details').html(response.size+' for '+response.items+' item(s)');
            }).onError(function(response){
                self.removeClass('ajax-loader').addClass('info-action');
                self.prev('#container-size-details').html(response.message);
            }).send();

            return true;
		</xsl:attribute>
	</xsl:template>
		
	<!-- trash actions -->
	 <xsl:template match="OFFICITY:LIBITEM[INFO/TRASHED='no']" mode="trash-action">
       		<form>
       			<input type="hidden" name="ID" value="{@ID}" />
       			<input type="hidden" value="intrash">
					<xsl:attribute name="name">
						<xsl:apply-templates select="INFO/TRASHED" mode="gen-info-input-name" />
					</xsl:attribute>
       			</input>
	        	<a href="#" title="Send to Trash" class="action trash">
	        		<xsl:attribute name="onclick">
				        fm = new FormManager(<xsl:value-of select="$panelID"/>, AppController);
				
				        fm.onSuccess(delegate(this, function(response){
				            $(AppController).panelslider('removePanel', <xsl:value-of select="$panelID"/>);
				            $('#slider').find('.panel-lib-index').trigger('panel-refresh');
				        }));
				
				        fm.displayProcess('Trashing...');
				        fm.setScript('<xsl:apply-templates select="." mode="element-script-update" />');
				        fm.parseAndSend(this.parentNode);
				
				        return false;
	        		</xsl:attribute>
	        		<xsl:text>Send to Trash</xsl:text>
	       		</a>
       		</form>
       		<form>
       			<input type="hidden" name="ID" value="{@ID}" />
       			<input type="hidden" name="targetModule" value="contact" />
       			<input type="hidden" name="targetID" value="{$userID}" />
       			<input type="hidden" name="dependency" value="officity:contactFavorites"/>
	        	<a href="#" title="Add to favorites" class="action favorites">
	        		<xsl:attribute name="onclick">
				        fm = new FormManager(<xsl:value-of select="$panelID"/>, AppController);
				
				        fm.onSuccess(delegate(this, function(response){
				            $('#slider').find('.panel-lib-index').trigger('panel-refresh');
				        }));
				
				        fm.displayProcess('Adding to favorites...');
				        fm.setScript('<xsl:apply-templates select="." mode="element-script-link" />');
				        fm.parseAndSend(this.parentNode);
				
				        return false;
	        		</xsl:attribute>
	        		<xsl:text>Add to Favorites</xsl:text>
	       		</a>
       		</form>
 	</xsl:template>
 	
 	<xsl:template match="OFFICITY:LIBITEM[INFO/TRASHED='intrash' or INFO/TRASHED='intrasheditem']" mode="trash-action">
       		<form>
       			<input type="hidden" name="ID" value="{@ID}" />
       			<input type="hidden" value="no">
					<xsl:attribute name="name">
						<xsl:apply-templates select="INFO/TRASHED" mode="gen-info-input-name" />
					</xsl:attribute>
       			</input>
	        	<a href="#" title="Remove from Trash" class="action trash">
	        		<xsl:attribute name="onclick">
				        fm = new FormManager(<xsl:value-of select="$panelID"/>, AppController);
				
				        fm.onSuccess(delegate(this, function(response){
				            $(AppController).panelslider('removePanel', <xsl:value-of select="$panelID"/>);
				            $('#slider').find('.panel-lib-index').trigger('panel-refresh');
				        }));
				
				        fm.displayProcess('Restoring...');
				        fm.setScript('<xsl:apply-templates select="." mode="element-script-update" />');
				        fm.parseAndSend(this.parentNode);
				
				        return false;
	        		</xsl:attribute>
	        		<xsl:text>Remove from Trash</xsl:text>
	       		</a>
       		</form>
 	</xsl:template>
	
	<!-- security (groups and owners) -->
	<xsl:template name="apply-permissions-js">	
		$('#<xsl:value-of select="$panelID"/>.panel').bind('apply-single-permission', function(eventObject, selectElem, targetsName, targetModule, targetID){
	        if ($(selectElem).val() == '') return;	                		
  		    
  		    $(selectElem).hide();
  		    $(selectElem).closest('.info').find('.actions-label').html('');
  		    $(selectElem).closest('.info').find('.ajax-loader-nav').show();
  			
            var ajaxRequest = new AjaxRequest(
                <xsl:value-of select="/RESPONSE/URL/panelID" />,
                AppController,
                '<xsl:apply-templates select="$item" mode="element-script-assign-security"/>',
                'POST'
            );
            
            var newSetting = $(selectElem).val();
            ajaxRequest.setData({
				type : targetsName,
				targetIDs : [$(selectElem).attr('id')],
				newSetting : newSetting,
				ID : targetID,
				module : targetModule
            });

            // no error dialog and return errors in short msgs format
            ajaxRequest.errorDialog(false, true);
            ajaxRequest.internalErrorDialog(false, true);            
            
            ajaxRequest.onSuccess(delegate(this, function(response){
            	if (newSetting == 'remove')
            	{
            		var remainingCheckedItems = $('#<xsl:value-of select="$panelID" />.panel').find('.block-nav :checkbox:not(#check-selectall)');	
            	
            		$(selectElem).closest('.items').fadeOut(200, function(){ 
					    $(this).remove();
					});
														
					if (remainingCheckedItems.length == 1)
					{
						$('#<xsl:value-of select="$panelID" />.panel').find('#check-selectall').closest('.items').fadeOut(200, function(){ 
					    	$(this).remove();
						});
					}
            	}
            	else
            	{
            		$(selectElem).closest('.info').find('.ajax-loader-nav').hide();
            		quickSearcher<xsl:value-of select="$panelID" />.refresh();
            	}
            })).onError(delegate(this, function(response){
				$(selectElem).closest('.info').find('.ajax-loader-nav').hide();
				$(selectElem).closest('.info').find('.actions-label').html(response.message);
            })).send();
		}).bind('apply-all-permissions', function(eventObject, selectElem, targetsName, targetModule, targetID){
			if ($(selectElem).val() == '') return;			

			var checkedItems = $('#<xsl:value-of select="$panelID" />.panel').find('.block-nav :checked:not(#check-selectall)');
			if (checkedItems.length == 0)
			{
				$(selectElem).val('');
				return;
        	}
        		
            var ajaxRequest = new AjaxRequest(
                <xsl:value-of select="/RESPONSE/URL/panelID" />,
                AppController,
                '<xsl:apply-templates select="$item" mode="element-script-assign-security"/>',
                'POST'
            );
            
     		var IDs = [];
	  		checkedItems.each(function(){
	 			IDs.push($(this).val());
	    		//$(this).removeAttr('checked');
	    	});
	    	
	    	var newSetting = $(selectElem).val();
	    	
            ajaxRequest.setData({
				type : targetsName,
				targetIDs : IDs,
				newSetting : newSetting,
				ID : targetID,
				module : targetModule
            });
            
            $(selectElem).val('');

            // display error dialog and return errors in long msgs format
            ajaxRequest.errorDialog(true, false);
            ajaxRequest.internalErrorDialog(true, false);     
            
            $(this).trigger('panel-displayloader', [true, 'body']);       
            
            ajaxRequest.onSuccess(delegate(this, function(response){            
               if (newSetting == 'remove')
            	{
            		checkedItems.closest('.items').remove();
					
					var selectAllElem = $('#<xsl:value-of select="$panelID" />.panel').find('#check-selectall');
					selectAllElem.removeAttr('checked');
					
					var remainingCheckedItems = $('#<xsl:value-of select="$panelID" />.panel').find('.block-nav :checkbox:not(#check-selectall)');					
					if (remainingCheckedItems.length == 0)
					{
						selectAllElem.closest('.items').remove();
					}

            		$(this).trigger('panel-displayloader', [false, 'body']);            		
            	}
            	else
            	{
            		quickSearcher<xsl:value-of select="$panelID" />.refresh();
           		}
            })).onError(delegate(this, function(response){
				$(this).trigger('panel-displayloader', [false, 'body']); 
            })).send();
		});
	</xsl:template>
	
	<!-- current container display -->
	<xsl:template name="get-current-display">
    	<xsl:choose>
    		<xsl:when test="/RESPONSE/URL/display/text() and (/RESPONSE/URL/display!='')">
    			<xsl:value-of select="/RESPONSE/URL/display" />
    		</xsl:when>
    		<xsl:otherwise>
    			<xsl:call-template name="get-container-display" />
    		</xsl:otherwise>
    	</xsl:choose>
	</xsl:template>
	
	<!-- disk/folder display -->
	<xsl:template name="get-container-display">
    	<xsl:choose>
    		<xsl:when test="$container/INFO/DISPLAY/text() and ($container/INFO/DISPLAY!='')">
    			<xsl:value-of select="$container/INFO/DISPLAY" />
    		</xsl:when>
    		<xsl:otherwise>
    			<xsl:text>manual</xsl:text>
    		</xsl:otherwise>
    	</xsl:choose>
	</xsl:template>
	
	<!-- draggable items -->
	<xsl:template name="choose-draggable-navigation">
		<xsl:param name="items" />
		<xsl:param name="container" />
		
		<xsl:choose>
			<xsl:when test="count($items)&gt;1">
				<div id="drag-container-{$panelID}">
					<xsl:for-each select="$items" >					
						<xsl:apply-templates select="." mode="element-navitem-draggable" />
					</xsl:for-each>
					<script type="text/javascript">
						<xsl:call-template name="init-draggable-js">
							<xsl:with-param name="container" select="$container" />
							<xsl:with-param name="itemsCount" select="count($items)" />
						</xsl:call-template>
					</script>
				</div>
			</xsl:when>
			<xsl:otherwise>
				<xsl:for-each select="$items" >					
					<xsl:apply-templates select="." mode="element-navitem" />
				</xsl:for-each>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="init-draggable-js">	
		<xsl:param name="container" />
		<xsl:param name="dependency" select="'officity:content'" />
		<xsl:param name="itemsCount" />
		
		<xsl:if test="$itemsCount &gt; 1">
	        $('#<xsl:value-of select="$panelID"/>.panel .block-nav #drag-container-<xsl:value-of select="$panelID"/>').sortable({
	        	handle : '.drag-handle',
	            containment : '#<xsl:value-of select="$panelID"/>.panel .block-nav #drag-container-<xsl:value-of select="$panelID"/>',
	            start: function(event, ui) { 
	            	ui.item.addClass('dragged'); 
	           	},
	            stop: function(event, ui) { 
	           		ui.item.removeClass('dragged'); 
	           		//$('#<xsl:value-of select="$panelID"/>.panel').trigger('panel-displayloader', [true, 'body']);
	           		
	                // returns contact[], an array of IDs
	                var sortedElems = $('#<xsl:value-of select="$panelID"/>.panel .block-nav #drag-container-<xsl:value-of select="$panelID"/>').sortable('toArray');
	
					// get rid of the prefix in order to send an array of element IDs
					for (var i in sortedElems)
					{
						// e. g. : officity__libitem-5
						var idParts = sortedElems[i].split('-', 2); 
						sortedElems[i] = idParts[1];
					}
					
	                var updateRequest = new AjaxRequest(
	                    <xsl:value-of select="$panelID"/>,
	                    AppController,
	                    '<xsl:apply-templates select="$container" mode="element-script-sort-deps"/>',
	                    'POST',
	                    'json'
	                );
	
	                updateRequest.setData({sortedIDs:sortedElems});
	                updateRequest.addData('dependency', '<xsl:value-of select="$dependency"/>');
	                updateRequest.addData('targetModule', '<xsl:value-of select="name($container)"/>');
	                updateRequest.addData('ID', <xsl:value-of select="$container/@ID"/>);
	                
					// display error dialog and return errors in long msgs format
					updateRequest.errorDialog(true, false);
					updateRequest.internalErrorDialog(true, false);
	
	                updateRequest.onSuccess(function(response){
	                    //$('#<xsl:value-of select="$panelID"/>.panel').trigger('panel-displayloader', [false, 'body']);
	                }).onError(function(response){
	                    //$('#<xsl:value-of select="$panelID"/>.panel').trigger('panel-displayloader', [false, 'body']);
	                }).send();
	         	},
	         	revert:25,
	         	placeholder:'items draggable dragged-placeholder',
	         	forcePlaceholderSize:true
	        }).disableSelection();
        </xsl:if>
	</xsl:template>
</xsl:stylesheet>
