<?xml version="1.0" encoding="utf-8"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee/shared/app/app.definitions.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
	<!-- EDITOR/APPLICATION -->
	<xsl:template match="APP" mode="element-editor">
		<xsl:text>sushee</xsl:text>
	</xsl:template>
	<xsl:template match="APP" mode="element-application">
		<xsl:text>factory</xsl:text>
	</xsl:template>
	<xsl:template match="APP" mode="element-application-editor">
		<xsl:text>officity</xsl:text>
	</xsl:template>
	
    <!-- APP HOME PANEL HEADER -->
	<xsl:template match="APP" mode="element-home-panel-header">
        <xsl:call-template name="staticitemheader">
            <xsl:with-param name="title">
            	<xsl:apply-templates select="." mode="element-label" />
			</xsl:with-param>
            <xsl:with-param name="icon">
            	<xsl:choose>
            		<xsl:when test="INFO/ICON/text()!=''">
			            <xsl:value-of select="INFO/ICON" />
	    	        </xsl:when>
	    	        <xsl:otherwise>
	    	        	<xsl:text>../system/images/icons/applications/application-32.png</xsl:text>
	    	        </xsl:otherwise>
	            </xsl:choose>
			</xsl:with-param>
            <xsl:with-param name="info">
            	<xsl:choose>
            		<xsl:when test="DESCRIPTIONS/DESCRIPTION/SUMMARY/text()!=''">
			            <xsl:apply-templates select="DESCRIPTIONS/DESCRIPTION/SUMMARY" />
	    	        </xsl:when>
	    	        <xsl:otherwise>
	    	        	<xsl:text>This is the starting point of your application.</xsl:text>
	    	        </xsl:otherwise>
	            </xsl:choose>
            </xsl:with-param>
        </xsl:call-template>
	</xsl:template>
	
    <!-- LABEL(s) -->
	<xsl:template match="APP" mode="element-label">
        <xsl:value-of select="INFO/DENOMINATION"/>
	</xsl:template>

	<!-- ICON(s) -->
	<xsl:template match="APP" mode="element-icon">
		<xsl:text>../system/images/icons/applications/application.png</xsl:text>
	</xsl:template>
	
	<xsl:template match="APP[INFO/ICON/text() and ancestor::NAMESPACE]" mode="element-icon">
		<xsl:text>../</xsl:text>
		<xsl:value-of select="ancestor::NAMESPACE/INFO/NAMESPACE" />
		<xsl:text>/</xsl:text>
		<xsl:value-of select="INFO/ICON" />			
	</xsl:template>
	
	<xsl:template match="APP[INFO/ICON/text() and DEPENDENCIES/DEPENDENCY[@type='officity:appNamespaces']/NAMESPACE]" mode="element-icon">
		<xsl:text>../</xsl:text>
		<xsl:value-of select="DEPENDENCIES/DEPENDENCY[@type='officity:appNamespaces']/NAMESPACE/INFO/NAMESPACE" />
		<xsl:text>/</xsl:text>
		<xsl:value-of select="INFO/ICON" />
	</xsl:template>

	<!-- INFO LABEL(s) -->
	<xsl:template match="APP" mode="element-info">
        <xsl:apply-templates select="DEPENDENCIES/DEPENDENCY[@type='officity:appNamespaces']/NAMESPACE" mode="element-label"/>
	</xsl:template>

	<!-- NAVIGATION ITEM(s) -->
	<xsl:template match="APP" mode="element-subnavitem-check">
		<xsl:apply-templates select="." mode="element-navitem-check">
		  	<xsl:with-param name="cssclass">
		  		<xsl:text>group-</xsl:text>
		  		<xsl:apply-templates select="ancestor::NAMESPACE" mode="element-navitem-id"/>
		  	</xsl:with-param>
		  	<xsl:with-param name="tab" select="true()" />
		</xsl:apply-templates>
	</xsl:template>
	
	<!-- TITLE(s) -->
	
	<!-- SCRIPTS -->
	<xsl:template match="APP" mode="element-script-detail">
		<xsl:text>applications/Details</xsl:text>
	</xsl:template>

	<xsl:template match="APP" mode="element-script-new">
		<xsl:text>applications/New</xsl:text>
	</xsl:template>
</xsl:stylesheet>