<?xml version="1.0"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee/shared/contact/check.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
	<xsl:import href="include.xsl"/>
	<xsl:output encoding="UTF-8" method="xml" indent="no"/>
	<xsl:strip-space elements="*"/>
	
	<xsl:template match="/RESPONSE">
		<div class="content">
			<xsl:choose>
				<xsl:when test="RESULTS/@pages = 1">
				    <xsl:call-template name="nav-new">
				    	<xsl:with-param name="title" select="'Create new...'" />
				    	<xsl:with-param name="module" select="'contact'" />
				    	<xsl:with-param name="app" select="'directory'" />
				    	<xsl:with-param name="editor" select="'officity'" />
				    	<xsl:with-param name="panelURI">
				    		<xsl:choose>
				    			<xsl:when test="/RESPONSE/URL/info-contact-contacttype='PM'">
				    				<xsl:text>contacts/SocietyNew</xsl:text>
				    			</xsl:when>
				    			<xsl:otherwise>
				    				<xsl:text>contacts/New</xsl:text>
				    			</xsl:otherwise>
				    		</xsl:choose>
				    	</xsl:with-param>
				        <xsl:with-param name="params">
				    		<xsl:choose>
				    			<xsl:when test="/RESPONSE/URL/info-contact-contacttype='PM'">
						            <xsl:text>DENOMINATION:'</xsl:text>
						            <xsl:value-of select="/RESPONSE/URL/info-contact-denomination"/>
						            <xsl:text>'</xsl:text>
				    			</xsl:when>
				    			<xsl:otherwise>
						            <xsl:text>FIRSTNAME:'</xsl:text>
						            <xsl:value-of select="/RESPONSE/URL/info-contact-firstname"/>
						            <xsl:text>',LASTNAME:'</xsl:text>
						            <xsl:value-of select="/RESPONSE/URL/info-contact-lastname"/>
						            <xsl:text>'</xsl:text>
				    			</xsl:otherwise>
				    		</xsl:choose>
				        </xsl:with-param>
				    	<xsl:with-param name="cssclass" select="'grey-bkgnd'" />
				   	</xsl:call-template>
				   	<xsl:if test="RESULTS/@hits = 0">
				   		<div class="no-result">No hits</div>
				   	</xsl:if>
				</xsl:when>
				<xsl:otherwise>
					<div class="items warning">
						<div class="icon">
							<img src="{$systemImagesURL}icons/warning/warning-16.png"/>
						</div>
						<div class="label" style="width:100%;">
							<xsl:value-of select="RESULTS/@hits"/>
							<xsl:text> matches, please refine your criterias.</xsl:text>
						</div>
					</div>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:for-each select="RESULTS/CONTACT">
                <xsl:sort select="translate(concat(INFO[CONTACTTYPE='PP']/LASTNAME,INFO[CONTACTTYPE='PP']/FIRSTNAME,INFO[CONTACTTYPE='PM']/DENOMINATION), $xsltsl-str-upper, $xsltsl-str-lower)" order="ascending"/>
                <xsl:apply-templates select="." mode="element-navitem"/>
			</xsl:for-each>
		</div>
	</xsl:template>
</xsl:stylesheet>
