<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee/shared/contact/contact-op.class.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
	class Sushee_ContactElementOperation extends AbstractElementOperation
	{
		function __construct()
		{
			parent::__construct(new Sushee_ContactElement());		
		}
		
		function __destruct()
		{
			
		}
		
		/* *** */
		
		public function create()
		{
		    if (URLParam::exists('email-check'))
            {
                $email1 = $this->element->getInfo('EMAIL1');
                if (!empty($email1))
                {
                    $check_contact = new Sushee_ContactElement();
                    if ($check_contact->findMatch('EMAIL1', $email1) == true)
                    {
                        $this->error('e-mail <strong>'.$email1.'</strong> already used!');
                    }
                }
            }
            
            return parent::_create(self::EXECUTE);
		}
		
		public function _check4Create()
		{	
		    $nql = new Officity_Shell(); 

		    $CONTACT_TYPE = URLParam::fetch('info-contact-contacttype', 'PP');
		    $this->element->setSearchInfo('CONTACTTYPE', '=', $CONTACT_TYPE);
		    
		    $searchtext = ($CONTACT_TYPE == 'PP') ? 
		    				URLParam::fetch('info-contact-firstname', '').' '.URLParam::fetch('info-contact-lastname', '') :
		    				URLParam::fetch('info-contact-denomination', '');
		    		    				
		    $this->element->addSearchInfo('SEARCHTEXT', 'MATCH', trim($searchtext));
		    		    
			$this->element->setDisplayProfile();
		    $this->element->setDefaultPaginate(50);
		
		    $this->element->search('list');
		    
		    $search_command = $this->element->getNQLCommand();		
		    $nql->addCommand($search_command);
		
		    die($nql->transform(dirname(__FILE__).'/check.xsl'));
		}
		
		public function _fetch()
		{
			$nql = new Officity_Shell();
					
		    $CONTACT_TYPE = URLParam::fetch('info-contact-contacttype', 'PP');
		    $this->element->setSearchInfo('CONTACTTYPE', '=', $CONTACT_TYPE);
		    
		     $this->element->setSearchInfo('SEARCHTEXT', 'MATCH', URLParam::fetch('term', ''));
		
			$this->element->setDisplayProfile();
		    $this->element->setDefaultPaginate(50);	
			
		    $this->element->search('list');
		    
		    $search_command = $this->element->getNQLCommand();		
		    $nql->addCommand($search_command);
		
		    header('Content-type: application/json');
			die($nql->transformToText(dirname(__FILE__).'/fetch-json.xsl'));
		}
		
		public function _count()
		{
			session_write_close(); // optim: unlock session data and allow concurrent accesses to this script
			
			$INDEX_LETTERS = $this->fetchURLParam('index');
			
            $contact_info = $society_info = '';
            
            $letters_count = strlen($INDEX_LETTERS);            
            for ($i=0; $i<$letters_count; $i++)
            {
                $letter = $INDEX_LETTERS[$i];
                $contact_info .= '<LASTNAME operator="starts-with">'.$letter.'</LASTNAME>';
                $society_info .= '<DENOMINATION operator="starts-with">'.$letter.'</DENOMINATION>';
                //$element->addSearchInfo('LASTNAME', 'starts-with', $letter);
                //$element->addSearchInfo('DENOMINATION', 'starts-with', $letter);
            }
            
            // count contact & societies
            $this->element->createFromXML('
            		<CONTACT>
            			<INFO>'.$contact_info.'</INFO>
            			<INFO>'.$society_info.'</INFO>
            		</CONTACT>
            ');            

            $hits = $this->element->count(SAVE);
            if ($hits !== false)
            {
                $this->success($hits);
            }
            
            return false;
		}
		
		public function _removePreview()
		{
            $this->element->setID($this->fetchURLParam('ID'));
            return $this->element->removeFile('PREVIEW', self::EXECUTE);
		}
		
		function _addKeyring()
		{
			$result = false;
			
			$this->element->setID($this->fetchURLParam('contactID')); 
			$KEYRING_ID = $this->fetchURLParam('keyringID');
			$this->element->setDependencyByName('keyringUsers', 'KEYRING', $KEYRING_ID, 'reverse', 'append');
			
			//$this->element->logCommand();
			
			$result = $this->element->update(self::EXECUTE);
			if ($result == false) 
			{
				$this->abort();
			}
			
			return $result;
		}
		
		function _removeKeyring()
		{
			$result = false;
			
			$this->element->setID($this->fetchURLParam('contactID')); 
			$KEYRING_ID = $this->fetchURLParam('keyringID');
			$this->element->setDependencyByName('keyringUsers', 'KEYRING', $KEYRING_ID, 'reverse', 'remove');
			
			//$this->element->logCommand();
			
			$result = $this->element->update(self::EXECUTE);
			if ($result == false) 
			{
				$this->abort();
			}
			
			return $result;
		}
	}
?>