<?xml version="1.0" encoding="utf-8"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee/shared/group/group.definitions.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
	<!-- EDITOR/APPLICATION -->
	<xsl:template match="GROUP" mode="element-editor">
		<xsl:text>sushee</xsl:text>
	</xsl:template>
	<!--xsl:template match="GROUP" mode="element-application">
		<xsl:text>dummyapplication</xsl:text>
	</xsl:template-->
	<!--xsl:template match="GROUP" mode="element-application-editor">
		<xsl:text>dummyapplicationeditor</xsl:text>
	</xsl:template-->
	
    <!-- LABEL(s) -->
	<xsl:template match="GROUP" mode="element-label">
        <xsl:value-of select="INFO/DENOMINATION"/>
	</xsl:template>
	
	<xsl:template match="GROUP[parent::GROUPS]" mode="element-label">
		<xsl:apply-templates select="@denomination" mode="display-value" />
	</xsl:template>

	<!-- ICON(s) -->
	<xsl:template match="GROUP" mode="element-icon">
		<xsl:text>../system/images/icons/contacts/group-16.png</xsl:text>
	</xsl:template>

	<!-- INFO LABEL(s) -->
	<xsl:template match="GROUP" mode="element-info">
	</xsl:template>
	
	<!-- TITLE(s) -->
	<xsl:template match="GROUP" mode="element-title">
        <xsl:variable name="module">
    		<xsl:call-template name="translate-namespace-name">
        		<xsl:with-param name="name" select="name(.)"/>
        	</xsl:call-template>
        </xsl:variable>
        
		<h2 class="{$module}">
			<xsl:apply-templates select="." mode="element-label"/>
		</h2>
	</xsl:template>

	<!-- NAVIGATION ITEM(s) -->
	<!--xsl:template match="GROUP" mode="element-navitem-parms">
        <xsl:text>ID:</xsl:text>
        <xsl:value-of select="@ID"/>
        <xsl:text>,module:'</xsl:text>
        <xsl:value-of select="name(.)"/>
        <xsl:text>'</xsl:text>
    </xsl:template-->
    
	<!--xsl:template match="GROUP" mode="element-navitem">
		<xsl:call-template name="navigationitem">
			<xsl:with-param name="editor">
				<xsl:apply-templates select="." mode="element-application-editor"/>
			</xsl:with-param>
			<xsl:with-param name="app">
				<xsl:apply-templates select="." mode="element-application"/>
			</xsl:with-param>
			<xsl:with-param name="id">
                <xsl:apply-templates select="." mode="element-navitem-id"/>
            </xsl:with-param>
			<xsl:with-param name="title">
				<xsl:apply-templates select="." mode="element-label"/>
			</xsl:with-param>
			<xsl:with-param name="panelURI">
				<xsl:apply-templates select="." mode="element-script-detail"/>
			</xsl:with-param>
			<xsl:with-param name="params">
               <xsl:apply-templates select="." mode="element-navitem-parms"/>
            </xsl:with-param>
			<xsl:with-param name="icon">
				<xsl:apply-templates select="." mode="element-icon"/>
			</xsl:with-param>
			<xsl:with-param name="info">
				<xsl:apply-templates select="." mode="element-info"/>
			</xsl:with-param>
		</xsl:call-template>
	</xsl:template-->
	
	<!--xsl:template match="GROUP" mode="element-navitem-parms">
        <xsl:text>ID:</xsl:text>
        <xsl:value-of select="@ID"/>
        <xsl:text>,module:'</xsl:text>
        <xsl:value-of select="name(.)"/>
        <xsl:text>'</xsl:text>
    </xsl:template-->
	
	<!-- SCRIPTS -->
	<!--xsl:template match="GROUP" mode="element-script-detail">
		<xsl:text>Details</xsl:text>
	</xsl:template-->

	<!--xsl:template match="GROUP" mode="element-script-new">
		<xsl:text>New</xsl:text>
	</xsl:template-->
	
	<xsl:template match="GROUP" mode="element-script-ops">
		<xsl:value-of select="$systemURL" />
		<xsl:text>call-operation.php?editor=</xsl:text>
		<xsl:apply-templates select="." mode="element-editor" />
		<xsl:text disable-output-escaping="yes">&amp;module=group</xsl:text>
		<xsl:text disable-output-escaping="yes">&amp;opObject=Sushee_GroupElementOperation</xsl:text>
	</xsl:template>
</xsl:stylesheet>